/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.persistence;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.ArrayElement;
import org.tigr.microarray.mev.CGHSlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.RNASeqElement;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.annotation.AnnotationStateSavingParser;
import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseAlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASETableViewer;
import org.tigr.microarray.mev.persistence.BufferedImageWrapper;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.util.FloatMatrix;

public class PersistenceObjectFactory {
    public static FloatMatrix readFloatMatrix(String inputFile) throws IOException {
        File binFile = new File(MultipleArrayViewer.CURRENT_TEMP_DIR, inputFile);
        FloatMatrix fm = new FloatMatrix(PersistenceObjectFactory.readMatrix(binFile));
        return fm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMatrix(File outputFile, FloatMatrix fm) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        try {
            int numRows = fm.getRowDimension();
            int numCols = fm.getColumnDimension();
            dos.writeInt(numRows);
            dos.writeInt(numCols);
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    dos.writeFloat(fm.A[i][j]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in writing floatmatrix " + outputFile.getName());
            e.printStackTrace();
        }
        finally {
            dos.flush();
            dos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[][] readMatrix(File binFile) throws IOException {
        float[][] matrix = new float[1][1];
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(binFile)));){
            int numRows = dis.readInt();
            int numCols = dis.readInt();
            matrix = new float[numRows][numCols];
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    matrix[i][j] = dis.readFloat();
                }
            }
        }
        return matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIntMatrix(File outputFile, int[][] matrix) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        try {
            int numRows = matrix.length;
            dos.writeInt(numRows);
            for (int i = 0; i < numRows; ++i) {
                dos.writeInt(matrix[i].length);
                for (int j = 0; j < matrix[i].length; ++j) {
                    dos.writeInt(matrix[i][j]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in writing intmatrix " + outputFile.getName());
            e.printStackTrace();
        }
        finally {
            dos.flush();
            dos.close();
        }
        dos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterWrapper readIntMatrix(String inputFile) throws IOException {
        File binFile = new File(MultipleArrayViewer.CURRENT_TEMP_DIR, inputFile);
        Object matrix = new int[1][1];
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(binFile)));){
            int numRows = dis.readInt();
            matrix = new int[numRows][];
            for (int i = 0; i < numRows; ++i) {
                int numCols = dis.readInt();
                matrix[i] = new int[numCols];
                for (int j = 0; j < numCols; ++j) {
                    matrix[i][j] = dis.readInt();
                }
            }
        }
        ClusterWrapper fm = ClusterWrapper.wrapClusters((int[][])matrix);
        return fm;
    }

    public static FloatSlideData makeFloatSlideData(Vector sampleLabelKeys, Hashtable sampleLabels, String filename, String name, Boolean isNonZero, Integer normalizedState, Integer sortState, SpotInformationData spotInfoData, Integer dataType, ISlideMetaData ismd, String intensityFileName) throws IOException {
        return PersistenceObjectFactory.makeFloatSlideData(sampleLabelKeys, sampleLabels, filename, name, isNonZero, normalizedState, sortState, spotInfoData, dataType, ismd, intensityFileName, null);
    }

    public static FloatSlideData makeFloatSlideData(Vector sampleLabelKeys, Hashtable sampleLabels, String filename, String name, Boolean isNonZero, Integer normalizedState, Integer sortState, SpotInformationData spotInfoData, Integer dataType, ISlideMetaData ismd, String intensityFileName, SampleAnnotation sampAnn) throws IOException {
        FloatSlideData fsd = new FloatSlideData(sampleLabelKeys, sampleLabels, filename, name, isNonZero, normalizedState, sortState, spotInfoData, dataType, ismd);
        File filePath = new File(MultipleArrayViewer.CURRENT_TEMP_DIR, intensityFileName);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filePath)));
        float[] currentCY3 = new float[dis.readInt()];
        for (int i = 0; i < currentCY3.length; ++i) {
            currentCY3[i] = dis.readFloat();
        }
        fsd.setCurrentCY3(currentCY3);
        float[] currentCY5 = new float[dis.readInt()];
        for (int i = 0; i < currentCY5.length; ++i) {
            currentCY5[i] = dis.readFloat();
        }
        fsd.setCurrentCY5(currentCY5);
        float[] trueCY3 = new float[dis.readInt()];
        for (int i = 0; i < trueCY3.length; ++i) {
            trueCY3[i] = dis.readFloat();
        }
        fsd.setTrueCY3(trueCY3);
        float[] trueCY5 = new float[dis.readInt()];
        for (int i = 0; i < trueCY5.length; ++i) {
            trueCY5[i] = dis.readFloat();
        }
        fsd.setTrueCY5(trueCY5);
        char[] detection = new char[dis.readInt()];
        for (int i = 0; i < detection.length; ++i) {
            detection[i] = dis.readChar();
        }
        fsd.setDetection(detection);
        float[] pvalues = new float[dis.readInt()];
        for (int i = 0; i < pvalues.length; ++i) {
            pvalues[i] = dis.readFloat();
        }
        fsd.setPvalues(pvalues);
        int[] flags = new int[dis.readInt()];
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = dis.readInt();
        }
        fsd.setGenePixFlags(flags);
        dis.close();
        if (sampAnn != null) {
            fsd.setSampleAnnotation(sampAnn);
        }
        return fsd;
    }

    public static SlideData makeSlideData(String slideDataName, Vector sampleLabelKeys, String sampleLabelKey, Hashtable sampleLabels, String slideFileName, Boolean isNonZero, Integer rows, Integer columns, Integer normalizedState, Integer sortState, SpotInformationData spotInfoData, String[] fieldNames, Integer dataType, String annotationFileName, String dataFile) throws IOException {
        return PersistenceObjectFactory.makeSlideData(slideDataName, sampleLabelKeys, sampleLabelKey, sampleLabels, slideFileName, isNonZero, rows, columns, normalizedState, sortState, spotInfoData, fieldNames, dataType, annotationFileName, dataFile, null, null);
    }

    public static SlideData makeSlideData(String slideDataName, Vector sampleLabelKeys, String sampleLabelKey, Hashtable sampleLabels, String slideFileName, Boolean isNonZero, Integer rows, Integer columns, Integer normalizedState, Integer sortState, SpotInformationData spotInfoData, String[] fieldNames, Integer dataType, String annotationFileName, String dataFile, String iAnnotationFileName) throws IOException {
        return PersistenceObjectFactory.makeSlideData(slideDataName, sampleLabelKeys, sampleLabelKey, sampleLabels, slideFileName, isNonZero, rows, columns, normalizedState, sortState, spotInfoData, fieldNames, dataType, annotationFileName, dataFile, iAnnotationFileName, null);
    }

    public static SlideData makeSlideData(String slideDataName, Vector sampleLabelKeys, String sampleLabelKey, Hashtable sampleLabels, String slideFileName, Boolean isNonZero, Integer rows, Integer columns, Integer normalizedState, Integer sortState, SpotInformationData spotInfoData, String[] fieldNames, Integer dataType, String annotationFileName, String dataFile, String iAnnotationFileName, SampleAnnotation sampAnn) throws IOException {
        SlideData aSlideData = new SlideData(slideDataName, sampleLabelKeys, sampleLabelKey, sampleLabels, slideFileName, isNonZero, rows, columns, normalizedState, sortState, spotInfoData, fieldNames, dataType);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(MultipleArrayViewer.CURRENT_TEMP_DIR, annotationFileName))));
        Vector allSlideDataElements = PersistenceObjectFactory.loadSlideDataAnnotation(dis, dataType);
        dis.close();
        Vector<Object> allIAnnotations = new Vector();
        if (iAnnotationFileName != null) {
            File iAnnotFile = new File(MultipleArrayViewer.CURRENT_TEMP_DIR, iAnnotationFileName);
            FileReader fr = new FileReader(iAnnotFile);
            try {
                if (iAnnotFile.length() > 1L) {
                    allIAnnotations = PersistenceObjectFactory.loadSlideDataIAnnotation(iAnnotFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(MultipleArrayViewer.CURRENT_TEMP_DIR, dataFile))));
        int numSlideDataElements = dis.readInt();
        for (int i = 0; i < numSlideDataElements; ++i) {
            ISlideDataElement sde = (ISlideDataElement)allSlideDataElements.get(i);
            sde.setIntensity(0, dis.readFloat());
            sde.setIntensity(1, dis.readFloat());
            sde.setTrueIntensity(0, dis.readFloat());
            sde.setTrueIntensity(1, dis.readFloat());
            if (dataType != 0 && dataType != 1) {
                sde.setDetection(new Character(dis.readChar()).toString());
            } else if (dataType == 6) {
                int temp = dis.readInt();
                System.out.println("int size: " + temp);
                char[] codechars = new char[temp];
                for (int j = 0; j < codechars.length; ++j) {
                    codechars[j] = dis.readChar();
                }
                int transcriptLength = dis.readInt();
                int count = dis.readInt();
                sde = new RNASeqElement((SlideDataElement)sde, new String(codechars), transcriptLength, count);
            }
            if (allIAnnotations == null || allIAnnotations.size() <= 0) continue;
            sde.setElementAnnotation((IAnnotation)allIAnnotations.get(i));
        }
        dis.close();
        aSlideData.setAllElements(allSlideDataElements);
        aSlideData.updateFilledAnnFields();
        if (sampAnn != null) {
            aSlideData.setSampleAnnotation(sampAnn);
        }
        return aSlideData;
    }

    private static Vector loadSlideDataAnnotation(DataInputStream dis, int dataType) throws IOException {
        int numSlideDataElements = dis.readInt();
        Vector<ArrayElement> allSlideDataElements = new Vector<ArrayElement>(numSlideDataElements);
        boolean isCGHData = dis.readBoolean();
        for (int i = 0; i < numSlideDataElements; ++i) {
            int j;
            int temp = dis.readInt();
            char[] buff = new char[temp];
            for (j = 0; j < temp; ++j) {
                buff[j] = dis.readChar();
            }
            String uid = new String(buff);
            int[] rows = new int[dis.readInt()];
            for (j = 0; j < rows.length; ++j) {
                rows[j] = dis.readInt();
            }
            int[] cols = new int[dis.readInt()];
            for (j = 0; j < cols.length; ++j) {
                cols[j] = dis.readInt();
            }
            String[] extraFields = new String[dis.readInt()];
            for (j = 0; j < extraFields.length; ++j) {
                buff = new char[dis.readInt()];
                for (int k = 0; k < buff.length; ++k) {
                    buff[k] = dis.readChar();
                }
                extraFields[j] = new String(buff);
            }
            boolean isNull = dis.readBoolean();
            boolean isNonZero = dis.readBoolean();
            if (dataType == 0 || dataType == 1) {
                if (isCGHData) {
                    allSlideDataElements.add(i, new CGHSlideDataElement(rows, cols, extraFields, uid, isNull, isNonZero));
                    continue;
                }
                allSlideDataElements.add(i, new SlideDataElement(rows, cols, extraFields, uid, isNull, isNonZero));
                continue;
            }
            char detection = dis.readChar();
            float pValue = dis.readFloat();
            int flags = dis.readInt();
            allSlideDataElements.add(i, new AffySlideDataElement(rows, cols, extraFields, uid, isNull, isNonZero, detection, pValue, flags));
        }
        return allSlideDataElements;
    }

    public static void writeSlideDataAnnotation(DataOutputStream dos, SlideData sd) throws IOException {
        Vector allSlideDataElements = sd.getAllElements();
        int numSlideDataElements = allSlideDataElements.size();
        dos.writeInt(numSlideDataElements);
        dos.writeBoolean(sd.isCGHData());
        for (int i = 0; i < numSlideDataElements; ++i) {
            ISlideDataElement sde = (ISlideDataElement)allSlideDataElements.get(i);
            String uid = sde.getUID();
            char[] temp = uid.toCharArray();
            dos.writeInt(temp.length);
            for (int j = 0; j < temp.length; ++j) {
                dos.writeChar(temp[j]);
            }
            int rowsize = sde.getRows().length;
            dos.writeInt(rowsize);
            for (int j = 0; j < rowsize; ++j) {
                dos.writeInt(sde.getRows()[j]);
            }
            int colsize = sde.getColumns().length;
            dos.writeInt(colsize);
            for (int j = 0; j < colsize; ++j) {
                dos.writeInt(sde.getColumns()[j]);
            }
            String[] oldModelFields = sd.getOldModelFieldNames();
            int numFields = oldModelFields.length;
            dos.writeInt(numFields);
            for (int j = 0; j < numFields; ++j) {
                try {
                    temp = sde.getFieldAt(j).toCharArray();
                    dos.writeInt(temp.length);
                    for (int k = 0; k < temp.length; ++k) {
                        dos.writeChar(temp[k]);
                    }
                    continue;
                }
                catch (NullPointerException npe) {
                    dos.writeInt(0);
                }
            }
            dos.writeBoolean(sde.getIsNull());
            dos.writeBoolean(sde.isNonZero());
            int dataType = sd.getDataType();
            if (dataType == 0 || dataType == 1 || dataType == 6) continue;
            dos.writeChar(((AffySlideDataElement)sde).getDetection().charAt(0));
            dos.writeFloat(((AffySlideDataElement)sde).getPvalue());
            dos.writeInt(((AffySlideDataElement)sde).getGenePixFlags());
        }
    }

    public static void writeSlideDataIntensities(DataOutputStream dos, SlideData sd) throws IOException {
        Vector allSlideDataElements = sd.getAllElements();
        int numSlideDataElements = sd.size();
        dos.writeInt(numSlideDataElements);
        for (int i = 0; i < numSlideDataElements; ++i) {
            ISlideDataElement sde = (ISlideDataElement)allSlideDataElements.get(i);
            dos.writeFloat(sde.getIntensity(0));
            dos.writeFloat(sde.getIntensity(1));
            dos.writeFloat(sde.getTrueIntensity(0));
            dos.writeFloat(sde.getTrueIntensity(1));
            if (sd.getDataType() != 0 && sd.getDataType() != 1 && sd.getDataType() != 6) {
                dos.writeChar(sde.getDetection().toCharArray()[0]);
                continue;
            }
            if (sd.getDataType() != 6) continue;
            RNASeqElement rse = (RNASeqElement)sde;
            int classCodeLength = rse.getClasscode().length();
            dos.writeInt(classCodeLength);
            for (int j = 0; j < classCodeLength; ++j) {
                dos.writeChar(rse.getClasscode().charAt(j));
            }
            dos.writeInt(rse.getTranscriptLength());
            dos.writeInt(rse.getCount());
        }
    }

    public static void writeFloatSlideDataIntensities(DataOutputStream dos, FloatSlideData fsd) throws IOException {
        float[] currentCY3 = fsd.getCurrentCY3();
        if (currentCY3 != null) {
            dos.writeInt(currentCY3.length);
            for (int i = 0; i < currentCY3.length; ++i) {
                dos.writeFloat(currentCY3[i]);
            }
        } else {
            dos.writeInt(0);
        }
        float[] currentCY5 = fsd.getCurrentCY5();
        if (currentCY5 != null) {
            dos.writeInt(currentCY5.length);
            for (int i = 0; i < currentCY5.length; ++i) {
                dos.writeFloat(currentCY5[i]);
            }
        } else {
            dos.writeInt(0);
        }
        float[] trueCY3 = fsd.getTrueCY3();
        dos.writeInt(trueCY3.length);
        for (int i = 0; i < trueCY3.length; ++i) {
            dos.writeFloat(trueCY3[i]);
        }
        float[] trueCY5 = fsd.getTrueCY5();
        dos.writeInt(trueCY5.length);
        for (int i = 0; i < trueCY5.length; ++i) {
            dos.writeFloat(trueCY5[i]);
        }
        char[] detection = fsd.getDetection();
        dos.writeInt(detection.length);
        for (int i = 0; i < detection.length; ++i) {
            dos.writeChar(detection[i]);
        }
        float[] pvalues = fsd.getPvalue();
        dos.writeInt(pvalues.length);
        for (int i = 0; i < pvalues.length; ++i) {
            dos.writeFloat(pvalues[i]);
        }
        int[] flags = fsd.getGenePixFlags();
        dos.writeInt(flags.length);
        for (int i = 0; i < flags.length; ++i) {
            dos.writeInt(flags[i]);
        }
    }

    public static void writeBufferedImage(DataOutputStream dos, BufferedImage bi) throws IOException {
        try {
            ImageIO.write((RenderedImage)bi, "jpg", dos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedImageWrapper readBufferedImage(String inputFile) throws IOException {
        File binFile = new File(MultipleArrayViewer.CURRENT_TEMP_DIR, inputFile);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(binFile)));
        BufferedImage bi = ImageIO.read(binFile);
        dis.close();
        return new BufferedImageWrapper(bi);
    }

    public static EaseAlgorithmData makeEASEResult(String filename) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(MultipleArrayViewer.CURRENT_TEMP_DIR, filename)));
            Vector<String[]> datatemp = new Vector<String[]>();
            while (br.ready()) {
                datatemp.add(br.readLine().split("\t"));
            }
            br.close();
            String[][] data = (String[][])datatemp.toArray((T[])new String[datatemp.size()][]);
            EaseAlgorithmData edata = new EaseAlgorithmData();
            edata.setResultMatrix(data);
            edata.setImpliesFileLocation(MultipleArrayViewer.CURRENT_TEMP_DIR);
            return edata;
        }
        catch (IOException ioe) {
            System.out.println("Unable to read EASETableViewer data.");
            return null;
        }
    }

    public static EASETableViewer makeEASETableViewer(String[] headerNames, DefaultMutableTreeNode analysisNode, Experiment experiment, ClusterWrapper clusters, boolean haveAccessionNumbers, boolean clusterAnalysis, boolean isEaseConsolidatedResult, String outfileFullPath) {
        try {
            return new EASETableViewer(headerNames, EASETableViewer.readData((BufferedReader)new BufferedReader(new FileReader(new File(MultipleArrayViewer.CURRENT_TEMP_DIR, outfileFullPath)))), analysisNode, experiment, clusters.getClusters(), haveAccessionNumbers, clusterAnalysis, isEaseConsolidatedResult);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public static void writeSlideDataIAnnotation(PrintWriter pw, SlideData sd) throws Exception {
        Object iAnnotationFileName = null;
        if (sd.getAllElements().get(0) instanceof AffySlideDataElement) {
            AnnotationStateSavingParser asp = new AnnotationStateSavingParser();
            Vector<IAnnotation> annotationVector = new Vector<IAnnotation>();
            Vector allslideData = sd.getAllElements();
            for (int i = 0; i < allslideData.size(); ++i) {
                ISlideDataElement sde = (ISlideDataElement)allslideData.get(i);
                IAnnotation annot = sde.getElementAnnotation();
                if (annot == null) continue;
                annotationVector.add(annot);
            }
            AnnotationStateSavingParser fileParser = new AnnotationStateSavingParser();
            if (annotationVector.size() > 1) {
                fileParser.writeAnnotationFile(annotationVector, pw);
            }
        }
    }

    public static Vector<IAnnotation> loadSlideDataIAnnotation(File file) throws Exception {
        Vector<IAnnotation> allAnnotations = new Vector();
        AnnotationStateSavingParser fileParser = new AnnotationStateSavingParser();
        allAnnotations = fileParser.readSavedAnnotation(file);
        return allAnnotations;
    }
}

