/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.persistence;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.RNASeqFloatSlideData;
import org.tigr.microarray.mev.RNASeqSlideData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.persistence.PersistenceObjectFactory;

public class ISlideDataPersistenceDelegate
extends PersistenceDelegate {
    @Override
    protected Expression instantiate(Object oldInstance, Encoder encoder) {
        Expression e;
        try {
            if (oldInstance instanceof RNASeqFloatSlideData) {
                RNASeqFloatSlideData rsfsd = (RNASeqFloatSlideData)oldInstance;
                FloatSlideData temp = new FloatSlideData(rsfsd);
                e = new Expression((RNASeqFloatSlideData)oldInstance, ((RNASeqFloatSlideData)oldInstance).getClass(), "new", new Object[]{temp, ClusterWrapper.wrapClusters((int[][])new int[][]{rsfsd.getCounts()}), rsfsd.getLibrarySize()});
            } else if (oldInstance instanceof FloatSlideData) {
                FloatSlideData fsd = (FloatSlideData)oldInstance;
                File outputFile = File.createTempFile("floatslidedata", ".bin", new File(MultipleArrayViewer.CURRENT_TEMP_DIR));
                outputFile.deleteOnExit();
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                PersistenceObjectFactory.writeFloatSlideDataIntensities(dos, fsd);
                dos.close();
                e = new Expression((FloatSlideData)oldInstance, new PersistenceObjectFactory().getClass(), "makeFloatSlideData", new Object[]{fsd.getSlideDataKeys(), fsd.getSlideDataLabels(), fsd.getFullSlideFileName(), fsd.getSlideDataName(), new Boolean(fsd.getIsNonZero()), new Integer(fsd.getNormalizedState()), new Integer(fsd.getSortState()), fsd.getSpotInformationData(), new Integer(fsd.getDataType()), fsd.getSlideMetaData(), outputFile.getName(), fsd.getSampleAnnotation()});
            } else {
                SlideData sd = (SlideData)oldInstance;
                if (oldInstance instanceof RNASeqSlideData) {
                    RNASeqSlideData rssd = (RNASeqSlideData)oldInstance;
                    SlideData temp = new SlideData(rssd);
                    e = new Expression((RNASeqSlideData)oldInstance, ((RNASeqSlideData)oldInstance).getClass(), "new", new Object[]{temp, rssd.getLibrarySize()});
                } else {
                    File annotationFile = File.createTempFile("slidedataannotation", ".bin", new File(MultipleArrayViewer.CURRENT_TEMP_DIR));
                    annotationFile.deleteOnExit();
                    DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(annotationFile)));
                    PersistenceObjectFactory.writeSlideDataAnnotation(dos, sd);
                    dos.close();
                    File iAnnotationFile = File.createTempFile("iannotation", ".txt", new File(MultipleArrayViewer.CURRENT_TEMP_DIR));
                    annotationFile.deleteOnExit();
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(iAnnotationFile)));
                    PersistenceObjectFactory.writeSlideDataIAnnotation(pw, sd);
                    pw.close();
                    File outputFile = File.createTempFile("slidedata", ".bin", new File(MultipleArrayViewer.CURRENT_TEMP_DIR));
                    outputFile.deleteOnExit();
                    dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                    PersistenceObjectFactory.writeSlideDataIntensities(dos, sd);
                    dos.close();
                    e = new Expression((SlideData)oldInstance, new PersistenceObjectFactory().getClass(), "makeSlideData", new Object[]{sd.getSlideDataName(), sd.getSlideDataKeys(), sd.getSampleLabelKey(), sd.getSlideDataLabels(), sd.getSlideFileName(), new Boolean(sd.isNonZero()), new Integer(sd.getRows()), new Integer(sd.getColumns()), new Integer(sd.getNormalizedState()), new Integer(sd.getSortState()), sd.getSpotInformationData(), sd.getOldModelFieldNames(), new Integer(sd.getDataType()), annotationFile.getName(), outputFile.getName(), iAnnotationFile.getName(), sd.getSampleAnnotation()});
                }
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            System.out.println("Can't write to file to save FloatSlideData");
            return null;
        }
        return e;
    }

    public void initialize(Class type, Object oldInstance, Object newInstance, Encoder encoder) {
    }
}

