/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.persistence;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.util.DoubleArray;

public class DoubleArrayPersistenceDelegate
extends PersistenceDelegate {
    @Override
    public Expression instantiate(Object oldInstance, Encoder encoder) {
        DoubleArray fm = (DoubleArray)oldInstance;
        try {
            File outputFile = File.createTempFile("doublearray", ".bin", new File(MultipleArrayViewer.CURRENT_TEMP_DIR));
            outputFile.deleteOnExit();
            DoubleArrayPersistenceDelegate.writeDoubleArray(outputFile, fm);
            return new Expression((DoubleArray)oldInstance, this.getClass(), "readDoubleArray", new Object[]{outputFile.getName()});
        }
        catch (IOException ioe) {
            System.out.println("Can't write to file to save DoubleArray");
            return null;
        }
    }

    public static DoubleArray readDoubleArray(String inputFile) throws IOException {
        File binFile = new File(MultipleArrayViewer.CURRENT_TEMP_DIR, inputFile);
        DoubleArray fm = new DoubleArray(DoubleArrayPersistenceDelegate.readArray(binFile));
        return fm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[] readArray(File binFile) throws IOException {
        double[] matrix = new double[1];
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(binFile)));){
            int numRows = dis.readInt();
            matrix = new double[numRows];
            for (int i = 0; i < numRows; ++i) {
                matrix[i] = dis.readDouble();
            }
        }
        return matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDoubleArray(File outputFile, DoubleArray fm) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        try {
            double[] array = fm.toArray();
            int numRows = array.length;
            dos.writeInt(numRows);
            for (int i = 0; i < numRows; ++i) {
                dos.writeDouble(array[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Error in writing DoubleArray " + outputFile.getName());
            e.printStackTrace();
        }
        finally {
            dos.flush();
            dos.close();
        }
    }
}

