/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.persistence;

import java.awt.image.BufferedImage;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.persistence.BufferedImageWrapper;
import org.tigr.microarray.mev.persistence.PersistenceObjectFactory;

public class BufferedImagePersistenceDelegate
extends PersistenceDelegate {
    @Override
    public Expression instantiate(Object oldInstance, Encoder encoder) {
        BufferedImageWrapper biw = (BufferedImageWrapper)oldInstance;
        BufferedImage bi = biw.getBufferedImage();
        try {
            File outputFile = File.createTempFile("bufferedimage", ".jpg", new File(MultipleArrayViewer.CURRENT_TEMP_DIR));
            outputFile.deleteOnExit();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            PersistenceObjectFactory.writeBufferedImage(dos, bi);
            dos.close();
            return new Expression((BufferedImageWrapper)oldInstance, new PersistenceObjectFactory().getClass(), "readBufferedImage", new Object[]{outputFile.getName()});
        }
        catch (IOException ioe) {
            System.out.println("Can't write to file to save BufferedImage");
            return null;
        }
    }

    public void initialize(Class type, Object oldInstance, Object newInstance, XMLEncoder encoder) {
    }
}

