/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.persistence;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.util.BooleanArray;

public class BooleanArrayPersistenceDelegate
extends PersistenceDelegate {
    @Override
    public Expression instantiate(Object oldInstance, Encoder encoder) {
        BooleanArray fm = (BooleanArray)oldInstance;
        try {
            File outputFile = File.createTempFile("booleanarray", ".bin", new File(MultipleArrayViewer.CURRENT_TEMP_DIR));
            outputFile.deleteOnExit();
            BooleanArrayPersistenceDelegate.writeBooleanArray(outputFile, fm);
            return new Expression((BooleanArray)oldInstance, this.getClass(), "readBooleanArray", new Object[]{outputFile.getName()});
        }
        catch (IOException ioe) {
            System.out.println("Can't write to file to save BooleanArray.");
            return null;
        }
    }

    public static BooleanArray readBooleanArray(String inputFile) throws IOException {
        File binFile = new File(MultipleArrayViewer.CURRENT_TEMP_DIR, inputFile);
        BooleanArray fm = new BooleanArray(BooleanArrayPersistenceDelegate.readArray(binFile));
        return fm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean[] readArray(File binFile) throws IOException {
        boolean[] matrix = new boolean[1];
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(binFile)));){
            int numRows = dis.readInt();
            matrix = new boolean[numRows];
            for (int i = 0; i < numRows; ++i) {
                matrix[i] = dis.readBoolean();
            }
        }
        return matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBooleanArray(File outputFile, BooleanArray fm) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        try {
            boolean[] array = fm.toArray();
            int numRows = array.length;
            dos.writeInt(numRows);
            for (int i = 0; i < numRows; ++i) {
                dos.writeBoolean(array[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Error in writing BooleanArray " + outputFile.getName());
            e.printStackTrace();
        }
        finally {
            dos.flush();
            dos.close();
        }
    }
}

