/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.gaggle;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.systemsbiology.gaggle.core.Boss;
import org.systemsbiology.gaggle.core.Goose;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;
import org.systemsbiology.gaggle.core.datatypes.GaggleTuple;
import org.systemsbiology.gaggle.core.datatypes.Namelist;
import org.systemsbiology.gaggle.core.datatypes.Network;
import org.systemsbiology.gaggle.core.datatypes.Single;
import org.systemsbiology.gaggle.core.datatypes.Tuple;
import org.systemsbiology.gaggle.geese.common.GaggleConnectionListener;
import org.systemsbiology.gaggle.geese.common.GooseShutdownHook;
import org.systemsbiology.gaggle.geese.common.RmiGaggleConnector;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.ArrayElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.MevChipAnnotation;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.helpers.GenomeBrowserWebstart;
import org.tigr.microarray.mev.gaggle.GaggleListener;
import org.tigr.microarray.mev.gaggle.GaggleTranslater;

public class GooseImpl
implements Goose,
GaggleConnectionListener {
    String myGaggleName = "Multiple Array Viewer";
    String genomeBrowserGoose;
    String[] gooseNames;
    private boolean isConnected = false;
    String targetGoose = "Boss";
    RmiGaggleConnector gaggleConnector;
    Boss gaggleBoss;
    GaggleListener listener;

    public void setListener(GaggleListener listener) {
        this.listener = listener;
    }

    public String getTargetGoose() {
        return this.targetGoose;
    }

    public void setTargetGoose(String targetGoose) {
        this.targetGoose = targetGoose;
    }

    public String getMyGaggleName() {
        return this.myGaggleName;
    }

    public void setMyGaggleName(String myGaggleName) {
        this.myGaggleName = myGaggleName;
    }

    public String[] getGooseNames() {
        return this.gooseNames;
    }

    public void setGooseNames(String[] gooseNames) {
        this.gooseNames = gooseNames;
        this.updateGenomeBrowserGoose();
    }

    private void updateGenomeBrowserGoose() {
        if (this.genomeBrowserGoose != null) {
            for (String gooseName : this.gooseNames) {
                if (!this.genomeBrowserGoose.equals(gooseName)) continue;
                return;
            }
            this.genomeBrowserGoose = null;
        }
        for (int i = 0; i < this.gooseNames.length; ++i) {
            if (!this.gooseNames[i].startsWith("Genome Browser")) continue;
            this.genomeBrowserGoose = this.gooseNames[i];
        }
    }

    public String getGenomeBrowserGoose(String species) {
        while (this.genomeBrowserGoose == null) {
            GenomeBrowserWebstart.onWebstartGenomeBrowser((String)species);
            if (JOptionPane.showConfirmDialog(new JFrame(), "Could not find a connected Genome Browser.\nMeV will launch an instance of the Genome Browser.\nPlease load the genome of the organism of interest.\nClick Ok when the genome is loaded to begin the broadcast.\nSee http://mev.tm4.org/documentation/gaggle for help", "Waiting for Genome Browser", 2, 3) != 0) {
                return null;
            }
            this.updateGenomeBrowserGoose();
        }
        return this.genomeBrowserGoose;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void doBroadcastMatrix(DataMatrix matrix, String target) {
        if (!this.isConnected()) {
            this.gaggleConnectWarning();
            return;
        }
        if (target == null) {
            target = this.targetGoose;
        }
        try {
            this.gaggleBoss.broadcastMatrix(this.myGaggleName, target, matrix);
        }
        catch (RemoteException rex) {
            JOptionPane.showMessageDialog(new JFrame(), "Gaggle unavailable. Please use Utilities -> Connect to Gaggle.");
            this.disconnectFromGaggle();
        }
    }

    public void disconnectFromGaggle() {
        if (this.isConnected()) {
            this.gaggleConnector.disconnectFromGaggle(true);
        }
    }

    public void gaggleInit() {
        if (this.gaggleConnector == null) {
            this.gaggleConnector = new RmiGaggleConnector((Goose)this);
            this.gaggleConnector.setAutoStartBoss(true);
            new GooseShutdownHook(this.gaggleConnector);
            this.gaggleConnector.addListener((GaggleConnectionListener)this);
        }
    }

    public boolean connectToGaggle() {
        TMEV.GAGGLE_CONNECT_ON_STARTUP = true;
        if (this.gaggleConnector == null) {
            this.gaggleInit();
        }
        try {
            this.gaggleConnector.connectToGaggle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gaggleBoss = this.gaggleConnector.getBoss();
        return this.gaggleBoss != null;
    }

    public void doBroadcastNetwork(Network nt) {
        if (!this.isConnected()) {
            this.gaggleConnectWarning();
            return;
        }
        try {
            this.gaggleBoss.broadcastNetwork(this.myGaggleName, this.targetGoose, nt);
        }
        catch (RemoteException rex) {
            System.err.println("doBroadcastNetwork: rmi error calling boss.broadcast");
            this.disconnectFromGaggle();
        }
    }

    public void doBroadcastNamelist(Namelist nl) {
        if (!this.isConnected()) {
            this.gaggleConnectWarning();
            return;
        }
        try {
            this.gaggleBoss.broadcastNamelist(this.myGaggleName, this.targetGoose, nl);
        }
        catch (RemoteException rex) {
            System.err.println("doBroadcastNamelist: rmi error calling boss.broadcast");
            this.disconnectFromGaggle();
        }
    }

    public void show(String key) throws RemoteException {
        this.gaggleBoss.show(key);
    }

    protected void gaggleConnectWarning() {
        String title = "Not connected to Gaggle";
        String msg = "Please connect to Gaggle using the Utilities -> Gaggle menu.";
        JOptionPane.showMessageDialog(new JFrame(), msg, title, 0);
        this.disconnectFromGaggle();
    }

    public void handleMatrix(String sourceGoose, DataMatrix matrix) throws RemoteException {
        MevChipAnnotation chipAnno = new MevChipAnnotation();
        chipAnno.setSpeciesName(matrix.getSpecies());
        Tuple metaData = matrix.getMetadata();
        int dataType = 2;
        if (metaData != null) {
            List singles = metaData.getSingleList();
            for (Single thisSingle : singles) {
                if (thisSingle.getName().equals("MeV-metadata")) {
                    try {
                        Tuple mevMetaData = (Tuple)thisSingle.getValue();
                        List items = mevMetaData.getSingleList();
                        for (Single item : items) {
                            String itemname = item.getName();
                            if (itemname.equals("data-type")) {
                                String untranslatedDataType = item.getValue().toString();
                                dataType = GaggleTranslater.translateDataType(untranslatedDataType);
                                chipAnno.setDataType(new Integer(dataType).toString());
                            }
                            if (itemname.equals("array-name")) {
                                chipAnno.setChipName(item.getValue().toString());
                                chipAnno.setChipType(item.getValue().toString());
                            }
                            if (!itemname.equals("log-status")) continue;
                            String string = item.getValue().toString();
                        }
                    }
                    catch (ClassCastException cce) {
                        // empty catch block
                    }
                }
                if (!thisSingle.getName().equals("identifier-type")) continue;
                String string = thisSingle.getValue().toString();
            }
        }
        String[] moreFields = new String[1];
        boolean rColumns = true;
        int column = 1;
        int row = 1;
        int experimentCount = matrix.getColumnCount();
        ISlideData[] slideDataArray = new ISlideData[experimentCount];
        slideDataArray[0] = new SlideData(matrix.getRowCount(), 1);
        slideDataArray[0].setSlideFileName("Broadcast via Gaggle from " + sourceGoose + " " + matrix.getShortName());
        for (int i = 1; i < experimentCount; ++i) {
            slideDataArray[i] = new FloatSlideData(slideDataArray[0].getSlideMetaData(), matrix.getRowCount());
            slideDataArray[i].setSlideFileName("Broadcast via Gaggle from " + sourceGoose + " " + matrix.getShortName());
        }
        String[] fieldNames = new String[]{matrix.getRowTitlesTitle()};
        if (fieldNames == null || fieldNames[0] == null) {
            fieldNames = new String[]{"untitled annotation"};
        }
        slideDataArray[0].getSlideMetaData().setFieldNames(fieldNames);
        for (int i = 0; i < experimentCount; ++i) {
            slideDataArray[i].setSlideDataName(matrix.getColumnTitles()[i]);
        }
        double[][] matrixData = matrix.get();
        String[] rowTitles = matrix.getRowTitles();
        double maxval = Double.NEGATIVE_INFINITY;
        double minval = Double.POSITIVE_INFINITY;
        for (int r = 0; r < matrix.getRowCount(); ++r) {
            int[] rows = new int[]{0, 1, 0};
            int[] columns = new int[]{0, 1, 0};
            rows[0] = rows[2] = row++;
            columns[0] = columns[2] = column;
            column = column == 1 ? 1 : ++column;
            moreFields[0] = rowTitles[r];
            ArrayElement sde = new SlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], moreFields);
            if (dataType == 2) {
                sde = new AffySlideDataElement((ISlideDataElement)((Object)sde));
            }
            slideDataArray[0].addSlideDataElement((ISlideDataElement)((Object)sde));
            for (int i = 0; i < slideDataArray.length; ++i) {
                float cy3 = 1.0f;
                float cy5 = new Double(matrixData[r][i]).floatValue();
                slideDataArray[i].setIntensities(r, cy3, cy5);
                if ((double)cy5 < minval) {
                    minval = cy5;
                }
                if (!((double)cy5 > maxval)) continue;
                maxval = cy5;
            }
        }
        this.listener.expressionDataReceived(slideDataArray, chipAnno, dataType);
    }

    public void doExit() throws RemoteException {
        this.disconnectFromGaggle();
        this.listener.onExit();
    }

    public void doHide() throws RemoteException {
        this.listener.onHide();
    }

    public void doShow() throws RemoteException {
        this.listener.onShow();
    }

    public String getName() throws RemoteException {
        return this.myGaggleName;
    }

    public void handleNameList(String arg0, Namelist nl) throws RemoteException {
        String broadcastName = nl.getName();
        nl.getMetadata();
        Tuple metaData = nl.getMetadata();
        String identifier = null;
        boolean interactive = true;
        if (metaData != null) {
            List singles = metaData.getSingleList();
            for (Single thisSingle : singles) {
                if (thisSingle.getName().equals("MeV-metadata")) {
                    // empty if block
                }
                if (thisSingle.getName().equals("identifier-type")) {
                    identifier = thisSingle.getValue().toString();
                }
                try {
                    if (!thisSingle.getName().equals("user-interactive")) continue;
                    interactive = new Boolean(thisSingle.getValue().toString());
                }
                catch (Exception e) {
                    interactive = true;
                }
            }
        }
        this.listener.nameListReceived(nl.getNames(), identifier, interactive, broadcastName);
    }

    public void setName(String newGaggleName) throws RemoteException {
        this.myGaggleName = newGaggleName;
        this.listener.onNameChange(newGaggleName);
    }

    public void update(String[] gooseNames) throws RemoteException {
        this.setGooseNames(gooseNames);
        Vector<String> menuNames = new Vector<String>();
        menuNames.add("Boss");
        for (int i = 0; i < gooseNames.length; ++i) {
            if (gooseNames[i].equals(this.myGaggleName)) continue;
            menuNames.add(gooseNames[i]);
        }
        String[] temp = new String[menuNames.size()];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = (String)menuNames.get(i);
        }
        this.listener.onUpdate(temp);
    }

    public void setConnected(boolean connected, Boss boss) {
        this.isConnected = connected;
        this.gaggleBoss = boss;
        if (!this.isConnected) {
            this.myGaggleName = "Multiple Array Viewer";
        }
        this.listener.onUpdateConnected(connected);
    }

    public void handleCluster(String arg0, org.systemsbiology.gaggle.core.datatypes.Cluster arg1) throws RemoteException {
    }

    public void handleNetwork(String arg0, Network arg1) throws RemoteException {
    }

    public void handleTuple(String arg0, GaggleTuple arg1) throws RemoteException {
    }

    public void handleCluster(String arg0, Cluster arg1) throws RemoteException {
    }

    public void doBroadcastList() throws RemoteException {
    }
}

