/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.gaggle;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;
import org.systemsbiology.gaggle.core.datatypes.Interaction;
import org.systemsbiology.gaggle.core.datatypes.Namelist;
import org.systemsbiology.gaggle.core.datatypes.Network;
import org.systemsbiology.gaggle.core.datatypes.Single;
import org.systemsbiology.gaggle.core.datatypes.Tuple;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.util.FloatMatrix;

public class GaggleTranslater {
    private MultipleArrayViewer mav;

    public GaggleTranslater(MultipleArrayViewer mav) {
        this.mav = mav;
    }

    public DataMatrix createMatrix(int[] rows, String fieldname, String species, String algorithmName) {
        IData data = this.mav.getData();
        DataMatrix m = new DataMatrix();
        FloatMatrix f = data.getExperiment().getMatrix();
        String[] rowTitles = new String[rows.length];
        m.setSize(rows.length, f.getColumnDimension());
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < f.getColumnDimension(); ++j) {
                m.set(i, j, (double)data.getRatio(j, rows[i], 1));
            }
        }
        rowTitles = data.getAnnotationList(fieldname, rows);
        m.setRowTitles(rowTitles);
        m.setRowTitlesTitle(fieldname);
        String[] temp = new String[f.getColumnDimension()];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = data.getSampleAnnotation(i, data.getCurrentSampleLabelKey());
            if (temp[i] != null && !temp[i].equalsIgnoreCase("na")) continue;
            temp[i] = "Sample " + i + 1;
        }
        m.setColumnTitles(temp);
        m.setSpecies(species);
        m.setName("MeV matrix (" + m.getRowCount() + " x " + m.getColumnCount() + ") from algorithm " + algorithmName);
        m.setShortName("MeV matrix (" + m.getRowCount() + " x " + m.getColumnCount() + ") from algorithm " + algorithmName);
        m.setMetadata(GaggleTranslater.getMatrixMetadata(fieldname, null, data.getDataType(), data.getChipAnnotation().getChipName(), algorithmName));
        return m;
    }

    public Namelist createNamelist(Experiment e, int[] rows) {
        if (e == null || rows == null) {
            return new Namelist();
        }
        IData data = this.mav.getData();
        int[] indices = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            indices[i] = e.getGeneIndexMappedToData(rows[i]);
        }
        Namelist nl = new Namelist();
        String fieldName = data.getFieldNames()[this.mav.getMenubar().getDisplayMenu().getLabelIndex()];
        String[] names = new String[indices.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = data.getAnnotationList(fieldName, new int[]{indices[i]})[0];
        }
        nl.setName("MeV Namelist (" + names.length + ")");
        nl.setNames(names);
        nl.setSpecies(this.mav.getCurrentSpecies());
        nl.setMetadata(GaggleTranslater.getNamelistMetadata(fieldName, null));
        return nl;
    }

    public Network createNetwork(Vector<int[]> interactions, Vector<String> types, Vector<Boolean> directionals) {
        IData data = this.mav.getData();
        Network nt = new Network();
        nt.setSpecies(this.mav.getCurrentSpecies());
        Hashtable<String, String[]> nodeAnnotations = new Hashtable<String, String[]>();
        String[] allFields = data.getFieldNames();
        for (int i = 0; i < interactions.size(); ++i) {
            String source = data.getAnnotationList(data.getFieldNames()[this.mav.getMenubar().getDisplayMenu().getLabelIndex()], new int[]{interactions.get(i)[0]})[0];
            String target = data.getAnnotationList(data.getFieldNames()[this.mav.getMenubar().getDisplayMenu().getLabelIndex()], new int[]{interactions.get(i)[1]})[0];
            Interaction tempInt = new Interaction(source, target, types.get(i), directionals.get(i).booleanValue());
            nt.add(tempInt);
            if (!nodeAnnotations.containsKey(source)) {
                nodeAnnotations.put(source, new String[0]);
                for (String field : allFields) {
                    nt.addNodeAttribute(source, field, (Object)data.getElementAnnotation(interactions.get(i)[0], field)[0]);
                }
            }
            if (nodeAnnotations.containsKey(target)) continue;
            nodeAnnotations.put(target, new String[0]);
            for (String field : allFields) {
                nt.addNodeAttribute(target, field, (Object)data.getElementAnnotation(interactions.get(i)[1], field)[0]);
            }
        }
        nt.setName("MeV Network (" + nt.getNodes().length + ")");
        nt.setMetadata(this.getNetworkMetadata());
        return nt;
    }

    private static Tuple getNamelistMetadata(String identifierType, String source) {
        Tuple metaData = new Tuple();
        Single geneIdentifier = new Single("identifier-type", (Serializable)((Object)identifierType));
        metaData.addSingle(geneIdentifier);
        Tuple meVDataValues = new Tuple();
        if (source != null && !source.equals("")) {
            meVDataValues.addSingle(new Single("algorithm-source", (Serializable)((Object)source)));
        }
        Single meVMetaData = new Single("MeV-metadata", (Serializable)meVDataValues);
        metaData.addSingle(meVMetaData);
        return metaData;
    }

    private static Tuple getMatrixMetadata(String identifier, String logStatus, int dataType, String arrayName, String algorithmSource) {
        Tuple metaData = new Tuple();
        if (identifier != null && !identifier.equals("")) {
            metaData.addSingle(new Single("identifier-type", (Serializable)((Object)identifier)));
        }
        Tuple meVDataValues = new Tuple();
        if (logStatus != null && !logStatus.equals("")) {
            meVDataValues.addSingle(new Single("log-status", (Serializable)((Object)logStatus)));
        }
        meVDataValues.addSingle(new Single("data-type", (Serializable)((Object)GaggleTranslater.createGaggleDatatype(dataType))));
        if (arrayName != null && !arrayName.equals("")) {
            meVDataValues.addSingle(new Single("array-name", (Serializable)((Object)arrayName)));
        }
        if (algorithmSource != null && !algorithmSource.equals("")) {
            meVDataValues.addSingle(new Single("algorithm-source", (Serializable)((Object)algorithmSource)));
        }
        Single meVMetaData = new Single("MeV-metadata", (Serializable)meVDataValues);
        metaData.addSingle(meVMetaData);
        return metaData;
    }

    private Tuple getNetworkMetadata() {
        Tuple metaData = new Tuple();
        Tuple meVDataValues = new Tuple();
        Single meVMetaData = new Single("MeV-metadata", (Serializable)meVDataValues);
        metaData.addSingle(meVMetaData);
        return metaData;
    }

    public static String createGaggleDatatype(int mevDataType) {
        if (mevDataType == 0 || mevDataType == 1) {
            return "ratios";
        }
        return "intensities";
    }

    public static int translateDataType(String untranslatedDataType) {
        if (untranslatedDataType.equals("intensities")) {
            return 2;
        }
        if (untranslatedDataType.equals("ratios")) {
            return 1;
        }
        return 2;
    }
}

