/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.util.StringTokenizer;
import org.tigr.microarray.mev.file.agilent.AgilentFeature;

public class TopFeature
extends AgilentFeature {
    static final String sGB = "GB";
    static final String sGBPRI = "GBPri";
    static final String sGP = "GP";
    static final String sSP = "SP";
    private String topHit;
    private String accession;

    public TopFeature(String line) {
        StringTokenizer st = new StringTokenizer(line, "\t");
        int kount = st.countTokens();
        if (kount != 9) {
            System.out.println("kount(" + kount + ") != 9:" + line);
        } else {
            String one = st.nextToken();
            String two = st.nextToken();
            String three = st.nextToken();
            String four = st.nextToken();
            String five = st.nextToken();
            String six = st.nextToken();
            String seven = st.nextToken();
            String eight = st.nextToken();
            String nine = st.nextToken();
            this.setCol(this.s2int(one));
            this.setRow(this.s2int(two));
            this.setName(three);
            this.setSysName(four);
            this.setRefNumber(this.s2int(five));
            this.setControlType(six);
            this.setGeneName(seven);
            this.setTopHit(eight);
            this.setDesc(nine);
            this.assignFeatureType();
            if (this.hasGbPri(this.getTopHit())) {
                this.setAccession(TopFeature.parseAccession(this.topHit));
            } else {
                this.setAccession(this.getGeneName());
            }
        }
    }

    private boolean hasGbPri(String s) {
        boolean toReturn = false;
        if (s.toLowerCase().startsWith(sGBPRI.toLowerCase())) {
            toReturn = true;
        } else if (s.toLowerCase().startsWith(sGB.toLowerCase())) {
            toReturn = true;
        } else {
            int iPipe = s.indexOf("|");
            while (iPipe != -1) {
                int lastPipe = iPipe;
                String sub = s.substring(iPipe + 1);
                if (sub.toLowerCase().startsWith(sGBPRI.toLowerCase())) {
                    toReturn = true;
                }
                iPipe = s.indexOf("|", lastPipe + 1);
            }
        }
        return toReturn;
    }

    static String parseAccession(String s) {
        int iGb = s.toLowerCase().indexOf(sGB.toLowerCase());
        int iPipe = s.indexOf("|", iGb);
        int iColon = s.indexOf(":", iGb);
        int iNextPipe = s.indexOf("|", iPipe + 1);
        int iNextColon = s.indexOf(":", iColon + 1);
        String temp = iPipe != -1 ? (iNextPipe == -1 ? s.substring(iPipe + 1) : s.substring(iPipe + 1, iNextPipe - 2)) : (iNextColon == -1 ? s.substring(iColon + 1) : s.substring(iColon + 1, iNextColon - 2));
        int iDot = temp.indexOf(".");
        int iDash = temp.indexOf("-");
        String toReturn = iDot != -1 ? temp.substring(0, iDot) : (iDash != -1 ? temp.substring(0, iDash) : temp);
        return toReturn;
    }

    private int kountChar(String s, char c) {
        int toReturn = 0;
        for (int i = 0; i < s.length(); ++i) {
            char at = s.charAt(i);
            if (at != c) continue;
            ++toReturn;
        }
        return toReturn;
    }

    public int s2int(String s) {
        Integer I = new Integer(s);
        return I;
    }

    private void setTopHit(String sTopHit) {
        this.topHit = sTopHit;
    }

    public String getTopHit() {
        return this.topHit;
    }

    private void setAccession(String accession) {
        this.accession = accession;
    }

    public String getAccession() {
        return this.accession;
    }
}

