/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertyFactory {
    public static Properties readProperties(String bundle, Properties props) throws IOException {
        props = PropertyFactory.getPropertyBundle(bundle);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertyBundle(String sBundle) throws IOException {
        Properties p = new Properties();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(sBundle);
        try {
            p.load(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return p;
    }

    public static double getDoubleProperty(Properties pOb, String sKey) {
        double dVal = 0.0;
        try {
            String sVal = pOb.getProperty(sKey);
            if (sVal != null) {
                dVal = Double.valueOf(sVal);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return dVal;
    }

    public static long getLongProperty(Properties pOb, String sKey) {
        long lVal = 0L;
        try {
            String sVal = pOb.getProperty(sKey);
            if (sVal != null) {
                lVal = Long.valueOf(sVal);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return lVal;
    }

    public static boolean getBooleanProperty(Properties pOb, String sKey) {
        String value = pOb.getProperty(sKey);
        return value != null && value.equals("true");
    }

    public static int getIntProperty(Properties pOb, String sKey) {
        int lVal = 0;
        try {
            String sVal = pOb.getProperty(sKey);
            if (sVal != null) {
                lVal = Integer.valueOf(sVal);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lVal;
    }
}

