/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.tigr.microarray.mev.file.agilent.AgilentFile;
import org.tigr.microarray.mev.file.agilent.EightFeature;
import org.tigr.microarray.mev.file.agilent.Reader;
import org.tigr.microarray.mev.file.agilent.TopFeature;
import org.tigr.microarray.mev.file.agilent.UnrecognizedPatternException;

public class MeVotation {
    static String TAB = "\t";
    static String END_LINE = "\r\n";
    private Vector vLine;
    private AgilentFile af;

    public void parseAgilentPattern(File agilentPattern, String blankReplacement) throws UnrecognizedPatternException, IOException {
        Reader r = new Reader();
        r.readFile(agilentPattern);
        this.vLine = r.getVNullLineBasedOnHeader(blankReplacement);
        this.af = new AgilentFile(this.vLine);
    }

    public String getFileString() {
        StringBuffer sbReturn = new StringBuffer();
        Vector v = this.af.getVAgilentFeature();
        if (this.af.getPatternType() == 8) {
            sbReturn.append("UID\tR\tC\tGeneName\tDescription\r\n");
            for (int i = 0; i < v.size(); ++i) {
                EightFeature ef = (EightFeature)v.elementAt(i);
                if (ef.getControlType().equals("ignore")) continue;
                sbReturn.append(ef.getRefNumber());
                sbReturn.append(TAB);
                sbReturn.append(ef.getRow());
                sbReturn.append(TAB);
                sbReturn.append(ef.getCol());
                sbReturn.append(TAB);
                sbReturn.append(this.nullify(ef.getGeneName()));
                sbReturn.append(TAB);
                sbReturn.append(this.nullify(ef.getDesc()));
                sbReturn.append(END_LINE);
            }
        } else if (this.af.getPatternType() == 9) {
            sbReturn.append("UID\tR\tC\tGeneName\tDescription\tTopHit\r\n");
            for (int i = 0; i < v.size(); ++i) {
                TopFeature tf = (TopFeature)v.elementAt(i);
                if (!tf.getControlType().equals("ignore")) {
                    sbReturn.append(tf.getRefNumber());
                    sbReturn.append(TAB);
                    sbReturn.append(tf.getRow());
                    sbReturn.append(TAB);
                    sbReturn.append(tf.getCol());
                    sbReturn.append(TAB);
                    sbReturn.append(this.nullify(tf.getName()));
                    sbReturn.append(TAB);
                    sbReturn.append(this.nullify(tf.getDesc()));
                    sbReturn.append(TAB);
                    sbReturn.append(this.nullify(TopFeature.parseAccession(tf.getTopHit())));
                    sbReturn.append(END_LINE);
                }
                if (i != 100) continue;
            }
        } else {
            System.out.println("SomethingReallyFunky");
        }
        return sbReturn.toString();
    }

    private String nullify(String s) {
        if (s == null) {
            return "null";
        }
        if (s.equals("")) {
            return "null";
        }
        if (s.equals("NA")) {
            return "null";
        }
        return s;
    }
}

