/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.file.agilent.ColumnMismatchException;
import org.tigr.microarray.mev.file.agilent.Extract;
import org.tigr.microarray.mev.file.agilent.Reader;

public class MeVerizer {
    public static String HEADER_HEADER = "FEATURES";
    public static String FUDGE = "FUDGE";
    public static String PLACE_HOLDER = "MOTHRA";
    public static boolean PARSE_BY_HEADERS = true;
    public static boolean PARSE_BY_INDICES = false;
    private String mHeaders;
    private String columnDef;
    private String headerLine;
    private int iHeaders;
    private Vector vExtract;

    public MeVerizer(String mHeadersP, String columnDefP) throws ColumnMismatchException {
        this.mHeaders = mHeadersP;
        this.columnDef = columnDefP;
        StringTokenizer st1 = new StringTokenizer(mHeadersP, "\t");
        StringTokenizer st2 = new StringTokenizer(columnDefP, "\t");
        if (st1.countTokens() != st2.countTokens()) {
            throw new ColumnMismatchException("Header columns are mismatched");
        }
    }

    public void parseExtract(File f, boolean parseByHeaders, String replacement) throws IOException {
        Vector vLine = this.readFileAsVector(f);
        this.iHeaders = this.findHeaderRow(vLine, HEADER_HEADER);
        this.headerLine = this.findHeaderString(vLine, HEADER_HEADER);
        this.vExtract = this.createExtract(vLine, this.headerLine, this.iHeaders, parseByHeaders, replacement);
    }

    private Vector createExtract(Vector vLine, String headerLine, int iHeader, boolean parseByHeaders, String replacement) {
        Vector<Extract> vReturn = new Vector<Extract>();
        for (int i = iHeader + 1; i < vLine.size(); ++i) {
            String line = (String)vLine.elementAt(i);
            Extract e = new Extract();
            if (parseByHeaders) {
                e.parseLineByHeaders(headerLine, line, this.columnDef, replacement);
            } else {
                e.parseLineByIndex(this.columnDef, line, replacement);
            }
            vReturn.add(e);
        }
        return vReturn;
    }

    private String findHeaderString(Vector vLine, String sDefine) {
        String sReturn = null;
        for (int i = 0; i < vLine.size(); ++i) {
            String line = (String)vLine.elementAt(i);
            if (!line.startsWith(sDefine)) continue;
            sReturn = line;
        }
        return sReturn;
    }

    private int findHeaderRow(Vector vLine, String sDefine) {
        int iReturn = 0;
        for (int i = 0; i < vLine.size(); ++i) {
            String line = (String)vLine.elementAt(i);
            if (!line.startsWith(sDefine)) continue;
            iReturn = i;
        }
        return iReturn;
    }

    private Vector readFileAsVector(File f) throws IOException {
        Reader r = new Reader();
        r.readFile(f);
        return r.getVNullLine(PLACE_HOLDER);
    }

    public String getFileString() {
        StringBuffer sbReturn = new StringBuffer(this.mHeaders + "\r\n");
        for (int i = 0; i < this.vExtract.size(); ++i) {
            Extract e = (Extract)this.vExtract.elementAt(i);
            String s = e.getParsedLine();
            sbReturn.append(s);
            sbReturn.append("\r\n");
        }
        return sbReturn.toString();
    }

    public Vector checkHeaders() {
        Vector<String> vReturn = new Vector<String>();
        Vector<String> vWant = new Vector<String>();
        Vector<String> vHave = new Vector<String>();
        StringTokenizer stWant = new StringTokenizer(this.columnDef, "\t");
        while (stWant.hasMoreTokens()) {
            vWant.add(stWant.nextToken());
        }
        StringTokenizer stHave = new StringTokenizer(this.headerLine, "\t");
        while (stHave.hasMoreTokens()) {
            vHave.add(stHave.nextToken());
        }
        for (int i = 0; i < vWant.size(); ++i) {
            String want = (String)vWant.elementAt(i);
            boolean wantFound = false;
            for (int j = 0; j < vHave.size(); ++j) {
                String have = (String)vHave.elementAt(j);
                if (!want.toLowerCase().equals(have.toLowerCase())) continue;
                wantFound = true;
            }
            if (wantFound) continue;
            vReturn.add(want);
        }
        return vReturn;
    }
}

