/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.file.AgilentAnnFileParser;
import org.tigr.microarray.file.AgilentMevFileParser;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.SlideLoaderProgressBar;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.FileLoaderUtility;

public class AgilentMevFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private AgilentMevFileLoaderPanel amflp;
    private boolean loadEnabled = false;
    private String[] uidArray;
    boolean haveSRandSC;
    boolean loadMedianIntensities = false;
    private boolean haveAnnMatch = false;
    private MultipleArrayViewer mav;

    public AgilentMevFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.amflp = new AgilentMevFileLoaderPanel();
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public void setFilePath(String path) {
        this.amflp.pathTextField.setText(path);
        this.processFileList(path, new Vector());
    }

    public Vector loadExpressionFiles() throws IOException {
        File file;
        int i;
        Object[] mevFiles = this.amflp.getMevSelectedListModel().toArray();
        Object[] annFiles = this.amflp.getAnnSelectedListModel().toArray();
        Vector<ISlideData> data = new Vector<ISlideData>();
        ISlideMetaData metaData = null;
        this.loadMedianIntensities = this.amflp.loadMedButton.isSelected();
        this.setFilesCount(mevFiles.length);
        this.setRemain(mevFiles.length);
        for (i = 0; i < mevFiles.length; ++i) {
            this.setFileName(((File)mevFiles[i]).getName());
            if (i == 0) {
                file = new File(this.amflp.pathTextField.getText(), ((File)mevFiles[i]).getName());
                ISlideData slideData = this.loadSlideData(file);
                if (slideData == null) {
                    return null;
                }
                data.add(slideData);
                metaData = slideData.getSlideMetaData();
            } else {
                file = new File(this.amflp.pathTextField.getText(), ((File)mevFiles[i]).getName());
                data.add(this.loadFloatSlideData(file, metaData));
            }
            this.setRemain(mevFiles.length - i - 1);
            this.setFilesProgress(i);
        }
        if (!this.amflp.noAnnFileBox.isSelected()) {
            for (i = 0; i < annFiles.length; ++i) {
                file = new File(this.amflp.annFileListTextField.getText(), ((File)annFiles[i]).getName());
                this.loadAnnotationFile((SlideData)data.elementAt(0), file);
            }
        } else {
            File file2 = new File(this.amflp.pathTextField.getText(), ((File)mevFiles[0]).getName());
            this.loadAnnotationFromMevFile(file2, (SlideData)data.elementAt(0));
        }
        if (this.amflp.noAnnFileBox.isSelected() || annFiles == null || annFiles.length == 0) {
            this.haveAnnMatch = true;
        }
        if (!this.haveAnnMatch) {
            String msg = "The selected annoation file";
            if (annFiles != null && annFiles.length > 1) {
                msg = msg + "s";
            }
            msg = msg + " did not have have UID's that matched any UID's \n";
            msg = msg + "in the selected mev files.";
            JOptionPane.showMessageDialog(this.amflp, msg, "Annotation Mismatch Warning", 2);
        }
        return data;
    }

    @Override
    public ISlideData loadExpressionFile(File file) {
        return null;
    }

    public void loadAnnotationFromMevFile(File file, SlideData data) {
        AgilentMevFileParser mfp = new AgilentMevFileParser();
        mfp.loadFile(file);
        SpotInformationData annot = mfp.getSpotInformation();
        int length = annot.getSize();
        String[] header = annot.getSpotInformationHeader();
        data.getSlideMetaData().appendFieldNames(header);
        for (int i = 0; i < length; ++i) {
            ((SlideDataElement)data.getSlideDataElement(i)).setExtraFields(annot.getSpotInformationArray(i));
        }
    }

    public ISlideData loadSlideData(File currentFile) throws IOException {
        SlideData slideData = null;
        AgilentMevFileParser mfp = new AgilentMevFileParser();
        mfp.loadFile(currentFile);
        if (mfp.isMevFileLoaded()) {
            Vector headers = mfp.getColumnHeaders();
            int i1 = this.getIntensityColumn(headers, 1);
            int i2 = this.getIntensityColumn(headers, 2);
            if (i1 == -1 || i2 == -1) {
                if (this.loadMedianIntensities) {
                    JOptionPane.showMessageDialog(this.amflp, "Error loading " + currentFile.getName() + "\n" + "The file was missing median intensity columns indicated by\n" + "the header names MedA and MedB", "Load Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.amflp, "Error loading " + currentFile.getName() + "\n" + "The file was missing intensity columns indicated by\n" + "the header names IA and IB", "Load Error", 0);
                }
                return null;
            }
            this.haveSRandSC = false;
            if (headers.size() > 7) {
                String possibleSR = (String)headers.elementAt(7);
                String possibleSC = (String)headers.elementAt(8);
                if (possibleSR.equals("SR") && possibleSC.equals("SC")) {
                    this.haveSRandSC = true;
                }
            }
            String[][] data = mfp.getDataMatrix();
            this.uidArray = new String[data.length];
            int maxRow = 0;
            int maxCol = 0;
            for (int i = 0; i < data.length; ++i) {
                maxRow = Math.max(maxRow, Integer.parseInt(data[i][3]));
                maxCol = Math.max(maxCol, Integer.parseInt(data[i][4]));
            }
            SampleAnnotation sampAnn = new SampleAnnotation();
            slideData = new SlideData(maxRow, maxCol, sampAnn);
            this.setLinesCount(data.length);
            for (int i = 0; i < data.length; ++i) {
                int[] rows = new int[3];
                int[] cols = new int[3];
                float[] intensities = new float[2];
                this.uidArray[i] = data[i][0];
                try {
                    intensities[0] = Float.parseFloat(data[i][i1]);
                    intensities[1] = Float.parseFloat(data[i][i2]);
                    rows[0] = Integer.parseInt(data[i][3]);
                    cols[0] = Integer.parseInt(data[i][4]);
                    rows[1] = Integer.parseInt(data[i][5]);
                    cols[1] = Integer.parseInt(data[i][6]);
                    if (this.haveSRandSC) {
                        rows[2] = Integer.parseInt(data[i][7]);
                        cols[2] = Integer.parseInt(data[i][8]);
                    } else {
                        rows[2] = 0;
                        cols[2] = 0;
                    }
                }
                catch (NumberFormatException e) {
                    final String fileName = currentFile.getName();
                    final int loc = i;
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showConfirmDialog(AgilentMevFileLoader.this.amflp, "The input file \"" + fileName + "\" was missing critical information on line # " + String.valueOf(loc + 1) + "\n" + "MeV files require entries for UID, Intensities, and slide location information.", "Loading Aborted/Loading Error", 0);
                        }
                    });
                    thread.start();
                    return null;
                }
                SlideDataElement sde = new SlideDataElement(data[i][0], rows, cols, intensities, null);
                slideData.add(sde);
                this.setFileProgress(i);
            }
            if (this.amflp.saveSpotInfoBox.isSelected() && !this.amflp.noAnnFileBox.isSelected()) {
                slideData.setSpotInformationData(mfp.getSpotInformation());
            }
            slideData.setSampleAnnotationLoaded(true);
            slideData.getSampleAnnotation().setAnnotation("Default Slide Name", currentFile.getName());
            slideData.setSlideDataName(currentFile.getName());
            slideData.setSlideFileName(currentFile.getPath());
            this.mav.getData().setSampleAnnotationLoaded(true);
        }
        return slideData;
    }

    private int getIntensityColumn(Vector headers, int index) {
        int col = -1;
        String headerKey = this.loadMedianIntensities ? (index == 1 ? "MedA" : "MedB") : (index == 1 ? "IA" : "IB");
        for (int i = 0; i < headers.size(); ++i) {
            if (!((String)headers.elementAt(i)).equals(headerKey)) continue;
            col = i;
            break;
        }
        return col;
    }

    public ISlideData loadFloatSlideData(File currentFile, ISlideMetaData metaData) throws IOException {
        AgilentMevFileParser mfp = new AgilentMevFileParser();
        mfp.loadFile(currentFile);
        SampleAnnotation sampAnn = new SampleAnnotation();
        FloatSlideData slideData = new FloatSlideData(metaData, sampAnn);
        if (mfp.isMevFileLoaded()) {
            Vector headers = mfp.getColumnHeaders();
            int i1 = this.getIntensityColumn(headers, 1);
            int i2 = this.getIntensityColumn(headers, 2);
            if (i1 == -1 || i2 == -1) {
                if (this.loadMedianIntensities) {
                    JOptionPane.showMessageDialog(this.amflp, "Error loading " + currentFile.getName() + "\n" + "The file was missing median intensity columns indicated by\n" + "the header names MedA and MedB", "Load Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.amflp, "Error loading " + currentFile.getName() + "\n" + "The file was missing intensity columns indicated by\n" + "the header names IA and IB", "Load Error", 0);
                }
                return null;
            }
            String[][] data = mfp.getDataMatrix();
            this.setLinesCount(data.length);
            for (int i = 0; i < data.length; ++i) {
                slideData.setIntensities(i, Float.parseFloat(data[i][i1]), Float.parseFloat(data[i][i2]));
                this.setFileProgress(i);
            }
            if (this.amflp.saveSpotInfoBox.isSelected() && !this.amflp.noAnnFileBox.isSelected()) {
                slideData.setSpotInformationData(mfp.getSpotInformation());
            }
        }
        slideData.setSampleAnnotationLoaded(true);
        slideData.getSampleAnnotation().setAnnotation("Default Slide Name", currentFile.getName());
        this.mav.getData().setSampleAnnotationLoaded(true);
        slideData.setSlideDataName(currentFile.getName());
        slideData.setSlideFileName(currentFile.getPath());
        slideData.setSlideDataName(currentFile.getName());
        return slideData;
    }

    public Vector loadAnnotationFile(SlideData targetData, File sourceFile) throws IOException {
        AgilentAnnFileParser parser = new AgilentAnnFileParser();
        parser.loadFile(sourceFile);
        if (parser.isAnnFileLoaded()) {
            Vector headers = parser.getColumnHeaders();
            int firstAnnField = 1;
            if (headers.size() >= 3 && ((String)headers.get(1)).equalsIgnoreCase("R") && ((String)headers.get(2)).equalsIgnoreCase("C")) {
                firstAnnField = 3;
            }
            String[] annotHeaders = new String[headers.size() - firstAnnField];
            for (int i = firstAnnField; i < headers.size(); ++i) {
                annotHeaders[i - firstAnnField] = (String)headers.elementAt(i);
            }
            targetData.getSlideMetaData().appendFieldNames(annotHeaders);
            String[][] annMatrix = parser.getDataMatrix();
            Hashtable<String, String[]> hash = new Hashtable<String, String[]>();
            int dataLength = targetData.size();
            for (int i = 0; i < annMatrix.length; ++i) {
                String[] value = new String[annMatrix[i].length - firstAnnField];
                System.arraycopy(annMatrix[i], firstAnnField, value, 0, annMatrix[i].length - firstAnnField);
                hash.put(annMatrix[i][0], value);
            }
            for (int i = 0; i < dataLength; ++i) {
                String[] extraFields = (String[])hash.get(this.uidArray[i]);
                if (!this.haveAnnMatch && extraFields != null) {
                    this.haveAnnMatch = true;
                }
                ((SlideDataElement)targetData.getSlideDataElement(i)).setExtraFields(extraFields);
            }
        }
        return new Vector();
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Agilent Feature Extraction Files (*.txt)";
            }
        };
        return mevFileFilter;
    }

    public FileFilter getAnnotationFileFilter() {
        FileFilter annFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Agilent Design Files (*.txt)";
            }
        };
        return annFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean state) {
        this.loadEnabled = state;
        this.checkLoadEnable();
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.amflp;
    }

    public void processFileList(String filePath, Vector fileNames) {
        this.amflp.setPath(filePath);
        if (fileNames == null) {
            return;
        }
        FileFilter mevFileFilter = this.getFileFilter();
        FileFilter annFileFilter = this.getAnnotationFileFilter();
        this.amflp.getMevAvailableListModel().clear();
        this.amflp.getAnnAvailableListModel().clear();
        for (int i = 0; i < fileNames.size(); ++i) {
            File targetFile = new File((String)fileNames.elementAt(i));
            if (mevFileFilter.accept(targetFile)) {
                this.amflp.getMevAvailableListModel().addElement(new File((String)fileNames.elementAt(i)));
            }
            if (!annFileFilter.accept(targetFile)) continue;
            this.amflp.getAnnAvailableListModel().addElement(new File((String)fileNames.elementAt(i)));
        }
    }

    @Override
    public String getFilePath() {
        if (this.amflp.pathTextField == null) {
            return null;
        }
        return this.amflp.pathTextField.getText();
    }

    @Override
    public void openDataPath() {
    }

    @Override
    public String getAnnotationFilePath() {
        return null;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    public class ProgressRunner
    implements Runnable {
        @Override
        public void run() {
            AgilentMevFileLoader.this.progress = new SlideLoaderProgressBar(AgilentMevFileLoader.this.superLoader.getFrame());
        }
    }

    private class AgilentMevFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JPanel mevSelectionPanel;
        JPanel mevListPanel;
        JPanel selectFilePanel;
        JLabel selectFile;
        JButton browseButton1;
        JTextField pathTextField;
        JLabel selectAnnotation;
        JButton browseButton2;
        JTextField annFileListTextField;
        JPanel annotationPanel;
        JPanel selectAnnotationPanel;
        JLabel mevAvailableLabel;
        JLabel mevSelectedLabel;
        JList mevAvailableList;
        JList mevSelectedList;
        JScrollPane mevAvailableScrollPane;
        JScrollPane mevSelectedScrollPane;
        JButton mevAddButton;
        JButton mevAddAllButton;
        JButton mevRemoveButton;
        JButton mevRemoveAllButton;
        JPanel mevButtonPanel;
        JPanel annSelectionPanel;
        JPanel annListPanel;
        JLabel annAvailableLabel;
        JLabel annSelectedLabel;
        JList annAvailableList;
        JList annSelectedList;
        JScrollPane annAvailableScrollPane;
        JScrollPane annSelectedScrollPane;
        JButton annAddButton;
        JButton annAddAllButton;
        JButton annRemoveButton;
        JButton annRemoveAllButton;
        JPanel annButtonPanel;
        JPanel selectionPanel;
        JSplitPane splitPane;
        JPanel fileLoaderPanel;
        JCheckBox noAnnFileBox;
        JCheckBox saveSpotInfoBox;
        JCheckBox cutQuotesBox;
        JRadioButton loadIButton;
        JRadioButton loadMedButton;

        public AgilentMevFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.selectFilePanel = new JPanel();
            this.selectFilePanel.setLayout(new GridBagLayout());
            this.selectFile = new JLabel("Select directory containing Agilent Feature Extraction Files");
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.setSize(new Dimension(100, 30));
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.browseButton1.addActionListener(new EventHandler());
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            AgilentMevFileLoader.this.gba.add(this.selectFilePanel, this.selectFile, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.selectFilePanel, this.pathTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.selectFilePanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.mevSelectionPanel = new JPanel();
            this.mevSelectionPanel.setLayout(new GridBagLayout());
            this.mevSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Agilent Feature Extraction Files (*.txt)"));
            this.mevAvailableLabel = new JLabel("Available Files");
            this.mevSelectedLabel = new JLabel("Selected Files");
            this.mevAvailableList = new JList(new DefaultListModel());
            this.mevSelectedList = new JList(new DefaultListModel());
            this.mevAvailableScrollPane = new JScrollPane(this.mevAvailableList);
            this.mevSelectedScrollPane = new JScrollPane(this.mevSelectedList);
            this.mevAddButton = new JButton("Add");
            this.mevAddButton.setPreferredSize(new Dimension(100, 20));
            this.mevAddButton.addActionListener(new EventHandler());
            this.mevAddAllButton = new JButton("Add All");
            this.mevAddAllButton.setPreferredSize(new Dimension(100, 20));
            this.mevAddAllButton.addActionListener(new EventHandler());
            this.mevRemoveButton = new JButton("Remove");
            this.mevRemoveButton.setPreferredSize(new Dimension(100, 20));
            this.mevRemoveButton.addActionListener(new EventHandler());
            this.mevRemoveAllButton = new JButton("Remove All");
            this.mevRemoveAllButton.setPreferredSize(new Dimension(100, 20));
            this.mevRemoveAllButton.addActionListener(new EventHandler());
            this.mevButtonPanel = new JPanel();
            this.mevButtonPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add(this.mevButtonPanel, this.mevAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevButtonPanel, this.mevAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevButtonPanel, this.mevRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevButtonPanel, this.mevRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.loadIButton = new JRadioButton("Load Integrated Spot Intensities", true);
            this.loadIButton.setFocusPainted(false);
            this.loadMedButton = new JRadioButton("Load Median Spot Intensities");
            this.loadMedButton.setFocusPainted(false);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.loadIButton);
            bg.add(this.loadMedButton);
            this.noAnnFileBox = new JCheckBox("Use Annotation Contained in MeV File (no annotation file)", false);
            this.noAnnFileBox.setFocusPainted(false);
            this.noAnnFileBox.setActionCommand("use-annotation-in-mev-file");
            this.noAnnFileBox.addActionListener(new EventHandler());
            this.saveSpotInfoBox = new JCheckBox("Load Auxiliary Spot Information", false);
            this.saveSpotInfoBox.setFocusPainted(false);
            this.cutQuotesBox = new JCheckBox("Remove Annotation Quotes(\"...\")", false);
            this.cutQuotesBox.setHorizontalAlignment(0);
            this.cutQuotesBox.setFocusPainted(false);
            this.mevListPanel = new JPanel();
            this.mevListPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add(this.mevListPanel, this.mevAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevListPanel, this.mevAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevListPanel, this.mevButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevListPanel, this.mevSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevListPanel, this.mevSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevSelectionPanel, this.selectFilePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.mevSelectionPanel, this.mevListPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.selectAnnotationPanel = new JPanel();
            this.selectAnnotationPanel.setLayout(new GridBagLayout());
            this.browseButton2 = new JButton("Browse");
            this.browseButton2.addActionListener(new EventHandler());
            this.browseButton2.setSize(new Dimension(100, 30));
            this.browseButton2.setPreferredSize(new Dimension(100, 30));
            this.selectAnnotation = new JLabel("Select directory containing Agilent Design files");
            this.annFileListTextField = new JTextField();
            this.annFileListTextField.setEditable(false);
            this.annFileListTextField.setForeground(Color.black);
            this.annFileListTextField.setFont(new Font("monospaced", 1, 12));
            AgilentMevFileLoader.this.gba.add(this.selectAnnotationPanel, this.selectAnnotation, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.selectAnnotationPanel, this.annFileListTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.selectAnnotationPanel, this.browseButton2, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.annSelectionPanel = new JPanel();
            this.annSelectionPanel.setLayout(new GridBagLayout());
            this.annSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (Agilent Design Files(*.txt)"));
            this.annAvailableLabel = new JLabel("Available Files");
            this.annSelectedLabel = new JLabel("Selected Files");
            this.annAvailableList = new JList(new DefaultListModel());
            this.annSelectedList = new JList(new DefaultListModel());
            this.annAvailableScrollPane = new JScrollPane(this.annAvailableList);
            this.annSelectedScrollPane = new JScrollPane(this.annSelectedList);
            this.annAddButton = new JButton("Add");
            this.annAddButton.addActionListener(new EventHandler());
            this.annAddAllButton = new JButton("Add All");
            this.annAddAllButton.addActionListener(new EventHandler());
            this.annRemoveButton = new JButton("Remove");
            this.annRemoveButton.addActionListener(new EventHandler());
            this.annRemoveAllButton = new JButton("Remove All");
            this.annRemoveAllButton.addActionListener(new EventHandler());
            Dimension buttonSize = new Dimension(100, 20);
            Dimension largestAnnButtonSize = this.annRemoveAllButton.getPreferredSize();
            this.annAddButton.setPreferredSize(buttonSize);
            this.annAddAllButton.setPreferredSize(buttonSize);
            this.annRemoveButton.setPreferredSize(buttonSize);
            this.annRemoveAllButton.setPreferredSize(buttonSize);
            this.mevAddAllButton.setFocusPainted(false);
            this.mevAddButton.setFocusPainted(false);
            this.mevRemoveAllButton.setFocusPainted(false);
            this.mevRemoveButton.setFocusPainted(false);
            this.annAddAllButton.setFocusPainted(false);
            this.annAddButton.setFocusPainted(false);
            this.annRemoveAllButton.setFocusPainted(false);
            this.annRemoveButton.setFocusPainted(false);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add(buttonPanel, this.loadIButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add(buttonPanel, this.saveSpotInfoBox, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add(buttonPanel, this.loadMedButton, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add(buttonPanel, this.noAnnFileBox, 1, 1, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add(buttonPanel, this.cutQuotesBox, 0, 2, 2, 1, 1, 0, 2, 13, new Insets(0, 118, 0, 5), 0, 0);
            this.annButtonPanel = new JPanel();
            this.annButtonPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add(this.annButtonPanel, this.annAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annButtonPanel, this.annAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annButtonPanel, this.annRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annButtonPanel, this.annRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.annListPanel = new JPanel();
            this.annListPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add(this.annListPanel, this.annAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annListPanel, this.annSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annListPanel, this.annAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annListPanel, this.annButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annListPanel, this.annSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annSelectionPanel, buttonPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annSelectionPanel, this.selectAnnotationPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 0, 2, 0), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.annSelectionPanel, this.annListPanel, 0, 3, 1, 2, 1, 1, 1, 10, new Insets(2, 2, 0, 2), 0, 0);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add(this.selectionPanel, this.annSelectionPanel, 0, 1, 2, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this.selectionPanel, this.mevSelectionPanel, 0, 5, 2, 2, 1, 1, 1, 10, new Insets(0, 2, 0, 2), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add(this.fileLoaderPanel, this.selectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentMevFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        }

        public void setPath(String path) {
            this.pathTextField.setText(path);
        }

        public void validateLists() {
            if (((DefaultListModel)this.mevSelectedList.getModel()).size() > 0) {
                AgilentMevFileLoader.this.markLoadEnabled(true);
            } else {
                AgilentMevFileLoader.this.markLoadEnabled(false);
            }
        }

        public void onMevFileBrowse() {
            FileLoaderUtility fileLoad = new FileLoaderUtility();
            Vector retrievedFileNames = new Vector();
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(1);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                ((DefaultListModel)this.mevAvailableList.getModel()).clear();
                ((DefaultListModel)this.mevSelectedList.getModel()).clear();
                File selectedFile = fileChooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
                for (int i = 0; i < retrievedFileNames.size(); ++i) {
                    Object fileName = retrievedFileNames.get(i);
                    boolean acceptFile = AgilentMevFileLoader.this.getFileFilter().accept((File)fileName);
                    if (!acceptFile) continue;
                    this.pathTextField.setText(path);
                    String Name = fileChooser.getName((File)fileName);
                    ((DefaultListModel)this.mevAvailableList.getModel()).addElement(new File(Name));
                }
            }
        }

        public void onMevAdd() {
            int i;
            int[] chosenIndices = this.mevAvailableList.getSelectedIndices();
            Object[] chosenObjects = new Object[chosenIndices.length];
            for (i = chosenIndices.length - 1; i >= 0; --i) {
                Object addItem = ((DefaultListModel)this.mevAvailableList.getModel()).getElementAt(chosenIndices[i]);
                chosenObjects[i] = addItem;
            }
            for (i = 0; i < chosenIndices.length; ++i) {
                ((DefaultListModel)this.mevSelectedList.getModel()).addElement(chosenObjects[i]);
            }
            this.validateLists();
        }

        public void onMevAddAll() {
            int elementCount = ((DefaultListModel)this.mevAvailableList.getModel()).size();
            for (int i = 0; i < elementCount; ++i) {
                Object addItem = ((DefaultListModel)this.mevAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.mevSelectedList.getModel()).addElement(addItem);
            }
            this.validateLists();
        }

        public void onMevRemove() {
            int[] chosenIndices = this.mevSelectedList.getSelectedIndices();
            for (int i = chosenIndices.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.mevSelectedList.getModel()).remove(chosenIndices[i]);
            }
            this.validateLists();
        }

        public void onMevRemoveAll() {
            ((DefaultListModel)this.mevSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public void onAnnAdd() {
            int i;
            int[] chosenIndices = this.annAvailableList.getSelectedIndices();
            Object[] chosenObjects = new Object[chosenIndices.length];
            for (i = chosenIndices.length - 1; i >= 0; --i) {
                Object addItem = ((DefaultListModel)this.annAvailableList.getModel()).getElementAt(chosenIndices[i]);
                chosenObjects[i] = addItem;
            }
            for (i = 0; i < chosenIndices.length; ++i) {
                ((DefaultListModel)this.annSelectedList.getModel()).addElement(chosenObjects[i]);
            }
            this.validateLists();
        }

        public void onAnnAddAll() {
            int elementCount = ((DefaultListModel)this.annAvailableList.getModel()).size();
            for (int i = 0; i < elementCount; ++i) {
                Object addItem = ((DefaultListModel)this.annAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.annSelectedList.getModel()).addElement(addItem);
            }
            this.validateLists();
        }

        public void onAnnRemove() {
            int[] chosenIndices = this.annSelectedList.getSelectedIndices();
            for (int i = chosenIndices.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.annSelectedList.getModel()).remove(chosenIndices[i]);
            }
            this.validateLists();
        }

        public void onAnnRemoveAll() {
            ((DefaultListModel)this.annSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public void updateAnnFieldTextField() {
            DefaultListModel model = (DefaultListModel)this.annSelectedList.getModel();
            AgilentAnnFileParser parser = new AgilentAnnFileParser();
            String text = "";
            for (int i = 0; i < model.getSize(); ++i) {
                File annFile = (File)model.get(i);
                parser.loadFile(annFile);
                if (!parser.isAnnFileLoaded()) continue;
                Vector annVector = parser.getColumnHeaders();
                if (i > 0 && annVector.size() > 3) {
                    text = text + ", ";
                }
                for (int j = 3; j < annVector.size() - 1; ++j) {
                    text = text + (String)annVector.elementAt(j) + ", ";
                }
                text = text + (String)annVector.elementAt(annVector.size() - 1);
            }
        }

        public void onUseMevAnn() {
            if (this.noAnnFileBox.isSelected()) {
                this.enableAnnotationPanel(false);
            } else {
                this.enableAnnotationPanel(true);
            }
        }

        public void onAnnFileBrowse() {
            FileLoaderUtility fileLoad = new FileLoaderUtility();
            Vector retrievedFileNames = new Vector();
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(1);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                ((DefaultListModel)this.annAvailableList.getModel()).clear();
                ((DefaultListModel)this.annSelectedList.getModel()).clear();
                File selectedFile = fileChooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
                for (int i = 0; i < retrievedFileNames.size(); ++i) {
                    Object fileName = retrievedFileNames.get(i);
                    boolean acceptFile = AgilentMevFileLoader.this.getAnnotationFileFilter().accept((File)fileName);
                    if (!acceptFile) continue;
                    this.annFileListTextField.setText(path);
                    String Name = fileChooser.getName((File)fileName);
                    ((DefaultListModel)this.annAvailableList.getModel()).addElement(new File(Name));
                }
            }
        }

        public void enableAnnotationPanel(boolean enable) {
            this.annAddAllButton.setEnabled(enable);
            this.annAddButton.setEnabled(enable);
            this.annRemoveAllButton.setEnabled(enable);
            this.annRemoveButton.setEnabled(enable);
            this.annAvailableLabel.setEnabled(enable);
            this.annSelectedLabel.setEnabled(enable);
            this.annAvailableList.setEnabled(enable);
            this.annSelectedList.setEnabled(enable);
            if (!enable) {
                this.annAvailableList.setBackground(Color.lightGray);
                this.annSelectedList.setBackground(Color.lightGray);
            } else {
                this.annAvailableList.setBackground(Color.white);
                this.annSelectedList.setBackground(Color.white);
            }
        }

        public DefaultListModel getMevAvailableListModel() {
            return (DefaultListModel)this.mevAvailableList.getModel();
        }

        public DefaultListModel getAnnAvailableListModel() {
            return (DefaultListModel)this.annAvailableList.getModel();
        }

        public DefaultListModel getMevSelectedListModel() {
            return (DefaultListModel)this.mevSelectedList.getModel();
        }

        public DefaultListModel getAnnSelectedListModel() {
            return (DefaultListModel)this.annSelectedList.getModel();
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            @Override
            public void nodeSelected(FileTreePaneEvent event) {
                String filePath = (String)event.getValue("Path");
                Vector fileNames = (Vector)event.getValue("Filenames");
                AgilentMevFileLoader.this.processFileList(filePath, fileNames);
            }

            @Override
            public void nodeCollapsed(FileTreePaneEvent event) {
            }

            @Override
            public void nodeExpanded(FileTreePaneEvent event) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == AgilentMevFileLoaderPanel.this.mevAddButton) {
                    AgilentMevFileLoaderPanel.this.onMevAdd();
                } else if (source == AgilentMevFileLoaderPanel.this.browseButton1) {
                    AgilentMevFileLoaderPanel.this.onMevFileBrowse();
                } else if (source == AgilentMevFileLoaderPanel.this.mevAddAllButton) {
                    AgilentMevFileLoaderPanel.this.onMevAddAll();
                } else if (source == AgilentMevFileLoaderPanel.this.mevRemoveButton) {
                    AgilentMevFileLoaderPanel.this.onMevRemove();
                } else if (source == AgilentMevFileLoaderPanel.this.mevRemoveAllButton) {
                    AgilentMevFileLoaderPanel.this.onMevRemoveAll();
                } else if (source == AgilentMevFileLoaderPanel.this.annAddButton) {
                    AgilentMevFileLoaderPanel.this.onAnnAdd();
                } else if (source == AgilentMevFileLoaderPanel.this.annAddAllButton) {
                    AgilentMevFileLoaderPanel.this.onAnnAddAll();
                } else if (source == AgilentMevFileLoaderPanel.this.annRemoveButton) {
                    AgilentMevFileLoaderPanel.this.onAnnRemove();
                } else if (source == AgilentMevFileLoaderPanel.this.annRemoveAllButton) {
                    AgilentMevFileLoaderPanel.this.onAnnRemoveAll();
                } else if (source == AgilentMevFileLoaderPanel.this.noAnnFileBox) {
                    AgilentMevFileLoaderPanel.this.onUseMevAnn();
                } else if (source == AgilentMevFileLoaderPanel.this.browseButton2) {
                    AgilentMevFileLoaderPanel.this.onAnnFileBrowse();
                }
            }
        }
    }
}

