/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.file.agilent.EightFeature;
import org.tigr.microarray.mev.file.agilent.TopFeature;
import org.tigr.microarray.mev.file.agilent.UnrecognizedPatternException;

public class AgilentFile {
    static final int EIGHT_COL = 8;
    static final int NINE_COL = 9;
    private int patternType;
    private Vector vAgilentFeature;
    private File file;

    public AgilentFile(Vector vLine) throws UnrecognizedPatternException {
        String header = (String)vLine.elementAt(0);
        this.patternType = this.characterizePattern(header);
        this.setVAgilentFeature(new Vector());
        for (int i = 1; i < vLine.size(); ++i) {
            String line = (String)vLine.elementAt(i);
            if (this.patternType == 8) {
                EightFeature ef = new EightFeature(line);
                this.getVAgilentFeature().add(ef);
                continue;
            }
            if (this.patternType != 9) continue;
            TopFeature tf = new TopFeature(line);
            this.getVAgilentFeature().add(tf);
        }
    }

    public int characterizePattern(String header) throws UnrecognizedPatternException {
        StringTokenizer st = new StringTokenizer(header, "\t");
        int kount = st.countTokens();
        if (kount == 8) {
            return 8;
        }
        if (kount == 9) {
            return 9;
        }
        throw new UnrecognizedPatternException(header + " unrecognized");
    }

    public void setPatternType(int patternType) {
        this.patternType = patternType;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public String getPatternName() {
        return this.file.getName();
    }

    public void setVAgilentFeature(Vector vFeature) {
        this.vAgilentFeature = vFeature;
    }

    public Vector getVAgilentFeature() {
        return this.vAgilentFeature;
    }
}

