/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.FileLoaderUtility;

public class TavFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private TavFileLoaderPanel tflp;
    private boolean loadEnabled = false;
    private boolean stop = false;
    private ISlideMetaData meta;
    private boolean fillMissingSpots = false;
    private static final int BUFFER_SIZE = 131072;
    private String[] fieldNames = new String[0];
    int coordinatePairCount = 3;
    int intensityCount = 2;
    int headerRowCount = 1;
    int headerColumnCount;
    int uniqueIDIndex;
    int nameIndex;
    boolean indicesAdjusted = true;
    private MultipleArrayViewer mav;

    public TavFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.tflp = new TavFileLoaderPanel();
    }

    @Override
    public void setFilePath(String path) {
        this.tflp.setPath(path);
        File fileDir = new File(path);
        File[] allFiles = fileDir.listFiles();
        Vector<File> v = new Vector<File>(allFiles.length);
        for (int i = 0; i < allFiles.length; ++i) {
            v.add(allFiles[i]);
        }
        this.processFileList(path, v);
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public Vector<ISlideData> loadExpressionFiles() throws IOException {
        Object[] tavFiles = this.tflp.getTavSelectedListModel().toArray();
        Vector<ISlideData> data = new Vector<ISlideData>(tavFiles.length);
        if (tavFiles.length < 1) {
            return null;
        }
        this.setFilesCount(tavFiles.length);
        File ffile = new File(this.tflp.pathTextField.getText(), ((File)tavFiles[0]).getName());
        int countOfLines = this.getCountOfLines(ffile);
        for (int i = 0; i < tavFiles.length; ++i) {
            ISlideData slideData;
            File file = new File(this.tflp.pathTextField.getText(), ((File)tavFiles[i]).getName());
            if (this.stop) {
                return null;
            }
            this.setFilesProgress(i);
            this.setRemain(tavFiles.length - i);
            this.setFileName(file.getPath());
            if (i == 0) {
                this.setLinesCount(countOfLines);
                if (this.meta == null) {
                    slideData = this.fillMissingSpots ? this.loadSlideDataFillAllSpots(file) : this.loadSlideData(file);
                    this.meta = slideData.getSlideMetaData();
                } else {
                    slideData = this.loadFloatSlideData(file, countOfLines, this.meta);
                }
            } else {
                slideData = this.loadFloatSlideData(file, countOfLines, this.meta);
            }
            data.add(slideData);
        }
        ((ISlideData)data.get(0)).getSlideMetaData().clearFieldNames();
        ((ISlideData)data.get(0)).getSlideMetaData().appendFieldNames(this.fieldNames);
        return data;
    }

    @Override
    public ISlideData loadExpressionFile(File currentFile) throws IOException {
        return null;
    }

    private ISlideData loadSlideData(File file) throws IOException {
        String currentLine;
        if (!this.indicesAdjusted) {
            this.uniqueIDIndex -= 9;
            this.nameIndex -= 9;
            this.indicesAdjusted = true;
        }
        int maxRows = 0;
        int maxColumns = 0;
        int preSpotRows = this.headerRowCount;
        int[] rows = new int[this.coordinatePairCount];
        int[] columns = new int[this.coordinatePairCount];
        float[] intensities = new float[this.intensityCount];
        Vector<String> moreFields = new Vector<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        int header_row = 0;
        while ((currentLine = reader.readLine()) != null) {
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            ss.init(currentLine);
            int currentRow = ss.nextIntToken();
            int currentColumn = ss.nextIntToken();
            if (currentRow > maxRows) {
                maxRows = currentRow;
            }
            if (currentColumn <= maxColumns) continue;
            maxColumns = currentColumn;
        }
        SampleAnnotation sampAnn = new SampleAnnotation();
        SlideData slideData = new SlideData(maxRows, maxColumns, sampAnn);
        reader.close();
        reader = new BufferedReader(new FileReader(file));
        header_row = 0;
        int curpos = 0;
        while ((currentLine = reader.readLine()) != null) {
            int j;
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            this.setFileProgress(curpos++);
            ss.init(currentLine);
            for (j = 0; j < this.coordinatePairCount; ++j) {
                rows[j] = ss.nextIntToken();
                columns[j] = ss.nextIntToken();
            }
            for (j = 0; j < this.intensityCount; ++j) {
                intensities[j] = ss.nextFloatToken(0.0f);
            }
            moreFields.clear();
            while (ss.hasMoreTokens()) {
                String avoidNullString = ss.nextToken();
                if (avoidNullString.equals("null")) {
                    moreFields.add("");
                    continue;
                }
                moreFields.add(avoidNullString);
            }
            String[] allFields = new String[moreFields.size()];
            for (int i = 0; i < moreFields.size(); ++i) {
                allFields[i] = (String)moreFields.get(i);
            }
            SlideDataElement slideDataElement = new SlideDataElement(String.valueOf(curpos), rows, columns, intensities, allFields);
            slideData.addSlideDataElement(slideDataElement);
        }
        reader.close();
        slideData.setSampleAnnotationLoaded(true);
        slideData.getSampleAnnotation().setAnnotation("Default Slide Name", file.getName());
        this.mav.getData().setSampleAnnotationLoaded(true);
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    private ISlideData loadFloatSlideData(File file, int countOfLines, ISlideMetaData slideMetaData) throws IOException {
        String currentLine;
        int doubleCoordinatePairCount = this.coordinatePairCount * 2;
        int preSpotRows = this.headerRowCount;
        if (!this.indicesAdjusted) {
            this.uniqueIDIndex -= 9;
            this.nameIndex -= 9;
            this.indicesAdjusted = true;
        }
        SampleAnnotation sampAnn = new SampleAnnotation();
        FloatSlideData slideData = new FloatSlideData(slideMetaData, sampAnn);
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        float[] intensities = new float[this.intensityCount];
        int header_row = 0;
        int index = 0;
        while ((currentLine = reader.readLine()) != null) {
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            this.setFileProgress(index);
            ss.init(currentLine);
            ss.passTokens(doubleCoordinatePairCount);
            for (int j = 0; j < this.intensityCount; ++j) {
                intensities[j] = ss.nextFloatToken(0.0f);
            }
            slideData.setIntensities(index, intensities[0], intensities[1]);
            ++index;
        }
        reader.close();
        slideData.setSampleAnnotationLoaded(true);
        slideData.getSampleAnnotation().setAnnotation("Default Slide Name", file.getName());
        this.mav.getData().setSampleAnnotationLoaded(true);
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    private ISlideData loadSlideDataFillAllSpots(File file) throws IOException {
        SlideDataElement slideDataElement;
        String currentLine;
        if (!this.indicesAdjusted) {
            this.uniqueIDIndex -= 9;
            this.nameIndex -= 9;
            this.indicesAdjusted = true;
        }
        int maxRows = 0;
        int maxColumns = 0;
        int preSpotRows = this.headerRowCount;
        int[] rows = new int[this.coordinatePairCount];
        int[] columns = new int[this.coordinatePairCount];
        float[] intensities = new float[this.intensityCount];
        Vector<String> moreFields = new Vector<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        int header_row = 0;
        while ((currentLine = reader.readLine()) != null) {
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            ss.init(currentLine);
            int currentRow = ss.nextIntToken();
            int currentColumn = ss.nextIntToken();
            if (currentRow > maxRows) {
                maxRows = currentRow;
            }
            if (currentColumn <= maxColumns) continue;
            maxColumns = currentColumn;
        }
        SampleAnnotation sampAnn = new SampleAnnotation();
        SlideData slideData = new SlideData(maxRows, maxColumns, sampAnn);
        reader.close();
        reader = new BufferedReader(new FileReader(file));
        header_row = 0;
        int curpos = 0;
        boolean[][] realData = new boolean[maxRows][maxColumns];
        while ((currentLine = reader.readLine()) != null) {
            int j;
            if (header_row < preSpotRows) {
                ++header_row;
                continue;
            }
            this.setFileProgress(curpos++);
            ss.init(currentLine);
            for (j = 0; j < this.coordinatePairCount; ++j) {
                rows[j] = ss.nextIntToken();
                columns[j] = ss.nextIntToken();
            }
            for (j = 0; j < this.intensityCount; ++j) {
                intensities[j] = ss.nextFloatToken(0.0f);
            }
            while (ss.hasMoreTokens()) {
                String avoidNullString = ss.nextToken();
                if (avoidNullString.equals("null")) {
                    moreFields.add("");
                    continue;
                }
                moreFields.add(avoidNullString);
            }
            String[] allFields = new String[moreFields.size()];
            for (int i = 0; i < moreFields.size(); ++i) {
                allFields[i] = (String)moreFields.get(i);
            }
            realData[rows[0] - 1][columns[0] - 1] = true;
            slideDataElement = new SlideDataElement(String.valueOf(curpos), rows, columns, intensities, allFields);
            slideData.addSlideDataElement(slideDataElement);
        }
        reader.close();
        intensities[0] = 0.0f;
        intensities[1] = 0.0f;
        for (int i = 0; i < maxRows; ++i) {
            for (int j = 0; j < maxColumns; ++j) {
                if (realData[i][j]) continue;
                slideDataElement = new SlideDataElement(new int[]{i + 1, 1, 1}, new int[]{j + 1, 1, 1}, intensities, new String[0]);
                slideData.insertElementAt(slideDataElement, i * maxColumns + j);
            }
        }
        slideData.setSampleAnnotationLoaded(true);
        slideData.getSampleAnnotation().setAnnotation("Default Slide Name", file.getName());
        this.mav.getData().setSampleAnnotationLoaded(true);
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter tavFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".tav");
            }

            @Override
            public String getDescription() {
                return "TIGR ArrayViewer Expression Files (*.tav)";
            }
        };
        return tavFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean state) {
        this.loadEnabled = state;
        this.checkLoadEnable();
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.tflp;
    }

    public void processFileList(String filePath, Vector fileNames) {
        this.tflp.setPath(filePath);
        if (fileNames == null) {
            return;
        }
        FileFilter tavFileFilter = this.getFileFilter();
        this.tflp.getTavAvailableListModel().clear();
        for (int i = 0; i < fileNames.size(); ++i) {
            File targetFile = new File((String)fileNames.elementAt(i));
            if (!tavFileFilter.accept(targetFile)) continue;
            this.tflp.getTavAvailableListModel().addElement(new File((String)fileNames.elementAt(i)));
        }
    }

    @Override
    public String getFilePath() {
        if (this.tflp.pathTextField == null) {
            return null;
        }
        return this.tflp.pathTextField.getText();
    }

    @Override
    public void openDataPath() {
    }

    @Override
    public String getAnnotationFilePath() {
        return null;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    static /* synthetic */ String[] access$202(TavFileLoader x0, String[] x1) {
        x0.fieldNames = x1;
        return x1;
    }

    private class TavFileLoaderPanel
    extends JPanel {
        JTextField pathTextField;
        JPanel tavSelectionPanel;
        JPanel tavListPanel;
        JLabel tavAvailableLabel;
        JLabel tavSelectedLabel;
        JList tavAvailableList;
        JList tavSelectedList;
        JScrollPane tavAvailableScrollPane;
        JScrollPane tavSelectedScrollPane;
        JButton tavAddButton;
        JButton tavAddAllButton;
        JButton tavRemoveButton;
        JButton tavRemoveAllButton;
        JPanel tavButtonPanel;
        JTextField preferencesTextField;
        JButton browseButton2;
        JPanel preferencesSelectionPanel;
        JPanel preferencesPanel;
        JPanel manualPanel;
        JPanel genericPanel;
        JTabbedPane fieldsTabbedPane;
        JPanel fieldsPanel;
        JPanel selectionPanel;
        JSplitPane splitPane;
        JPanel fileLoaderPanel;
        JPanel selectFilePanel;
        JLabel selectFile;
        JLabel selectAnnotation;
        JButton browseButton1;

        public TavFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.selectFilePanel = new JPanel();
            this.selectFilePanel.setLayout(new GridBagLayout());
            this.selectFile = new JLabel("Select expression data directory");
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.setSize(new Dimension(100, 30));
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.browseButton1.addActionListener(new EventHandler());
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            TavFileLoader.this.gba.add(this.selectFilePanel, this.selectFile, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.selectFilePanel, this.pathTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.selectFilePanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.tavSelectionPanel = new JPanel();
            this.tavSelectionPanel.setLayout(new GridBagLayout());
            this.tavSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (TaV Format Files)"));
            this.tavAvailableLabel = new JLabel("Available");
            this.tavSelectedLabel = new JLabel("Selected");
            this.tavAvailableList = new JList(new DefaultListModel());
            this.tavSelectedList = new JList(new DefaultListModel());
            this.tavAvailableScrollPane = new JScrollPane(this.tavAvailableList);
            this.tavSelectedScrollPane = new JScrollPane(this.tavSelectedList);
            this.tavAddButton = new JButton("Add");
            this.tavAddButton.setPreferredSize(new Dimension(100, 20));
            this.tavAddButton.addActionListener(new EventHandler());
            this.tavAddAllButton = new JButton("Add All");
            this.tavAddAllButton.setPreferredSize(new Dimension(100, 20));
            this.tavAddAllButton.addActionListener(new EventHandler());
            this.tavRemoveButton = new JButton("Remove");
            this.tavRemoveButton.setPreferredSize(new Dimension(100, 20));
            this.tavRemoveButton.addActionListener(new EventHandler());
            this.tavRemoveAllButton = new JButton("Remove All");
            this.tavRemoveAllButton.setPreferredSize(new Dimension(100, 20));
            this.tavRemoveAllButton.addActionListener(new EventHandler());
            this.tavButtonPanel = new JPanel();
            this.tavButtonPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavButtonPanel, this.tavRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.tavListPanel = new JPanel();
            this.tavListPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavListPanel, this.tavSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavSelectionPanel, this.selectFilePanel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.tavSelectionPanel, this.tavListPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.preferencesTextField = new JTextField();
            this.preferencesTextField.setEditable(false);
            this.preferencesTextField.setForeground(Color.black);
            this.preferencesTextField.setFont(new Font("monospaced", 1, 12));
            this.browseButton2 = new JButton("Browse Preferences");
            this.browseButton2.addActionListener(new EventHandler());
            this.preferencesSelectionPanel = new JPanel();
            this.preferencesSelectionPanel.setLayout(new GridBagLayout());
            this.preferencesSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Selected Preferences File"));
            TavFileLoader.this.gba.add(this.preferencesSelectionPanel, this.preferencesTextField, 0, 0, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.preferencesSelectionPanel, this.browseButton2, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.preferencesPanel = new JPanel();
            this.preferencesPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.preferencesPanel, this.preferencesSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.manualPanel = new JPanel();
            this.manualPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.manualPanel, new JPanel(), 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.genericPanel = new JPanel();
            this.genericPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.genericPanel, new JPanel(), 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fieldsTabbedPane = new JTabbedPane();
            this.fieldsTabbedPane.addTab("Preferences", this.preferencesPanel);
            this.fieldsTabbedPane.addTab("Manual", this.manualPanel);
            this.fieldsTabbedPane.addTab("Generic", this.genericPanel);
            this.fieldsTabbedPane.setEnabledAt(1, false);
            this.fieldsTabbedPane.setEnabledAt(2, false);
            this.fieldsTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    TavFileLoaderPanel.this.validateLists();
                }
            });
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new GridBagLayout());
            this.fieldsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Additional Requirements"));
            TavFileLoader.this.gba.add(this.fieldsPanel, this.fieldsTabbedPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.selectionPanel, this.tavSelectionPanel, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this.selectionPanel, this.fieldsPanel, 0, 3, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            TavFileLoader.this.gba.add(this.fileLoaderPanel, this.selectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            TavFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void onTavFileBrowse() {
            FileLoaderUtility fileLoad = new FileLoaderUtility();
            Vector retrievedFileNames = new Vector();
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(1);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                ((DefaultListModel)this.tavAvailableList.getModel()).clear();
                ((DefaultListModel)this.tavSelectedList.getModel()).clear();
                File selectedFile = fileChooser.getSelectedFile();
                this.pathTextField.setText(selectedFile.getAbsolutePath());
                String path = selectedFile.getAbsolutePath();
                retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
                for (int i = 0; i < retrievedFileNames.size(); ++i) {
                    Object fileName = retrievedFileNames.get(i);
                    boolean acceptFile = TavFileLoader.this.getFileFilter().accept((File)fileName);
                    if (!acceptFile) continue;
                    String Name = fileChooser.getName((File)fileName);
                    ((DefaultListModel)this.tavAvailableList.getModel()).addElement(new File(Name));
                }
            }
        }

        public void setPath(String path) {
            this.pathTextField.setText(path);
        }

        public void openDataPath() {
        }

        public void validateLists() {
            if (((DefaultListModel)this.tavSelectedList.getModel()).size() <= 0) {
                TavFileLoader.this.markLoadEnabled(false);
                return;
            }
            Component tabbedPaneTarget = this.fieldsTabbedPane.getSelectedComponent();
            if (tabbedPaneTarget == this.preferencesPanel) {
                if (this.preferencesTextField.getText().length() <= 0) {
                    TavFileLoader.this.markLoadEnabled(false);
                    return;
                }
                TavFileLoader.this.markLoadEnabled(true);
                return;
            }
            if (tabbedPaneTarget == this.manualPanel) {
                TavFileLoader.this.markLoadEnabled(true);
                return;
            }
            TavFileLoader.this.markLoadEnabled(true);
        }

        public void onTavAdd() {
            int i;
            int[] chosenIndices = this.tavAvailableList.getSelectedIndices();
            Object[] chosenObjects = new Object[chosenIndices.length];
            for (i = chosenIndices.length - 1; i >= 0; --i) {
                Object addItem = ((DefaultListModel)this.tavAvailableList.getModel()).getElementAt(chosenIndices[i]);
                chosenObjects[i] = addItem;
            }
            for (i = 0; i < chosenIndices.length; ++i) {
                ((DefaultListModel)this.tavSelectedList.getModel()).addElement(chosenObjects[i]);
            }
            this.validateLists();
        }

        public void onTavAddAll() {
            int elementCount = ((DefaultListModel)this.tavAvailableList.getModel()).size();
            for (int i = 0; i < elementCount; ++i) {
                Object addItem = ((DefaultListModel)this.tavAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.tavSelectedList.getModel()).addElement(addItem);
            }
            this.validateLists();
        }

        public void onTavRemove() {
            int[] chosenIndices = this.tavSelectedList.getSelectedIndices();
            for (int i = chosenIndices.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.tavSelectedList.getModel()).remove(chosenIndices[i]);
            }
            this.validateLists();
        }

        public void onTavRemoveAll() {
            ((DefaultListModel)this.tavSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public DefaultListModel getTavAvailableListModel() {
            return (DefaultListModel)this.tavAvailableList.getModel();
        }

        public DefaultListModel getTavSelectedListModel() {
            return (DefaultListModel)this.tavSelectedList.getModel();
        }

        public void selectPreferencesFile() {
            JFileChooser jfc = new JFileChooser(TMEV.getFile("preferences/"));
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String filename = file.getName();
                    if (filename.endsWith("Preferences")) {
                        return true;
                    }
                    if (filename.endsWith("preferences")) {
                        return true;
                    }
                    return filename.endsWith(".pref");
                }

                @Override
                public String getDescription() {
                    return "Preference Files";
                }
            };
            jfc.setFileFilter(ff);
            int activityCode = jfc.showDialog(this, "Select");
            if (activityCode == 0) {
                File target = jfc.getSelectedFile();
                if (this.readPreferencesFile(target)) {
                    this.preferencesTextField.setText(target.getPath());
                    this.validateLists();
                } else {
                    JOptionPane.showMessageDialog(this, "An invalid preferences file was selected. ", "Invalid Preferences File", 0);
                }
            }
        }

        public boolean readPreferencesFile(File inputFile) {
            StringTokenizer ss;
            Hashtable<String, String> tavPreferencesProperties = new Hashtable<String, String>();
            BufferedReader reader = null;
            boolean returnValue = true;
            try {
                reader = new BufferedReader(new FileReader(inputFile));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                returnValue = false;
            }
            try {
                String currentLine;
                TavFileLoader.this.indicesAdjusted = false;
                while ((currentLine = reader.readLine()) != null) {
                    currentLine.trim();
                    if (currentLine.startsWith("//") || currentLine.length() == 0) continue;
                    ss = new StringTokenizer(currentLine, "\t");
                    String key = ss.nextToken();
                    if (ss.hasMoreTokens()) {
                        tavPreferencesProperties.put(key, ss.nextToken());
                        continue;
                    }
                    tavPreferencesProperties.put(key, new String(""));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                String additionalFields;
                String dbs;
                String nameString;
                String uniqueIDString;
                String headerInfo;
                String elementInfo = (String)tavPreferencesProperties.get("Element Info");
                if (elementInfo != null) {
                    ss = new StringTokenizer(elementInfo, ":");
                    TavFileLoader.this.coordinatePairCount = Integer.parseInt(ss.nextToken());
                    TavFileLoader.this.intensityCount = Integer.parseInt(ss.nextToken());
                }
                if ((headerInfo = (String)tavPreferencesProperties.get("Headers")) != null) {
                    ss = new StringTokenizer(headerInfo, ":");
                    TavFileLoader.this.headerRowCount = Integer.parseInt(ss.nextToken());
                    TavFileLoader.this.headerColumnCount = Integer.parseInt(ss.nextToken());
                }
                if ((uniqueIDString = (String)tavPreferencesProperties.get("Unique ID")) != null) {
                    TavFileLoader.this.uniqueIDIndex = Integer.parseInt(uniqueIDString);
                }
                if ((nameString = (String)tavPreferencesProperties.get("Spot Name")) != null) {
                    TavFileLoader.this.nameIndex = Integer.parseInt(nameString);
                }
                if ((dbs = (String)tavPreferencesProperties.get("Database Names")) != null) {
                    ss = new StringTokenizer(dbs, ":");
                }
                if ((additionalFields = (String)tavPreferencesProperties.get("Additional Fields")) != null) {
                    ss = new StringTokenizer(additionalFields, ":");
                    if (ss.countTokens() > 0) {
                        TavFileLoader.access$202(TavFileLoader.this, new String[ss.countTokens()]);
                        int i = 0;
                        while (ss.hasMoreTokens()) {
                            ((TavFileLoader)TavFileLoader.this).fieldNames[i] = ss.nextToken();
                            ++i;
                        }
                    } else {
                        TavFileLoader.access$202(TavFileLoader.this, new String[0]);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                returnValue = false;
            }
            return returnValue;
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            @Override
            public void nodeSelected(FileTreePaneEvent event) {
                String filePath = (String)event.getValue("Path");
                Vector fileNames = (Vector)event.getValue("Filenames");
                TavFileLoader.this.processFileList(filePath, fileNames);
            }

            @Override
            public void nodeCollapsed(FileTreePaneEvent event) {
            }

            @Override
            public void nodeExpanded(FileTreePaneEvent event) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == TavFileLoaderPanel.this.tavAddButton) {
                    TavFileLoaderPanel.this.onTavAdd();
                } else if (source == TavFileLoaderPanel.this.tavAddAllButton) {
                    TavFileLoaderPanel.this.onTavAddAll();
                } else if (source == TavFileLoaderPanel.this.tavRemoveButton) {
                    TavFileLoaderPanel.this.onTavRemove();
                } else if (source == TavFileLoaderPanel.this.tavRemoveAllButton) {
                    TavFileLoaderPanel.this.onTavRemoveAll();
                } else if (source == TavFileLoaderPanel.this.browseButton2) {
                    TavFileLoaderPanel.this.selectPreferencesFile();
                } else if (source == TavFileLoaderPanel.this.browseButton1) {
                    TavFileLoaderPanel.this.onTavFileBrowse();
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

