/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.file.ExpressionFileFilter;
import org.tigr.util.StringSplitter;

public class TavFileFilter
extends ExpressionFileFilter {
    private static final int BUFFER_SIZE = 131072;

    @Override
    public boolean accept(File f) {
        String extension = "";
        if (f.isDirectory()) {
            return true;
        }
        return f.getName().endsWith(".tav");
    }

    @Override
    public String getDescription() {
        return "TIGR ArrayViewer Files (*.tav)";
    }

    @Override
    public Vector loadExpressionFile(File file) throws IOException {
        String currentLine;
        Vector<SlideData> dataVector = new Vector<SlideData>();
        if (!this.accept(file)) {
            return dataVector;
        }
        int maxRows = 0;
        int maxColumns = 0;
        int coordinatePairCount = 3;
        int intensityCount = 2;
        boolean preSpotRows = false;
        int[] rows = new int[coordinatePairCount];
        int[] columns = new int[coordinatePairCount];
        float[] intensities = new float[intensityCount];
        String[] moreFields = new String[3];
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        int header_row = 0;
        while ((currentLine = reader.readLine()) != null) {
            if (header_row < 0) {
                ++header_row;
                continue;
            }
            ss.init(currentLine);
            int currentRow = ss.nextIntToken();
            int currentColumn = ss.nextIntToken();
            if (currentRow > maxRows) {
                maxRows = currentRow;
            }
            if (currentColumn <= maxColumns) continue;
            maxColumns = currentColumn;
        }
        SlideData slideData = new SlideData(maxRows, maxColumns);
        reader.close();
        reader = new BufferedReader(new FileReader(file));
        header_row = 0;
        boolean curpos = false;
        while ((currentLine = reader.readLine()) != null) {
            int j;
            if (header_row < 0) {
                ++header_row;
                continue;
            }
            ss.init(currentLine);
            for (j = 0; j < coordinatePairCount; ++j) {
                rows[j] = ss.nextIntToken();
                columns[j] = ss.nextIntToken();
            }
            for (j = 0; j < intensityCount; ++j) {
                intensities[j] = ss.nextFloatToken(0.0f);
            }
            for (j = 0; j < moreFields.length; ++j) {
                if (ss.hasMoreTokens()) {
                    String avoidNullString = ss.nextToken();
                    if (avoidNullString.equals("null")) {
                        moreFields[j] = "";
                        continue;
                    }
                    moreFields[j] = avoidNullString;
                    continue;
                }
                moreFields[j] = "";
            }
            SlideDataElement slideDataElement = new SlideDataElement(rows, columns, intensities, moreFields);
            slideData.addSlideDataElement(slideDataElement);
        }
        reader.close();
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        dataVector.add(slideData);
        return dataVector;
    }
}

