/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.AffymetrixAnnotationParser;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.RNASeqFileLoader;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;

public class TCGADownloader
extends ExpressionFileLoader {
    private static final long serialVersionUID = 1L;
    private GBA gba;
    private int dataType = 2;
    private boolean stop = false;
    private TCGADownloaderPanel tcgaDP;
    ExpressionFileTableCellRenderer myCellRenderer;
    protected String[] moreFields = new String[0];
    private JRadioButton dataTypeSFRB;
    private JRadioButton dataTypeRNARB;
    JCheckBox selectAllCB;
    private ISlideData[] slideDataArray = null;
    private ISlideDataElement sde;
    private Hashtable _tempAnno = new Hashtable();
    private MultipleArrayViewer mav;
    private String testTCGAURL = "https://tcga-data.nci.nih.gov/tcgafiles/ftp_auth/distro_ftpusers/anonymous/tumor/gbm/cgcc/broad.mit.edu/ht_hg-u133a/transcriptome/broad.mit.edu_GBM.HT_HG-U133A.Level_2.7.1004.0/5500024037497121008340.D07.level2.data.txt";
    private String tcgaURLBase = "https://tcga-data.nci.nih.gov/tcgafiles/ftp_auth/distro_ftpusers/anonymous/";
    File tcgaDownloadFile;
    Progress dlProgress;

    @Override
    public void setFilePath(String path) {
        this.tcgaDP.setFileName(path);
        this.processTCGAFile(this.testTCGAURL);
    }

    public TCGADownloader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.tcgaDP = new TCGADownloaderPanel();
    }

    @Override
    public Vector<ISlideData> loadExpressionFiles() throws IOException {
        if (this.tcgaDP.getXColumn() == 0) {
            JOptionPane.showMessageDialog(null, "The selected file has no gene annotation and cannot be loaded. \n\nPlease make sure you have selected an EXPRESSION value in the file loader table.\nThe 1st column cannot contain expression values.", "Missing Annotation Error", 0, null);
            return null;
        }
        return this.loadTCGAasStanfordExpressionFile(this.tcgaDownloadFile, this.tcgaDP.getXRow() + 1, this.tcgaDP.getXColumn());
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    @Override
    public boolean canAutoLoad(File f) {
        return true;
    }

    public Vector<ISlideData> loadTCGAasStanfordExpressionFile(File f, int rowcoord, int colcoord) throws IOException {
        String currentLine;
        int preSpotRows = rowcoord;
        int preExperimentColumns = colcoord;
        int numLines = this.getCountOfLines(f);
        int spotCount = numLines - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        this.moreFields = new String[preExperimentColumns];
        boolean rColumns = true;
        int rRows = spotCount;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        int column = 1;
        int row = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(numLines);
        this.setFileProgress(0);
        if (this.isAnnotationSelected()) {
            this.mav.getData().setAnnotationLoaded(true);
            File annoFile = new File(this.getAnnotationFilePath());
            String extension = annoFile.getName().substring(annoFile.getName().lastIndexOf(46) + 1, annoFile.getName().length());
            if (annoFile.getName().endsWith("annot.csv")) {
                AffymetrixAnnotationParser aafp = AffymetrixAnnotationParser.createAnnotationFileParser(new File(this.getAnnotationFilePath()));
                this._tempAnno = aafp.getAffyAnnotation();
            }
            if (extension.equalsIgnoreCase("txt")) {
                AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader(new File(this.getAnnotationFilePath()));
                this._tempAnno = afr.getAffyAnnotation();
                this.chipAnno = afr.getAffyChipAnnotation();
            }
        }
        while ((currentLine = reader.readLine()) != null) {
            try {
                if (this.stop) {
                    return null;
                }
                while (currentLine.endsWith("\t")) {
                    currentLine = currentLine.substring(0, currentLine.length() - 1);
                }
                ss.init(currentLine);
                if (counter == 0) {
                    int i;
                    int experimentCount = ss.countTokens() + 1 - preExperimentColumns;
                    SampleAnnotation sampAnn = new SampleAnnotation();
                    this.slideDataArray = new ISlideData[experimentCount];
                    this.slideDataArray[0] = new SlideData(rRows, 1, sampAnn);
                    this.slideDataArray[0].setSlideFileName(f.getPath());
                    for (int i2 = 1; i2 < this.slideDataArray.length; ++i2) {
                        sampAnn = new SampleAnnotation();
                        this.slideDataArray[i2] = new FloatSlideData(this.slideDataArray[0].getSlideMetaData(), spotCount, sampAnn);
                        this.slideDataArray[i2].setSlideFileName(f.getPath());
                    }
                    String[] fieldNames = new String[preExperimentColumns];
                    for (i = 0; i < preExperimentColumns; ++i) {
                        fieldNames[i] = ss.nextToken();
                    }
                    this.slideDataArray[0].getSlideMetaData().setFieldNames(fieldNames);
                    for (i = 0; i < experimentCount; ++i) {
                        String val = ss.nextToken();
                        this.slideDataArray[i].setSampleAnnotationLoaded(true);
                        this.slideDataArray[i].getSampleAnnotation().setAnnotation("Default Slide Name", val);
                        this.slideDataArray[i].setSlideDataName(val);
                        this.mav.getData().setSampleAnnotationLoaded(true);
                    }
                } else if (counter >= preSpotRows) {
                    rows[0] = rows[2] = row++;
                    columns[0] = columns[2] = column;
                    column = column == 1 ? 1 : ++column;
                    for (int i = 0; i < preExperimentColumns; ++i) {
                        this.moreFields[i] = ss.nextToken();
                    }
                    String cloneName = this.moreFields[0];
                    MevAnnotation mevAnno = null;
                    if (this._tempAnno.size() != 0) {
                        if ((MevAnnotation)this._tempAnno.get(cloneName) != null) {
                            mevAnno = (MevAnnotation)this._tempAnno.get(cloneName);
                        } else {
                            mevAnno = new MevAnnotation();
                            mevAnno.setCloneID(cloneName);
                        }
                    }
                    this.sde = this.getDataType() == 2 ? new AffySlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], this.moreFields, mevAnno) : new SlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], this.moreFields, mevAnno);
                    this.slideDataArray[0].addSlideDataElement(this.sde);
                    for (int i = 0; i < this.slideDataArray.length; ++i) {
                        float cy5;
                        float cy3 = 1.0f;
                        try {
                            String value = ss.nextToken();
                            cy5 = Float.parseFloat(value);
                        }
                        catch (Exception e) {
                            cy3 = 0.0f;
                            cy5 = Float.NaN;
                        }
                        this.slideDataArray[i].setIntensities(counter - preSpotRows, cy3, cy5);
                    }
                } else {
                    for (int i = 0; i < preExperimentColumns - 1; ++i) {
                        ss.nextToken();
                    }
                    String key = ss.nextToken();
                    for (int j = 0; j < this.slideDataArray.length; ++j) {
                        if (this.slideDataArray[j].getSampleAnnotation() != null) {
                            String val = ss.nextToken();
                            this.slideDataArray[j].getSampleAnnotation().setAnnotation(key, val);
                            continue;
                        }
                        SampleAnnotation sampAnn = new SampleAnnotation();
                        sampAnn.setAnnotation(key, ss.nextToken());
                        this.slideDataArray[j].setSampleAnnotation(sampAnn);
                        this.slideDataArray[j].setSampleAnnotationLoaded(true);
                    }
                }
                this.setFileProgress(counter);
                ++counter;
            }
            catch (NoSuchElementException nsee) {}
        }
        reader.close();
        Vector<ISlideData> data = new Vector<ISlideData>(this.slideDataArray.length);
        for (int i = 0; i < this.slideDataArray.length; ++i) {
            data.add(this.slideDataArray[i]);
        }
        this.setFilesProgress(1);
        return data;
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Tab Delimited, Multiple Sample Files (TDMS) (*.txt)";
            }
        };
        return mevFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.tcgaDP.getXRow() + 1;
        int tableColumn = this.tcgaDP.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.tcgaDP.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.tcgaDP;
    }

    public void processTCGAFile(String tcgaURL) {
        URL url;
        Vector<String> columnHeaders = new Vector<String>();
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        BufferedWriter out = null;
        String currentLine = null;
        String fileName = "tcgaDownload_" + System.currentTimeMillis() + ".txt";
        this.tcgaDownloadFile = new File(fileName);
        try {
            this.tcgaDownloadFile.createNewFile();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        FileWriter fstream = null;
        try {
            fstream = new FileWriter(fileName);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.tcgaDP.setFileName(fileName);
        System.out.println("this.getFilePath() = " + this.getFilePath());
        int numFiles = this.tcgaDP.filesList.getSelectedIndices().length;
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        if (this.dataTypeSFRB.isSelected()) {
            int i;
            ArrayList allData = new ArrayList();
            for (i = 0; i < this.tcgaDP.filesList.getSelectedIndices().length; ++i) {
                this.dlProgress.setDescription("Download Progress: " + (i + 1) + " of " + this.tcgaDP.filesList.getSelectedIndices().length);
                try {
                    allData.add(new ArrayList());
                    url = new URL(tcgaURL + this.tcgaDP.filesList.getSelectedValues()[i]);
                    URLConnection url_conn = url.openConnection();
                    url_conn.setDoInput(true);
                    url_conn.setUseCaches(true);
                    reader = new BufferedReader(new InputStreamReader(url_conn.getInputStream()));
                    while ((currentLine = reader.readLine()) != null) {
                        if (i == 0) {
                            ((ArrayList)allData.get(i)).add(currentLine);
                            continue;
                        }
                        ((ArrayList)allData.get(i)).add(currentLine.split("\t")[1]);
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println("error parsing file: " + tcgaURL + this.tcgaDP.filesList.getSelectedValues()[i]);
                }
            }
            try {
                out = new BufferedWriter(fstream);
                for (i = 0; i < ((ArrayList)allData.get(0)).size(); ++i) {
                    this.dlProgress.setDescription("Processing Data: " + (i + 1) + " of " + ((ArrayList)allData.get(0)).size());
                    String line = "";
                    try {
                        for (int j = 0; j < allData.size(); ++j) {
                            line = line + (j == 0 ? "" : "\t") + (String)((ArrayList)allData.get(j)).get(i);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    out.write(line + "\n");
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.dataTypeRNARB.isSelected()) {
            try {
                int i;
                out = new BufferedWriter(fstream);
                BufferedReader[] readerArr = new BufferedReader[numFiles];
                for (i = 0; i < numFiles; ++i) {
                    this.dlProgress.setDescription("Download Progress: " + (i + 1) + " of " + numFiles);
                    try {
                        url = new URL(tcgaURL + this.tcgaDP.filesList.getSelectedValues()[i]);
                        URLConnection url_conn = url.openConnection();
                        url_conn.setDoInput(true);
                        url_conn.setUseCaches(true);
                        readerArr[i] = new BufferedReader(new InputStreamReader(url_conn.getInputStream()));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("error parsing file: ");
                        e.printStackTrace();
                    }
                }
                out.write("Tracking ID\t");
                out.write("locus\t");
                out.write("nearest_ref_id\t");
                out.write("class_code\t");
                out.write("transcript_length");
                for (i = 0; i < numFiles; ++i) {
                    String sampleName = (String)this.tcgaDP.filesList.getSelectedValues()[i];
                    if (sampleName.length() > 50) {
                        sampleName = sampleName.substring(0, 49) + "...";
                    }
                    readerArr[i].readLine();
                    out.write("\t" + sampleName);
                    out.write("\t" + sampleName);
                }
                out.write("\n");
                boolean notPageEnd = true;
                int index = 0;
                while (notPageEnd) {
                    this.dlProgress.setDescription("Processing row: " + index);
                    for (int i2 = 0; i2 < numFiles; ++i2) {
                        currentLine = readerArr[i2].readLine();
                        if (currentLine == null) {
                            notPageEnd = false;
                            break;
                        }
                        String[] curLine = currentLine.split("\t");
                        if (i2 == 0) {
                            out.write("ID_" + index + "\t");
                            out.write(curLine[0] + "\t");
                            out.write("\t");
                            out.write("\t");
                            out.write("\t");
                        }
                        out.write(curLine[3] + "\t");
                        out.write(curLine[1]);
                        if (i2 == numFiles - 1) continue;
                        out.write("\t");
                    }
                    out.write("\n");
                    ++index;
                }
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            reader = new BufferedReader(new FileReader(this.tcgaDownloadFile));
            currentLine = reader.readLine();
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                columnHeaders.add(ss.nextToken());
            }
            model.setColumnIdentifiers(columnHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && cnt < 100) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i = 0; i < ss.countTokens() + 1; ++i) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            out.close();
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.tcgaDP.setTableModel(model);
        Point p = this.getFirstExpressionCell(dataVector);
        this.tcgaDP.setSelectedCell(p.x, p.y);
        this.dlProgress.dispose();
    }

    @Override
    public String getFilePath() {
        return this.tcgaDP.fileNameTextField.getText();
    }

    @Override
    public String getAnnotationFilePath() {
        return this.tcgaDP.getAnnFilePath();
    }

    @Override
    public void openDataPath() {
    }

    public void setDataType(int data_Type) {
        this.dataType = data_Type != -1 ? data_Type : 1;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public boolean isAnnotationSelected() {
        return this.tcgaDP.adh.annotationSelected;
    }

    public static void main(String[] args) {
        try {
            int i;
            FileWriter fstream = new FileWriter("C://Users//Dan//Desktop//rnaseqfileGen.txt");
            BufferedWriter out = new BufferedWriter(fstream);
            BufferedReader[] reader = new BufferedReader[22];
            for (i = 0; i < 22; ++i) {
                System.out.println("file number " + (i + 1));
                try {
                    URL url = new URL("https://tcga-data.nci.nih.gov/tcgafiles/ftp_auth/distro_ftpusers/anonymous/tumor/brca/cgcc/unc.edu/illuminahiseq_rnaseqv2/rnaseqv2/unc.edu_BRCA.IlluminaHiSeq_RNASeqV2.Level_3.1.0.0/unc.edu.0042b857-502f-4d8e-baac-845c1a9bb64b.1154126.exon_quantification.txt");
                    URLConnection url_conn = url.openConnection();
                    url_conn.setDoInput(true);
                    url_conn.setUseCaches(true);
                    reader[i] = new BufferedReader(new InputStreamReader(url_conn.getInputStream()));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("error parsing file: ");
                    e.printStackTrace();
                }
            }
            out.write("Tracking ID\t");
            out.write("locus\t");
            out.write("nearest_ref_id\t");
            out.write("class_code\t");
            out.write("transcript_length\t");
            for (i = 0; i < 22; ++i) {
                reader[i].readLine();
                out.write("TCGA RNASeq Sample " + i + "\t" + "TCGA RNASeq Sample" + i + "\t");
            }
            out.write("\n");
            boolean notPageEnd = true;
            while (notPageEnd) {
                for (int i2 = 0; i2 < 22; ++i2) {
                    int index = 0;
                    String currentLine = reader[i2].readLine();
                    if (currentLine == null) {
                        notPageEnd = false;
                        break;
                    }
                    String[] curLine = currentLine.split("\t");
                    if (i2 == 0) {
                        out.write("RowID_" + index + "\t");
                        out.write(curLine[0] + "\t");
                        out.write("\t");
                        out.write("\t");
                        out.write("\t");
                    }
                    out.write(curLine[3] + "\t");
                    out.write(curLine[1] + "\t");
                    ++index;
                }
                out.write("\n");
            }
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
        this.tcgaDP.adh.setAnnFilePath(filePath);
        this.tcgaDP.adh.annotationSelected = true;
    }

    private class TCGADownloaderPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField fileNameTextField;
        JTextField selectedFiles;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel fileLoaderPanel;
        private int xRow = -1;
        private int xColumn = -1;
        JPanel fileSelectionPanel;
        JLabel fileSelectionLabel;
        JLabel dataSelection;
        JButton downloadButton;
        JRadioButton twoColorArray;
        JRadioButton singleColorArray;
        AnnotationDownloadHandler adh;
        protected EventListener eventListener;
        private JList filesList;
        private LevelCBListener levelCBListener;
        private JComboBox[] tcgaLevelBoxes;
        private DefaultListModel dlm;
        boolean antiRecursion = false;
        private String downloadFileURL;

        public TCGADownloaderPanel() {
            this.adh = new AnnotationDownloadHandler(TCGADownloader.this.superLoader.viewer.getResourceManager(), TCGADownloader.this.superLoader.annotationLists, TCGADownloader.this.superLoader.defaultSpeciesName, TCGADownloader.this.superLoader.defaultArrayName);
            this.eventListener = new EventListener();
            this.levelCBListener = new LevelCBListener();
            this.setLayout(new GridBagLayout());
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.fileSelectionLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select expression data file</html>";
            this.dataSelection.setText(chooseFile);
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "TCGA Data Downloader"));
            this.tcgaLevelBoxes = new JComboBox[7];
            JLabel[] tcgaLevelLabels = new JLabel[]{new JLabel("Access Root"), new JLabel("Tissue Type"), new JLabel("Center Type"), new JLabel("Center"), new JLabel("Platform"), new JLabel("Data Type"), new JLabel("Archive")};
            JLabel filesFoundLabel = new JLabel("Files found");
            this.tcgaLevelBoxes[0] = new JComboBox<String>(new String[]{"Select/", "tumor/", "other/"});
            this.tcgaLevelBoxes[1] = new JComboBox();
            this.tcgaLevelBoxes[2] = new JComboBox();
            this.tcgaLevelBoxes[3] = new JComboBox();
            this.tcgaLevelBoxes[4] = new JComboBox();
            this.tcgaLevelBoxes[5] = new JComboBox();
            this.tcgaLevelBoxes[6] = new JComboBox();
            for (int i = 0; i < this.tcgaLevelBoxes.length; ++i) {
                this.tcgaLevelBoxes[i].setEnabled(false);
                this.tcgaLevelBoxes[i].addActionListener(this.levelCBListener);
            }
            this.tcgaLevelBoxes[0].setEnabled(true);
            TCGADownloader.this.dataTypeSFRB = new JRadioButton("TDMS File");
            TCGADownloader.this.dataTypeRNARB = new JRadioButton("RNASeq");
            ButtonGroup bg = new ButtonGroup();
            bg.add(TCGADownloader.this.dataTypeSFRB);
            bg.add(TCGADownloader.this.dataTypeRNARB);
            TCGADownloader.this.dataTypeSFRB.setSelected(true);
            this.downloadButton = new JButton("Download from TCGA");
            this.downloadButton.addActionListener(this.eventListener);
            this.downloadButton.setEnabled(false);
            this.dlm = new DefaultListModel();
            this.dlm.addElement("No files found");
            this.filesList = new JList(this.dlm);
            TCGADownloader.this.selectAllCB = new JCheckBox("Select All");
            TCGADownloader.this.selectAllCB.setEnabled(false);
            TCGADownloader.this.selectAllCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TCGADownloader.this.selectAllCB.isSelected()) {
                        int[] indices = new int[TCGADownloaderPanel.this.dlm.size()];
                        for (int i = 0; i < indices.length; ++i) {
                            indices[i] = i;
                        }
                        TCGADownloaderPanel.this.filesList.setSelectedIndices(indices);
                        TCGADownloaderPanel.this.downloadButton.setEnabled(true);
                    } else {
                        TCGADownloaderPanel.this.downloadButton.setEnabled(false);
                        TCGADownloaderPanel.this.filesList.clearSelection();
                    }
                }
            });
            this.filesList.setEnabled(false);
            this.filesList.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (TCGADownloaderPanel.this.filesList.getSelectedIndices() == null || TCGADownloaderPanel.this.filesList.getSelectedIndices().length == 0) {
                        TCGADownloaderPanel.this.downloadButton.setEnabled(false);
                    } else {
                        TCGADownloaderPanel.this.downloadButton.setEnabled(true);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            this.filesList.setSelectionMode(2);
            JScrollPane fileScroll = new JScrollPane(this.filesList);
            TCGADownloader.this.gba.add(this.fileSelectionPanel, TCGADownloader.this.dataTypeSFRB, 1, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            TCGADownloader.this.gba.add(this.fileSelectionPanel, TCGADownloader.this.dataTypeRNARB, 2, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            for (int i = 0; i < this.tcgaLevelBoxes.length; ++i) {
                TCGADownloader.this.gba.add(this.fileSelectionPanel, tcgaLevelLabels[i], 0, i + 1, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                TCGADownloader.this.gba.add(this.fileSelectionPanel, this.tcgaLevelBoxes[i], 1, i + 1, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            }
            TCGADownloader.this.gba.add(this.fileSelectionPanel, filesFoundLabel, 2, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            TCGADownloader.this.gba.add(this.fileSelectionPanel, fileScroll, 2, 1, 1, 6, 2, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            TCGADownloader.this.gba.add(this.fileSelectionPanel, TCGADownloader.this.selectAllCB, 2, this.tcgaLevelBoxes.length, 1, 1, 2, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            TCGADownloader.this.gba.add(this.fileSelectionPanel, this.downloadButton, 2, tcgaLevelLabels.length + 1, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.expressionTable = new JTable();
            TCGADownloader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable.setDefaultRenderer(Object.class, TCGADownloader.this.myCellRenderer);
            this.expressionTable.setIntercellSpacing(new Dimension(1, 1));
            this.expressionTable.setShowHorizontalLines(false);
            this.expressionTable.setShowVerticalLines(true);
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    TCGADownloaderPanel.this.setSelectedCell(TCGADownloaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), TCGADownloaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            TCGADownloader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            TCGADownloader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            TCGADownloader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            TCGADownloader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 3, 1, 6, 3, 6, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            TCGADownloader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        }

        public String getAnnFilePath() {
            return this.adh.getAnnFilePath();
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            TCGADownloader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            TCGADownloader.this.checkLoadEnable();
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void setFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
            this.selectedFiles.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        private void fillFilesFound(String urlBuild) {
            try {
                String currentLine;
                this.filesList.setEnabled(true);
                TCGADownloader.this.selectAllCB.setEnabled(true);
                URL url = new URL(urlBuild);
                URLConnection url_conn = url.openConnection();
                url_conn.setDoInput(true);
                url_conn.setUseCaches(true);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url_conn.getInputStream()));
                while ((currentLine = reader.readLine()) != null && !currentLine.contains("Parent Directory")) {
                }
                this.dlm.removeAllElements();
                while ((currentLine = reader.readLine()) != null && currentLine.contains("href")) {
                    String item = currentLine.substring(currentLine.indexOf(">"), currentLine.length());
                    item = item.substring(1, item.indexOf("<"));
                    if (TCGADownloader.this.dataTypeRNARB.isSelected() && !item.contains("exon") || !TCGADownloader.this.dataTypeRNARB.isSelected() && (item.contains("DESCRIPTION.txt") || item.contains("MANIFEST.txt") || item.contains("README_DCC.txt"))) continue;
                    this.dlm.addElement(item);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void setNextCBLevel(int i, String urlBuild) {
            try {
                String currentLine;
                URL url = new URL(urlBuild);
                URLConnection url_conn = url.openConnection();
                url_conn.setDoInput(true);
                url_conn.setUseCaches(true);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url_conn.getInputStream()));
                while ((currentLine = reader.readLine()) != null && !currentLine.contains("Parent Directory")) {
                }
                this.tcgaLevelBoxes[i + 1].addItem("Select");
                while ((currentLine = reader.readLine()) != null && currentLine.contains("href")) {
                    String item = currentLine.substring(currentLine.indexOf(">"), currentLine.length());
                    item = item.substring(1, item.indexOf("<"));
                    if (i + 1 == 6) {
                        if (!item.contains("Level_2") && (!item.contains("Level_3") || !TCGADownloader.this.dataTypeRNARB.isSelected()) || item.contains("tar.gz")) continue;
                        this.tcgaLevelBoxes[i + 1].addItem(item);
                        continue;
                    }
                    this.tcgaLevelBoxes[i + 1].addItem(item);
                }
                System.out.println("tcgaLevelBoxes[i+1].getItemCount() " + this.tcgaLevelBoxes[i + 1].getItemCount());
                if (this.tcgaLevelBoxes[i + 1].getItemCount() < 2) {
                    this.tcgaLevelBoxes[i + 1].removeAllItems();
                    this.tcgaLevelBoxes[i + 1].addItem("No samples found in directory.");
                    this.tcgaLevelBoxes[i + 1].setEnabled(false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private class LevelCBListener
        implements ActionListener {
            private LevelCBListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TCGADownloaderPanel.this.antiRecursion) {
                    return;
                }
                TCGADownloaderPanel.this.antiRecursion = true;
                String urlBuild = TCGADownloader.this.tcgaURLBase + "";
                for (int i = 0; i < TCGADownloaderPanel.this.tcgaLevelBoxes.length && TCGADownloaderPanel.this.tcgaLevelBoxes[i].isEnabled() && TCGADownloaderPanel.this.tcgaLevelBoxes[i].getSelectedItem() != null; ++i) {
                    urlBuild = urlBuild.concat(TCGADownloaderPanel.this.tcgaLevelBoxes[i].getSelectedItem().toString());
                    if (TCGADownloaderPanel.this.tcgaLevelBoxes[i] == event.getSource()) break;
                }
                boolean sourceLevel = true;
                for (int i = 0; i < TCGADownloaderPanel.this.tcgaLevelBoxes.length; ++i) {
                    TCGADownloaderPanel.this.tcgaLevelBoxes[i].setEnabled(sourceLevel);
                    if (TCGADownloaderPanel.this.tcgaLevelBoxes[i] != event.getSource()) continue;
                    if (i < TCGADownloaderPanel.this.tcgaLevelBoxes.length - 1) {
                        TCGADownloaderPanel.this.tcgaLevelBoxes[i + 1].setEnabled(true);
                        TCGADownloaderPanel.this.filesList.setEnabled(false);
                        TCGADownloader.this.selectAllCB.setEnabled(false);
                        TCGADownloaderPanel.this.tcgaLevelBoxes[i + 1].removeAllItems();
                        TCGADownloaderPanel.this.setNextCBLevel(i, urlBuild);
                        ++i;
                        sourceLevel = false;
                        continue;
                    }
                    TCGADownloaderPanel.this.fillFilesFound(urlBuild);
                    TCGADownloaderPanel.this.downloadFileURL = urlBuild;
                }
                TCGADownloaderPanel.this.antiRecursion = false;
            }
        }

        private class EventListener
        implements ActionListener {
            private EventListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == TCGADownloaderPanel.this.downloadButton) {
                    TCGADownloader.this.dlProgress = new Progress(null, "Downloading from TCGA", null);
                    TCGADownloader.this.dlProgress.setTitle("Downloading data from TCGA");
                    TCGADownloader.this.dlProgress.setIndeterminate(true);
                    TCGADownloader.this.dlProgress.setIndeterminantString("Please wait...");
                    TCGADownloader.this.dlProgress.setModal(true);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            TCGADownloader.this.processTCGAFile(TCGADownloaderPanel.this.downloadFileURL);
                            if (TCGADownloader.this.dataTypeRNARB.isSelected()) {
                                System.out.println("RNASeq selected");
                                TCGADownloader.this.superLoader.changeSelectedFileFilterAndLoader(16);
                                ((RNASeqFileLoader)TCGADownloader.this.superLoader.selectedFileLoader).setTCGADataFile(TCGADownloader.this.tcgaDownloadFile.getName());
                                TMEV.storeProperty("tcga-path", "tcga path to archive");
                            }
                        }
                    };
                    Thread thread = new Thread(runnable);
                    thread.start();
                    TCGADownloader.this.dlProgress.show();
                } else if (source == TCGADownloaderPanel.this.twoColorArray) {
                    TCGADownloader.this.dataType = 1;
                    TCGADownloader.this.setDataType(TCGADownloader.this.dataType);
                } else if (source == TCGADownloaderPanel.this.singleColorArray) {
                    TCGADownloader.this.dataType = 2;
                    TCGADownloader.this.setDataType(TCGADownloader.this.dataType);
                }
            }
        }
    }
}

