/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.IChipAnnotation;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindowDialog;
import org.tigr.microarray.mev.file.AffyGCOSFileLoader;
import org.tigr.microarray.mev.file.AffymetrixFileLoader;
import org.tigr.microarray.mev.file.AgilentFileLoader;
import org.tigr.microarray.mev.file.CGHStanfordFileLoader;
import org.tigr.microarray.mev.file.DFCI_CoreFileLoader;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileLoadInfo;
import org.tigr.microarray.mev.file.FileType;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.GEOSeriesMatrixLoader;
import org.tigr.microarray.mev.file.GEO_GDSFileLoader;
import org.tigr.microarray.mev.file.GenePixFileLoader;
import org.tigr.microarray.mev.file.MAGETABFileLoader;
import org.tigr.microarray.mev.file.Mas5FileLoader;
import org.tigr.microarray.mev.file.MevFileLoader;
import org.tigr.microarray.mev.file.RMAFileLoader;
import org.tigr.microarray.mev.file.RNASeqFileLoader;
import org.tigr.microarray.mev.file.SOFT_AffymetrixFileLoader;
import org.tigr.microarray.mev.file.SOFT_TwoChannelFileLoader;
import org.tigr.microarray.mev.file.StanfordFileLoader;
import org.tigr.microarray.mev.file.TCGADownloader;
import org.tigr.microarray.mev.file.TavFileLoader;
import org.tigr.microarray.mev.resources.ExpressionDataSupportDataFile;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.ResourcererAnnotationFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class SuperExpressionFileLoader {
    public static String DATA_PATH = TMEV.getDataPath();
    public static String ANNOTATION_PATH = TMEV.getSettingForOption("current-annotation-path");
    public static final ImageIcon ICON_COMPUTER = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/PCIcon.gif")));
    public static final ImageIcon ICON_DISK = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/disk.gif")));
    public static final ImageIcon ICON_FOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/Directory.gif")));
    public static final ImageIcon ICON_EXPANDEDFOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/expandedfolder.gif")));
    protected ExpressionFileLoader[] fileLoaders;
    protected ExpressionFileLoader selectedFileLoader;
    protected FileFilter[] fileFilters;
    protected FileFilter selectedFileFilter;
    protected JFrame mainFrame;
    protected JPanel fileFilterPanel;
    protected JLabel fileFilterLabel;
    protected JLabel fileType;
    protected JComboBox fileTypeList;
    protected JComboBox fileFilterComboBox;
    protected JPanel fileLoaderPanel;
    protected JButton infoButton;
    protected JButton cancelButton;
    protected JButton loadButton;
    protected JPanel buttonPanel;
    protected JPanel selectionPanel;
    protected JSplitPane mainSplitPane;
    protected GBA gba;
    protected EventListener eventListener;
    protected MultipleArrayViewer viewer;
    protected Loader loader;
    protected int loaderIndex = 0;
    protected JMenuBar menuBar;
    protected JMenu menu1;
    protected JMenu menu2;
    protected JMenu menu3;
    protected JMenu menu4;
    protected JMenu helpMenu;
    protected JMenuItem[] menuItem;
    protected JMenuItem[] subMenuItem;
    protected JTextField filetype = null;
    protected boolean hasAnnotationList = false;
    protected Hashtable<String, Vector<String>> annotationLists;
    protected String defaultSpeciesName;
    protected String defaultArrayName;

    public SuperExpressionFileLoader(MultipleArrayViewer viewer, FileLoadInfo loadingInfo) {
        this(viewer);
        FileType ft = loadingInfo.getFileType();
        ExpressionFileLoader expressionLoader = this.getFileLoader(ft.getLoaderIndex());
        String arrayType = loadingInfo.getArrayType();
        String speciesName = this.getSpeciesName(loadingInfo.getArrayType());
        String fileURL = loadingInfo.getDataFileURL();
        boolean isMultiFile = loadingInfo.isMultiFile();
        File dataFile = new File(TMEV.getDataPath());
        if (loadingInfo.isDownloadDatafile()) {
            try {
                dataFile = viewer.getSupportFile(new ExpressionDataSupportDataFile(fileURL, isMultiFile, ft));
            }
            catch (SupportFileAccessError sfae) {
                ShowThrowableDialog.show(this.mainFrame, "File download failed", true, 64, sfae, "MeV was unable to download the file " + fileURL + "<br/><br/>Please check that this is a valid URL and that " + "your computer is connected to the internet.");
                dataFile = null;
            }
        }
        if (arrayType != null && !arrayType.equals("")) {
            try {
                File annotationFile = this.getAnnotationFile(speciesName, arrayType);
                expressionLoader.setAnnotationFilePath(annotationFile.getAbsolutePath());
            }
            catch (SupportFileAccessError sfae) {
                ShowThrowableDialog.show(this.mainFrame, "File download failed", true, 64, sfae, "MeV was unable to download the annotation file for the specified array \"" + arrayType + "\".<br/><br/>The array name may be invalid or your computer may not be connected to the internet.");
            }
        }
        if (dataFile != null) {
            expressionLoader.setCoordinates(loadingInfo.getFirstRow(), loadingInfo.getFirstColumn());
            if (expressionLoader.canAutoLoad(dataFile)) {
                this.selectedFileLoader = expressionLoader;
                this.mainFrame.setVisible(false);
                this.setFilePath(dataFile.getAbsolutePath());
                this.loader.run();
            } else {
                this.changeSelectedFileFilterAndLoader(ft.getLoaderIndex());
                this.setFilePath(dataFile.getAbsolutePath());
            }
        }
    }

    public SuperExpressionFileLoader(MultipleArrayViewer viewer) {
        this.viewer = viewer;
        this.defaultArrayName = TMEV.getSettingForOption("last-loaded-array");
        this.defaultSpeciesName = TMEV.getSettingForOption("last-loaded-species");
        this.hasAnnotationList = this.initializeAnnotationInfo();
        this.loader = new Loader();
        this.initializeFileLoaders();
        this.initializeGUI();
    }

    public SuperExpressionFileLoader() {
        this.loader = new Loader();
        this.initializeFileLoaders();
        this.initializeGUI();
        this.hasAnnotationList = this.initializeAnnotationInfo();
    }

    private String getSpeciesName(String arrayType) {
        if (arrayType == null) {
            return null;
        }
        Enumeration<String> allAnnTypes = this.annotationLists.keys();
        while (allAnnTypes.hasMoreElements()) {
            String thisSpecies = allAnnTypes.nextElement();
            Vector<String> theseArrays = this.annotationLists.get(thisSpecies);
            for (int i = 0; i < theseArrays.size(); ++i) {
                if (!arrayType.equals(theseArrays.get(i))) continue;
                return thisSpecies;
            }
        }
        return null;
    }

    private boolean initializeAnnotationInfo() {
        try {
            PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
            File f = this.viewer.getSupportFile(aafd);
            this.annotationLists = aafd.parseAnnotationListFile(f);
            return true;
        }
        catch (SupportFileAccessError sfae) {
            this.annotationLists = null;
            return false;
        }
        catch (IOException ioe) {
            this.annotationLists = null;
            return false;
        }
        catch (Exception e) {
            this.annotationLists = null;
            return false;
        }
    }

    public File getAnnotationFile(String organismName, String arrayName) throws SupportFileAccessError {
        return this.viewer.getSupportFile(new ResourcererAnnotationFileDefinition(organismName, arrayName));
    }

    protected void initializeFileLoaders() {
        int defaultSelection = 0;
        this.fileLoaders = new ExpressionFileLoader[18];
        this.fileLoaders[0] = new StanfordFileLoader(this);
        this.fileLoaders[1] = null;
        this.fileLoaders[2] = null;
        this.fileLoaders[3] = null;
        this.fileLoaders[4] = null;
        this.fileLoaders[5] = null;
        this.fileLoaders[6] = null;
        this.fileLoaders[7] = null;
        this.fileLoaders[8] = null;
        this.fileLoaders[9] = null;
        this.fileLoaders[10] = null;
        this.fileLoaders[11] = null;
        this.fileLoaders[12] = null;
        this.fileLoaders[13] = null;
        this.fileLoaders[14] = null;
        this.fileLoaders[15] = null;
        this.fileLoaders[16] = null;
        this.fileLoaders[17] = null;
        this.selectedFileLoader = this.fileLoaders[defaultSelection];
        this.fileFilters = new FileFilter[this.fileLoaders.length];
        this.fileFilters[0] = this.fileLoaders[0].getFileFilter();
        this.selectedFileFilter = this.fileFilters[defaultSelection];
    }

    public void helpWindow(String st) {
        HelpWindow.launchBrowser((Window)this.mainFrame, (String)st);
    }

    public void menuItem(JMenu jItem, final String st) {
        this.menuItem = new JMenuItem[9];
        this.menuItem[0] = new JMenuItem("Tab Delimited, Multiple Sample Files");
        this.menuItem[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("TDMS");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(0);
                }
            }
        });
        jItem.add(this.menuItem[0]);
        this.menuItem[1] = new JMenu("TIGR Files");
        this.subMenuItem = new JMenuItem[2];
        this.subMenuItem[0] = new JMenuItem("MeV Files");
        this.subMenuItem[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"Mev"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(1);
                }
            }
        });
        this.menuItem[1].add(this.subMenuItem[0]);
        this.subMenuItem[1] = new JMenuItem("TIGR ArrayViewer (*.tav) Files");
        this.subMenuItem[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"Tav"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(2);
                }
            }
        });
        this.menuItem[1].add(this.subMenuItem[1]);
        jItem.add(this.menuItem[1]);
        this.menuItem[2] = new JMenu("Affymetrix Files");
        this.subMenuItem = new JMenuItem[5];
        this.subMenuItem[0] = new JMenuItem("Affymetrix GCOS(using MAS5)Files");
        this.subMenuItem[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("GCOS");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(3);
                }
            }
        });
        this.menuItem[2].add(this.subMenuItem[0]);
        this.subMenuItem[1] = new JMenuItem("dChip/DFCI_Core Format Files");
        this.menuItem[2].add(this.subMenuItem[1]);
        this.subMenuItem[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("dChip");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(4);
                }
            }
        });
        this.subMenuItem[2] = new JMenuItem("GW Affymetrix Files");
        this.menuItem[2].add(this.subMenuItem[2]);
        this.subMenuItem[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("GW");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(5);
                }
            }
        });
        this.subMenuItem[3] = new JMenuItem("Bioconductor(using MAS5) Files");
        this.menuItem[2].add(this.subMenuItem[3]);
        this.subMenuItem[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("bioconductor");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(6);
                }
            }
        });
        this.subMenuItem[4] = new JMenuItem("RMA Files");
        this.menuItem[2].add(this.subMenuItem[4]);
        this.subMenuItem[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("RMA");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(7);
                }
            }
        });
        jItem.add(this.menuItem[2]);
        this.menuItem[3] = new JMenuItem("CGH Tab Delimited, Multiple Sample");
        this.menuItem[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("CGH");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(8);
                }
            }
        });
        jItem.add(this.menuItem[3]);
        this.menuItem[4] = new JMenu("GEO Files");
        this.subMenuItem = new JMenuItem[4];
        this.subMenuItem[0] = new JMenuItem("GPL Family Format Files (Affymetrix)");
        this.subMenuItem[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"GEOaffy"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(9);
                }
            }
        });
        this.menuItem[4].add(this.subMenuItem[0]);
        this.subMenuItem[1] = new JMenuItem("GPL Family Format Files (Two Channel)");
        this.subMenuItem[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"GEOtwo"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(10);
                }
            }
        });
        this.menuItem[4].add(this.subMenuItem[1]);
        this.subMenuItem[2] = new JMenuItem("GEO Series Matrix Files");
        this.subMenuItem[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"GEOSeriesMatrix"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(13);
                }
            }
        });
        this.menuItem[4].add(this.subMenuItem[2]);
        this.subMenuItem[3] = new JMenuItem("GEO GDS Format Files");
        this.subMenuItem[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"GEO GDS Format Files"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(14);
                }
            }
        });
        this.menuItem[4].add(this.subMenuItem[3]);
        jItem.add(this.menuItem[4]);
        this.menuItem[5] = new JMenuItem("MAGE-TAB Files");
        this.menuItem[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"MAGE"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(15);
                }
            }
        });
        jItem.add(this.menuItem[5]);
        this.menuItem[6] = new JMenuItem("RNASeq DGE/RPKM Files");
        this.menuItem[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("RNASeq Loader");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(16);
                }
            }
        });
        jItem.add(this.menuItem[6]);
        this.menuItem[7] = new JMenuItem("Download TCGA Data");
        this.menuItem[7].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    SuperExpressionFileLoader.this.helpWindow("TCGA Data Downloader");
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(17);
                }
            }
        });
        jItem.add(this.menuItem[7]);
        this.menuItem[8] = new JMenu("Other Format Files");
        this.subMenuItem = new JMenuItem[2];
        this.subMenuItem[0] = new JMenuItem("GenePix Format Files");
        this.subMenuItem[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"GenePix"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(11);
                }
            }
        });
        this.menuItem[8].add(this.subMenuItem[0]);
        this.subMenuItem[1] = new JMenuItem("Agilent Files");
        this.subMenuItem[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (st == "File Format Hint") {
                    HelpWindowDialog helpWindowDialog = new HelpWindowDialog((Frame)SuperExpressionFileLoader.this.mainFrame, HelpWindowDialog.createText((String)"Agilent"));
                } else {
                    SuperExpressionFileLoader.this.changeSelectedFileFilterAndLoader(12);
                }
            }
        });
        this.menuItem[8].add(this.subMenuItem[1]);
        jItem.add(this.menuItem[8]);
    }

    public void initializeGUI() {
        this.gba = new GBA();
        this.eventListener = new EventListener();
        this.mainFrame = new JFrame("Expression File Loader");
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SuperExpressionFileLoader.this.viewer.setDataLoadersEnabled(true);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                SuperExpressionFileLoader.this.viewer.setDataLoadersEnabled(true);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SuperExpressionFileLoader.this.viewer.setDataLoadersEnabled(false);
            }
        });
        this.mainFrame.getContentPane().setLayout(new GridBagLayout());
        this.menuBar = new JMenuBar();
        this.menu1 = new JMenu("Select File Loader");
        this.menu1.setMnemonic(83);
        this.menuItem(this.menu1, "Select Expression File Type");
        this.menuBar.add(this.menu1);
        this.menu2 = new JMenu("Help");
        this.menu2.setMnemonic(72);
        this.menuItem(this.menu2, "File Format Hint");
        this.menuBar.add(this.menu2);
        this.menuBar.setBorderPainted(true);
        this.mainFrame.setJMenuBar(this.menuBar);
        this.fileFilterLabel = new JLabel();
        this.fileLoaderPanel = this.selectedFileLoader.getFileLoaderPanel();
        this.fileLoaderPanel.setSize(new Dimension(750, 750));
        this.fileLoaderPanel.setPreferredSize(new Dimension(750, 750));
        URL url = this.getClass().getClassLoader().getResource("org/tigr/images/Information24.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        ImageIcon imageIcon = new ImageIcon(image);
        this.infoButton = new JButton(null, imageIcon);
        this.infoButton.setActionCommand("info-command");
        this.infoButton.addActionListener(this.eventListener);
        this.infoButton.setFocusPainted(false);
        this.infoButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.eventListener);
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setSize(60, 30);
        this.cancelButton.setPreferredSize(new Dimension(60, 30));
        this.cancelButton.setFocusPainted(false);
        this.loadButton = new JButton("Load");
        this.loadButton.addActionListener(this.eventListener);
        this.loadButton.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        this.loadButton.setSize(60, 30);
        this.loadButton.setPreferredSize(new Dimension(60, 30));
        this.loadButton.setFocusPainted(false);
        this.loadButton.setEnabled(false);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.gba.add(this.buttonPanel, this.infoButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        url = this.getClass().getClassLoader().getResource("org/tigr/images/dialog_button_bar.gif");
        image = Toolkit.getDefaultToolkit().getImage(url);
        imageIcon = new ImageIcon(image);
        JLabel myLbl = new JLabel(imageIcon);
        this.gba.add(this.buttonPanel, myLbl, 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.buttonPanel, this.cancelButton, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.buttonPanel, this.loadButton, 3, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(this.mainFrame.getContentPane(), this.fileLoaderPanel, 0, 1, 1, 3, 1, 1, 1, 10);
        this.gba.add(this.mainFrame.getContentPane(), this.buttonPanel, 0, 4, 1, 1, 1, 0, 2, 10);
        this.mainFrame.setSize(800, 680);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.mainFrame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.mainFrame.setLocation((screenSize.width - this.mainFrame.getSize().width) / 2, (screenSize.height - this.mainFrame.getSize().height) / 2);
        this.mainFrame.setVisible(true);
        this.selectedFileLoader.openDataPath();
    }

    public void setLoadEnabled(boolean state) {
        this.loadButton.setEnabled(state);
    }

    private ExpressionFileLoader getFileLoader(int target) {
        ExpressionFileLoader loader;
        FileType selectedType = FileType.getTypeFromLoaderIndex(target);
        if (target >= 0 && target < this.fileLoaders.length && this.fileLoaders[target] != null) {
            return this.fileLoaders[target];
        }
        this.setLoadEnabled(false);
        switch (selectedType) {
            case STANFORD: {
                loader = this.fileLoaders[0];
                break;
            }
            case MEV_TARBALL: {
                loader = new MevFileLoader(this);
                break;
            }
            case TAV: {
                loader = new TavFileLoader(this);
                break;
            }
            case AFFY_GCOS: {
                loader = new AffyGCOSFileLoader(this);
                break;
            }
            case DCHIP: {
                loader = new DFCI_CoreFileLoader(this);
                break;
            }
            case GW_AFFY: {
                loader = new AffymetrixFileLoader(this);
                break;
            }
            case BIOCONDUCTOR_MAS5: {
                loader = new Mas5FileLoader(this);
                break;
            }
            case RMA: {
                loader = new RMAFileLoader(this);
                break;
            }
            case CGH: {
                loader = new CGHStanfordFileLoader(this);
                break;
            }
            case AFFY_GPL: {
                loader = new SOFT_AffymetrixFileLoader(this);
                break;
            }
            case TWO_CHANNEL_GPL: {
                loader = new SOFT_TwoChannelFileLoader(this);
                break;
            }
            case GENEPIX: {
                loader = new GenePixFileLoader(this);
                break;
            }
            case AGILENT: {
                loader = new AgilentFileLoader(this);
                break;
            }
            case GEO_SERIES_MATRIX: {
                loader = new GEOSeriesMatrixLoader(this);
                break;
            }
            case GEO_GDS: {
                loader = new GEO_GDSFileLoader(this);
                break;
            }
            case MAGETAB: {
                loader = new MAGETABFileLoader(this);
                break;
            }
            case RNASEQ: {
                loader = new RNASeqFileLoader(this);
                break;
            }
            case TCGA_DOWNLOAD: {
                loader = new TCGADownloader(this);
                break;
            }
            default: {
                loader = new StanfordFileLoader(this);
            }
        }
        this.fileLoaders[target] = loader;
        return loader;
    }

    public void changeSelectedFileFilterAndLoader(int target) {
        if (target < 0 || target >= this.fileLoaders.length || target >= this.fileFilters.length) {
            return;
        }
        this.selectedFileLoader = this.getFileLoader(target);
        this.mainFrame.toFront();
        this.fileFilters[target] = this.selectedFileLoader.getFileFilter();
        this.selectedFileFilter = this.fileFilters[target];
        this.loaderIndex = target;
        this.changeFileLoaderPanel(this.selectedFileLoader);
    }

    public void changeFileLoaderPanel(ExpressionFileLoader targetFileLoader) {
        Container cp = this.mainFrame.getContentPane();
        cp.remove(this.fileLoaderPanel);
        this.fileLoaderPanel = targetFileLoader.getFileLoaderPanel();
        this.gba.add(cp, this.fileLoaderPanel, 0, 1, 1, 3, 1, 1, 1, 10);
        this.checkLoadEnable();
        cp.validate();
        this.selectedFileLoader.openDataPath();
        cp.repaint();
    }

    public void addFileFilter(FileFilter fileFilter) {
        if (fileFilter == null) {
            return;
        }
        this.fileFilterComboBox.addItem(fileFilter.getDescription());
    }

    public void addFileFilters(FileFilter[] fileFilters) {
        for (int i = 0; i < fileFilters.length; ++i) {
            this.fileFilterComboBox.addItem(this.getFileDescription(i));
        }
    }

    public String getFileDescription(int target) {
        return FileType.getTypeFromLoaderIndex(target).getDescription();
    }

    public void checkLoadEnable() {
        this.selectedFileLoader.checkLoadEnable();
    }

    public void onInfo() {
        HelpWindow.launchBrowser((Window)this.getFrame(), (String)"File Loader");
    }

    public void onCancel() {
        this.clean();
    }

    public void onLoad() {
        this.clean();
        Thread thread = new Thread(new Loader());
        thread.setPriority(5);
        thread.start();
        this.selectedFileLoader.showModal();
    }

    public void clean() {
        this.mainFrame.dispose();
    }

    public JFrame getFrame() {
        return this.viewer.getFrame();
    }

    public MultipleArrayViewer getArrayViewer() {
        return this.viewer;
    }

    private ISlideData[] toISlideDataArray(Vector<ISlideData> dataVector) {
        if (dataVector == null || dataVector.size() < 1) {
            return null;
        }
        ISlideData[] data = new ISlideData[dataVector.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dataVector.elementAt(i);
        }
        return data;
    }

    private void updateDataPath(String dataPath) {
        System.out.println("dataPath = " + dataPath);
        System.out.println("new File(dataPath).getParent() = " + new File(dataPath).getParent());
        if (dataPath != null) {
            DATA_PATH = dataPath;
            TMEV.setDataPath(DATA_PATH);
        }
    }

    public void setFilePath(String path) {
        this.selectedFileLoader.setFilePath(path);
    }

    public String getDefaultSpeciesName() {
        return this.defaultSpeciesName;
    }

    public String getDefaultArrayName() {
        return this.defaultArrayName;
    }

    public class FillPanel
    extends JPanel {
        GradientPaint gp;
        Color backgroundColor = new Color(25, 25, 169);
        Color fadeColor = new Color(140, 220, 240);

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            this.gp = new GradientPaint(0.0f, dim.height / 2, this.backgroundColor, dim.width, dim.height / 2, this.fadeColor);
            g2.setPaint(this.gp);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
        }
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            this.setLayout(new GridBagLayout());
            JLabel iconLabel = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("org/tigr/images/dialog_banner2.gif"))));
            iconLabel.setOpaque(false);
            iconLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private class Loader
    implements Runnable {
        @Override
        public void run() {
            Vector<ISlideData> data = null;
            int dataType = 0;
            IChipAnnotation chipAnnotation = null;
            try {
                SuperExpressionFileLoader.this.selectedFileLoader.showModal();
                data = SuperExpressionFileLoader.this.selectedFileLoader.loadExpressionFiles();
                chipAnnotation = SuperExpressionFileLoader.this.selectedFileLoader.getChipAnnotation();
                dataType = SuperExpressionFileLoader.this.selectedFileLoader.getDataType();
                SuperExpressionFileLoader.this.selectedFileLoader.dispose();
                if (data != null) {
                    SuperExpressionFileLoader.this.viewer.fireDataLoaded(SuperExpressionFileLoader.this.toISlideDataArray(data), chipAnnotation, dataType);
                } else {
                    System.out.println("data null");
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                ioe.getCause();
            }
        }
    }

    private class EventListener
    implements ActionListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == SuperExpressionFileLoader.this.infoButton) {
                SuperExpressionFileLoader.this.onInfo();
            } else if (source == SuperExpressionFileLoader.this.cancelButton) {
                SuperExpressionFileLoader.this.onCancel();
            } else if (source == SuperExpressionFileLoader.this.loadButton) {
                SuperExpressionFileLoader.this.onLoad();
            }
        }
    }
}

