/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.annotation.AffymetrixAnnotationParser;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;

public class StanfordFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private int dataType = 2;
    private boolean stop = false;
    private StanfordFileLoaderPanel sflp;
    ExpressionFileTableCellRenderer myCellRenderer;
    protected String[] moreFields = new String[0];
    private ISlideData[] slideDataArray = null;
    private ISlideDataElement sde;
    private Hashtable _tempAnno = new Hashtable();
    private MultipleArrayViewer mav;

    @Override
    public void setFilePath(String path) {
        this.sflp.setFileName(path);
        this.processStanfordFile(new File(path));
    }

    public StanfordFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.sflp = new StanfordFileLoaderPanel();
    }

    public Vector<ISlideData> loadStanfordExpressionFile(File f) throws IOException {
        int selectedPreSpotRows = this.sflp.getXRow() + 1;
        int selectedPreExperimentColumns = this.sflp.getXColumn();
        return this.loadStanfordExpressionFile(f, selectedPreSpotRows, selectedPreExperimentColumns);
    }

    @Override
    public Vector<ISlideData> loadExpressionFiles() throws IOException {
        if (this.sflp.getXColumn() == 0) {
            JOptionPane.showMessageDialog(null, "The selected file has no gene annotation and cannot be loaded. \n\nPlease make sure you have selected an EXPRESSION value in the file loader table.\nThe 1st column cannot contain expression values.", "Missing Annotation Error", 0, null);
            return null;
        }
        return this.loadStanfordExpressionFile(new File(this.sflp.fileNameTextField.getText()), this.sflp.getXRow() + 1, this.sflp.getXColumn());
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    @Override
    public boolean canAutoLoad(File f) {
        return true;
    }

    public Vector<ISlideData> loadStanfordExpressionFile(File f, int rowcoord, int colcoord) throws IOException {
        String currentLine;
        int preSpotRows = rowcoord;
        int preExperimentColumns = colcoord;
        int numLines = this.getCountOfLines(f);
        int spotCount = numLines - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        this.moreFields = new String[preExperimentColumns];
        boolean rColumns = true;
        int rRows = spotCount;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        int column = 1;
        int row = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(numLines);
        this.setFileProgress(0);
        if (this.isAnnotationSelected()) {
            this.mav.getData().setAnnotationLoaded(true);
            File annoFile = new File(this.getAnnotationFilePath());
            String extension = annoFile.getName().substring(annoFile.getName().lastIndexOf(46) + 1, annoFile.getName().length());
            if (annoFile.getName().endsWith("annot.csv")) {
                AffymetrixAnnotationParser aafp = AffymetrixAnnotationParser.createAnnotationFileParser(new File(this.getAnnotationFilePath()));
                this._tempAnno = aafp.getAffyAnnotation();
            }
            if (extension.equalsIgnoreCase("txt")) {
                AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader(new File(this.getAnnotationFilePath()));
                this._tempAnno = afr.getAffyAnnotation();
                this.chipAnno = afr.getAffyChipAnnotation();
            }
        }
        while ((currentLine = reader.readLine()) != null) {
            try {
                if (this.stop) {
                    return null;
                }
                while (currentLine.endsWith("\t")) {
                    currentLine = currentLine.substring(0, currentLine.length() - 1);
                }
                ss.init(currentLine);
                if (counter == 0) {
                    int i;
                    int experimentCount = ss.countTokens() + 1 - preExperimentColumns;
                    SampleAnnotation sampAnn = new SampleAnnotation();
                    this.slideDataArray = new ISlideData[experimentCount];
                    this.slideDataArray[0] = new SlideData(rRows, 1, sampAnn);
                    this.slideDataArray[0].setSlideFileName(f.getPath());
                    for (int i2 = 1; i2 < this.slideDataArray.length; ++i2) {
                        sampAnn = new SampleAnnotation();
                        this.slideDataArray[i2] = new FloatSlideData(this.slideDataArray[0].getSlideMetaData(), spotCount, sampAnn);
                        this.slideDataArray[i2].setSlideFileName(f.getPath());
                    }
                    String[] fieldNames = new String[preExperimentColumns];
                    for (i = 0; i < preExperimentColumns; ++i) {
                        fieldNames[i] = ss.nextToken();
                    }
                    this.slideDataArray[0].getSlideMetaData().setFieldNames(fieldNames);
                    for (i = 0; i < experimentCount; ++i) {
                        String val = ss.nextToken();
                        this.slideDataArray[i].setSampleAnnotationLoaded(true);
                        this.slideDataArray[i].getSampleAnnotation().setAnnotation("Default Slide Name", val);
                        this.slideDataArray[i].setSlideDataName(val);
                        this.mav.getData().setSampleAnnotationLoaded(true);
                    }
                } else if (counter >= preSpotRows) {
                    rows[0] = rows[2] = row++;
                    columns[0] = columns[2] = column;
                    column = column == 1 ? 1 : ++column;
                    for (int i = 0; i < preExperimentColumns; ++i) {
                        this.moreFields[i] = ss.nextToken();
                    }
                    String cloneName = this.moreFields[0];
                    MevAnnotation mevAnno = null;
                    if (this._tempAnno.size() != 0) {
                        if ((MevAnnotation)this._tempAnno.get(cloneName) != null) {
                            mevAnno = (MevAnnotation)this._tempAnno.get(cloneName);
                        } else {
                            mevAnno = new MevAnnotation();
                            mevAnno.setCloneID(cloneName);
                        }
                    }
                    this.sde = this.getDataType() == 2 ? new AffySlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], this.moreFields, mevAnno) : new SlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], this.moreFields, mevAnno);
                    this.slideDataArray[0].addSlideDataElement(this.sde);
                    for (int i = 0; i < this.slideDataArray.length; ++i) {
                        float cy5;
                        float cy3 = 1.0f;
                        try {
                            String value = ss.nextToken();
                            cy5 = Float.parseFloat(value);
                        }
                        catch (Exception e) {
                            cy3 = 0.0f;
                            cy5 = Float.NaN;
                        }
                        this.slideDataArray[i].setIntensities(counter - preSpotRows, cy3, cy5);
                    }
                } else {
                    for (int i = 0; i < preExperimentColumns - 1; ++i) {
                        ss.nextToken();
                    }
                    String key = ss.nextToken();
                    for (int j = 0; j < this.slideDataArray.length; ++j) {
                        if (this.slideDataArray[j].getSampleAnnotation() != null) {
                            String val = ss.nextToken();
                            this.slideDataArray[j].getSampleAnnotation().setAnnotation(key, val);
                            continue;
                        }
                        SampleAnnotation sampAnn = new SampleAnnotation();
                        sampAnn.setAnnotation(key, ss.nextToken());
                        this.slideDataArray[j].setSampleAnnotation(sampAnn);
                        this.slideDataArray[j].setSampleAnnotationLoaded(true);
                    }
                }
                this.setFileProgress(counter);
                ++counter;
            }
            catch (NoSuchElementException nsee) {}
        }
        reader.close();
        Vector<ISlideData> data = new Vector<ISlideData>(this.slideDataArray.length);
        for (int i = 0; i < this.slideDataArray.length; ++i) {
            data.add(this.slideDataArray[i]);
        }
        this.setFilesProgress(1);
        return data;
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Tab Delimited, Multiple Sample Files (TDMS) (*.txt)";
            }
        };
        return mevFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.sflp.getXRow() + 1;
        int tableColumn = this.sflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.sflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        if (!this.sflp.twoColorArray.isSelected() & !this.sflp.singleColorArray.isSelected()) {
            String eMsg = "<html>Please select an array type..<br>";
            JOptionPane.showMessageDialog(null, eMsg, "Warning", 1);
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.sflp;
    }

    public void processStanfordFile(File targetFile) {
        Vector<String> columnHeaders = new Vector<String>();
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        String currentLine = null;
        if (!this.validateFile(targetFile)) {
            return;
        }
        this.sflp.setFileName(targetFile.getAbsolutePath());
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        try {
            reader = new BufferedReader(new FileReader(targetFile), 131072);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            currentLine = reader.readLine();
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                columnHeaders.add(ss.nextToken());
            }
            model.setColumnIdentifiers(columnHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && cnt < 100) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i = 0; i < ss.countTokens() + 1; ++i) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.sflp.setTableModel(model);
        Point p = this.getFirstExpressionCell(dataVector);
        this.sflp.setSelectedCell(p.x, p.y);
    }

    @Override
    public String getFilePath() {
        return this.sflp.fileNameTextField.getText();
    }

    @Override
    public String getAnnotationFilePath() {
        return this.sflp.getAnnFilePath();
    }

    @Override
    public void openDataPath() {
    }

    public void setDataType(int data_Type) {
        this.dataType = data_Type != -1 ? data_Type : 1;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public boolean isAnnotationSelected() {
        return this.sflp.adh.annotationSelected;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
        this.sflp.adh.setAnnFilePath(filePath);
        this.sflp.adh.annotationSelected = true;
    }

    private class StanfordFileLoaderPanel
    extends JPanel {
        JTextField fileNameTextField;
        JTextField selectedFiles;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel fileLoaderPanel;
        JTextField fieldsTextField;
        JPanel fieldsPanel;
        JSplitPane splitPane;
        JList availableList;
        JScrollPane availableScrollPane;
        private int xRow = -1;
        private int xColumn = -1;
        JPanel fileSelectionPanel;
        JLabel fileSelectionLabel;
        JLabel dataSelection;
        JButton browseButton1;
        JPanel buttonPanel;
        JRadioButton twoColorArray;
        JRadioButton singleColorArray;
        AnnotationDownloadHandler adh;
        protected EventListener eventListener;

        public StanfordFileLoaderPanel() {
            this.adh = new AnnotationDownloadHandler(StanfordFileLoader.this.superLoader.viewer.getResourceManager(), StanfordFileLoader.this.superLoader.annotationLists, StanfordFileLoader.this.superLoader.defaultSpeciesName, StanfordFileLoader.this.superLoader.defaultArrayName);
            this.eventListener = new EventListener();
            this.setLayout(new GridBagLayout());
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.fileSelectionLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select expression data file</html>";
            this.dataSelection.setText(chooseFile);
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (Tab Delimited Multiple Sample (*.*))"));
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(this.eventListener);
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.twoColorArray = new JRadioButton("Two-color Array", false);
            this.twoColorArray.setFocusPainted(false);
            this.twoColorArray.addActionListener(new EventListener());
            this.singleColorArray = new JRadioButton("Single-color Array");
            this.singleColorArray.setFocusPainted(false);
            this.singleColorArray.addActionListener(new EventListener());
            this.singleColorArray.setSelected(true);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.twoColorArray);
            bg.add(this.singleColorArray);
            StanfordFileLoader.this.gba.add(this.buttonPanel, this.twoColorArray, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.buttonPanel, this.singleColorArray, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.fileSelectionLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedFiles, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.buttonPanel, 0, 3, 0, 0, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.expressionTable = new JTable();
            StanfordFileLoader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable.setDefaultRenderer(Object.class, StanfordFileLoader.this.myCellRenderer);
            this.expressionTable.setIntercellSpacing(new Dimension(1, 1));
            this.expressionTable.setShowHorizontalLines(false);
            this.expressionTable.setShowVerticalLines(true);
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    StanfordFileLoaderPanel.this.setSelectedCell(StanfordFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), StanfordFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            StanfordFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.adh.getAnnotationLoaderPanel(StanfordFileLoader.this.gba), 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 3, 1, 6, 3, 6, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            StanfordFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        }

        public boolean isAnnotationSelected() {
            return this.adh.annotationSelected;
        }

        public String getAnnFilePath() {
            return this.adh.getAnnFilePath();
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            StanfordFileLoader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            StanfordFileLoader.this.checkLoadEnable();
        }

        public boolean onBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                StanfordFileLoader.this.processStanfordFile(selectedFile);
                return true;
            }
            return false;
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void setFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
            this.selectedFiles.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String fieldsText) {
        }

        private class EventListener
        implements ActionListener {
            private EventListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == StanfordFileLoaderPanel.this.browseButton1) {
                    StanfordFileLoaderPanel.this.onBrowse();
                } else if (source == StanfordFileLoaderPanel.this.twoColorArray) {
                    StanfordFileLoader.this.dataType = 1;
                    StanfordFileLoader.this.setDataType(StanfordFileLoader.this.dataType);
                } else if (source == StanfordFileLoaderPanel.this.singleColorArray) {
                    StanfordFileLoader.this.dataType = 2;
                    StanfordFileLoader.this.setDataType(StanfordFileLoader.this.dataType);
                }
            }
        }
    }
}

