/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;

public class SlideLoaderProgressBar
extends JDialog {
    protected static final int BUFFER_SIZE = 131072;
    private int result = 2;
    private ISlideData[] data;
    protected ISlideMetaData meta;
    private File[] files;
    private boolean stop = false;
    private Exception exception;
    private LoadingPanel loadingPanel = new LoadingPanel();
    private boolean fillMissingSpots = false;

    public SlideLoaderProgressBar(JFrame frame) {
        super((Frame)frame, "Slide Data Loading");
        Listener listener = new Listener();
        JPanel btnsPanel = this.createBtnsPanel(listener);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)this.loadingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)btnsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        panel.add((Component)cancelButton, "East");
        this.getRootPane().setDefaultButton(cancelButton);
        return panel;
    }

    public void setFilesCount(int count) {
        this.loadingPanel.setFilesCount(count);
    }

    public void setLinesCount(int count) {
        this.loadingPanel.setLinesCount(count);
    }

    public void setFilesProgress(int value) {
        this.loadingPanel.setFilesProgress(value);
    }

    public void setFileProgress(int value) {
        this.loadingPanel.setFileProgress(value);
    }

    public void setFileName(String filename) {
        this.loadingPanel.setFileName(filename);
    }

    public void setRemain(int count) {
        this.loadingPanel.setRemain(count);
    }

    private class LoadingPanel
    extends JPanel {
        private JProgressBar filesProgress = new JProgressBar();
        private JProgressBar fileProgress = new JProgressBar();
        private JLabel filesLabel = new JLabel("Remain: ");
        private JLabel fileLabel = new JLabel("File: ");

        public LoadingPanel() {
            this.setPreferredSize(new Dimension(350, 120));
            this.setBorder(new BevelBorder(0));
            this.setLayout(new GridBagLayout());
            this.filesProgress.setStringPainted(true);
            this.fileProgress.setStringPainted(true);
            this.add((Component)this.filesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.filesProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileProgress, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        public void setFilesCount(int count) {
            this.filesProgress.setMaximum(count);
        }

        public void setLinesCount(int count) {
            this.fileProgress.setMaximum(count);
        }

        public void setFilesProgress(int value) {
            this.filesProgress.setValue(value);
        }

        public void setFileProgress(int value) {
            this.fileProgress.setValue(value);
        }

        public void setFileName(String filename) {
            this.fileLabel.setText("File: " + filename);
        }

        public void setRemain(int count) {
            this.filesLabel.setText(String.valueOf(count) + " file(s) remaining to load.");
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SlideLoaderProgressBar.this.dispose();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SlideLoaderProgressBar.this.dispose();
        }
    }
}

