/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.GEOPlatformfileParser;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;
import org.tigr.util.swing.SOFTFileFilter;
import org.tigr.util.swing.TXTFileFilter;

public class SOFT_TwoChannelFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private SOFT_TwoChannelFileLoaderPanel softflp;
    private int dataType;
    private int data_row_count = 0;
    private int numOfSamplesinFile = 0;
    private Vector sampleNames = new Vector();
    private boolean loadEnable = false;
    private Vector rawLines = new Vector();
    private Hashtable platformMatrix = new Hashtable();
    private Vector platformHeaders = new Vector();
    private String[] moreFields = new String[0];
    private String[] fieldNames = new String[0];
    private MultipleArrayViewer mav;

    public SOFT_TwoChannelFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.softflp = new SOFT_TwoChannelFileLoaderPanel();
    }

    @Override
    public void setFilePath(String path) {
        this.softflp.setFileName(path);
        this.processSOFT_TwoChannelFile(new File(path));
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter affymetrixFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".soft") || f.getName().endsWith(".SOFT")) {
                    return true;
                }
                return f.getName().endsWith(".txt") || f.getName().endsWith(".TXT");
            }

            @Override
            public String getDescription() {
                return "GEO SOFT Two Channel Format Files (*.soft, *.txt)";
            }
        };
        return affymetrixFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.softflp.getXRow() + 1;
        int tableColumn = this.softflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.softflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public void markLoadEnabled(boolean state) {
        this.loadEnable = state;
        this.setLoadEnabled(this.loadEnable);
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.softflp;
    }

    @Override
    public String getFilePath() {
        return null;
    }

    @Override
    public ISlideData loadExpressionFile(File f) throws IOException {
        return null;
    }

    public Vector loadExpressionFiles() throws IOException {
        Vector data = new Vector();
        data = this.loadSOFT_AffyFile(new File(this.softflp.fileNameTextField.getText()));
        return data;
    }

    private Vector loadSOFT_AffyFile(File file) throws IOException {
        int i;
        this.setDataType(1);
        float[] intensities = new float[2];
        boolean rColumns = true;
        int totalRows = this.softflp.expressionTable.getRowCount();
        int totalColumns = this.softflp.expressionTable.getColumnCount();
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        int column = 1;
        int row = 1;
        int preSpotRows = this.softflp.getXRow();
        int preExperimentColumns = this.softflp.getXColumn();
        int spotCount = totalRows - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        if (this.platformMatrix.size() != 0) {
            this.moreFields = new String[this.platformHeaders.size()];
            this.fieldNames = new String[this.platformHeaders.size()];
            for (int m = 0; m < this.platformHeaders.size(); ++m) {
                this.fieldNames[m] = (String)this.platformHeaders.elementAt(m);
            }
        } else {
            this.moreFields = new String[preExperimentColumns];
            this.fieldNames = new String[preExperimentColumns];
            for (int i2 = 0; i2 < preExperimentColumns; ++i2) {
                this.fieldNames[i2] = "ID_REF";
            }
        }
        String[] extraFields = new String[1];
        ISlideData[] slideData = new ISlideData[this.sampleNames.size()];
        SlideDataElement sde = null;
        SampleAnnotation sampAnn = new SampleAnnotation();
        slideData[0] = new SlideData(spotCount, 1, sampAnn);
        slideData[0].setSlideFileName(file.getAbsolutePath());
        for (i = 1; i < slideData.length; ++i) {
            sampAnn = new SampleAnnotation();
            slideData[i] = new FloatSlideData(slideData[0].getSlideMetaData(), spotCount, sampAnn);
            slideData[i].setSlideFileName(file.getPath());
        }
        slideData[0].getSlideMetaData().appendFieldNames(this.fieldNames);
        for (i = 0; i < slideData.length; ++i) {
            slideData[i].setSampleAnnotationLoaded(true);
            slideData[i].getSampleAnnotation().setAnnotation("Default Slide Name", (String)this.sampleNames.get(i));
            slideData[i].setSlideDataName((String)this.sampleNames.get(i));
            this.mav.getData().setSampleAnnotationLoaded(true);
        }
        for (i = 0; i < spotCount; ++i) {
            String probeID = (String)this.softflp.expressionTable.getValueAt(i, 0);
            if (this.platformMatrix.size() != 0) {
                String Val = (String)this.platformMatrix.get(probeID);
                StringSplitter pSplit = new StringSplitter(':');
                pSplit.init(Val);
                for (int j = 0; j < this.platformHeaders.size(); ++j) {
                    if (!pSplit.hasMoreTokens()) continue;
                    this.moreFields[j] = pSplit.nextToken();
                }
            } else {
                for (int k = 0; k < preExperimentColumns; ++k) {
                    this.moreFields[k] = probeID;
                }
            }
            rows[0] = rows[2] = row++;
            columns[0] = columns[2] = column;
            column = column == 1 ? 1 : ++column;
            sde = new SlideDataElement(String.valueOf(i), rows, columns, new float[2], this.moreFields);
            slideData[0].addSlideDataElement(sde);
            int col = 1;
            for (int k = 0; k < slideData.length; ++k) {
                try {
                    intensities[0] = 1.0f;
                    intensities[1] = Float.parseFloat((String)this.softflp.expressionTable.getValueAt(i, col));
                }
                catch (Exception e) {
                    intensities[1] = Float.NaN;
                }
                slideData[k].setIntensities(i, intensities[0], intensities[1]);
                ++col;
            }
        }
        Vector<ISlideData> data = new Vector<ISlideData>();
        for (int i3 = 0; i3 < slideData.length; ++i3) {
            data.add(slideData[i3]);
        }
        return data;
    }

    public void processSOFT_TwoChannelFile(File targetFile) {
        Hashtable<String, String> dataMatrix = new Hashtable<String, String>();
        Vector<String> columnHeaders = null;
        Vector<String> Headers = new Vector<String>();
        Headers.add(0, "ID_REF");
        BufferedReader reader = null;
        String currentLine = null;
        int index = 0;
        this.softflp.setFileName(targetFile.getAbsolutePath());
        GEOPlatformfileParser parser = new GEOPlatformfileParser();
        this.platformMatrix = parser.parsePlatformData(targetFile);
        this.platformHeaders = parser.getColumnHeaders();
        try {
            reader = new BufferedReader(new FileReader(targetFile));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            StringSplitter split = new StringSplitter('=');
            while ((currentLine = reader.readLine()) != null && !currentLine.contains("^SERIES")) {
                if (currentLine.contains("^SAMPLE")) {
                    split.init(currentLine);
                    split.nextToken();
                    String sample = split.nextToken();
                    this.sampleNames.add(index, sample);
                    columnHeaders = new Vector<String>();
                    columnHeaders.clear();
                    columnHeaders.add(0, sample);
                }
                if (!currentLine.contains("sample_table_begin")) continue;
                int VALUEcolumnPosition = 0;
                int ID_REFcolumnPosition = 0;
                String colName = "";
                currentLine = reader.readLine();
                ss.init(currentLine);
                while (ss.hasMoreTokens()) {
                    columnHeaders.add(ss.nextToken());
                }
                for (int i = 0; i < columnHeaders.size(); ++i) {
                    colName = (String)columnHeaders.get(i);
                    if (colName.equalsIgnoreCase("VALUE")) {
                        VALUEcolumnPosition = i - 1;
                        String sample = (String)this.sampleNames.elementAt(index);
                        Headers.add(sample);
                    }
                    if (!(colName = (String)columnHeaders.get(i)).equalsIgnoreCase("ID_REF")) continue;
                    ID_REFcolumnPosition = i - 1;
                }
                while (!(currentLine = reader.readLine()).contains("sample_table_end")) {
                    ss.init(currentLine);
                    String key = null;
                    String value = null;
                    int i = 0;
                    while (i < columnHeaders.size()) {
                        if (i == ID_REFcolumnPosition) {
                            key = ss.nextToken();
                            ++i;
                        }
                        if (ss.hasMoreTokens()) {
                            if (i == VALUEcolumnPosition) {
                                value = (String)this.sampleNames.elementAt(this.sampleNames.size() - 1);
                                value = value.concat(":");
                                value = value.concat(ss.nextToken());
                                ++i;
                                continue;
                            }
                            ss.nextToken();
                            ++i;
                            continue;
                        }
                        ++i;
                    }
                    if (!dataMatrix.containsKey(key)) {
                        dataMatrix.put(key, value);
                        continue;
                    }
                    String val = (String)dataMatrix.get(key);
                    val = val.concat(":");
                    val = val.concat(value);
                    dataMatrix.put(key, val);
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.generateExpressionTable(dataMatrix, Headers);
    }

    public void generateExpressionTable(Hashtable dataMatrix, Vector Headers) {
        Enumeration eKeys = dataMatrix.keys();
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.setColumnIdentifiers(Headers);
        while (eKeys.hasMoreElements()) {
            Vector<String> rowVector = new Vector<String>();
            StringSplitter split = new StringSplitter(':');
            String key = (String)eKeys.nextElement();
            String value = (String)dataMatrix.get(key);
            String sName = "";
            rowVector.add(key);
            split.init(value);
            for (int i = 0; i < this.sampleNames.size(); ++i) {
                if (split.hasMoreTokens()) {
                    sName = split.nextToken();
                }
                if (sName.equalsIgnoreCase((String)this.sampleNames.elementAt(i))) {
                    try {
                        rowVector.add(split.nextToken());
                    }
                    catch (Exception e) {
                        rowVector.add("");
                    }
                    continue;
                }
                String eMsg = "<html>The following probes are missing from some samples<br><html>Probes:<br> " + key + "<html>Sample<br>" + sName + " </html>";
                JOptionPane.showMessageDialog(null, eMsg, "Error", 0);
            }
            model.addRow(rowVector);
        }
        this.softflp.setTableModel(model);
    }

    private boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public void openDataPath() {
    }

    public void setDataType(int data_Type) {
        this.dataType = data_Type;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public String getAnnotationFilePath() {
        return null;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    private class SOFT_TwoChannelFileLoaderPanel
    extends JPanel {
        JPanel fileLoaderPanel;
        JPanel fileSelectionPanel;
        JLabel dataSelection;
        JTextField fileNameTextField;
        JButton browseButton1;
        JLabel fileSelectionLabel;
        JTextField selectedFiles;
        JPanel tablePanel;
        JTable expressionTable;
        JScrollPane tableScrollPane;
        JLabel instructionsLabel;
        private int xRow = -1;
        private int xColumn = -1;

        public SOFT_TwoChannelFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.fileSelectionLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select expression data file</html>";
            this.dataSelection.setText(chooseFile);
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(new EventHandler());
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (GEO SOFT Two Channel Format Files) "));
            SOFT_TwoChannelFileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_TwoChannelFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_TwoChannelFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_TwoChannelFileLoader.this.gba.add(this.fileSelectionPanel, this.fileSelectionLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_TwoChannelFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedFiles, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.expressionTable = new JTable();
            this.expressionTable.setDefaultRenderer(Object.class, new ExpressionFileTableCellRenderer());
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(true);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    SOFT_TwoChannelFileLoaderPanel.this.xRow = SOFT_TwoChannelFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint());
                    SOFT_TwoChannelFileLoaderPanel.this.xColumn = SOFT_TwoChannelFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint());
                    SOFT_TwoChannelFileLoader.this.checkLoadEnable();
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            SOFT_TwoChannelFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_TwoChannelFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            SOFT_TwoChannelFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_TwoChannelFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 7, 1, 6, 3, 6, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_TwoChannelFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void openDataPath() {
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void selectSOFT_TwoChannelFile() {
            JFileChooser jfc = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            jfc.addChoosableFileFilter((FileFilter)new TXTFileFilter());
            jfc.addChoosableFileFilter((FileFilter)new SOFTFileFilter());
            int activityCode = jfc.showOpenDialog(this);
            if (activityCode == 0) {
                File target = jfc.getSelectedFile();
                SOFT_TwoChannelFileLoader.this.processSOFT_TwoChannelFile(target);
            }
        }

        public void setFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
            this.selectedFiles.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String fieldsText) {
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            @Override
            public void nodeSelected(FileTreePaneEvent event) {
            }

            @Override
            public void nodeCollapsed(FileTreePaneEvent event) {
            }

            @Override
            public void nodeExpanded(FileTreePaneEvent event) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == SOFT_TwoChannelFileLoaderPanel.this.browseButton1) {
                    SOFT_TwoChannelFileLoaderPanel.this.selectSOFT_TwoChannelFile();
                }
            }
        }

        private class ListListener
        implements ListSelectionListener {
            private ListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent lse) {
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return null;
            }
        }
    }
}

