/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.GEOPlatformfileParser;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;
import org.tigr.util.swing.SOFTFileFilter;
import org.tigr.util.swing.TXTFileFilter;

public class SOFT_AffymetrixFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private SOFT_AffymetrixFileLoaderPanel softflp;
    private int dataType;
    private String[] fieldNames = new String[0];
    private String[] moreFields = new String[0];
    private int data_row_count = 0;
    private int numOfSamplesinFile = 0;
    private Vector sampleNames = new Vector();
    private boolean loadEnable = false;
    private Vector rawLines = new Vector();
    private Hashtable platformMatrix = new Hashtable();
    private Vector platformHeaders = new Vector();
    private boolean IntensitywithDetection = false;
    private boolean OnlyIntensity = false;
    private MultipleArrayViewer mav;

    public SOFT_AffymetrixFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.softflp = new SOFT_AffymetrixFileLoaderPanel();
    }

    @Override
    public void setFilePath(String path) {
        this.softflp.setFileName(path);
        this.processSOFT_AffymetrixFile(new File(path));
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter affymetrixFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".soft") || f.getName().endsWith(".SOFT")) {
                    return true;
                }
                return f.getName().endsWith(".txt") || f.getName().endsWith(".TXT");
            }

            @Override
            public String getDescription() {
                return "GEO SOFT Affymetrix Format Files (*.soft, *.txt)";
            }
        };
        return affymetrixFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.softflp.getXRow() + 1;
        int tableColumn = this.softflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.softflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public void markLoadEnabled(boolean state) {
        this.loadEnable = state;
        this.setLoadEnabled(this.loadEnable);
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.softflp;
    }

    @Override
    public String getFilePath() {
        return null;
    }

    @Override
    public ISlideData loadExpressionFile(File f) throws IOException {
        return null;
    }

    public Vector loadExpressionFiles() throws IOException {
        Vector data = new Vector();
        data = this.loadSOFT_AffyFile(new File(this.softflp.fileNameTextField.getText()));
        return data;
    }

    private Vector loadSOFT_AffyFile(File file) throws IOException {
        int i;
        this.setDataType(2);
        float[] intensities = new float[2];
        boolean rColumns = true;
        int totalRows = this.softflp.expressionTable.getRowCount();
        int totalColumns = this.softflp.expressionTable.getColumnCount();
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        int column = 1;
        int row = 1;
        int preSpotRows = this.softflp.getXRow();
        int preExperimentColumns = this.softflp.getXColumn();
        int spotCount = totalRows - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        if (this.platformMatrix != null) {
            this.moreFields = new String[this.platformHeaders.size()];
            this.fieldNames = new String[this.platformHeaders.size()];
            for (int m = 0; m < this.platformHeaders.size(); ++m) {
                this.fieldNames[m] = (String)this.platformHeaders.elementAt(m);
            }
        } else {
            this.moreFields = new String[1];
            this.fieldNames = new String[1];
            this.fieldNames[0] = "ID_REF";
        }
        String[] extraFields = new String[1];
        ISlideData[] slideData = new ISlideData[this.sampleNames.size()];
        AffySlideDataElement affysde = null;
        SampleAnnotation sampAnn = new SampleAnnotation();
        slideData[0] = new SlideData(spotCount, 1, sampAnn);
        slideData[0].setSlideFileName(file.getAbsolutePath());
        for (i = 1; i < slideData.length; ++i) {
            sampAnn = new SampleAnnotation();
            slideData[i] = new FloatSlideData(slideData[0].getSlideMetaData(), spotCount, sampAnn);
            slideData[i].setSlideFileName(file.getPath());
        }
        slideData[0].getSlideMetaData().appendFieldNames(this.fieldNames);
        for (i = 0; i < slideData.length; ++i) {
            slideData[i].setSampleAnnotationLoaded(true);
            slideData[i].getSampleAnnotation().setAnnotation("Default Slide Name", (String)this.sampleNames.get(i));
            slideData[i].setSlideDataName((String)this.sampleNames.get(i));
            this.mav.getData().setSampleAnnotationLoaded(true);
        }
        for (i = 0; i < spotCount; ++i) {
            String probeID = (String)this.softflp.expressionTable.getValueAt(i, 0);
            if (this.platformMatrix != null) {
                String Val = (String)this.platformMatrix.get(probeID);
                StringSplitter pSplit = new StringSplitter(':');
                pSplit.init(Val);
                this.moreFields[0] = probeID;
                for (int j = 1; j < this.platformHeaders.size(); ++j) {
                    if (!pSplit.hasMoreTokens()) continue;
                    this.moreFields[j] = pSplit.nextToken();
                }
            } else {
                this.moreFields[0] = probeID;
            }
            rows[0] = rows[2] = row++;
            columns[0] = columns[2] = column;
            column = column == 1 ? 1 : ++column;
            affysde = new AffySlideDataElement(String.valueOf(i), rows, columns, new float[2], this.moreFields);
            slideData[0].addSlideDataElement(affysde);
            int col = 1;
            for (int k = 0; k < slideData.length; ++k) {
                try {
                    intensities[0] = 1.0f;
                    intensities[1] = Float.parseFloat((String)this.softflp.expressionTable.getValueAt(i, col));
                    if (this.IntensitywithDetection) {
                        extraFields[0] = (String)this.softflp.expressionTable.getValueAt(i, col + 1);
                    }
                }
                catch (Exception e) {
                    intensities[1] = Float.NaN;
                }
                if (k == 0) {
                    slideData[k].setIntensities(i, intensities[0], intensities[1]);
                    if (this.IntensitywithDetection) {
                        affysde.setDetection(extraFields[0]);
                    }
                } else {
                    if (i == 1) {
                        this.meta = slideData[0].getSlideMetaData();
                    }
                    slideData[k].setIntensities(i, intensities[0], intensities[1]);
                    if (this.IntensitywithDetection) {
                        ((FloatSlideData)slideData[k]).setDetection(i, extraFields[0]);
                    }
                }
                if (this.IntensitywithDetection) {
                    col += 2;
                    continue;
                }
                ++col;
            }
        }
        Vector<ISlideData> data = new Vector<ISlideData>();
        for (int i2 = 0; i2 < slideData.length; ++i2) {
            data.add(slideData[i2]);
        }
        return data;
    }

    public void processSOFT_AffymetrixFile(File targetFile) {
        Hashtable<String, String> dataMatrix = new Hashtable<String, String>();
        Vector<String> _tempcolumnHeaders = null;
        Vector<String> eTableHeaders = new Vector<String>();
        eTableHeaders.add(0, "ID_REF");
        BufferedReader reader = null;
        String currentLine = null;
        int index = 0;
        this.softflp.setFileName(targetFile.getName());
        GEOPlatformfileParser parser = new GEOPlatformfileParser();
        this.platformMatrix = parser.parsePlatformData(targetFile);
        this.platformHeaders = parser.getColumnHeaders();
        try {
            reader = new BufferedReader(new FileReader(targetFile));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            StringSplitter split = new StringSplitter('=');
            while ((currentLine = reader.readLine()) != null && !currentLine.contains("^SERIES")) {
                if (currentLine.contains("^SAMPLE")) {
                    split.init(currentLine);
                    split.nextToken();
                    String sample = split.nextToken();
                    this.sampleNames.add(index, sample);
                    _tempcolumnHeaders = new Vector<String>();
                    _tempcolumnHeaders.clear();
                    _tempcolumnHeaders.add(0, sample);
                }
                if (!currentLine.contains("sample_table_begin")) continue;
                int VALUEcolumnPosition = 0;
                int ID_REFcolumnPosition = 0;
                int ABS_CALLcolumnPosition = 0;
                String colName = "";
                currentLine = reader.readLine();
                ss.init(currentLine);
                while (ss.hasMoreTokens()) {
                    _tempcolumnHeaders.add(ss.nextToken());
                }
                for (int i = 0; i < _tempcolumnHeaders.size(); ++i) {
                    colName = (String)_tempcolumnHeaders.get(i);
                    if (colName.equalsIgnoreCase("VALUE")) {
                        VALUEcolumnPosition = i - 1;
                        String sample = (String)this.sampleNames.elementAt(index);
                        eTableHeaders.add(sample);
                    }
                    if ((colName = (String)_tempcolumnHeaders.get(i)).equalsIgnoreCase("ID_REF")) {
                        ID_REFcolumnPosition = i - 1;
                    }
                    if (!(colName = (String)_tempcolumnHeaders.get(i)).equalsIgnoreCase("ABS_CALL")) continue;
                    ABS_CALLcolumnPosition = i - 1;
                    eTableHeaders.add((String)_tempcolumnHeaders.get(i));
                    this.IntensitywithDetection = true;
                }
                if (!this.IntensitywithDetection) {
                    this.OnlyIntensity = true;
                }
                while (!(currentLine = reader.readLine()).contains("sample_table_end")) {
                    ss.init(currentLine);
                    String key = null;
                    String value = null;
                    int i = 0;
                    while (i < _tempcolumnHeaders.size()) {
                        if (i == ID_REFcolumnPosition) {
                            key = ss.nextToken();
                            ++i;
                        }
                        if (ss.hasMoreTokens()) {
                            if (this.OnlyIntensity) {
                                if (i == VALUEcolumnPosition) {
                                    value = (String)this.sampleNames.elementAt(this.sampleNames.size() - 1);
                                    value = value.concat(":");
                                    value = value.concat(ss.nextToken());
                                    ++i;
                                    continue;
                                }
                                ss.nextToken();
                                ++i;
                                continue;
                            }
                            if (!this.IntensitywithDetection) continue;
                            if (i == VALUEcolumnPosition) {
                                value = (String)this.sampleNames.elementAt(this.sampleNames.size() - 1);
                                value = value.concat(":");
                                value = value.concat(ss.nextToken());
                                value = value.concat(":");
                                ++i;
                                continue;
                            }
                            if (i == ABS_CALLcolumnPosition) {
                                value = value.concat(ss.nextToken());
                                ++i;
                                continue;
                            }
                            ss.nextToken();
                            ++i;
                            continue;
                        }
                        ++i;
                    }
                    if (!dataMatrix.containsKey(key)) {
                        dataMatrix.put(key, value);
                        continue;
                    }
                    String val = (String)dataMatrix.get(key);
                    val = val.concat(":");
                    val = val.concat(value);
                    dataMatrix.put(key, val);
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.generateExpressionTable(dataMatrix, eTableHeaders);
    }

    public void generateExpressionTable(Hashtable dataMatrix, Vector Headers) {
        Enumeration eKeys = dataMatrix.keys();
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.setColumnIdentifiers(Headers);
        while (eKeys.hasMoreElements()) {
            Vector<String> rowVector = new Vector<String>();
            StringSplitter split = new StringSplitter(':');
            String key = (String)eKeys.nextElement();
            String value = (String)dataMatrix.get(key);
            String sName = "";
            rowVector.add(key);
            split.init(value);
            for (int i = 0; i < this.sampleNames.size(); ++i) {
                String eMsg;
                if (split.hasMoreTokens()) {
                    sName = split.nextToken();
                }
                if (this.IntensitywithDetection) {
                    if (sName.equalsIgnoreCase((String)this.sampleNames.elementAt(i))) {
                        try {
                            rowVector.add(split.nextToken());
                            rowVector.add(split.nextToken());
                        }
                        catch (Exception e) {
                            rowVector.add("");
                            rowVector.add("NA");
                        }
                        continue;
                    }
                    eMsg = "<html>The following probes are missing from some samples<br><html>Probes: " + key + "<br>" + "<html>Sample: " + sName + "<br>" + " </html>";
                    JOptionPane.showMessageDialog(null, eMsg, "Error", 0);
                    continue;
                }
                if (!this.OnlyIntensity) continue;
                if (sName.equalsIgnoreCase((String)this.sampleNames.elementAt(i))) {
                    try {
                        rowVector.add(split.nextToken());
                    }
                    catch (Exception e) {
                        rowVector.add("");
                    }
                    continue;
                }
                eMsg = "<html>The following probes are missing from some samples<br><html>Probes: " + key + "<br>" + "<html>Sample: " + sName + "<br>" + " </html>";
                JOptionPane.showMessageDialog(null, eMsg, "Error", 0);
            }
            model.addRow(rowVector);
        }
        this.softflp.setTableModel(model);
    }

    private boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public void openDataPath() {
    }

    public void setDataType(int data_Type) {
        this.dataType = data_Type;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public String getAnnotationFilePath() {
        return null;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    private class SOFT_AffymetrixFileLoaderPanel
    extends JPanel {
        JPanel fileLoaderPanel;
        JPanel fileSelectionPanel;
        JLabel dataSelection;
        JTextField fileNameTextField;
        JButton browseButton1;
        JLabel fileSelectionLabel;
        JTextField selectedFiles;
        JPanel additionalRequirementPanel;
        ButtonGroup optionsButtonGroup;
        JRadioButton onlyIntensityRadioButton;
        JRadioButton intensityWithDetectionRadioButton;
        JPanel tablePanel;
        JTable expressionTable;
        JScrollPane tableScrollPane;
        private int xRow = -1;
        private int xColumn = -1;

        public SOFT_AffymetrixFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.fileSelectionLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select expression data file</html>";
            this.dataSelection.setText(chooseFile);
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(new EventHandler());
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (GEO GPL Family Format Files *Affymetrix*)"));
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileSelectionPanel, this.fileSelectionLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedFiles, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.expressionTable = new JTable();
            this.expressionTable.setDefaultRenderer(Object.class, new ExpressionFileTableCellRenderer());
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setSize(300, 300);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(true);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    SOFT_AffymetrixFileLoaderPanel.this.xRow = SOFT_AffymetrixFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint());
                    SOFT_AffymetrixFileLoaderPanel.this.xColumn = SOFT_AffymetrixFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint());
                    SOFT_AffymetrixFileLoader.this.checkLoadEnable();
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            SOFT_AffymetrixFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 7, 1, 6, 3, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 4, 1, 6, 3, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            SOFT_AffymetrixFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void openDataPath() {
        }

        public void onBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.addChoosableFileFilter((FileFilter)new TXTFileFilter());
            fileChooser.addChoosableFileFilter((FileFilter)new SOFTFileFilter());
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                ((SOFT_AffymetrixFileLoader)SOFT_AffymetrixFileLoader.this).softflp.fileNameTextField.setText(selectedFile.getAbsolutePath());
                ((SOFT_AffymetrixFileLoader)SOFT_AffymetrixFileLoader.this).softflp.selectedFiles.setText(selectedFile.getAbsolutePath());
                SOFT_AffymetrixFileLoader.this.processSOFT_AffymetrixFile(selectedFile);
            }
        }

        public void setFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == SOFT_AffymetrixFileLoaderPanel.this.browseButton1) {
                    SOFT_AffymetrixFileLoaderPanel.this.onBrowse();
                }
            }
        }
    }
}

