/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.IRNASeqSlide;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.RNASeqChipAnnotation;
import org.tigr.microarray.mev.RNASeqElement;
import org.tigr.microarray.mev.RNASeqFloatSlideData;
import org.tigr.microarray.mev.RNASeqSlideData;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.annotation.RnaseqAnnotationParser;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;

public class RNASeqFileLoader
extends ExpressionFileLoader {
    private static final long serialVersionUID = 1L;
    private GBA gba;
    private int dataType = 6;
    private boolean loadEnabled = false;
    private boolean stop = false;
    private RnaSeqFileLoaderPanel sflp;
    ExpressionFileTableCellRenderer myCellRenderer;
    protected String[] moreFields = new String[0];
    private IRNASeqSlide[] slideDataArray = null;
    private ISlideDataElement sde;
    private Hashtable<String, ArrayList<MevAnnotation>> _tempAnno = new Hashtable();
    private MultipleArrayViewer mav;
    private final int UID = 0;
    private final int LOCUS = 1;
    private final int REF_ID = 2;
    private final int STATUS = 3;
    private final int TRANSCRIPT_LEN = 4;
    private final int DATA_START = 5;
    private final int UNDEF = 0;
    private final int RPKM = 1;
    private final int COUNT = 2;
    private final int RPKM_AND_COUNT = 3;
    private final int FPKM_AND_COUNT = 4;
    private String[] dataTypes = new String[5];

    @Override
    public void setFilePath(String path) {
        this.sflp.setFileName(path);
        this.processStanfordFile(new File(path));
    }

    public RNASeqFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.getClass();
        this.dataTypes[0] = "Select";
        this.getClass();
        this.dataTypes[1] = "RPKM";
        this.getClass();
        this.dataTypes[2] = "Count";
        this.getClass();
        this.dataTypes[3] = "RPKM & Count";
        this.getClass();
        this.dataTypes[4] = "FPKM & Count";
        this.gba = new GBA();
        this.sflp = new RnaSeqFileLoaderPanel();
    }

    public Vector<ISlideData> loadStanfordExpressionFile(File f) throws IOException {
        int selectedPreSpotRows = this.sflp.getXRow() + 1;
        int selectedPreExperimentColumns = this.sflp.getXColumn();
        return this.loadStanfordExpressionFile(f, selectedPreSpotRows, selectedPreExperimentColumns);
    }

    @Override
    public Vector<ISlideData> loadExpressionFiles() throws IOException {
        if (this.sflp.getXColumn() == 0) {
            JOptionPane.showMessageDialog(null, "The selected file has no gene annotation and cannot be loaded. \n\nPlease make sure you have selected an EXPRESSION value in the file loader table.\nThe 1st column cannot contain expression values.", "Missing Annotation Error", 0, null);
            return null;
        }
        return this.loadStanfordExpressionFile(new File(this.sflp.fileNameTextField.getText()), this.sflp.getXRow() + 1, this.sflp.getXColumn());
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    @Override
    public boolean canAutoLoad(File f) {
        return true;
    }

    public Vector<ISlideData> loadStanfordExpressionFile(File f, int rowcoord, int colcoord) throws IOException {
        String currentLine;
        int preSpotRows = rowcoord;
        int preExperimentColumns = colcoord;
        int numLines = this.getCountOfLines(f);
        int spotCount = numLines - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this, "There is no spot data available.", "TDMS Load Error", 1);
            return null;
        }
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        this.moreFields = new String[preExperimentColumns];
        boolean rColumns = true;
        int rRows = spotCount;
        int dataFormat = this.sflp.getSelectedDataFormat();
        try {
            this.validateDataFormat(f, dataFormat, preExperimentColumns, preSpotRows);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, e1.getMessage() + "\nInvalid File format for data type " + dataFormat, "Bad Format Error", 1);
            return null;
        }
        int notFoundCtr = 0;
        Hashtable<String, Integer> libSizeTable = null;
        if (this.sflp.libSizeIsNeeded()) {
            libSizeTable = this.loadLibSize(this.sflp.getLibrarySizeFile());
            if (libSizeTable == null) {
                JOptionPane.showMessageDialog(null, "Library File not selected or does not exist.", "Library File Error", 1);
                return null;
            }
        } else {
            libSizeTable = this.calculateLibSize(dataFormat, f, preExperimentColumns, preSpotRows);
        }
        RnaseqAnnotationParser rnaseqAnnoParser = this.sflp.annoCheck.isSelected() ? RnaseqAnnotationParser.createAnnotationFileParser(new File(this.getAnnotationFile())) : RnaseqAnnotationParser.createAnnotationFileParser(new File(this.getPathFromSpeciesAndGenome()));
        this._tempAnno = rnaseqAnnoParser.getAnnotation();
        if (this.sflp.annoCheck.isSelected()) {
            this.chipAnno.setChipName("-");
            this.chipAnno.setChipType("-");
            this.chipAnno.setDataType("RNASeq");
            this.chipAnno.setGenomeBuild("-");
            this.chipAnno.setSpeciesName("-");
        } else {
            this.chipAnno.setChipName(this.sflp.getGenome() + "_" + this.sflp.getSpecies());
            this.chipAnno.setChipType(this.sflp.getGenome() + "_" + this.sflp.getSpecies());
            this.chipAnno.setDataType("RNASeq");
            this.chipAnno.setGenomeBuild(this.sflp.getBuild());
            this.chipAnno.setSpeciesName(this.sflp.getSpecies());
        }
        ((RNASeqChipAnnotation)this.chipAnno).setReadLength(100);
        this.mav.getData().setAnnotationLoaded(true);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        int column = 1;
        int row = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(numLines);
        this.setFileProgress(0);
        while ((currentLine = reader.readLine()) != null) {
            try {
                if (this.stop) {
                    return null;
                }
                while (currentLine.endsWith("\t")) {
                    currentLine = currentLine.substring(0, currentLine.length() - 1);
                }
                ss.init(currentLine);
                if (counter == 0) {
                    int i;
                    int experimentCount = dataFormat == 3 || dataFormat == 4 ? (ss.countTokens() + 1 - preExperimentColumns) / 2 : ss.countTokens() + 1 - preExperimentColumns;
                    SampleAnnotation sampAnn = new SampleAnnotation();
                    this.slideDataArray = new IRNASeqSlide[experimentCount];
                    this.slideDataArray[0] = new RNASeqSlideData(rRows, 1, sampAnn);
                    this.slideDataArray[0].setSlideFileName(f.getPath());
                    for (int i2 = 1; i2 < this.slideDataArray.length; ++i2) {
                        sampAnn = new SampleAnnotation();
                        this.slideDataArray[i2] = new RNASeqFloatSlideData(this.slideDataArray[0].getSlideMetaData(), spotCount, sampAnn);
                        this.slideDataArray[i2].setSlideFileName(f.getPath());
                    }
                    String[] fieldNames = new String[preExperimentColumns];
                    for (i = 0; i < preExperimentColumns; ++i) {
                        fieldNames[i] = ss.nextToken();
                    }
                    this.slideDataArray[0].getSlideMetaData().setFieldNames(fieldNames);
                    for (i = 0; i < experimentCount; ++i) {
                        String val = ss.nextToken();
                        this.slideDataArray[i].setSampleAnnotationLoaded(true);
                        this.slideDataArray[i].getSampleAnnotation().setAnnotation("Default Slide Name", val);
                        this.slideDataArray[i].setSlideDataName(val);
                        if (dataFormat == 3 || dataFormat == 4) {
                            ss.nextToken();
                        }
                        this.mav.getData().setSampleAnnotationLoaded(true);
                    }
                } else if (counter >= preSpotRows) {
                    rows[0] = rows[2] = row++;
                    columns[0] = columns[2] = column;
                    column = column == 1 ? 1 : ++column;
                    for (int i = 0; i < preExperimentColumns; ++i) {
                        this.moreFields[i] = ss.nextToken();
                    }
                    this.getClass();
                    String cloneName = this.moreFields[2];
                    this.getClass();
                    Vector<String> locusInfo = this.parserLocus(this.moreFields[1]);
                    MevAnnotation mevAnno = null;
                    if (this._tempAnno.size() != 0) {
                        ArrayList<MevAnnotation> annoObjList = this._tempAnno.get(cloneName);
                        if (annoObjList == null) {
                            ++notFoundCtr;
                            mevAnno = new MevAnnotation();
                        } else {
                            MevAnnotation _tmpA;
                            mevAnno = _tmpA = (MevAnnotation)annoObjList.get(0).clone();
                            this.getClass();
                            mevAnno.setCloneID(this.moreFields[0]);
                        }
                        this.getClass();
                        mevAnno.setCloneID(this.moreFields[0]);
                        mevAnno.setProbeChromosome(locusInfo.get(0));
                        mevAnno.setProbeTxStartBP(locusInfo.get(1));
                        mevAnno.setProbeTxEndBP(locusInfo.get(2));
                        int givenLen = Integer.parseInt(locusInfo.get(2)) - Integer.parseInt(locusInfo.get(1));
                    }
                    this.sde = new RNASeqElement(String.valueOf(row + 1), rows, columns, new float[2], this.moreFields, mevAnno);
                    RNASeqElement rNASeqElement = (RNASeqElement)this.sde;
                    this.getClass();
                    rNASeqElement.setClasscode(this.moreFields[3]);
                    int len = 0;
                    try {
                        len = mevAnno.getProbeTxLengthInBP();
                    }
                    catch (Exception c) {
                        if (mevAnno == null) {
                            System.out.println("mevAnno is NULL");
                        }
                        return null;
                    }
                    this.getClass();
                    if (this.moreFields[4].trim().length() == 0) {
                        ((RNASeqElement)this.sde).setTranscriptLength(len);
                    } else {
                        try {
                            RNASeqElement rNASeqElement2 = (RNASeqElement)this.sde;
                            this.getClass();
                            rNASeqElement2.setTranscriptLength(Integer.parseInt(this.moreFields[4]));
                        }
                        catch (NumberFormatException e) {
                            ((RNASeqElement)this.sde).setTranscriptLength(len);
                        }
                    }
                    this.slideDataArray[0].addSlideDataElement(this.sde);
                    for (int i = 0; i < this.slideDataArray.length; ++i) {
                        float cy3 = 1.0f;
                        float cy5 = 1.0f;
                        int count = 0;
                        String sample = this.slideDataArray[i].getSlideDataName();
                        int libSize = libSizeTable.get(sample);
                        this.slideDataArray[i].setLibrarySize(libSize);
                        try {
                            String value = ss.nextToken();
                            switch (dataFormat) {
                                case 0: {
                                    return null;
                                }
                                case 1: {
                                    cy5 = Float.parseFloat(value);
                                    if (cy5 == 0.0f || cy5 == 0.0f) {
                                        count = 0;
                                        break;
                                    }
                                    len = ((RNASeqElement)this.sde).getTranscriptLength();
                                    count = (int)((double)(cy5 * (float)libSize * (float)len) / Math.pow(10.0, 9.0));
                                    break;
                                }
                                case 2: {
                                    count = Integer.parseInt(value);
                                    if (count == 0) {
                                        cy5 = 0.0f;
                                        break;
                                    }
                                    len = ((RNASeqElement)this.sde).getTranscriptLength();
                                    cy5 = (float)(Math.pow(10.0, 9.0) * (double)count) / ((float)libSize * (float)len);
                                    break;
                                }
                                case 3: {
                                    cy5 = Float.parseFloat(value);
                                    count = Integer.parseInt(ss.nextToken());
                                    break;
                                }
                                case 4: {
                                    cy5 = Float.parseFloat(value);
                                    count = Integer.parseInt(ss.nextToken());
                                }
                            }
                        }
                        catch (Exception e) {
                            cy3 = 0.0f;
                            cy5 = 0.0f;
                            count = 0;
                        }
                        this.slideDataArray[i].setIntensities(counter - preSpotRows, cy3, cy5);
                        this.slideDataArray[i].setCount(counter - preSpotRows, count);
                    }
                } else {
                    for (int i = 0; i < preExperimentColumns - 1; ++i) {
                        ss.nextToken();
                    }
                    String key = ss.nextToken();
                    for (int j = 0; j < this.slideDataArray.length; ++j) {
                        if (this.slideDataArray[j].getSampleAnnotation() != null) {
                            String val = ss.nextToken();
                            this.slideDataArray[j].getSampleAnnotation().setAnnotation(key, val);
                            continue;
                        }
                        SampleAnnotation sampAnn = new SampleAnnotation();
                        sampAnn.setAnnotation(key, ss.nextToken());
                        this.slideDataArray[j].setSampleAnnotation(sampAnn);
                        this.slideDataArray[j].setSampleAnnotationLoaded(true);
                    }
                }
                this.setFileProgress(counter);
                ++counter;
            }
            catch (NoSuchElementException nsee) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        reader.close();
        Vector<ISlideData> data = new Vector<ISlideData>(this.slideDataArray.length);
        for (int i = 0; i < this.slideDataArray.length; ++i) {
            data.add(this.slideDataArray[i]);
        }
        this.setFilesProgress(1);
        this._tempAnno.clear();
        this._tempAnno = null;
        return data;
    }

    private void validateDataFormat(File f, int dataFormat, int preExperimentColumns, int preSpotRows) throws Exception {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        String[] sampleNames = null;
        int experimentCount = 0;
        int counter = 0;
        while ((currentLine = reader.readLine()) != null) {
            int i;
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            if (counter == 0) {
                experimentCount = dataFormat == 3 || dataFormat == 4 ? (ss.countTokens() + 1 - preExperimentColumns) / 2 : ss.countTokens() + 1 - preExperimentColumns;
                for (i = 0; i < preExperimentColumns; ++i) {
                    ss.nextToken();
                }
                sampleNames = new String[experimentCount];
                for (i = 0; i < experimentCount; ++i) {
                    String curSampleName;
                    if (dataFormat == 3 || dataFormat == 4) {
                        String lastSampleName = ss.nextToken();
                        if (!lastSampleName.equals(curSampleName = ss.nextToken())) {
                            throw new Exception("Sample Names should match for adjacent Samples for this format." + lastSampleName + ", " + curSampleName);
                        }
                    } else {
                        curSampleName = ss.nextToken();
                    }
                    sampleNames[i] = curSampleName;
                }
            } else if (counter >= preSpotRows) {
                for (i = 0; i < preExperimentColumns; ++i) {
                    ss.nextToken();
                }
                for (int i2 = 0; i2 < experimentCount; ++i2) {
                    try {
                        switch (dataFormat) {
                            case 0: {
                                throw new Exception("Select valid format");
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                String tmp = ss.nextToken();
                                try {
                                    Integer.parseInt(tmp);
                                    break;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new Exception("Invalid data for COUNT format - " + tmp);
                                }
                            }
                            case 3: {
                                String tmp = ss.nextToken();
                                String tmp2 = ss.nextToken();
                                try {
                                    Float.parseFloat(tmp);
                                    Integer.parseInt(tmp2);
                                    break;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new Exception("Invalid data for RPKM AND COUNT format - " + tmp + " " + tmp2);
                                }
                            }
                            case 4: {
                                String tmp = ss.nextToken();
                                String tmp2 = ss.nextToken();
                                try {
                                    Float.parseFloat(tmp);
                                    Integer.parseInt(tmp2);
                                    break;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new Exception("Invalid data for RPKM AND COUNT format - " + tmp + " " + tmp2);
                                }
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
            }
            if (++counter <= 1000) continue;
        }
        reader.close();
    }

    private Hashtable<String, Integer> calculateLibSize(int dataFormat, File f, int preExperimentColumns, int preSpotRows) {
        int counter = 0;
        int experimentCount = 0;
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        String[] sampleNames = null;
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(f));
            StringSplitter ss = new StringSplitter('\t');
            while ((currentLine = reader.readLine()) != null) {
                int i;
                while (currentLine.endsWith("\t")) {
                    currentLine = currentLine.substring(0, currentLine.length() - 1);
                }
                ss.init(currentLine);
                if (counter == 0) {
                    experimentCount = dataFormat == 3 || dataFormat == 4 ? (ss.countTokens() + 1 - preExperimentColumns) / 2 : ss.countTokens() + 1 - preExperimentColumns;
                    for (i = 0; i < preExperimentColumns; ++i) {
                        ss.nextToken();
                    }
                    sampleNames = new String[experimentCount];
                    for (i = 0; i < experimentCount; ++i) {
                        if (dataFormat == 3 || dataFormat == 4) {
                            ss.nextToken();
                        }
                        String val = ss.nextToken();
                        table.put(val, new Integer(0));
                        sampleNames[i] = val;
                    }
                } else if (counter >= preSpotRows) {
                    for (i = 0; i < preExperimentColumns; ++i) {
                        ss.nextToken();
                    }
                    for (int i2 = 0; i2 < experimentCount; ++i2) {
                        try {
                            switch (dataFormat) {
                                case 0: 
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    Integer count = new Integer(ss.nextToken());
                                    count = count + table.get(sampleNames[i2]);
                                    table.put(sampleNames[i2], count);
                                    break;
                                }
                                case 3: {
                                    ss.nextToken();
                                    Integer count = new Integer(ss.nextToken());
                                    count = count + table.get(sampleNames[i2]);
                                    table.put(sampleNames[i2], count);
                                    break;
                                }
                                case 4: {
                                    ss.nextToken();
                                    Integer count = new Integer(ss.nextToken());
                                    count = count + table.get(sampleNames[i2]);
                                    table.put(sampleNames[i2], count);
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Integer n = new Integer(0);
                        }
                    }
                }
                ++counter;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }

    private Hashtable<String, Integer> loadLibSize(String librarySizeFile) {
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(librarySizeFile));
            Hashtable<String, Integer> table = new Hashtable<String, Integer>();
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.startsWith("#")) continue;
                String[] tmp = currentLine.split("\t");
                table.put(tmp[0], new Integer(tmp[1]));
            }
            reader.close();
            return table;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println(librarySizeFile + " Size Lib File does not exist.");
            JOptionPane.showMessageDialog(this, librarySizeFile + " File Not Found", "Library File Error.", 0);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, librarySizeFile + " File Error Reading", "Library File Error.", 64);
            return null;
        }
    }

    private Vector<String> parserLocus(String str) {
        Vector<String> temp = new Vector<String>(3);
        String[] t = str.split(":");
        String chr = t[0].substring(3);
        t = t[1].split("-");
        temp.add(chr);
        temp.add(t[0]);
        temp.add(t[1]);
        return temp;
    }

    private String getPathFromSpeciesAndGenome() {
        String path = "data/rnaseq/";
        path = this.sflp.getSpecies().equals("Human") ? path + "hg/" : (this.sflp.getSpecies().equals("Mouse") ? path + "mm/" : path + "null/");
        path = path + this.sflp.getBuild().toLowerCase() + "/" + this.sflp.getGenome().toLowerCase() + "/";
        String filename = this.sflp.getGenome().toLowerCase().substring(0, 3) + "_gene_" + this.sflp.getBuild().toLowerCase() + ".txt";
        return path + filename;
    }

    private String getAnnotationFile() {
        return this.sflp.annoTextField.getText();
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Tab Delimited, Multiple Sample Files (TDMS) (*.txt)";
            }
        };
        return mevFileFilter;
    }

    public void markLoadEnabled(boolean state) {
        this.loadEnabled = state;
        this.checkLoadEnable();
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.sflp.getXRow() + 1;
        int tableColumn = this.sflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.sflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.sflp;
    }

    public void processLibSizeFile(String fileName) {
        this.sflp.setLibSizeFileName(fileName);
    }

    public void processStanfordFile(File targetFile) {
        if (!this.validateFile(targetFile)) {
            return;
        }
        Vector<String> columnHeaders = new Vector<String>();
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        String currentLine = null;
        this.sflp.setFileName(targetFile.getAbsolutePath());
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        try {
            reader = new BufferedReader(new FileReader(targetFile), 131072);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            currentLine = reader.readLine();
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                columnHeaders.add(ss.nextToken());
            }
            model.setColumnIdentifiers(columnHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && cnt < 100) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i = 0; i < ss.countTokens() + 1; ++i) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.sflp.setTableModel(model);
        Point p = this.getFirstExpressionCell(dataVector);
        this.sflp.setSelectedCell(p.x, p.y);
    }

    @Override
    public String getFilePath() {
        return this.sflp.fileNameTextField.getText();
    }

    @Override
    public String getAnnotationFilePath() {
        return this.sflp.getAnnFilePath();
    }

    @Override
    public void openDataPath() {
    }

    public void setDataType(int data_Type) {
        this.dataType = data_Type != -1 ? data_Type : 1;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public boolean isAnnotationSelected() {
        return false;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    public boolean validateAnnoFile(String file) throws HeadlessException, IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        int i = 0;
        String _tmp = "";
        String expected_col_name = "OK";
        String[] COL_NAMES = new String[]{"PROBE_ID", "CHR", "STRAND", "TX_START", "TX_END", "CDS_START", "CDS_END", "exonCount", "exonStarts", "exonEnds", "GENE_SYMBOL", "GENE_TITLE", "REFSEQ_ACC", "PROTEIN_ACC", "ENTREZ_ID"};
        while ((currentLine = reader.readLine()) != null) {
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            if (counter == 0) {
                if (ss.countTokens() + 1 != COL_NAMES.length) {
                    while (ss.hasMoreTokens()) {
                        _tmp = _tmp + ss.nextToken() + ", ";
                    }
                    String exp_cols = "";
                    for (i = 0; i < COL_NAMES.length; ++i) {
                        exp_cols = exp_cols + COL_NAMES[i] + ", ";
                    }
                    JOptionPane.showMessageDialog(null, "Provided columns (" + String.valueOf(ss.countTokens()) + "): " + _tmp + "\n Expected columns (" + String.valueOf(COL_NAMES.length) + ") : " + exp_cols, "Annotation File Format Error.", 0);
                    reader.close();
                    return false;
                }
                while (ss.hasMoreTokens()) {
                    _tmp = ss.nextToken();
                    if (!_tmp.equals(COL_NAMES[i])) {
                        expected_col_name = COL_NAMES[i];
                        break;
                    }
                    ++i;
                }
            }
            if (!expected_col_name.equals("OK")) {
                JOptionPane.showMessageDialog(null, "Invalid Column at position " + String.valueOf(i + 1) + " : " + _tmp + "," + "\n Expected column : " + expected_col_name, "Annotation File Format Error.", 0);
                break;
            }
            if (counter > 20) break;
            ++counter;
        }
        reader.close();
        return expected_col_name.equals("OK");
    }

    public void setTCGADataFile(String string) {
        this.sflp.fileNameTextField.setText(string);
        File selectedFile = new File(string);
        this.sflp.dataTypeCombo.setSelectedItem("RPKM & Count");
        this.sflp.speciesCombo.setSelectedItem("Human");
        this.sflp.genomeCombo.setSelectedItem("RefSeq");
        this.sflp.bldCombo.setSelectedItem("hg19");
        this.processStanfordFile(selectedFile);
    }

    private class RnaSeqFileLoaderPanel
    extends JPanel {
        String[] species = new String[]{"Select", "Human", "Mouse"};
        String[] refGenome = new String[]{"Select", "RefSeq", "ENSEMBL"};
        String[] hgGenomeBlds = new String[]{"Select", "hg19", "hg18"};
        String[] mmGenomeBlds = new String[]{"Select", "mm9", "mm8"};
        JLabel dataTypeLabel;
        JLabel speciesLabel;
        JLabel genomeLabel;
        JLabel bldLabel;
        JLabel readLen;
        JTextField readLenBox;
        JComboBox dataTypeCombo;
        JComboBox speciesCombo;
        JComboBox genomeCombo;
        JComboBox bldCombo;
        boolean needSampleLibSize = false;
        boolean needCountAndExp = false;
        JPanel dataAttributesPanel;
        JTextField fileNameTextField;
        JTextField libSizeFileTextField;
        JTextField fieldsTextField;
        JTextField annoTextField;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel fileLoaderPanel;
        JSplitPane splitPane;
        JList availableList;
        JScrollPane availableScrollPane;
        private int xRow = -1;
        private int xColumn = -1;
        JPanel fileSelectionPanel;
        JLabel fileSelectionLabel;
        JLabel dataSelectionLabel;
        JLabel annoSelectionLabel;
        JButton browseButton1;
        JButton browseButton2;
        JButton browseButton3;
        JCheckBox annoCheck;
        protected EventListener eventListener = new EventListener();

        public RnaSeqFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.dataTypeCombo = new JComboBox<String>(RNASeqFileLoader.this.dataTypes);
            this.dataTypeCombo.addActionListener(this.eventListener);
            this.speciesCombo = new JComboBox<String>(this.species);
            this.speciesCombo.addActionListener(this.eventListener);
            this.genomeCombo = new JComboBox<String>(this.refGenome);
            this.bldCombo = new JComboBox();
            this.readLenBox = new JTextField();
            this.readLen = new JLabel("Read Length ");
            this.readLen.setForeground(Color.BLACK);
            this.dataTypeLabel = new JLabel("Data Type");
            this.dataTypeLabel.setForeground(Color.RED);
            this.speciesLabel = new JLabel("Species");
            this.speciesLabel.setForeground(Color.RED);
            this.genomeLabel = new JLabel("Reference Genome");
            this.genomeLabel.setForeground(Color.RED);
            this.bldLabel = new JLabel("UCSC Build");
            this.bldLabel.setForeground(Color.BLACK);
            this.annoCheck = new JCheckBox("Upload Annotation", false);
            this.annoCheck.addActionListener(this.eventListener);
            this.dataAttributesPanel = new JPanel();
            this.dataAttributesPanel.setLayout(new GridBagLayout());
            this.dataAttributesPanel.setBorder(new TitledBorder(new EtchedBorder(), "RNASeq Data Info"));
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.annoCheck, 0, 0, 1, 1, 0, 0, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.dataTypeLabel, 0, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.speciesLabel, 1, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.genomeLabel, 2, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.bldLabel, 3, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.readLen, 4, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 0, 1, 0), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.dataTypeCombo, 0, 2, 1, 1, 0, 0, 2, 10, new Insets(1, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.speciesCombo, 1, 2, 1, 1, 0, 0, 2, 10, new Insets(1, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.genomeCombo, 2, 2, 1, 1, 0, 0, 2, 10, new Insets(1, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.bldCombo, 3, 2, 1, 1, 0, 0, 2, 10, new Insets(1, 0, 1, 10), 0, 0);
            RNASeqFileLoader.this.gba.add(this.dataAttributesPanel, this.readLenBox, 4, 2, 1, 1, 0, 0, 2, 10, new Insets(1, 0, 1, 0), 0, 0);
            this.dataAttributesPanel.validate();
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.libSizeFileTextField = new JTextField();
            this.libSizeFileTextField.setEditable(false);
            this.libSizeFileTextField.setForeground(Color.black);
            this.libSizeFileTextField.setFont(new Font("monospaced", 1, 12));
            this.annoTextField = new JTextField();
            this.annoTextField.setEditable(false);
            this.annoTextField.setForeground(Color.black);
            this.annoTextField.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            this.fileSelectionLabel.setText("Library size file");
            this.dataSelectionLabel = new JLabel();
            this.dataSelectionLabel.setForeground(Color.RED);
            this.dataSelectionLabel.setText("RNASeq data file");
            this.annoSelectionLabel = new JLabel();
            this.annoSelectionLabel.setForeground(Color.BLACK);
            this.annoSelectionLabel.setText("Annotation data file");
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File(Tab Delimited Multiple Sample (*.*))"));
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(this.eventListener);
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.browseButton2 = new JButton("Browse");
            this.browseButton2.addActionListener(this.eventListener);
            this.browseButton2.setSize(100, 30);
            this.browseButton2.setPreferredSize(new Dimension(100, 30));
            this.browseButton3 = new JButton("Browse");
            this.browseButton3.addActionListener(this.eventListener);
            this.browseButton3.setSize(100, 30);
            this.browseButton3.setPreferredSize(new Dimension(100, 30));
            this.browseButton3.setEnabled(false);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelectionLabel, 0, 4, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 4, 1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 4, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.annoSelectionLabel, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.annoTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton3, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.fileSelectionLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.libSizeFileTextField, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton2, 2, 2, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.expressionTable = new JTable();
            RNASeqFileLoader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable.setDefaultRenderer(Object.class, RNASeqFileLoader.this.myCellRenderer);
            this.expressionTable.setIntercellSpacing(new Dimension(1, 1));
            this.expressionTable.setShowHorizontalLines(false);
            this.expressionTable.setShowVerticalLines(true);
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    RnaSeqFileLoaderPanel.this.setSelectedCell(RnaSeqFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), RnaSeqFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            RNASeqFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            RNASeqFileLoader.this.gba.add(this.fileLoaderPanel, this.dataAttributesPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 3, 1, 6, 3, 6, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            RNASeqFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.fileLoaderPanel.validate();
            RNASeqFileLoader.this.setDataType(6);
        }

        public boolean isAnnotationSelected() {
            return true;
        }

        public String getAnnFilePath() {
            return "no/way";
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            RNASeqFileLoader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            RNASeqFileLoader.this.checkLoadEnable();
        }

        public boolean onBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                RNASeqFileLoader.this.processStanfordFile(selectedFile);
                return true;
            }
            return false;
        }

        public boolean onBrowse2() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                RNASeqFileLoader.this.processLibSizeFile(fileChooser.getSelectedFile().getAbsolutePath());
                return true;
            }
            return false;
        }

        private boolean onBrowse3() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                try {
                    if (RNASeqFileLoader.this.validateAnnoFile(fileChooser.getSelectedFile().getAbsolutePath())) {
                        ((RNASeqFileLoader)RNASeqFileLoader.this).sflp.annoTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                        return true;
                    }
                }
                catch (HeadlessException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Error " + e.getMessage() + " \n occured while reading " + fileChooser.getSelectedFile().getAbsolutePath(), "Annotation File Error.", 0);
                    e.printStackTrace();
                }
            }
            return false;
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void setFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
        }

        public void setLibSizeFileName(String fileName) {
            this.libSizeFileTextField.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String fieldsText) {
        }

        protected String getLibrarySizeFile() {
            return this.libSizeFileTextField.getText();
        }

        public boolean libSizeIsNeeded() {
            return this.needSampleLibSize;
        }

        public boolean needBothCntAndExp() {
            return this.needCountAndExp;
        }

        public String getSpecies() {
            return (String)this.speciesCombo.getSelectedItem();
        }

        public String getBuild() {
            if (((String)this.bldCombo.getSelectedItem()).equals("Select")) {
                if (this.getSpecies().equals(this.species[1])) {
                    return this.hgGenomeBlds[1];
                }
                return this.mmGenomeBlds[1];
            }
            return (String)this.bldCombo.getSelectedItem();
        }

        public String getGenome() {
            return (String)this.genomeCombo.getSelectedItem();
        }

        private int getSelectedDataFormat() {
            JComboBox is = this.dataTypeCombo;
            Object[] selected = is.getSelectedObjects();
            if (((String)selected[0]).equals(RNASeqFileLoader.this.dataTypes[1])) {
                return 1;
            }
            if (((String)selected[0]).equals(RNASeqFileLoader.this.dataTypes[4])) {
                return 4;
            }
            if (((String)selected[0]).equals(RNASeqFileLoader.this.dataTypes[3])) {
                return 3;
            }
            if (((String)selected[0]).equals(RNASeqFileLoader.this.dataTypes[2])) {
                return 2;
            }
            return 0;
        }

        private class EventListener
        implements ActionListener {
            private EventListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == RnaSeqFileLoaderPanel.this.browseButton1) {
                    if (RNASeqFileLoader.this.sflp.getSelectedDataFormat() == 0 || !((RNASeqFileLoader)RNASeqFileLoader.this).sflp.annoCheck.isSelected() && (RNASeqFileLoader.this.sflp.getSpecies().equalsIgnoreCase("Select") || RNASeqFileLoader.this.sflp.getGenome().equalsIgnoreCase("Select"))) {
                        String eMsg = "Required Fields(RED) may be not have been selected";
                        JOptionPane.showMessageDialog(null, eMsg, "Error", 0);
                        return;
                    }
                    if (((RNASeqFileLoader)RNASeqFileLoader.this).sflp.annoCheck.isSelected() && ((RNASeqFileLoader)RNASeqFileLoader.this).sflp.annoTextField.getText().length() < 2) {
                        String eMsg = "Annotation File may not have been selected";
                        JOptionPane.showMessageDialog(null, eMsg, "File not selected Error", 0);
                        return;
                    }
                    if (RNASeqFileLoader.this.sflp.libSizeIsNeeded() && ((RNASeqFileLoader)RNASeqFileLoader.this).sflp.libSizeFileTextField.getText().length() < 2) {
                        String eMsg = "The Data type you selected requires a Library Size File \n which may not have been selected";
                        JOptionPane.showMessageDialog(null, eMsg, "File not selected Error", 0);
                        return;
                    }
                    RnaSeqFileLoaderPanel.this.onBrowse();
                } else if (source == RnaSeqFileLoaderPanel.this.browseButton2) {
                    RnaSeqFileLoaderPanel.this.onBrowse2();
                } else if (source == RnaSeqFileLoaderPanel.this.browseButton3) {
                    RnaSeqFileLoaderPanel.this.onBrowse3();
                } else if (source == RnaSeqFileLoaderPanel.this.annoCheck) {
                    if (RnaSeqFileLoaderPanel.this.annoCheck.isSelected()) {
                        RnaSeqFileLoaderPanel.this.annoSelectionLabel.setForeground(Color.RED);
                        RnaSeqFileLoaderPanel.this.speciesLabel.setForeground(Color.BLACK);
                        RnaSeqFileLoaderPanel.this.speciesCombo.setEnabled(false);
                        RnaSeqFileLoaderPanel.this.bldLabel.setForeground(Color.BLACK);
                        RnaSeqFileLoaderPanel.this.bldCombo.setEnabled(false);
                        RnaSeqFileLoaderPanel.this.genomeLabel.setForeground(Color.BLACK);
                        RnaSeqFileLoaderPanel.this.genomeCombo.setEnabled(false);
                        RnaSeqFileLoaderPanel.this.browseButton3.setEnabled(true);
                    } else {
                        RnaSeqFileLoaderPanel.this.annoSelectionLabel.setForeground(Color.BLACK);
                        RnaSeqFileLoaderPanel.this.speciesLabel.setForeground(Color.RED);
                        RnaSeqFileLoaderPanel.this.speciesCombo.setEnabled(true);
                        RnaSeqFileLoaderPanel.this.bldLabel.setForeground(Color.RED);
                        RnaSeqFileLoaderPanel.this.bldCombo.setEnabled(true);
                        RnaSeqFileLoaderPanel.this.genomeLabel.setForeground(Color.RED);
                        RnaSeqFileLoaderPanel.this.genomeCombo.setEnabled(true);
                        RnaSeqFileLoaderPanel.this.browseButton3.setEnabled(false);
                    }
                } else if (source == RnaSeqFileLoaderPanel.this.dataTypeCombo) {
                    ItemSelectable is = (ItemSelectable)source;
                    Object[] selected = is.getSelectedObjects();
                    RnaSeqFileLoaderPanel.this.fileSelectionLabel.setForeground(Color.BLACK);
                    RnaSeqFileLoaderPanel.this.fileSelectionLabel.setText("Library size file");
                    if (((String)selected[0]).equals(RNASeqFileLoader.this.dataTypes[1])) {
                        RnaSeqFileLoaderPanel.this.needSampleLibSize = true;
                        RnaSeqFileLoaderPanel.this.needCountAndExp = false;
                        RnaSeqFileLoaderPanel.this.fileSelectionLabel.setForeground(Color.RED);
                    } else if (((String)selected[0]).equals(RNASeqFileLoader.this.dataTypes[4])) {
                        RnaSeqFileLoaderPanel.this.needSampleLibSize = false;
                        RnaSeqFileLoaderPanel.this.needCountAndExp = true;
                    } else {
                        RnaSeqFileLoaderPanel.this.needSampleLibSize = false;
                        RnaSeqFileLoaderPanel.this.needCountAndExp = false;
                    }
                } else if (source == RnaSeqFileLoaderPanel.this.speciesCombo) {
                    ItemSelectable is = (ItemSelectable)source;
                    Object[] selected = is.getSelectedObjects();
                    if (((String)selected[0]).equals(RnaSeqFileLoaderPanel.this.species[1])) {
                        RnaSeqFileLoaderPanel.this.bldCombo.removeAllItems();
                        for (int i = 0; i < RnaSeqFileLoaderPanel.this.hgGenomeBlds.length; ++i) {
                            RnaSeqFileLoaderPanel.this.bldCombo.addItem(RnaSeqFileLoaderPanel.this.hgGenomeBlds[i]);
                        }
                    } else if (((String)selected[0]).equals(RnaSeqFileLoaderPanel.this.species[2])) {
                        RnaSeqFileLoaderPanel.this.bldCombo.removeAllItems();
                        for (int i = 0; i < RnaSeqFileLoaderPanel.this.mmGenomeBlds.length; ++i) {
                            RnaSeqFileLoaderPanel.this.bldCombo.addItem(RnaSeqFileLoaderPanel.this.mmGenomeBlds[i]);
                        }
                    }
                } else if (source == RnaSeqFileLoaderPanel.this.bldCombo || source == RnaSeqFileLoaderPanel.this.genomeCombo) {
                    // empty if block
                }
            }
        }
    }
}

