/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.AffymetrixAnnotationParser;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;

public class Mas5FileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private boolean stop = false;
    private Mas5FileLoaderPanel sflp;
    ExpressionFileTableCellRenderer myCellRenderer;
    private int affyDataType = 2;
    private Hashtable _tempAnno = new Hashtable();
    private MultipleArrayViewer mav;
    protected MevAnnotation mevAnno = new MevAnnotation();
    private String annotationFileName;

    @Override
    public void setFilePath(String path) {
        this.sflp.pathTextField.setText(path);
        this.processMas5File(new File(path));
    }

    public Mas5FileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.sflp = new Mas5FileLoaderPanel();
    }

    public Vector loadExpressionFiles() throws IOException {
        return this.loadMas5ExpressionFile(new File(this.sflp.selectedFiles.getText()), this.sflp.selectedCallFileTextField.getText());
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    public void setTMEVDataType() {
        TMEV.setDataType(2);
    }

    @Override
    public int getDataType() {
        return this.affyDataType;
    }

    public Vector loadMas5ExpressionFile(File f, String callfile) throws IOException {
        String currentLine;
        int preSpotRows = this.sflp.getXRow() + 1;
        int preExperimentColumns = this.sflp.getXColumn();
        this.setTMEVDataType();
        int numLines = this.getCountOfLines(f);
        int spotCount = numLines - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        String[] moreFields = new String[preExperimentColumns];
        boolean rColumns = true;
        int rRows = spotCount;
        float[] intensities = new float[2];
        ISlideData[] slideDataArray = null;
        AffySlideDataElement sde = null;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        int column = 1;
        int row = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(numLines);
        this.setFileProgress(0);
        if (this.isAnnotationSelected()) {
            this.mav.getData().setAnnotationLoaded(true);
            File annoFile = new File(this.getAnnotationFilePath());
            String extension = annoFile.getName().substring(annoFile.getName().lastIndexOf(46) + 1, annoFile.getName().length());
            if (annoFile.getName().endsWith("annot.csv")) {
                AffymetrixAnnotationParser aafp = AffymetrixAnnotationParser.createAnnotationFileParser(new File(this.getAnnotationFilePath()));
                this._tempAnno = aafp.getAffyAnnotation();
            }
            if (extension.equalsIgnoreCase("txt")) {
                AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader(new File(this.getAnnotationFilePath()));
                this._tempAnno = afr.getAffyAnnotation();
                this.chipAnno = afr.getAffyChipAnnotation();
            }
        }
        while ((currentLine = reader.readLine()) != null) {
            if (this.stop) {
                return null;
            }
            ss.init(currentLine);
            if (counter == 0) {
                int i;
                int experimentCount = ss.countTokens() + 2 - preExperimentColumns;
                SampleAnnotation sampAnn = new SampleAnnotation();
                slideDataArray = new ISlideData[experimentCount];
                slideDataArray[0] = new SlideData(rRows, 1, sampAnn);
                slideDataArray[0].setSlideFileName(f.getPath());
                for (int i2 = 1; i2 < slideDataArray.length; ++i2) {
                    sampAnn = new SampleAnnotation();
                    slideDataArray[i2] = new FloatSlideData(slideDataArray[0].getSlideMetaData(), spotCount, sampAnn);
                    slideDataArray[i2].setSlideFileName(f.getPath());
                }
                String[] fieldNames = new String[preExperimentColumns + 1];
                fieldNames[0] = "ChipID";
                for (i = 1; i < preExperimentColumns; ++i) {
                    fieldNames[i] = ss.nextToken();
                }
                fieldNames[preExperimentColumns] = callfile;
                slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                for (i = 0; i < experimentCount; ++i) {
                    String val = ss.nextToken();
                    slideDataArray[i].setSampleAnnotationLoaded(true);
                    slideDataArray[i].getSampleAnnotation().setAnnotation("Default Slide Name", val);
                    slideDataArray[i].setSlideDataName(val);
                    this.mav.getData().setSampleAnnotationLoaded(true);
                }
            } else if (counter >= preSpotRows) {
                rows[0] = rows[2] = row++;
                columns[0] = columns[2] = column;
                column = column == 1 ? 1 : ++column;
                for (int i = 0; i < preExperimentColumns; ++i) {
                    moreFields[i] = ss.nextToken();
                }
                String cloneName = moreFields[0];
                if (this._tempAnno.size() != 0) {
                    MevAnnotation mevAnno;
                    if ((MevAnnotation)this._tempAnno.get(cloneName) != null) {
                        mevAnno = (MevAnnotation)this._tempAnno.get(cloneName);
                        sde = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields, mevAnno);
                    } else {
                        mevAnno = new MevAnnotation();
                        mevAnno.setCloneID(cloneName);
                        sde = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], moreFields, mevAnno);
                    }
                } else {
                    sde = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields);
                }
                slideDataArray[0].addSlideDataElement(sde);
                for (int i = 0; i < slideDataArray.length; ++i) {
                    float cy5;
                    float cy3 = 1.0f;
                    try {
                        String value = ss.nextToken();
                        cy5 = Float.parseFloat(value);
                    }
                    catch (Exception e) {
                        cy3 = 0.0f;
                        cy5 = Float.NaN;
                    }
                    slideDataArray[i].setIntensities(counter - preSpotRows, cy3, cy5);
                }
            } else {
                for (int i = 0; i < preExperimentColumns - 1; ++i) {
                    ss.nextToken();
                }
                String key = ss.nextToken();
                for (int j = 0; j < slideDataArray.length; ++j) {
                    if (slideDataArray[j].getSampleAnnotation() != null) {
                        String val = ss.nextToken();
                        slideDataArray[j].getSampleAnnotation().setAnnotation(key, val);
                        continue;
                    }
                    SampleAnnotation sampAnn = new SampleAnnotation();
                    sampAnn.setAnnotation(key, ss.nextToken());
                    slideDataArray[j].setSampleAnnotation(sampAnn);
                    slideDataArray[j].setSampleAnnotationLoaded(true);
                }
            }
            this.setFileProgress(counter);
            ++counter;
        }
        reader.close();
        Vector<void> data = new Vector<void>(slideDataArray.length);
        for (int i = 0; i < slideDataArray.length; ++i) {
            data.add(slideDataArray[i]);
        }
        this.setFilesProgress(1);
        return data;
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Mas5 Files(*.txt)";
            }
        };
        return mevFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.sflp.getXRow() + 1;
        int tableColumn = this.sflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.sflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.sflp;
    }

    public void loadCallFile(File targetFile) {
        this.sflp.setCallFileName(targetFile.getAbsolutePath());
    }

    public void processMas5File(File targetFile) {
        Vector<String> columnHeaders = new Vector<String>();
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        String currentLine = null;
        if (!this.validateFile(targetFile)) {
            return;
        }
        this.sflp.setDataFileName(targetFile.getAbsolutePath());
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        try {
            reader = new BufferedReader(new FileReader(targetFile), 131072);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            currentLine = reader.readLine();
            ss.init(currentLine);
            columnHeaders.add("ChipID\t");
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                columnHeaders.add(ss.nextToken());
            }
            model.setColumnIdentifiers(columnHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && cnt < 100) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i = 0; i < ss.countTokens() + 1; ++i) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.sflp.setTableModel(model);
        Point p = this.getFirstExpressionCell(dataVector);
        this.sflp.setSelectedCell(p.x, p.y);
    }

    @Override
    public String getFilePath() {
        return this.sflp.fileNameTextField.getText();
    }

    @Override
    public void openDataPath() {
    }

    @Override
    public String getAnnotationFilePath() {
        return this.sflp.adh.getAnnFilePath();
    }

    public boolean isAnnotationSelected() {
        return this.sflp.adh.isAnnotationSelected();
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
        this.sflp.adh.setAnnFilePath(filePath);
    }

    private class Mas5FileLoaderPanel
    extends JPanel {
        JTextField pathTextField;
        JPanel pathPanel;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel mas5ListPanel;
        JList mas5AvailableList;
        JScrollPane mas5AvailableScrollPane;
        JPanel refListPanel;
        JList refAvailableList;
        JScrollPane refAvailableScrollPane;
        JTextField refTextField;
        JPanel refPanel;
        JTextField annoTextField;
        JPanel annoPanel;
        JPanel fileLoaderPanel;
        JSplitPane splitPane;
        JTextField fileNameTextField;
        JTextField callFileNameTextField;
        JTextField selectedCallFileTextField;
        JPanel additionalRequirements;
        JPanel fileSelectionPanel;
        JLabel selectedFileLabel;
        JLabel selectedCallFile;
        JLabel dataSelection;
        JLabel callFileSelection;
        JButton browseButton1;
        JButton browseButton3;
        JComboBox fileTypeList;
        JTextField selectedFiles;
        JPanel annotationPanel;
        AnnotationDownloadHandler adh;
        protected EventListener eventListener = new EventListener();
        private int xRow = -1;
        private int xColumn = -1;
        private JTextField annFileNameTextField;

        public Mas5FileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.adh = new AnnotationDownloadHandler(Mas5FileLoader.this.superLoader.viewer.getResourceManager(), Mas5FileLoader.this.superLoader.annotationLists, Mas5FileLoader.this.superLoader.defaultSpeciesName, Mas5FileLoader.this.superLoader.defaultArrayName);
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.selectedFileLabel = new JLabel();
            this.selectedFileLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.selectedFileLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select expression data file</html>";
            this.dataSelection.setText(chooseFile);
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (Mas5 Format Files)"));
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(this.eventListener);
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            Mas5FileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 0, 1, 1, 1, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.fileSelectionPanel, this.selectedFileLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.fileSelectionPanel, this.selectedFiles, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.annotationPanel = this.adh.getAnnotationLoaderPanel(Mas5FileLoader.this.gba);
            this.additionalRequirements = new JPanel();
            this.additionalRequirements.setLayout(new GridBagLayout());
            this.additionalRequirements.setBorder(new TitledBorder(new EtchedBorder(), "Additional Requirements"));
            this.callFileSelection = new JLabel();
            this.callFileSelection.setForeground(Color.BLACK);
            String callFileName = "<html> Select Call file </html>";
            this.callFileSelection.setText(callFileName);
            this.callFileNameTextField = new JTextField();
            this.callFileNameTextField.setEditable(false);
            this.callFileNameTextField.setForeground(Color.black);
            this.callFileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.browseButton3 = new JButton("Browse");
            this.browseButton3.addActionListener(this.eventListener);
            this.browseButton3.setSize(100, 30);
            this.browseButton3.setPreferredSize(new Dimension(100, 30));
            this.selectedCallFile = new JLabel();
            this.selectedCallFile.setForeground(Color.BLACK);
            String selectedCallFileName = "<html> Selected Call file </html>";
            this.selectedCallFile.setText(selectedCallFileName);
            this.selectedCallFileTextField = new JTextField();
            this.selectedCallFileTextField.setEditable(false);
            this.selectedCallFileTextField.setForeground(Color.black);
            this.selectedCallFileTextField.setFont(new Font("monospaced", 1, 12));
            Mas5FileLoader.this.gba.add(this.additionalRequirements, this.callFileSelection, 0, 0, 1, 1, 1, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.additionalRequirements, this.callFileNameTextField, 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.additionalRequirements, this.browseButton3, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.additionalRequirements, this.selectedCallFile, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.additionalRequirements, this.selectedCallFileTextField, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.expressionTable = new JTable();
            Mas5FileLoader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable.setDefaultRenderer(Object.class, Mas5FileLoader.this.myCellRenderer);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    Mas5FileLoaderPanel.this.setSelectedCell(Mas5FileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), Mas5FileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            Mas5FileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            Mas5FileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 1, 0, 1, 1, 3, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.fileLoaderPanel, this.annotationPanel, 1, 1, 1, 1, 3, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.fileLoaderPanel, this.additionalRequirements, 1, 2, 1, 1, 3, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 1, 3, 1, 2, 3, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            Mas5FileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            Mas5FileLoader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            Mas5FileLoader.this.checkLoadEnable();
        }

        public void onDataFileBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                Mas5FileLoader.this.processMas5File(selectedFile);
            }
        }

        public void onCallFileBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.callFileNameTextField.setText(selectedFile.getAbsolutePath());
                this.selectedCallFileTextField.setText(selectedFile.getAbsolutePath());
                Mas5FileLoader.this.loadCallFile(selectedFile);
            }
        }

        public void openDataPath() {
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void selectMas5File() {
            JFileChooser jfc = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            jfc.setFileFilter(Mas5FileLoader.this.getFileFilter());
            int activityCode = jfc.showDialog(this, "Select");
            if (activityCode == 0) {
                File target = jfc.getSelectedFile();
                Mas5FileLoader.this.processMas5File(target);
            }
        }

        public void setDataFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
            this.selectedFiles.setText(fileName);
        }

        public void setCallFileName(String fileName) {
            this.callFileNameTextField.setText(fileName);
            this.selectedCallFileTextField.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String fieldsText) {
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            @Override
            public void nodeSelected(FileTreePaneEvent event) {
            }

            @Override
            public void nodeCollapsed(FileTreePaneEvent event) {
            }

            @Override
            public void nodeExpanded(FileTreePaneEvent event) {
            }
        }

        private class ListListener
        implements ListSelectionListener {
            private ListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent lse) {
            }
        }

        private class EventListener
        implements ActionListener {
            private EventListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == Mas5FileLoaderPanel.this.browseButton1) {
                    Mas5FileLoaderPanel.this.onDataFileBrowse();
                }
                if (source == Mas5FileLoaderPanel.this.browseButton3) {
                    Mas5FileLoaderPanel.this.onCallFileBrowse();
                }
            }
        }
    }
}

