/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.ArrayElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.AffymetrixAnnotationParser;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.annotation.PublicURL;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.MageIDF;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.IDF;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.MAGETABInvestigation;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.HybridizationNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.SourceNode;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.CharacteristicsAttribute;
import uk.ac.ebi.arrayexpress2.magetab.datamodel.sdrf.node.attribute.FactorValueAttribute;
import uk.ac.ebi.arrayexpress2.magetab.exception.ParseException;
import uk.ac.ebi.arrayexpress2.magetab.parser.MAGETABParser;

public class MAGETABFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private boolean stop = false;
    private MAGETABFileLoaderPanel sflp;
    ExpressionFileTableCellRenderer myCellRenderer;
    private int DataType;
    protected String[] dataTypes;
    protected Hashtable<String, String> columnDataTypes = new Hashtable();
    private String SDRFFilePath;
    private String IDFFilePath;
    protected Hashtable<String, Integer> quantTypes;
    ArrayList sampleNames = new ArrayList();
    private matrixType matrixState;
    private Hashtable _tempAnno = new Hashtable();
    private MultipleArrayViewer mav;
    protected MevAnnotation mevAnno = new MevAnnotation();
    private MAGETABParser mageTabParser = new MAGETABParser();
    private MAGETABInvestigation investigation;
    private MageIDF mageIDFObject = new MageIDF();

    protected void setMatrixState(matrixType state) {
        this.matrixState = state;
    }

    protected matrixType getMatrixState() {
        return this.matrixState;
    }

    @Override
    public void setFilePath(String path) {
        this.sflp.setDataFileName(path);
        this.processAffyGCOSFile(new File(path));
    }

    public MAGETABFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.sflp = new MAGETABFileLoaderPanel();
    }

    public Vector loadExpressionFiles() throws IOException {
        if (this.isAnnotationSelected()) {
            this.mav.getData().setAnnotationLoaded(true);
            File annoFile = new File(this.getAnnotationFilePath());
            String extension = annoFile.getName().substring(annoFile.getName().lastIndexOf(46) + 1, annoFile.getName().length());
            if (annoFile.getName().endsWith("annot.csv")) {
                AffymetrixAnnotationParser aafp = AffymetrixAnnotationParser.createAnnotationFileParser(new File(this.getAnnotationFilePath()));
                this._tempAnno = aafp.getAffyAnnotation();
            }
            if (extension.equalsIgnoreCase("txt")) {
                AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader(new File(this.getAnnotationFilePath()));
                this._tempAnno = afr.getAffyAnnotation();
                this.chipAnno = afr.getAffyChipAnnotation();
            }
        }
        if (PublicURL.loadURLs(TMEV.getConfigurationFile("annotation_URLs.txt")) != 0) {
            JOptionPane.showMessageDialog(new JFrame(), "URLs will not be loaded", "Warning", 2);
        }
        return this.loadAffyGCOSExpressionFile(new File(this.sflp.selectedDataMatrix.getText()));
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    public void setDataType(int dataType) {
        this.DataType = dataType != -1 ? dataType : 1;
    }

    public Vector loadAffyGCOSExpressionFile(File f) throws IOException {
        String currentLine;
        int preSpotRows = this.sflp.getXRow() + 1;
        int preExperimentColumns = this.sflp.getXColumn();
        int numLines = this.getCountOfLines(f);
        int spotCount = numLines - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        if (this.sflp.oneChannelRadioButton.isSelected()) {
            this.setDataType(2);
        } else {
            this.setDataType(1);
        }
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        String[] moreFields = new String[1];
        String[] extraFields = null;
        boolean rColumns = true;
        int rRows = spotCount;
        ISlideData[] slideDataArray = null;
        ArrayElement sde = null;
        Object slideData = null;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        int experimentCount = 0;
        int counter = 0;
        int column = 1;
        int row = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(numLines);
        this.setFileProgress(0);
        float[] intensities = new float[2];
        this.setListsAndButtons();
        while ((currentLine = reader.readLine()) != null) {
            if (this.stop) {
                return null;
            }
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            if (counter == 0) {
                experimentCount = (ss.countTokens() + 1 - preExperimentColumns) / this.dataTypes.length;
                slideDataArray = new ISlideData[experimentCount];
                SampleAnnotation sampAnn = new SampleAnnotation();
                slideDataArray[0] = new SlideData(rRows, 1, sampAnn);
                slideDataArray[0].setSlideFileName(f.getPath());
                for (int i = 1; i < experimentCount; ++i) {
                    sampAnn = new SampleAnnotation();
                    slideDataArray[i] = new FloatSlideData(slideDataArray[0].getSlideMetaData(), spotCount, sampAnn);
                    slideDataArray[i].setSlideFileName(f.getPath());
                }
                switch (this.matrixState) {
                    case INTENSITY_PVAL: 
                    case INTENSITY: {
                        String[] fieldNames = new String[]{"AffyID"};
                        slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                        break;
                    }
                    case INTENSITY_DETECTION: {
                        String[] fieldNames = new String[2];
                        extraFields = new String[1];
                        fieldNames[0] = "AffyID";
                        fieldNames[1] = "Detection";
                        slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                        break;
                    }
                    case INTENSITY_DETECT_PVAL: {
                        String[] fieldNames = new String[3];
                        extraFields = new String[2];
                        fieldNames[0] = "AffyID";
                        fieldNames[1] = "Detection";
                        fieldNames[2] = "P-value";
                        slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                        break;
                    }
                    case LOG_RATIO: 
                    case RATIO: {
                        String[] fieldNames = new String[]{"ReporterID"};
                        slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                        break;
                    }
                    case LOG_CHANNELS: 
                    case RATIO_CHANNELS: {
                        String[] fieldNames;
                        if (this.dataTypes.length > 2) {
                            fieldNames = new String[3];
                            extraFields = new String[2];
                            fieldNames[0] = "ReporterID";
                            fieldNames[1] = "Channel1";
                            fieldNames[2] = "Channel2";
                        } else {
                            fieldNames = new String[]{"ReporterID"};
                        }
                        slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                        break;
                    }
                    case CHANNELS: {
                        String[] fieldNames = new String[]{"ReporterID"};
                        slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                        break;
                    }
                }
                ss.nextToken();
                int numqts = this.dataTypes.length;
                for (int i = 0; i < experimentCount; ++i) {
                    String slideDataName = (String)this.sampleNames.get(i);
                    slideDataArray[i].setSampleAnnotationLoaded(true);
                    slideDataArray[i].getSampleAnnotation().setAnnotation("Default Slide Name", slideDataName);
                    slideDataArray[i].setSlideDataName(slideDataName);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {}
            } else if (counter >= preSpotRows) {
                rows[0] = rows[2] = row++;
                columns[0] = columns[2] = column;
                column = column == 1 ? 1 : ++column;
                moreFields[0] = ss.nextToken();
                String cloneName = moreFields[0];
                MevAnnotation mevAnno = new MevAnnotation();
                if (this._tempAnno.size() != 0) {
                    if ((MevAnnotation)this._tempAnno.get(cloneName) != null) {
                        mevAnno = (MevAnnotation)this._tempAnno.get(cloneName);
                    } else {
                        mevAnno.setCloneID(cloneName);
                        intensities = new float[2];
                    }
                    sde = this.getDataType() == 2 ? new AffySlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields, mevAnno) : new SlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields, mevAnno);
                } else {
                    sde = this.getDataType() == 2 ? new AffySlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields) : new SlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields);
                }
                slideDataArray[0].addSlideDataElement((ISlideDataElement)((Object)sde));
                int i = 0;
                block53: for (i = 0; i < slideDataArray.length; ++i) {
                    try {
                        intensities[0] = 1.0f;
                        String[] currData = new String[this.dataTypes.length];
                        for (int j = 0; j < this.dataTypes.length; ++j) {
                            if (currentLine.length() < this.dataTypes.length) {
                                // empty if block
                            }
                            currData[j] = ss.nextToken();
                        }
                        switch (this.matrixState) {
                            case INTENSITY_PVAL: 
                            case INTENSITY: {
                                intensities[1] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:signal")) - 1]);
                                break;
                            }
                            case INTENSITY_DETECTION: {
                                intensities[1] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:signal")) - 1]);
                                extraFields[0] = currData[this.quantTypes.get(this.columnDataTypes.get("MEV:detection")) - 1];
                                break;
                            }
                            case INTENSITY_DETECT_PVAL: {
                                intensities[1] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:signal")) - 1]);
                                extraFields[0] = currData[this.quantTypes.get(this.columnDataTypes.get("MEV:detection")) - 1];
                                extraFields[1] = currData[this.quantTypes.get(this.columnDataTypes.get("MEV:pvalue")) - 1];
                                break;
                            }
                            case LOG_CHANNELS: {
                                intensities[1] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:log")) - 1]);
                                extraFields[0] = currData[this.quantTypes.get(this.columnDataTypes.get("MEV:channel1")) - 1];
                                extraFields[1] = currData[this.quantTypes.get(this.columnDataTypes.get("MEV:channel2")) - 1];
                                break;
                            }
                            case LOG_RATIO: {
                                intensities[1] = new Float(NumberFormat.getInstance().parse(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:log")) - 1]).floatValue()).floatValue();
                                break;
                            }
                            case RATIO_CHANNELS: {
                                intensities[1] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:ratio")) - 1]);
                                extraFields[0] = currData[this.quantTypes.get(this.columnDataTypes.get("MEV:channel1")) - 1];
                                extraFields[1] = currData[this.quantTypes.get(this.columnDataTypes.get("MEV:channel2")) - 1];
                                break;
                            }
                            case RATIO: {
                                intensities[1] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:ratio")) - 1]);
                                break;
                            }
                            case CHANNELS: {
                                intensities[0] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:channel1")) - 1]);
                                intensities[1] = Float.parseFloat(currData[this.quantTypes.get(this.columnDataTypes.get("MEV:channel2")) - 1]);
                                break;
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException iob) {
                        iob.printStackTrace();
                    }
                    catch (NumberFormatException nfe) {
                    }
                    catch (java.text.ParseException jtp) {
                    }
                    catch (Exception e) {
                        System.out.println("General exeception: " + i);
                        e.printStackTrace();
                        intensities[1] = Float.NaN;
                    }
                    if (i == 0) {
                        slideDataArray[i].setIntensities(counter - preSpotRows, intensities[0], intensities[1]);
                        switch (this.matrixState) {
                            case INTENSITY_PVAL: {
                                break;
                            }
                            case INTENSITY_DETECT_PVAL: {
                                sde.setDetection(extraFields[0]);
                                try {
                                    sde.setPvalue(new Float(NumberFormat.getInstance().parse(extraFields[1]).floatValue()).floatValue());
                                }
                                catch (Exception e) {}
                                break;
                            }
                            case INTENSITY_DETECTION: {
                                sde.setDetection(extraFields[0]);
                                break;
                            }
                        }
                        continue;
                    }
                    if (i == 1) {
                        this.meta = slideDataArray[0].getSlideMetaData();
                    }
                    slideDataArray[i].setIntensities(counter - preSpotRows, intensities[0], intensities[1]);
                    switch (this.matrixState) {
                        case INTENSITY_PVAL: {
                            continue block53;
                        }
                        case INTENSITY_DETECT_PVAL: {
                            ((FloatSlideData)slideDataArray[i]).setDetection(counter - preSpotRows, extraFields[0]);
                            try {
                                ((FloatSlideData)slideDataArray[i]).setPvalue(counter - preSpotRows, new Float(NumberFormat.getInstance().parse(extraFields[1]).floatValue()).floatValue());
                            }
                            catch (Exception e) {}
                            continue block53;
                        }
                        case INTENSITY_DETECTION: {
                            ((FloatSlideData)slideDataArray[i]).setDetection(counter - preSpotRows, extraFields[0]);
                            continue block53;
                        }
                    }
                }
            }
            this.setFileProgress(counter);
            ++counter;
        }
        reader.close();
        if (this.getIDFFilePath() != null) {
            try {
                URL fileURL = new URL("file:///" + this.getIDFFilePath());
                this.investigation = this.mageTabParser.parse(fileURL);
            }
            catch (IOException ioe) {
                String text = "<html><body><font face=arial size=4><b><center>We could not load the IDF and SDRF files you provided</center><b><hr size=3><br>";
                text = text + "<font face=arial size=4>The IDF or SDRF file could not be located. <br>";
                text = text + "Check that both files are in the same directory.<br><br>";
                text = text + "<br><br></body></html>";
                JOptionPane.showMessageDialog(null, text, "Unable to locate MAGE-TAB files.", 2);
            }
            catch (ParseException pe) {
                String text = "<html><body><font face=arial size=4><b><center>We could not load the IDF and SDRF files you provided</center><b><hr size=3><br>";
                text = text + "<font face=arial size=4>1. The IDF and SDRF files seem to be MAGE TAB version 1.1. We support 1.0<br>";
                text = text + "2. Check the column names of SDRF file. If Protocol Ref has any prefixes, delete the prefix.<br><br>";
                text = text + "3. Check if the SDRF file tag in IDF contains the correct SDRF file name";
                text = text + "<br><br></body></html>";
                JOptionPane.showMessageDialog(null, text, "Loader Parse failure", 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.investigation != null) {
                try {
                    this.populateIDFObject(this.investigation.IDF);
                }
                catch (NullPointerException npe) {
                    String text = "<html><body><font face=arial size=4><b><center>Parse failure</center><b><hr size=3><br>";
                    text = text + "<font face=arial size=4>The IDF file could not be parsed due to an incorrect MAGE-TAB version (We support v.1.0). <br>";
                    text = text + "Check the MAGE-TAB specification to ensure that the files are correctly formated.<br><br>";
                    text = text + "<br><br></body></html>";
                    JOptionPane.showMessageDialog(null, text, "Unable to parse MAGE-TAB files.", 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    this.populateSampleAnnotationfromSDRF(slideDataArray);
                }
                catch (NullPointerException npe) {
                    String text = "<html><body><font face=arial size=4><b><center>Parse failure</center><b><hr size=3><br>";
                    text = text + "<font face=arial size=4>The SDRF file could not be parsed due to inconsistencies between IDF <br>";
                    text = text + "and SDRF files or an incorrect MAGE-TAB version (We support v.1.0). <br>";
                    text = text + "1. Check that the BioMaterial names in the SDRF file match the column headers in the data matrix.<br><br>";
                    text = text + "2. Check that the Experimental Factor Values match those listed in the IDF.<br><br>";
                    text = text + "3. Check that the Protocols names and Parameter names match those listed in the IDF.<br><br>";
                    text = text + "4. Check to make sure that there are no blank cells in your file.<br><br>";
                    text = text + "5. Lastly, check the MAGE-TAB specification to ensure that the files are correctly formated.<br><br>";
                    text = text + "<br><br></body></html>";
                    JOptionPane.showMessageDialog(null, text, "Unable to parse MAGE-TAB files.", 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Vector<void> data = new Vector<void>(slideDataArray.length);
        for (int j = 0; j < slideDataArray.length; ++j) {
            data.add(slideDataArray[j]);
        }
        this.setFilesProgress(1);
        return data;
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "MAGE-TAB Files(*idf.txt, *sdrf.txt, *adf.txt, *data.txt)";
            }
        };
        return mevFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.sflp.getXRow() + 1;
        int tableColumn = this.sflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.sflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        this.sflp.setFieldsText(fieldSummary);
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.sflp;
    }

    @Override
    public int getDataType() {
        return this.DataType;
    }

    @Override
    public String getAnnotationFilePath() {
        return this.sflp.getAnnFilePath();
    }

    public boolean isAnnotationSelected() {
        return this.sflp.isAnnotationSelected();
    }

    public void processAffyGCOSFile(File targetFile) {
        Vector<String> columnHeaders = new Vector<String>();
        Vector<String> quantHeaders = new Vector<String>();
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        String currentLine = null;
        String current = "";
        String previous = "";
        this.sampleNames = new ArrayList();
        this.quantTypes = new Hashtable();
        if (!this.validateFile(targetFile)) {
            return;
        }
        this.sflp.setDataFileName(targetFile.getAbsolutePath());
        DefaultTableModel model = new DefaultTableModel();
        try {
            reader = new BufferedReader(new FileReader(targetFile), 131072);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            currentLine = reader.readLine();
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                current = ss.nextToken();
                columnHeaders.add(current);
                if (!previous.equalsIgnoreCase(current) && i > 0) {
                    this.sampleNames.add(current);
                }
                previous = current;
            }
            currentLine = reader.readLine();
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            boolean done = false;
            this.quantTypes.clear();
            int counter = 0;
            int numDataTypes = 0;
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                current = ss.nextToken();
                quantHeaders.add(current);
                if (this.quantTypes.containsKey(current)) {
                    done = true;
                    continue;
                }
                if (i <= 0 || done) continue;
                this.quantTypes.put(current, i);
                ++counter;
            }
            numDataTypes = counter;
            String QTs = this.quantTypes.toString();
            this.dataTypes = new String[this.quantTypes.keySet().size()];
            Enumeration<String> i = this.quantTypes.keys();
            while (i.hasMoreElements()) {
                String key = i.nextElement();
                int ordinal = this.quantTypes.get(key);
                this.dataTypes[ordinal - 1] = key;
            }
            this.sflp.signalComboBox.removeAllItems();
            this.sflp.detectionComboBox.removeAllItems();
            this.sflp.pValueComboBox.removeAllItems();
            this.sflp.dye1ComboBox.removeAllItems();
            this.sflp.dye2ComboBox.removeAllItems();
            this.sflp.ratioComboBox.removeAllItems();
            this.sflp.signalComboBox.addItem("none");
            this.sflp.detectionComboBox.addItem("none");
            this.sflp.pValueComboBox.addItem("none");
            this.sflp.dye1ComboBox.addItem("none");
            this.sflp.dye2ComboBox.addItem("none");
            this.sflp.ratioComboBox.addItem("none");
            for (int i2 = 0; i2 < this.dataTypes.length; ++i2) {
                this.sflp.signalComboBox.addItem(this.dataTypes[i2]);
                this.sflp.detectionComboBox.addItem(this.dataTypes[i2]);
                this.sflp.pValueComboBox.addItem(this.dataTypes[i2]);
                this.sflp.dye1ComboBox.addItem(this.dataTypes[i2]);
                this.sflp.dye2ComboBox.addItem(this.dataTypes[i2]);
                this.sflp.ratioComboBox.addItem(this.dataTypes[i2]);
            }
            this.refillDataTypeTable();
            this.columnDataTypes = this.guessFileFormat(this.dataTypes);
            model.setColumnIdentifiers(columnHeaders);
            model.addRow(quantHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && cnt < 100) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i3 = 0; i3 < ss.countTokens() + 1; ++i3) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.sflp.setTableModel(model);
        Point p = this.guessFirstExpressionCell(dataVector);
        this.sflp.setSelectedCell(1, 1);
        p.setLocation(1, 1);
        this.checkLoadEnable();
    }

    public void refillDataTypeTable() {
        if (this.sflp.oneChannelRadioButton.isSelected()) {
            this.sflp.dataTypePanel.remove(0);
            this.sflp.dataTypePanel.add((Component)this.sflp.oneChannelDataTypes, 0);
            this.setDataType(2);
            this.columnDataTypes.remove("MEV:channel1");
            this.columnDataTypes.remove("MEV:channel2");
            this.columnDataTypes.remove("MEV:ratio");
            this.columnDataTypes.remove("MEV:log");
            this.sflp.dye1ComboBox.setSelectedItem("none");
            this.sflp.dye2ComboBox.setSelectedItem("none");
            this.sflp.ratioComboBox.setSelectedItem("none");
        } else if (this.sflp.twoChannelRadioButton.isSelected()) {
            this.sflp.dataTypePanel.remove(0);
            this.sflp.dataTypePanel.add((Component)this.sflp.twoChannelDataTypes, 0);
            this.setDataType(0);
            this.columnDataTypes.remove("MEV:signal");
            this.columnDataTypes.remove("MEV:detection");
            this.columnDataTypes.remove("MEV:pvalue");
            this.sflp.signalComboBox.setSelectedItem("none");
            this.sflp.detectionComboBox.setSelectedItem("none");
            this.sflp.pValueComboBox.setSelectedItem("none");
        }
        this.sflp.dataTypePanel.validate();
        this.sflp.dataTypePanel.repaint();
    }

    protected Hashtable guessFileFormat(String[] row2) {
        Vector<Pattern> patterns = new Vector<Pattern>();
        Pattern sigPat = Pattern.compile(".*signal.*", 2);
        patterns.add(sigPat);
        Pattern pValuePat = Pattern.compile(".*p.value.*", 2);
        patterns.add(pValuePat);
        Pattern pCallPat = Pattern.compile(".*call.*", 2);
        patterns.add(pCallPat);
        Pattern detectPat = Pattern.compile(".*detect.*", 2);
        patterns.add(detectPat);
        Pattern channelPat = Pattern.compile(".*ch.*1.*", 2);
        patterns.add(channelPat);
        Pattern channe2Pat = Pattern.compile(".*ch.*2.*", 2);
        patterns.add(channe2Pat);
        Pattern dyePat = Pattern.compile(".*dye.*", 2);
        patterns.add(dyePat);
        Pattern cy3Pat = Pattern.compile(".*cy3.*", 2);
        patterns.add(cy3Pat);
        Pattern cy5Pat = Pattern.compile(".*cy5.*", 2);
        patterns.add(cy5Pat);
        Pattern ratioPat = Pattern.compile(".*rat.*", 2);
        patterns.add(ratioPat);
        Pattern logPat = Pattern.compile(".*log.*", 2);
        patterns.add(logPat);
        for (int i = 0; i < row2.length; ++i) {
            String str;
            String chr = str = row2[i];
            for (int j = 0; j < patterns.size(); ++j) {
                Pattern p = (Pattern)patterns.get(j);
                Matcher m = p.matcher(chr);
                if (m.find()) {
                    switch (j) {
                        case 0: {
                            this.columnDataTypes.put(str, "signal");
                            this.columnDataTypes.put("MEV:signal", str);
                            break;
                        }
                        case 1: {
                            this.columnDataTypes.put(str, "pvalue");
                            this.columnDataTypes.put("MEV:pvalue", str);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.columnDataTypes.put(str, "detection");
                            this.columnDataTypes.put("MEV:detection", str);
                            break;
                        }
                        case 4: 
                        case 7: {
                            this.columnDataTypes.put(str, "channel1");
                            this.columnDataTypes.put("MEV:channel1", str);
                            break;
                        }
                        case 5: 
                        case 8: {
                            this.columnDataTypes.put(str, "channel2");
                            this.columnDataTypes.put("MEV:channel2", str);
                            break;
                        }
                        case 6: {
                            if (str.indexOf("1") > 0) {
                                this.columnDataTypes.put(str, "channel1");
                                this.columnDataTypes.put("MEV:channel1", str);
                                break;
                            }
                            if (str.indexOf("2") <= 0) break;
                            this.columnDataTypes.put("MEV:channel2", str);
                            this.columnDataTypes.put(str, "channel2");
                            break;
                        }
                        case 9: {
                            this.columnDataTypes.put(str, "ratio");
                            this.columnDataTypes.put("MEV:ratio", str);
                            break;
                        }
                        case 10: {
                            this.columnDataTypes.put(str, "log");
                            this.columnDataTypes.put("MEV:log", str);
                            break;
                        }
                    }
                }
                if (this.columnDataTypes.containsKey(str)) continue;
                this.columnDataTypes.put(str, "none");
            }
        }
        String stateStr = this.setListsAndButtons();
        return this.columnDataTypes;
    }

    public String setListsAndButtons() {
        if (this.columnDataTypes.containsKey("MEV:signal") || this.columnDataTypes.containsKey("MEV:pvalue") || this.columnDataTypes.containsKey("MEV:detection")) {
            this.sflp.oneChannelRadioButton.doClick();
            if (this.columnDataTypes.containsKey("MEV:signal")) {
                this.sflp.signalComboBox.setSelectedItem(this.columnDataTypes.get("MEV:signal"));
                this.setMatrixState(matrixType.INTENSITY);
            } else {
                this.sflp.signalComboBox.setSelectedItem("none");
            }
            if (this.columnDataTypes.containsKey("MEV:detection")) {
                this.sflp.detectionComboBox.setSelectedItem(this.columnDataTypes.get("MEV:detection"));
                this.setMatrixState(matrixType.INTENSITY_DETECTION);
            } else {
                this.sflp.detectionComboBox.setSelectedItem("none");
            }
            if (this.columnDataTypes.containsKey("MEV:pvalue") && this.columnDataTypes.containsKey("MEV:detection")) {
                this.sflp.pValueComboBox.setSelectedItem(this.columnDataTypes.get("MEV:pvalue"));
                this.setMatrixState(matrixType.INTENSITY_DETECT_PVAL);
            } else if (this.columnDataTypes.containsKey("MEV:pvalue")) {
                this.sflp.pValueComboBox.setSelectedItem(this.columnDataTypes.get("MEV:pvalue"));
                this.setMatrixState(matrixType.INTENSITY_PVAL);
            } else {
                this.sflp.pValueComboBox.setSelectedItem("none");
            }
        } else if (this.columnDataTypes.containsKey("MEV:log")) {
            this.sflp.twoChannelRadioButton.doClick();
            this.sflp.ratioComboBox.setSelectedItem(this.columnDataTypes.get("MEV:log"));
            if (this.columnDataTypes.containsKey("MEV:channel1") && this.columnDataTypes.containsKey("MEV:channel2")) {
                this.sflp.dye1ComboBox.setSelectedItem(this.columnDataTypes.get("MEV:channel1"));
                this.sflp.dye2ComboBox.setSelectedItem(this.columnDataTypes.get("MEV:channel2"));
                this.setMatrixState(matrixType.LOG_CHANNELS);
            } else {
                this.sflp.dye1ComboBox.setSelectedItem(this.columnDataTypes.get("none"));
                this.sflp.dye2ComboBox.setSelectedItem(this.columnDataTypes.get("none"));
                this.setMatrixState(matrixType.LOG_RATIO);
            }
        } else if (this.columnDataTypes.containsKey("MEV:ratio")) {
            this.sflp.twoChannelRadioButton.doClick();
            this.sflp.ratioComboBox.setSelectedItem(this.columnDataTypes.get("MEV:ratio"));
            if (this.columnDataTypes.containsKey("MEV:channel1") && this.columnDataTypes.containsKey("MEV:channel2")) {
                this.sflp.dye1ComboBox.setSelectedItem(this.columnDataTypes.get("MEV:channel1"));
                this.sflp.dye2ComboBox.setSelectedItem(this.columnDataTypes.get("MEV:channel2"));
                this.setMatrixState(matrixType.RATIO_CHANNELS);
            } else {
                this.sflp.dye1ComboBox.setSelectedItem(this.columnDataTypes.get("none"));
                this.sflp.dye2ComboBox.setSelectedItem(this.columnDataTypes.get("none"));
                this.setMatrixState(matrixType.RATIO);
            }
        } else if (this.columnDataTypes.containsKey("MEV:channel1") && this.columnDataTypes.containsKey("MEV:channel2")) {
            this.sflp.twoChannelRadioButton.doClick();
            this.sflp.ratioComboBox.setSelectedItem(this.columnDataTypes.get("none"));
            this.sflp.dye1ComboBox.setSelectedItem(this.columnDataTypes.get("MEV:channel1"));
            this.sflp.dye2ComboBox.setSelectedItem(this.columnDataTypes.get("MEV:channel2"));
            this.setMatrixState(matrixType.CHANNELS);
        } else {
            this.sflp.oneChannelRadioButton.doClick();
            this.sflp.signalComboBox.setSelectedItem("none");
            this.sflp.detectionComboBox.setSelectedItem("none");
            this.sflp.pValueComboBox.setSelectedItem("none");
            this.sflp.ratioComboBox.setSelectedItem("none");
            this.sflp.dye1ComboBox.setSelectedItem("none");
            this.sflp.dye2ComboBox.setSelectedItem("none");
            this.setMatrixState(matrixType.NONE);
        }
        String matrixStateStr = this.getMatrixState().name();
        return matrixStateStr;
    }

    @Override
    public String getFilePath() {
        return this.sflp.selectedDataMatrix.getText();
    }

    @Override
    public void openDataPath() {
        this.sflp.openDataPath();
    }

    public void populateSampleAnnotationfromSDRF(ISlideData[] slideDataArray) {
        boolean srcNodeIndex = false;
        List sourcenodes = this.investigation.SDRF.sourceNodes;
        for (int i = 0; i < slideDataArray.length; ++i) {
            SourceNode src = (SourceNode)sourcenodes.get(i);
            List characteristicsList = src.characteristics;
            if (characteristicsList.size() == 0) continue;
            for (int j = 0; j < characteristicsList.size(); ++j) {
                slideDataArray[i].getSampleAnnotation().setAnnotation(((CharacteristicsAttribute)characteristicsList.get((int)j)).type, ((CharacteristicsAttribute)characteristicsList.get(j)).getNodeName());
            }
        }
        List nodes = this.investigation.SDRF.lookupNodes(HybridizationNode.class);
        for (int index = 0; index < nodes.size(); ++index) {
            HybridizationNode node = (HybridizationNode)nodes.get(index);
            List fvalist = node.factorValues;
            for (int i = 0; i < fvalist.size(); ++i) {
                FactorValueAttribute fva = (FactorValueAttribute)fvalist.get(i);
                slideDataArray[index].getSampleAnnotation().setAnnotation(((FactorValueAttribute)fvalist.get(i)).getNodeType(), ((FactorValueAttribute)fvalist.get(i)).getNodeName());
            }
        }
    }

    public void populateIDFObject(IDF idfObj) {
        ArrayList<String> alist = new ArrayList<String>();
        alist.add(idfObj.dateOfExperiment);
        this.mageIDFObject.setDateofExperiment(alist);
        this.mageIDFObject.setExperimentalDesign(idfObj.experimentalDesign);
        this.mageIDFObject.setExperimentalFactorName(idfObj.experimentalFactorName);
        this.mageIDFObject.setExperimentalFactorTermSourceRef(idfObj.experimentalFactorTermSourceREF);
        this.mageIDFObject.setExperimentalFactorTypes(idfObj.experimentalFactorType);
        alist = new ArrayList();
        alist.add(idfObj.experimentDescription);
        this.mageIDFObject.setExperimentDescription(alist);
        alist = new ArrayList();
        alist.add(idfObj.investigationTitle);
        this.mageIDFObject.setInvestigationTitle(alist);
        this.mageIDFObject.setNormalizationTermSourceRef(idfObj.normalizationTermSourceREF);
        this.mageIDFObject.setNormalizationType(idfObj.normalizationType);
        this.mageIDFObject.setPersonAddress(idfObj.personAddress);
        this.mageIDFObject.setPersonAffiliation(idfObj.personAffiliation);
        this.mageIDFObject.setPersonEmail(idfObj.personEmail);
        this.mageIDFObject.setPersonFax(idfObj.personFax);
        this.mageIDFObject.setPersonFirstName(idfObj.personFirstName);
        this.mageIDFObject.setPersonLastName(idfObj.personLastName);
        this.mageIDFObject.setPersonMidInitials(idfObj.personMidInitials);
        this.mageIDFObject.setPersonPhone(idfObj.personPhone);
        this.mageIDFObject.setPersonRoles(idfObj.personRoles);
        this.mageIDFObject.setPersonRolesTermSourceREF(idfObj.personRolesTermSourceREF);
        this.mageIDFObject.setProtocolContact(idfObj.protocolContact);
        this.mageIDFObject.setProtocolDescription(idfObj.protocolDescription);
        this.mageIDFObject.setProtocolHardware(idfObj.protocolHardware);
        this.mageIDFObject.setProtocolSoftware(idfObj.protocolSoftware);
        this.mageIDFObject.setProtocolTermSourceRef(idfObj.protocolTermSourceREF);
        this.mageIDFObject.setProtocolType(idfObj.protocolType);
        this.mageIDFObject.setPublicationAuthorList(idfObj.publicationAuthorList);
        this.mageIDFObject.setPublicationDOI(idfObj.publicationDOI);
        this.mageIDFObject.setPublicationStatus(idfObj.publicationStatus);
        this.mageIDFObject.setPublicationStatusTermSourceRef(idfObj.publicationStatusTermSourceREF);
        this.mageIDFObject.setPublicationTitle(idfObj.publicationTitle);
        alist = new ArrayList();
        alist.add(idfObj.publicReleaseDate);
        this.mageIDFObject.setPublicReleaseDate(alist);
        this.mageIDFObject.setPubMedID(idfObj.pubMedId);
        this.mageIDFObject.setQualityControlTermSourceRef(idfObj.qualityControlTermSourceREF);
        this.mageIDFObject.setQualityControlType(idfObj.qualityControlType);
        this.mageIDFObject.setReplicateType(idfObj.replicateType);
        this.mageIDFObject.setReplicateTypeTermSourceRef(idfObj.replicateTermSourceREF);
        String fname = (String)idfObj.sdrfFile.get(0);
        alist = new ArrayList();
        alist.add(fname);
        this.mageIDFObject.setSDRFFile(alist);
        this.mageIDFObject.setTermSourceFile(idfObj.termSourceFile);
        this.mageIDFObject.setTermSourceName(idfObj.termSourceName);
        this.mageIDFObject.setTermSourceVersion(idfObj.termSourceVersion);
        this.mav.setIDF(this.mageIDFObject);
    }

    public Point guessFirstExpressionCell(Vector<Vector<String>> dataVector) {
        int guessCol = 0;
        int guessRow = 0;
        Vector<String> lastRow = dataVector.get(dataVector.size() - 1);
        for (int j = lastRow.size() - 2; j >= 0; --j) {
            String thisEntry = lastRow.get(j);
            try {
                Float temp = new Float(thisEntry);
                continue;
            }
            catch (Exception e) {
                guessCol = j + 1;
                break;
            }
        }
        for (int i = dataVector.size() - 1; i >= 0; --i) {
            Vector<String> thisRow = dataVector.get(i);
            try {
                String thisEntry = thisRow.get(guessCol);
                Float temp = new Float(thisEntry);
                continue;
            }
            catch (Exception e) {
                guessRow = i + 1;
                break;
            }
        }
        return new Point(guessRow, guessCol);
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    public String getSDRFFilePath() {
        return this.SDRFFilePath;
    }

    public void setSDRFFilePath(String filePath) {
        this.SDRFFilePath = filePath;
    }

    public String getIDFFilePath() {
        return this.IDFFilePath;
    }

    public void setIDFFilePath(String filePath) {
        this.IDFFilePath = filePath;
    }

    private class MAGETABFileLoaderPanel
    extends JPanel {
        JPanel fileSelectionPanel;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel channelPanel;
        JPanel dataTypePanel;
        public JPanel oneChannelDataTypes;
        public JPanel twoChannelDataTypes;
        JPanel channelButtonPanel;
        JTextField selectedIDF;
        JTextField selectedSDRF;
        JTextField selectedADF;
        JTextField selectedDataMatrix;
        ButtonGroup channelButtonGroup;
        JRadioButton oneChannelRadioButton;
        JRadioButton twoChannelRadioButton;
        JPanel annotationPanel;
        JPanel mainPanel;
        JLabel IDFSelectionLabel;
        JLabel SDRFSelectionLabel;
        JLabel dataSelection;
        JLabel signalLabel;
        JLabel dye1Label;
        JLabel dye2Label;
        JLabel ratioLabel;
        JLabel pValueLabel;
        JLabel detectionLabel;
        JComboBox signalComboBox;
        JComboBox dye1ComboBox;
        JComboBox dye2ComboBox;
        JComboBox ratioComboBox;
        JComboBox pValueComboBox;
        JComboBox detectionComboBox;
        JButton browseButton1;
        protected EventListener eventListener;
        JButton IDFbrowseButton1;
        protected EventListener IDFeventListener;
        JButton SDRFbrowseButton1;
        protected EventListener SDRFeventListener;
        JPanel fileLoaderPanel;
        private int xRow = -1;
        private int xColumn = -1;
        AnnotationDownloadHandler adh;

        public MAGETABFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.adh = new AnnotationDownloadHandler(MAGETABFileLoader.this.superLoader.viewer.getResourceManager(), MAGETABFileLoader.this.superLoader.annotationLists, MAGETABFileLoader.this.superLoader.defaultSpeciesName, MAGETABFileLoader.this.superLoader.defaultArrayName);
            this.IDFeventListener = new EventListener();
            this.SDRFeventListener = new EventListener();
            this.eventListener = new EventListener();
            this.selectedDataMatrix = new JTextField(50);
            this.selectedDataMatrix.setEditable(true);
            this.selectedDataMatrix.setForeground(Color.black);
            this.selectedDataMatrix.setFont(new Font("monospaced", 1, 12));
            this.selectedIDF = new JTextField(50);
            this.selectedIDF.setEditable(true);
            this.selectedIDF.setForeground(Color.black);
            this.selectedIDF.setFont(new Font("monospaced", 1, 12));
            this.selectedSDRF = new JTextField(50);
            this.selectedSDRF.setEditable(true);
            this.selectedSDRF.setForeground(Color.black);
            this.selectedSDRF.setFont(new Font("monospaced", 1, 12));
            this.IDFSelectionLabel = new JLabel();
            this.IDFSelectionLabel.setForeground(Color.BLACK);
            String IDFTypeChoices = "<html> Select IDF </html>";
            this.IDFSelectionLabel.setText(IDFTypeChoices);
            this.SDRFSelectionLabel = new JLabel();
            this.SDRFSelectionLabel.setForeground(Color.BLACK);
            String SDRFTypeChoices = "<html> Select SDRF </html>";
            this.SDRFSelectionLabel.setText(SDRFTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select data matrix file</html>";
            this.dataSelection.setText(chooseFile);
            this.IDFbrowseButton1 = new JButton("Browse");
            this.IDFbrowseButton1.addActionListener(this.IDFeventListener);
            this.IDFbrowseButton1.setSize(100, 30);
            this.IDFbrowseButton1.setPreferredSize(new Dimension(100, 30));
            this.SDRFbrowseButton1 = new JButton("Browse");
            this.SDRFbrowseButton1.addActionListener(this.SDRFeventListener);
            this.SDRFbrowseButton1.setSize(100, 30);
            this.SDRFbrowseButton1.setPreferredSize(new Dimension(100, 30));
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(this.eventListener);
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (MAGE-TAB Format Files)"));
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.IDFSelectionLabel, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedIDF, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.IDFbrowseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.SDRFSelectionLabel, 0, 1, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedSDRF, 1, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.SDRFbrowseButton1, 2, 1, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 2, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedDataMatrix, 1, 2, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 2, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.annotationPanel = this.adh.getAnnotationLoaderPanel(MAGETABFileLoader.this.gba);
            this.channelPanel = new JPanel();
            this.channelPanel.setLayout(new GridBagLayout());
            this.channelPanel.setBorder(new TitledBorder(new EtchedBorder(), "Select Channel Data"));
            this.channelButtonGroup = new ButtonGroup();
            this.oneChannelRadioButton = new JRadioButton("1 Channel", true);
            this.oneChannelRadioButton.addActionListener(new EventListener());
            this.channelButtonGroup.add(this.oneChannelRadioButton);
            this.twoChannelRadioButton = new JRadioButton("2 Channels");
            this.twoChannelRadioButton.addActionListener(new EventListener());
            this.channelButtonGroup.add(this.twoChannelRadioButton);
            this.channelButtonPanel = new JPanel();
            this.channelButtonPanel.setLayout(new GridBagLayout());
            this.channelButtonPanel.add(this.oneChannelRadioButton);
            this.channelButtonPanel.add(this.twoChannelRadioButton);
            MAGETABFileLoader.this.gba.add(this.channelButtonPanel, this.oneChannelRadioButton, 0, 0, 1, 1, 0, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.channelButtonPanel, this.twoChannelRadioButton, 0, 1, 1, 1, 0, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            this.dataTypePanel = new JPanel();
            this.oneChannelDataTypes = new JPanel();
            this.oneChannelDataTypes.setLayout(new GridBagLayout());
            this.signalLabel = new JLabel("Signal");
            this.pValueLabel = new JLabel("p-value");
            this.detectionLabel = new JLabel("P/A Call");
            this.signalComboBox = new JComboBox();
            this.signalComboBox.addActionListener(this.eventListener);
            this.pValueComboBox = new JComboBox();
            this.pValueComboBox.addActionListener(this.eventListener);
            this.detectionComboBox = new JComboBox();
            this.detectionComboBox.addActionListener(this.eventListener);
            this.signalLabel.setPreferredSize(new Dimension(200, 20));
            this.pValueLabel.setPreferredSize(new Dimension(200, 20));
            this.detectionLabel.setPreferredSize(new Dimension(200, 20));
            this.signalComboBox.setPreferredSize(new Dimension(200, 20));
            this.pValueComboBox.setPreferredSize(new Dimension(200, 20));
            this.detectionComboBox.setPreferredSize(new Dimension(200, 20));
            MAGETABFileLoader.this.gba.add(this.oneChannelDataTypes, this.signalLabel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.oneChannelDataTypes, this.detectionLabel, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.oneChannelDataTypes, this.pValueLabel, 2, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.oneChannelDataTypes, this.signalComboBox, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.oneChannelDataTypes, this.detectionComboBox, 1, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.oneChannelDataTypes, this.pValueComboBox, 2, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            this.twoChannelDataTypes = new JPanel();
            this.twoChannelDataTypes.setLayout(new GridBagLayout());
            this.dye1Label = new JLabel("Intensity 1");
            this.dye2Label = new JLabel("Intensity 2");
            this.ratioLabel = new JLabel("Ratio / Log(ratio)");
            this.dye1ComboBox = new JComboBox();
            this.dye1ComboBox.addActionListener(this.eventListener);
            this.dye2ComboBox = new JComboBox();
            this.dye2ComboBox.addActionListener(this.eventListener);
            this.ratioComboBox = new JComboBox();
            this.ratioComboBox.addActionListener(this.eventListener);
            this.dye1Label.setPreferredSize(new Dimension(200, 20));
            this.dye2Label.setPreferredSize(new Dimension(200, 20));
            this.ratioLabel.setPreferredSize(new Dimension(200, 20));
            this.dye1ComboBox.setPreferredSize(new Dimension(200, 20));
            this.dye2ComboBox.setPreferredSize(new Dimension(200, 20));
            this.ratioComboBox.setPreferredSize(new Dimension(200, 20));
            MAGETABFileLoader.this.gba.add(this.twoChannelDataTypes, this.dye1Label, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.twoChannelDataTypes, this.dye2Label, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.twoChannelDataTypes, this.ratioLabel, 2, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.twoChannelDataTypes, this.dye1ComboBox, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.twoChannelDataTypes, this.dye2ComboBox, 1, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.twoChannelDataTypes, this.ratioComboBox, 2, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            if (this.oneChannelRadioButton.isSelected()) {
                this.dataTypePanel.add(this.oneChannelDataTypes);
            } else {
                this.dataTypePanel.add(this.twoChannelDataTypes);
            }
            this.dataTypePanel.validate();
            MAGETABFileLoader.this.gba.add(this.channelPanel, this.channelButtonPanel, 0, 0, 1, 2, 0, 0, 0, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.channelPanel, this.dataTypePanel, 1, 0, 5, 2, 1, 1, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            MAGETABFileLoader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable = new JTable();
            this.expressionTable.setDefaultRenderer(Object.class, MAGETABFileLoader.this.myCellRenderer);
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    MAGETABFileLoaderPanel.this.setSelectedCell(MAGETABFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), MAGETABFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>Select the appropriate number of channels, then select appropriate data columns from the dropdown lists.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            MAGETABFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            MAGETABFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileLoaderPanel, this.annotationPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileLoaderPanel, this.channelPanel, 0, 4, 1, 2, 3, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 7, 1, 6, 3, 6, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            MAGETABFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        }

        public boolean isAnnotationSelected() {
            return this.adh.isAnnotationSelected();
        }

        public String getAnnFilePath() {
            return this.adh.getAnnFilePath();
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            MAGETABFileLoader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            MAGETABFileLoader.this.checkLoadEnable();
        }

        public void openDataPath() {
        }

        public void onBrowse(String fileType) {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            File dir = new File(TMEV.getDataPath());
            fileChooser.setCurrentDirectory(dir);
            if (fileType.equalsIgnoreCase("IDF")) {
                fileChooser.setDialogTitle("Select IDF");
            } else if (fileType.equalsIgnoreCase("SDRF")) {
                fileChooser.setDialogTitle("Select SDRF");
            } else if (fileType.equalsIgnoreCase("ADF")) {
                fileChooser.setDialogTitle("Select ADF");
            } else if (fileType.equalsIgnoreCase("DATA")) {
                fileChooser.setDialogTitle("Select Data Matrix");
            }
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                String testName;
                File selectedFile = fileChooser.getSelectedFile();
                String fileName = selectedFile.getAbsolutePath();
                String baseName = "";
                String textS = "";
                if (fileType.equalsIgnoreCase("IDF")) {
                    this.selectedIDF.setText(fileName);
                    this.selectedIDF.setForeground(Color.BLACK);
                    if (fileName.endsWith("idf.txt")) {
                        textS = "idf.txt";
                    } else if (fileName.endsWith("IDF.txt")) {
                        textS = "IDF.txt";
                    }
                    if (selectedFile.exists()) {
                        MAGETABFileLoader.this.setIDFFilePath(selectedFile.getAbsolutePath());
                    }
                } else if (fileType.equalsIgnoreCase("SDRF")) {
                    this.selectedSDRF.setText(selectedFile.getAbsolutePath());
                    this.selectedSDRF.setForeground(Color.BLACK);
                    if (fileName.endsWith("sdrf.txt")) {
                        textS = "sdrf.txt";
                    } else if (fileName.endsWith("SDRF.txt")) {
                        textS = "SDRF.txt";
                    }
                } else if (fileType.equalsIgnoreCase("ADF")) {
                    this.selectedADF.setText(selectedFile.getAbsolutePath());
                    this.selectedADF.setForeground(Color.BLACK);
                    if (fileName.endsWith("adf.txt")) {
                        textS = "adf.txt";
                    } else if (fileName.endsWith("ADF.txt")) {
                        textS = "ADF.txt";
                    }
                } else if (fileType.equalsIgnoreCase("DATA")) {
                    this.selectedDataMatrix.setText(selectedFile.getAbsolutePath());
                    this.selectedDataMatrix.setForeground(Color.BLACK);
                    if (fileName.endsWith("data.txt")) {
                        textS = "data.txt";
                    } else if (fileName.endsWith("DATA.txt")) {
                        textS = "DATA.txt";
                    }
                } else {
                    baseName = new String("Logic error; you will have to select each file .");
                }
                baseName = fileName.substring(0, fileName.lastIndexOf(textS));
                if (this.selectedSDRF.getText().equals("") || this.selectedSDRF.getForeground().equals(Color.RED)) {
                    testName = baseName + "sdrf.txt";
                    this.selectedSDRF.setText(testName);
                    File testSDRF = new File(testName);
                    if (!testSDRF.exists()) {
                        this.selectedSDRF.setText("File " + testName + " does not exist.");
                        this.selectedSDRF.setForeground(Color.RED);
                        MAGETABFileLoader.this.setLoadEnabled(false);
                    } else {
                        this.selectedSDRF.setForeground(Color.BLACK);
                    }
                }
                if (this.selectedIDF.getText().equals("") || this.selectedIDF.getForeground().equals(Color.RED)) {
                    testName = baseName + "idf.txt";
                    this.selectedIDF.setText(testName);
                    File testIDF = new File(testName);
                    if (!testIDF.exists()) {
                        this.selectedIDF.setText("File " + testName + " does not exist.");
                        this.selectedIDF.setForeground(Color.RED);
                        MAGETABFileLoader.this.setLoadEnabled(false);
                    } else {
                        this.selectedIDF.setForeground(Color.BLACK);
                    }
                }
                if (this.selectedDataMatrix.getText().equals("") || this.selectedDataMatrix.getForeground().equals(Color.RED)) {
                    testName = baseName + "data.txt";
                    this.selectedDataMatrix.setText(testName);
                    File dataFile = new File(testName);
                    if (!dataFile.exists()) {
                        this.selectedDataMatrix.setText("File " + testName + " does not exist.");
                        this.selectedDataMatrix.setForeground(Color.RED);
                        MAGETABFileLoader.this.setLoadEnabled(false);
                    } else {
                        this.selectedDataMatrix.setForeground(Color.BLACK);
                        MAGETABFileLoader.this.processAffyGCOSFile(dataFile);
                    }
                } else {
                    File dataFile = new File(this.selectedDataMatrix.getText());
                    MAGETABFileLoader.this.processAffyGCOSFile(dataFile);
                }
                if (((MAGETABFileLoader)MAGETABFileLoader.this).sflp.signalComboBox.equals("none") && ((MAGETABFileLoader)MAGETABFileLoader.this).sflp.ratioComboBox.equals("none") && ((MAGETABFileLoader)MAGETABFileLoader.this).sflp.dye1ComboBox.equals("none") && ((MAGETABFileLoader)MAGETABFileLoader.this).sflp.dye2ComboBox.equals("none")) {
                    MAGETABFileLoader.this.setLoadEnabled(false);
                } else {
                    MAGETABFileLoader.this.setLoadEnabled(true);
                }
            }
            dir = fileChooser.getCurrentDirectory();
            String pathName = dir.getPath();
            TMEV.setDataPath(pathName);
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void setDataFileName(String fileName) {
            this.selectedDataMatrix.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String fieldsText) {
        }

        public class EventListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == MAGETABFileLoaderPanel.this.browseButton1) {
                    String fileType = "DATA";
                    MAGETABFileLoaderPanel.this.onBrowse(fileType);
                } else if (source == MAGETABFileLoaderPanel.this.IDFbrowseButton1) {
                    String fileType = "IDF";
                    MAGETABFileLoaderPanel.this.onBrowse(fileType);
                } else if (source == MAGETABFileLoaderPanel.this.SDRFbrowseButton1) {
                    String fileType = "SDRF";
                    MAGETABFileLoaderPanel.this.onBrowse(fileType);
                } else if (source == MAGETABFileLoaderPanel.this.signalComboBox) {
                    String columnHeader = (String)MAGETABFileLoaderPanel.this.signalComboBox.getSelectedItem();
                    if (columnHeader != null) {
                        if (!columnHeader.equals("none")) {
                            MAGETABFileLoader.this.columnDataTypes.put("MEV:signal", columnHeader);
                            MAGETABFileLoader.this.columnDataTypes.put(columnHeader, "signal");
                        } else {
                            try {
                                String header = MAGETABFileLoader.this.columnDataTypes.get("MEV:signal");
                                MAGETABFileLoader.this.columnDataTypes.put(header, "none");
                                MAGETABFileLoader.this.columnDataTypes.remove("MEV:signal");
                            }
                            catch (NullPointerException npe) {}
                        }
                    }
                } else if (source == MAGETABFileLoaderPanel.this.detectionComboBox) {
                    String columnHeader = (String)MAGETABFileLoaderPanel.this.detectionComboBox.getSelectedItem();
                    if (columnHeader != null) {
                        if (!columnHeader.equals("none")) {
                            MAGETABFileLoader.this.columnDataTypes.put("MEV:detection", columnHeader);
                            MAGETABFileLoader.this.columnDataTypes.put(columnHeader, "detection");
                        } else {
                            try {
                                String header = MAGETABFileLoader.this.columnDataTypes.get("MEV:detection");
                                MAGETABFileLoader.this.columnDataTypes.put(header, "none");
                                MAGETABFileLoader.this.columnDataTypes.remove("MEV:detection");
                            }
                            catch (NullPointerException npe) {}
                        }
                    }
                } else if (source == MAGETABFileLoaderPanel.this.pValueComboBox) {
                    String columnHeader = (String)MAGETABFileLoaderPanel.this.pValueComboBox.getSelectedItem();
                    if (columnHeader != null) {
                        if (!columnHeader.equals("none")) {
                            MAGETABFileLoader.this.columnDataTypes.put("MEV:pvalue", columnHeader);
                            MAGETABFileLoader.this.columnDataTypes.put(columnHeader, "pvalue");
                        } else {
                            try {
                                String header = MAGETABFileLoader.this.columnDataTypes.get("MEV:pvalue");
                                MAGETABFileLoader.this.columnDataTypes.put(header, "none");
                                MAGETABFileLoader.this.columnDataTypes.remove("MEV:pvalue");
                            }
                            catch (NullPointerException npe) {}
                        }
                    }
                } else if (source == MAGETABFileLoaderPanel.this.dye1ComboBox) {
                    String columnHeader = (String)MAGETABFileLoaderPanel.this.dye1ComboBox.getSelectedItem();
                    if (columnHeader != null) {
                        if (!columnHeader.equals("none")) {
                            MAGETABFileLoader.this.columnDataTypes.put("MEV:channel1", columnHeader);
                            MAGETABFileLoader.this.columnDataTypes.put(columnHeader, "channel1");
                        } else {
                            try {
                                String header = MAGETABFileLoader.this.columnDataTypes.get("MEV:channel1");
                                MAGETABFileLoader.this.columnDataTypes.put(header, "none");
                                MAGETABFileLoader.this.columnDataTypes.remove("MEV:channel1");
                            }
                            catch (NullPointerException npe) {}
                        }
                    }
                } else if (source == MAGETABFileLoaderPanel.this.dye2ComboBox) {
                    String columnHeader = (String)MAGETABFileLoaderPanel.this.dye2ComboBox.getSelectedItem();
                    if (columnHeader != null) {
                        if (!columnHeader.equals("none")) {
                            MAGETABFileLoader.this.columnDataTypes.put("MEV:channel2", columnHeader);
                            MAGETABFileLoader.this.columnDataTypes.put(columnHeader, "channel2");
                        } else {
                            try {
                                String header = MAGETABFileLoader.this.columnDataTypes.get("MEV:channel2");
                                MAGETABFileLoader.this.columnDataTypes.put(header, "none");
                                MAGETABFileLoader.this.columnDataTypes.remove("MEV:channel2");
                            }
                            catch (NullPointerException npe) {}
                        }
                    }
                } else if (source == MAGETABFileLoaderPanel.this.ratioComboBox) {
                    String columnHeader = (String)MAGETABFileLoaderPanel.this.ratioComboBox.getSelectedItem();
                    if (columnHeader != null) {
                        if (columnHeader.contains("Log") || columnHeader.contains("log") || columnHeader.contains("LOG")) {
                            MAGETABFileLoader.this.columnDataTypes.put("MEV:log", columnHeader);
                            MAGETABFileLoader.this.columnDataTypes.put(columnHeader, "log");
                        } else if (!columnHeader.equals("none")) {
                            MAGETABFileLoader.this.columnDataTypes.put("MEV:ratio", columnHeader);
                            MAGETABFileLoader.this.columnDataTypes.put(columnHeader, "ratio");
                        } else {
                            try {
                                String header = MAGETABFileLoader.this.columnDataTypes.get("MEV:log");
                                MAGETABFileLoader.this.columnDataTypes.put(header, "none");
                                MAGETABFileLoader.this.columnDataTypes.remove("MEV:log");
                                header = MAGETABFileLoader.this.columnDataTypes.get("MEV:ratio");
                                MAGETABFileLoader.this.columnDataTypes.put(header, "none");
                                MAGETABFileLoader.this.columnDataTypes.remove("MEV:ratio");
                            }
                            catch (NullPointerException npe) {}
                        }
                    }
                } else if (source == MAGETABFileLoaderPanel.this.oneChannelRadioButton) {
                    MAGETABFileLoader.this.refillDataTypeTable();
                } else if (source == MAGETABFileLoaderPanel.this.twoChannelRadioButton) {
                    MAGETABFileLoader.this.refillDataTypeTable();
                }
            }
        }
    }

    public static enum matrixType {
        NONE,
        INTENSITY,
        DETECTION,
        PVALUE,
        LOG_RATIO,
        RATIO,
        CHANNEL1,
        CHANNEL2,
        INTENSITY_DETECTION,
        INTENSITY_DETECT_PVAL,
        LOG_CHANNELS,
        RATIO_CHANNELS,
        CHANNELS,
        INTENSITY_PVAL;

    }
}

