/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.util.StringSplitter;

public class GenepixFileParser
extends Thread {
    private final int FIRST_NUM = 1;
    private final String BLOCK = "\"Block\"";
    private final String BLOCK_N = "Block";
    private final String COLUMN = "\"Column\"";
    private final String COLUMN_N = "Column";
    private final String F_PIX = "\"F Pixels\"";
    private final String F_PIX_N = "F Pixels";
    private final String ID = "\"ID\"";
    private final String ID_N = "ID";
    private final String NAME = "\"Name\"";
    private final String NAME_N = "Name";
    private final String RW = "\"Row\"";
    private final String ROW_N = "Row";
    private final String WAVE_KEY_1 = "ImageName";
    private final String WAVE_KEY_2 = "Wavelengths";
    private final String FLAGS = "\"Flags\"";
    private final String FLAGS_N = "Flags";
    private boolean ready;
    private boolean hasError;
    private File gprFile;
    private int taskEnd;
    private int counter;
    private int fPixAddr;
    private String errorMsg;
    private String chA;
    private String chB;
    private String chAn;
    private String chBn;
    private String chAs;
    private String chAsn;
    private String chBs;
    private String chBsn;
    private String bgChA;
    private String bgChB;
    private String bgChAn;
    private String bgChBn;
    private Vector tavFile;

    public GenepixFileParser() {
        this(new String(""));
    }

    public GenepixFileParser(String genepixFileName) {
        this(new File(genepixFileName));
    }

    public GenepixFileParser(File genepixFile) {
        this(genepixFile, false);
    }

    public GenepixFileParser(String genepixFileName, boolean useThread) {
        this(new File(genepixFileName), useThread);
    }

    public GenepixFileParser(File genepixFile, boolean useThread) {
        if (genepixFile != null) {
            this.gprFile = genepixFile;
            this.errorMsg = new String("");
            this.ready = false;
            this.hasError = false;
            this.taskEnd = 0;
            if (!useThread) {
                this.startLoad();
            }
        }
    }

    public int getCurrentStep() {
        return this.counter;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public int getProgressEnd() {
        return this.taskEnd;
    }

    public Vector getTavFile() {
        return this.tavFile;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean isCompleted() {
        return this.ready;
    }

    @Override
    public void run() {
        this.startLoad();
    }

    public static void main(String[] args) {
        if (args != null) {
            GenepixFileParser genepixFileLoader1 = new GenepixFileParser(args[0]);
        } else {
            GenepixFileParser genepixFileParser = new GenepixFileParser();
        }
    }

    private String calculateDensity(String[] tuple, int med, int sat, int backg) {
        String den = new String("");
        float fMedian = Float.parseFloat(tuple[med]);
        float bMedian = Float.parseFloat(tuple[backg]);
        float fPix = Float.parseFloat(tuple[this.fPixAddr]);
        float fSat = Float.parseFloat(tuple[sat]);
        int temp = (int)(fPix * (fMedian - bMedian) * (1.0f - (fSat /= 100.0f)));
        den = den + temp;
        return den;
    }

    private void defineKeys(String[] wvs) {
        this.chA = new String("\"F" + wvs[0] + " Median\"");
        this.chB = new String("\"F" + wvs[1] + " Median\"");
        this.chAs = new String("\"F" + wvs[0] + " % Sat.\"");
        this.chBs = new String("\"F" + wvs[1] + " % Sat.\"");
        this.bgChA = new String("\"B" + wvs[0] + " Median\"");
        this.bgChB = new String("\"B" + wvs[1] + " Median\"");
        this.chAn = new String("F" + wvs[0] + " Median");
        this.chBn = new String("F" + wvs[1] + " Median");
        this.chAsn = new String("F" + wvs[0] + " % Sat.");
        this.chBsn = new String("F" + wvs[1] + " % Sat.");
        this.bgChAn = new String("B" + wvs[0] + " Median");
        this.bgChBn = new String("B" + wvs[1] + " Median");
    }

    private int findRightCol(String[] str, String key, String noQuato) {
        int addr = 0;
        int size = str.length;
        String temp = new String("");
        for (int i = 0; i < str.length; ++i) {
            if (!str[i].equalsIgnoreCase(key) && !str[i].equalsIgnoreCase(noQuato)) continue;
            addr = i;
            i = str.length;
        }
        return addr;
    }

    private String[] getWaveLengths(String str) {
        String[] tempWave = new String[2];
        String wavStr = new String(str.substring(str.indexOf(61) + 1, str.lastIndexOf(34)));
        StringTokenizer token = new StringTokenizer(wavStr);
        int num = 0;
        while (token.hasMoreTokens()) {
            String wv = token.nextToken();
            if (!this.isNumber(wv)) continue;
            tempWave[num] = new String(wv);
            ++num;
        }
        return tempWave;
    }

    private boolean isChar(char x) {
        boolean b = true;
        switch (x) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                b = false;
                break;
            }
            default: {
                b = true;
            }
        }
        return b;
    }

    private boolean isNumber(String x) {
        boolean b = true;
        int length = x.length();
        for (int i = 0; i < length; ++i) {
            if (!this.isChar(x.charAt(i))) continue;
            b = false;
            i = length;
        }
        return b;
    }

    private boolean isWaveLengthDefination(String str) {
        String temp = str;
        if (temp.charAt(0) == '\"' && temp.indexOf(61) > 0) {
            return (temp = temp.substring(1, temp.indexOf(61))).equalsIgnoreCase("ImageName") || temp.equalsIgnoreCase("Wavelengths");
        }
        return false;
    }

    private Vector readGenePixFile() {
        BufferedReader buf = null;
        Vector<String> temp = new Vector<String>(2000, 500);
        String aLine = new String("");
        try {
            FileInputStream fileInput = new FileInputStream(this.gprFile);
            buf = new BufferedReader(new InputStreamReader(fileInput));
        }
        catch (IOException ex) {
            this.hasError = true;
            this.errorMsg = "Failed to open " + this.gprFile.getName() + ": " + ex.getMessage();
            return temp;
        }
        try {
            while ((aLine = buf.readLine()) != null) {
                temp.add(aLine);
            }
        }
        catch (IOException e) {
            this.hasError = true;
            this.errorMsg = "Failed to read " + this.gprFile.getName() + ": " + e.getMessage();
            temp.removeAllElements();
            return temp;
        }
        return temp;
    }

    private String removeAllEndSpaces(String str) {
        String temp;
        block1: {
            temp = new String(str);
            if (temp.length() <= 0) break block1;
            while (temp.charAt(temp.length() - 1) == ' ' && (temp = temp.substring(0, temp.length() - 1)).length() > 0) {
            }
        }
        return temp;
    }

    private String removeAllHeadSpaces(String str) {
        String temp;
        block1: {
            boolean spc = false;
            temp = new String(str);
            int length = temp.length();
            if (length <= 0) break block1;
            while (temp.charAt(0) == ' ' && (temp = temp.substring(1)).length() > 0) {
            }
        }
        return temp;
    }

    private String[] separateLine(String str) {
        String tempStr = new String("");
        StringSplitter spliter = new StringSplitter('\t');
        spliter.init(str);
        int num = spliter.countTokens() + 1;
        int length = 0;
        String[] name = new String[num];
        if (num > 1) {
            while (spliter.hasMoreTokens()) {
                tempStr = spliter.nextToken();
                tempStr = this.removeAllEndSpaces(tempStr);
                tempStr = this.removeAllHeadSpaces(tempStr);
                name[length++] = tempStr;
            }
        }
        return name;
    }

    private void startLoad() {
        String aLine = new String("");
        String densA = new String("");
        String densB = new String("");
        String name = new String("");
        String id = new String("");
        String[] waves = new String[2];
        int max = 0;
        int maxRow = 0;
        int maxCol = 0;
        Vector gprFileContents = this.readGenePixFile();
        this.taskEnd = gprFileContents.size();
        if (this.taskEnd <= 0) {
            return;
        }
        this.counter = 0;
        boolean noError = true;
        int fSize = gprFileContents.size();
        int hLines = 0;
        boolean going = true;
        while (going) {
            aLine = (String)gprFileContents.elementAt(hLines);
            if (aLine.charAt(0) == '\"' || this.isChar(aLine.charAt(0))) {
                if (this.isWaveLengthDefination(aLine)) {
                    waves = this.getWaveLengths(aLine);
                }
                going = true;
                ++hLines;
                continue;
            }
            if (hLines == 1) {
                going = true;
                ++hLines;
                continue;
            }
            going = false;
        }
        this.defineKeys(waves);
        aLine = (String)gprFileContents.elementAt(hLines - 1);
        String[] colNames = this.separateLine(aLine);
        int blockIndex = this.findRightCol(colNames, "\"Block\"", "Block");
        int colIndex = this.findRightCol(colNames, "\"Column\"", "Column");
        int rowIndex = this.findRightCol(colNames, "\"Row\"", "Row");
        int nameIndex = this.findRightCol(colNames, "\"Name\"", "Name");
        int idIndex = this.findRightCol(colNames, "\"ID\"", "ID");
        int flagIndex = this.findRightCol(colNames, "\"Flags\"", "Flags");
        aLine = (String)gprFileContents.elementAt(fSize - 1);
        String[] colValues = this.separateLine(aLine);
        if (colValues.length > 2) {
            max = Integer.parseInt(colValues[blockIndex]);
            maxCol = Integer.parseInt(colValues[colIndex]);
            maxRow = Integer.parseInt(colValues[rowIndex]);
        } else {
            JOptionPane.showMessageDialog(null, "You might add extra space at the end of file.\n(" + this.gprFile.getName() + "). \nPlease remove it and reload again.", "GenePix File Loader", 0);
            noError = false;
        }
        if (noError) {
            int maxMetaCol = max <= 12 ? 2 : 4;
            noError = true;
            if (noError) {
                this.fPixAddr = this.findRightCol(colNames, "\"F Pixels\"", "F Pixels");
                int f635m = this.findRightCol(colNames, this.chA, this.chAn);
                int f635s = this.findRightCol(colNames, this.chAs, this.chAsn);
                int b635m = this.findRightCol(colNames, this.bgChA, this.bgChAn);
                int f532m = this.findRightCol(colNames, this.chB, this.chBn);
                int f532s = this.findRightCol(colNames, this.chBs, this.chBsn);
                int b532m = this.findRightCol(colNames, this.bgChB, this.bgChBn);
                flagIndex = this.findRightCol(colNames, "\"Flags\"", "Flags");
                this.tavFile = new Vector(fSize - hLines, fSize - hLines >> 2);
                this.counter = hLines;
                for (int i = hLines; i < fSize; ++i) {
                    aLine = (String)gprFileContents.elementAt(i);
                    colValues = this.separateLine(aLine);
                    int block = Integer.parseInt(colValues[blockIndex]);
                    int col = Integer.parseInt(colValues[colIndex]);
                    int row = Integer.parseInt(colValues[rowIndex]);
                    int flag = Integer.parseInt(colValues[flagIndex]);
                    densA = this.calculateDensity(colValues, f532m, f532s, b532m);
                    densB = this.calculateDensity(colValues, f635m, f635s, b635m);
                    int metaRow = (block - 1) / maxMetaCol + 1;
                    int metaCol = (block - 1) % maxMetaCol + 1;
                    int slideRow = (metaRow - 1) * maxRow + row;
                    int slideCol = (metaCol - 1) * maxCol + col;
                    name = colValues[nameIndex];
                    id = colValues[idIndex];
                    Vector<Object> tavLine = new Vector<Object>(9);
                    tavLine.add(new Integer(densA));
                    tavLine.add(new Integer(densB));
                    tavLine.add(new Integer(slideRow));
                    tavLine.add(new Integer(slideCol));
                    tavLine.add(new Integer(metaRow));
                    tavLine.add(new Integer(metaCol));
                    tavLine.add(name);
                    tavLine.add(id);
                    tavLine.add(new Integer(flag));
                    this.tavFile.add(tavLine);
                    ++this.counter;
                }
                this.ready = true;
                this.counter = this.taskEnd;
            }
        }
    }
}

