/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.GenepixFileParser;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.FileLoaderUtility;

public class GenePixFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private GenePixFileLoaderPanel gpflp;
    private boolean loadEnabled = false;
    private MultipleArrayViewer mav;

    public GenePixFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.gpflp = new GenePixFileLoaderPanel();
    }

    @Override
    public void setFilePath(String path) {
        this.gpflp.pathTextField.setText(path);
        File fileDir = new File(path);
        File[] allFiles = fileDir.listFiles();
        Vector<File> v = new Vector<File>(allFiles.length);
        for (int i = 0; i < allFiles.length; ++i) {
            v.add(allFiles[i]);
        }
        this.processFileList(path, v);
    }

    @Override
    public int getDataType() {
        return 0;
    }

    public Vector loadExpressionFiles() throws IOException {
        Object[] genePixFiles = this.gpflp.getGenePixSelectedListModel().toArray();
        if (genePixFiles == null || genePixFiles.length < 1) {
            return null;
        }
        Vector<ISlideData> data = new Vector<ISlideData>();
        ISlideMetaData meta = null;
        this.setFilesCount(genePixFiles.length);
        this.setRemain(genePixFiles.length);
        for (int i = 0; i < genePixFiles.length; ++i) {
            File file;
            if (i == 0) {
                file = new File(this.gpflp.pathTextField.getText(), ((File)genePixFiles[i]).getName());
                data.add(this.loadSlideData(file));
                meta = (ISlideMetaData)data.elementAt(0);
            } else {
                file = new File(this.gpflp.pathTextField.getText(), ((File)genePixFiles[i]).getName());
                data.add(this.loadFloatSlideData(file, meta));
            }
            this.setFilesProgress(i + 1);
            if (i <= 0 || i % 10 != 0) continue;
            Runtime.getRuntime().gc();
        }
        if (data != null && data.size() > 0) {
            String[] fieldNames = new String[]{"Name", "ID"};
            meta.setFieldNames(fieldNames);
        }
        return data;
    }

    public ISlideData loadSlideData(File currentFile) {
        SlideData slideData = null;
        GenepixFileParser parser = new GenepixFileParser(currentFile, false);
        if (parser.isCompleted()) {
            Vector spotData;
            Vector data = parser.getTavFile();
            int[] rows = new int[3];
            int[] cols = new int[3];
            float[] intensity = new float[2];
            String[] moreFields = new String[2];
            int numElements = data.size();
            int maxRows = 0;
            int maxCols = 0;
            for (int i = 0; i < numElements; ++i) {
                spotData = (Vector)data.elementAt(i);
                maxRows = Math.max(maxRows, (Integer)spotData.elementAt(2));
                maxCols = Math.max(maxCols, (Integer)spotData.elementAt(3));
            }
            SampleAnnotation sampAnn = new SampleAnnotation();
            slideData = new SlideData(maxRows, maxCols, sampAnn);
            this.setLinesCount(numElements);
            for (int i = 0; i < numElements; ++i) {
                rows = new int[3];
                cols = new int[3];
                intensity = new float[2];
                moreFields = new String[2];
                spotData = (Vector)data.elementAt(i);
                intensity[0] = ((Integer)spotData.elementAt(0)).intValue();
                intensity[1] = ((Integer)spotData.elementAt(1)).intValue();
                rows[0] = (Integer)spotData.elementAt(2);
                cols[0] = (Integer)spotData.elementAt(3);
                rows[1] = 0;
                cols[1] = 0;
                rows[2] = (Integer)spotData.elementAt(4);
                cols[2] = (Integer)spotData.elementAt(5);
                moreFields[0] = (String)spotData.elementAt(6);
                moreFields[1] = (String)spotData.elementAt(7);
                int flag = (Integer)spotData.elementAt(8);
                SlideDataElement sde = new SlideDataElement(String.valueOf(i + 1), rows, cols, intensity, moreFields);
                sde.setGenePixFlags((Integer)spotData.elementAt(8));
                slideData.add((Object)sde);
                this.setFileProgress(i);
            }
            slideData.setSampleAnnotationLoaded(true);
            slideData.getSampleAnnotation().setAnnotation("Default Slide Name", currentFile.getName());
            this.mav.getData().setSampleAnnotationLoaded(true);
            slideData.setSlideDataName(currentFile.getName());
            slideData.setSlideFileName(currentFile.getPath());
        }
        return slideData;
    }

    public ISlideData loadFloatSlideData(File currentFile, ISlideMetaData meta) {
        FloatSlideData slideData = null;
        int m = 0;
        GenepixFileParser parser = new GenepixFileParser(currentFile, false);
        if (parser.isCompleted()) {
            SampleAnnotation sampAnn = new SampleAnnotation();
            slideData = new FloatSlideData(meta, sampAnn);
            Vector data = parser.getTavFile();
            int numElements = data.size();
            this.setLinesCount(numElements);
            for (int i = 0; i < numElements; ++i) {
                Vector spotData = (Vector)data.elementAt(i);
                float cy3 = ((Integer)spotData.elementAt(0)).intValue();
                float cy5 = ((Integer)spotData.elementAt(1)).intValue();
                spotData.elementAt(2);
                spotData.elementAt(6);
                slideData.setIntensities(i, cy3, cy5);
                spotData.elementAt(7);
                m = (Integer)spotData.elementAt(8);
                slideData.setGenePixFlags(i, m);
                this.setFileProgress(i);
            }
            slideData.setSampleAnnotationLoaded(true);
            slideData.getSampleAnnotation().setAnnotation("Default Slide Name", currentFile.getName());
            this.mav.getData().setSampleAnnotationLoaded(true);
            slideData.setSlideDataName(currentFile.getName());
            slideData.setSlideFileName(currentFile.getPath());
        }
        return slideData;
    }

    @Override
    public ISlideData loadExpressionFile(File f) throws IOException {
        return null;
    }

    public Vector loadAnnotationFile(File f) throws IOException {
        return new Vector();
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter genePixFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".gpr");
            }

            @Override
            public String getDescription() {
                return "GenePix Files (*.gpr)";
            }
        };
        return genePixFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean state) {
        this.loadEnabled = state;
        this.checkLoadEnable();
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.gpflp;
    }

    public void processFileList(String filePath, Vector fileNames) {
        this.gpflp.setPath(filePath);
        if (fileNames == null) {
            return;
        }
        FileFilter genePixFileFilter = this.getFileFilter();
        this.gpflp.getGenePixAvailableListModel().clear();
        for (int i = 0; i < fileNames.size(); ++i) {
            File targetFile = new File((String)fileNames.elementAt(i));
            if (!genePixFileFilter.accept(targetFile)) continue;
            this.gpflp.getGenePixAvailableListModel().addElement(new File((String)fileNames.elementAt(i)));
        }
    }

    @Override
    public String getFilePath() {
        if (this.gpflp.pathTextField == null) {
            return null;
        }
        return this.gpflp.pathTextField.getText();
    }

    @Override
    public void openDataPath() {
        this.gpflp.openDataPath();
    }

    @Override
    public String getAnnotationFilePath() {
        return null;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    private class GenePixFileLoaderPanel
    extends JPanel {
        JPanel selectionPanel;
        JPanel fileLoaderPanel;
        JPanel genePixSelectionPanel;
        JPanel selectFilePanel;
        JLabel selectFile;
        JButton browseButton1;
        JTextField pathTextField;
        JPanel genePixListPanel;
        JLabel genePixAvailableLabel;
        JLabel genePixSelectedLabel;
        JList genePixAvailableList;
        JList genePixSelectedList;
        JScrollPane genePixAvailableScrollPane;
        JScrollPane genePixSelectedScrollPane;
        JPanel genePixButtonPanel;
        JButton genePixAddButton;
        JButton genePixAddAllButton;
        JButton genePixRemoveButton;
        JButton genePixRemoveAllButton;

        public GenePixFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            this.genePixSelectionPanel = new JPanel();
            this.genePixSelectionPanel.setLayout(new GridBagLayout());
            this.genePixSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (GenePix Format Files)"));
            this.selectFilePanel = new JPanel();
            this.selectFilePanel.setLayout(new GridBagLayout());
            this.selectFile = new JLabel("Select expression data directory");
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.setSize(new Dimension(100, 30));
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.browseButton1.addActionListener(new EventHandler());
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            GenePixFileLoader.this.gba.add(this.selectFilePanel, this.selectFile, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.selectFilePanel, this.pathTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.selectFilePanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.genePixListPanel = new JPanel();
            this.genePixListPanel.setLayout(new GridBagLayout());
            this.genePixAvailableLabel = new JLabel("Available");
            this.genePixSelectedLabel = new JLabel("Selected");
            this.genePixAvailableList = new JList(new DefaultListModel());
            this.genePixSelectedList = new JList(new DefaultListModel());
            this.genePixAvailableScrollPane = new JScrollPane(this.genePixAvailableList);
            this.genePixSelectedScrollPane = new JScrollPane(this.genePixSelectedList);
            this.genePixButtonPanel = new JPanel();
            this.genePixButtonPanel.setLayout(new GridBagLayout());
            this.genePixAddButton = new JButton("Add");
            this.genePixAddButton.setPreferredSize(new Dimension(100, 20));
            this.genePixAddButton.addActionListener(new EventHandler());
            this.genePixAddAllButton = new JButton("Add All");
            this.genePixAddAllButton.setPreferredSize(new Dimension(100, 20));
            this.genePixAddAllButton.addActionListener(new EventHandler());
            this.genePixRemoveButton = new JButton("Remove");
            this.genePixRemoveButton.setPreferredSize(new Dimension(100, 20));
            this.genePixRemoveButton.addActionListener(new EventHandler());
            this.genePixRemoveAllButton = new JButton("Remove All");
            this.genePixRemoveAllButton.setPreferredSize(new Dimension(100, 20));
            this.genePixRemoveAllButton.addActionListener(new EventHandler());
            this.genePixAddAllButton.setFocusPainted(false);
            this.genePixAddButton.setFocusPainted(false);
            this.genePixRemoveAllButton.setFocusPainted(false);
            this.genePixRemoveButton.setFocusPainted(false);
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixButtonPanel, this.genePixRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixListPanel, this.genePixSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixSelectionPanel, this.selectFilePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.genePixSelectionPanel, this.genePixListPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this.selectionPanel, this.genePixSelectionPanel, 0, 1, 2, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            GenePixFileLoader.this.gba.add(this.fileLoaderPanel, this.selectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GenePixFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 2, 11, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void setPath(String path) {
            this.pathTextField.setText(path);
        }

        public void openDataPath() {
        }

        public void onDataFileBrowse() {
            FileLoaderUtility fileLoad = new FileLoaderUtility();
            Vector retrievedFileNames = new Vector();
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(1);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                ((DefaultListModel)this.genePixAvailableList.getModel()).clear();
                ((DefaultListModel)this.genePixSelectedList.getModel()).clear();
                File selectedFile = fileChooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                this.pathTextField.setText(path);
                retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
                for (int i = 0; i < retrievedFileNames.size(); ++i) {
                    Object fileName = retrievedFileNames.get(i);
                    boolean acceptFile = GenePixFileLoader.this.getFileFilter().accept((File)fileName);
                    if (!acceptFile) continue;
                    String Name = fileChooser.getName((File)fileName);
                    ((DefaultListModel)this.genePixAvailableList.getModel()).addElement(new File(Name));
                }
            }
        }

        public void validateLists() {
            if (((DefaultListModel)this.genePixSelectedList.getModel()).size() > 0) {
                GenePixFileLoader.this.markLoadEnabled(true);
            } else {
                GenePixFileLoader.this.markLoadEnabled(false);
            }
        }

        public void onGenePixAdd() {
            int i;
            int[] chosenIndices = this.genePixAvailableList.getSelectedIndices();
            Object[] chosenObjects = new Object[chosenIndices.length];
            for (i = chosenIndices.length - 1; i >= 0; --i) {
                Object addItem = ((DefaultListModel)this.genePixAvailableList.getModel()).getElementAt(chosenIndices[i]);
                chosenObjects[i] = addItem;
            }
            for (i = 0; i < chosenIndices.length; ++i) {
                ((DefaultListModel)this.genePixSelectedList.getModel()).addElement(chosenObjects[i]);
            }
            this.validateLists();
        }

        public void onGenePixAddAll() {
            int elementCount = ((DefaultListModel)this.genePixAvailableList.getModel()).size();
            for (int i = 0; i < elementCount; ++i) {
                Object addItem = ((DefaultListModel)this.genePixAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.genePixSelectedList.getModel()).addElement(addItem);
            }
            this.validateLists();
        }

        public void onGenePixRemove() {
            int[] chosenIndices = this.genePixSelectedList.getSelectedIndices();
            for (int i = chosenIndices.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.genePixSelectedList.getModel()).remove(chosenIndices[i]);
            }
            this.validateLists();
        }

        public void onGenePixRemoveAll() {
            ((DefaultListModel)this.genePixSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public DefaultListModel getGenePixAvailableListModel() {
            return (DefaultListModel)this.genePixAvailableList.getModel();
        }

        public DefaultListModel getGenePixSelectedListModel() {
            return (DefaultListModel)this.genePixSelectedList.getModel();
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == GenePixFileLoaderPanel.this.genePixAddButton) {
                    GenePixFileLoaderPanel.this.onGenePixAdd();
                } else if (source == GenePixFileLoaderPanel.this.genePixAddAllButton) {
                    GenePixFileLoaderPanel.this.onGenePixAddAll();
                } else if (source == GenePixFileLoaderPanel.this.genePixRemoveButton) {
                    GenePixFileLoaderPanel.this.onGenePixRemove();
                } else if (source == GenePixFileLoaderPanel.this.genePixRemoveAllButton) {
                    GenePixFileLoaderPanel.this.onGenePixRemoveAll();
                } else if (source == GenePixFileLoaderPanel.this.browseButton1) {
                    GenePixFileLoaderPanel.this.onDataFileBrowse();
                }
            }
        }
    }
}

