/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;

public class GEOSeriesMatrixLoader
extends ExpressionFileLoader {
    private GBA gba;
    private boolean stop = false;
    private int dataType;
    private GEO_SeriesMatrixFileLoaderPanel smatrixflp;
    private ExpressionFileTableCellRenderer myCellRenderer;
    private Vector datainfo = new Vector();
    private Vector platforminfo = new Vector();
    private boolean unload = false;
    private MultipleArrayViewer mav;

    @Override
    public void setFilePath(String path) {
        this.smatrixflp.setFileName(path);
        this.process_GEOSeriesMatrixFile(new File(path));
    }

    public GEOSeriesMatrixLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.smatrixflp = new GEO_SeriesMatrixFileLoaderPanel();
    }

    public Vector loadExpressionFiles() throws IOException {
        return this.load_GEOSeriesExpressionFile(new File(this.smatrixflp.fileNameTextField.getText()));
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    public Vector load_GEOSeriesExpressionFile(File f) throws IOException {
        int i;
        float[] intensities = new float[2];
        boolean rColumns = true;
        int totalRows = this.smatrixflp.expressionTable.getRowCount();
        int totalColumns = this.smatrixflp.expressionTable.getColumnCount();
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        int column = 1;
        int row = 1;
        int preSpotRows = this.smatrixflp.getXRow();
        int preExperimentColumns = this.smatrixflp.getXColumn();
        int spotCount = totalRows - preSpotRows;
        int experimentCount = totalColumns - preExperimentColumns;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        String[] moreFields = new String[preExperimentColumns];
        String[] fieldNames = new String[preExperimentColumns];
        ISlideData[] slideData = new ISlideData[experimentCount];
        SlideDataElement sde = null;
        AffySlideDataElement affysde = null;
        SampleAnnotation sampAnn = new SampleAnnotation();
        slideData[0] = new SlideData(spotCount, 1, sampAnn);
        slideData[0].setSlideFileName(f.getAbsolutePath());
        for (i = 1; i < slideData.length; ++i) {
            sampAnn = new SampleAnnotation();
            slideData[i] = new FloatSlideData(slideData[0].getSlideMetaData(), spotCount, sampAnn);
            slideData[i].setSlideFileName(f.getPath());
        }
        for (int m = 0; m < preExperimentColumns; ++m) {
            fieldNames[m] = this.smatrixflp.expressionTable.getColumnName(m);
        }
        slideData[0].getSlideMetaData().appendFieldNames(fieldNames);
        for (i = 0; i < slideData.length; ++i) {
            String val = this.smatrixflp.expressionTable.getColumnName(i + preExperimentColumns);
            slideData[i].setSampleAnnotationLoaded(true);
            slideData[i].getSampleAnnotation().setAnnotation("Default Slide Name", val);
            slideData[i].setSlideDataName(this.smatrixflp.expressionTable.getColumnName(i + preExperimentColumns));
            this.mav.getData().setSampleAnnotationLoaded(true);
        }
        for (i = 0; i < spotCount; ++i) {
            int j;
            for (j = 0; j < preExperimentColumns; ++j) {
                moreFields[j] = (String)this.smatrixflp.expressionTable.getValueAt(i, j);
            }
            rows[0] = rows[2] = row++;
            columns[0] = columns[2] = column;
            column = column == 1 ? 1 : ++column;
            if (this.smatrixflp.twoColorArray.isSelected()) {
                sde = new SlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], moreFields);
                slideData[0].addSlideDataElement(sde);
            } else {
                affysde = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], moreFields);
                slideData[0].addSlideDataElement(affysde);
            }
            for (j = 0; j < slideData.length; ++j) {
                try {
                    intensities[0] = 1.0f;
                    intensities[1] = Float.parseFloat((String)this.smatrixflp.expressionTable.getValueAt(i, j + preExperimentColumns));
                }
                catch (Exception e) {
                    intensities[1] = Float.NaN;
                }
                slideData[j].setIntensities(i, intensities[0], intensities[1]);
            }
        }
        Vector<ISlideData> data = new Vector<ISlideData>();
        for (int i2 = 0; i2 < slideData.length; ++i2) {
            data.add(slideData[i2]);
        }
        return data;
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "GEO Series Matrix File (*.txt)";
            }
        };
        return mevFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.smatrixflp.getXRow() + 1;
        int tableColumn = this.smatrixflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.smatrixflp.getTable().getModel();
        if (!this.smatrixflp.twoColorArray.isSelected() & !this.smatrixflp.affymetrixArray.isSelected()) {
            String eMsg = "<html>Please select an array type..<br>";
            JOptionPane.showMessageDialog(null, eMsg, "Warning", 1);
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public void setDataType(int data_Type) {
        this.dataType = data_Type;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.smatrixflp;
    }

    public void process_GEOSeriesMatrixFile(File targetFile) {
        this.smatrixflp.selectedFiles.setText(targetFile.getAbsolutePath());
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        String currentLine = null;
        Vector<String> columnHeaders = new Vector<String>();
        if (!this.validateFile(targetFile)) {
            return;
        }
        this.smatrixflp.setFileName(targetFile.getAbsolutePath());
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        try {
            reader = new BufferedReader(new FileReader(targetFile), 131072);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            currentLine = reader.readLine();
            while (!currentLine.contains("series_matrix_table_begin")) {
                currentLine = reader.readLine();
            }
            currentLine = reader.readLine();
            ss.init(currentLine);
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                columnHeaders.add(ss.nextToken());
            }
            model.setColumnIdentifiers(columnHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && !currentLine.contains("series_matrix_table_end")) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i = 0; i < ss.countTokens() + 1; ++i) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.smatrixflp.setTableModel(model);
        Point p = this.getFirstExpressionCell(dataVector);
        this.smatrixflp.setSelectedCell(p.x, p.y);
    }

    @Override
    public String getFilePath() {
        return this.smatrixflp.fileNameTextField.getText();
    }

    @Override
    public void openDataPath() {
        this.smatrixflp.openDataPath();
    }

    @Override
    public String getAnnotationFilePath() {
        return null;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    private class GEO_SeriesMatrixFileLoaderPanel
    extends JPanel {
        JPanel fileLoaderPanel;
        JPanel fileSelectionPanel;
        JLabel dataSelection;
        JTextField fileNameTextField;
        JButton browseButton1;
        JLabel fileSelectionLabel;
        JTextField selectedFiles;
        JPanel buttonPanel;
        JRadioButton twoColorArray;
        JRadioButton affymetrixArray;
        JPanel tablePanel;
        JTable expressionTable;
        JScrollPane tableScrollPane;
        private int xRow = -1;
        private int xColumn = -1;

        public GEO_SeriesMatrixFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.fileSelectionLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select expression data file</html>";
            this.dataSelection.setText(chooseFile);
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(new EventHandler());
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.twoColorArray = new JRadioButton("Spotted DNA/cDNA Array");
            this.twoColorArray.setFocusPainted(false);
            this.twoColorArray.addActionListener(new EventHandler());
            this.affymetrixArray = new JRadioButton("Affymetrix Array");
            this.affymetrixArray.setFocusPainted(false);
            this.affymetrixArray.setSelected(true);
            this.affymetrixArray.addActionListener(new EventHandler());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.twoColorArray);
            bg.add(this.affymetrixArray);
            GEOSeriesMatrixLoader.this.gba.add(this.buttonPanel, this.twoColorArray, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this.buttonPanel, this.affymetrixArray, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (GEO Series Matrix Files)"));
            GEOSeriesMatrixLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this.fileSelectionPanel, this.fileSelectionLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this.fileSelectionPanel, this.selectedFiles, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this.fileSelectionPanel, this.buttonPanel, 0, 3, 0, 0, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.expressionTable = new JTable();
            GEOSeriesMatrixLoader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable.setDefaultRenderer(Object.class, GEOSeriesMatrixLoader.this.myCellRenderer);
            this.expressionTable.setIntercellSpacing(new Dimension(1, 1));
            this.expressionTable.setShowHorizontalLines(false);
            this.expressionTable.setShowVerticalLines(true);
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    GEO_SeriesMatrixFileLoaderPanel.this.setSelectedCell(GEO_SeriesMatrixFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), GEO_SeriesMatrixFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            GEOSeriesMatrixLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            GEOSeriesMatrixLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 7, 1, 6, 3, 6, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            GEOSeriesMatrixLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            GEOSeriesMatrixLoader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            GEOSeriesMatrixLoader.this.checkLoadEnable();
        }

        public void openDataPath() {
        }

        public void onBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                GEOSeriesMatrixLoader.this.process_GEOSeriesMatrixFile(selectedFile);
            }
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void select_GEOSeriesMatrixFile() {
            JFileChooser jfc = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            jfc.setFileFilter(GEOSeriesMatrixLoader.this.getFileFilter());
            int activityCode = jfc.showDialog(this, "Select");
            if (activityCode == 0) {
                File target = jfc.getSelectedFile();
                GEOSeriesMatrixLoader.this.process_GEOSeriesMatrixFile(target);
            }
        }

        public void setFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == GEO_SeriesMatrixFileLoaderPanel.this.browseButton1) {
                    GEO_SeriesMatrixFileLoaderPanel.this.onBrowse();
                } else if (source == GEO_SeriesMatrixFileLoaderPanel.this.twoColorArray) {
                    GEOSeriesMatrixLoader.this.dataType = 1;
                    GEOSeriesMatrixLoader.this.setDataType(GEOSeriesMatrixLoader.this.dataType);
                } else if (source == GEO_SeriesMatrixFileLoaderPanel.this.affymetrixArray) {
                    GEOSeriesMatrixLoader.this.dataType = 2;
                    GEOSeriesMatrixLoader.this.setDataType(GEOSeriesMatrixLoader.this.dataType);
                }
            }
        }
    }
}

