/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.file.StringSplitter;

public class GEOPlatformfileParser {
    private Vector rawLines = new Vector();
    private Vector platformHeaders;

    public Hashtable parsePlatformData(File targetFile) {
        StringSplitter split = new StringSplitter('\t');
        String currentLine = null;
        this.platformHeaders = new Vector();
        Hashtable pMatrix = new Hashtable();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(targetFile));
            currentLine = reader.readLine();
            while ((currentLine = reader.readLine()) != null) {
                if (!currentLine.contains("platform_table_begin")) continue;
                currentLine = reader.readLine();
                split.init(currentLine);
                this.rawLines.add(currentLine);
                while (split.hasMoreTokens()) {
                    this.platformHeaders.add(split.nextToken());
                }
                int count = 0;
                while (!(currentLine = reader.readLine()).contains("platform_table_end")) {
                    this.rawLines.add(currentLine);
                    ++count;
                }
                if (!currentLine.contains("platform_table_end")) continue;
                pMatrix = this.getPlatformMatrix(this.rawLines);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pMatrix.size() != 0) {
            return pMatrix;
        }
        return null;
    }

    Hashtable getPlatformMatrix(Vector rawLines) {
        Hashtable<String, String> pMatrix = new Hashtable<String, String>();
        int size = rawLines.size();
        StringSplitter split = new StringSplitter('\t');
        for (int i = 1; i < size; ++i) {
            String Line = (String)rawLines.elementAt(i);
            split.init(Line);
            String key = split.nextToken();
            String values = "";
            while (split.hasMoreTokens()) {
                String temp = split.nextToken();
                if (temp != " " | temp != null) {
                    values = values.concat(temp);
                    values = values.concat(":");
                    continue;
                }
                values = values.concat("NA");
                values = values.concat(":");
            }
            if (pMatrix.containsKey(key)) continue;
            pMatrix.put(key, values);
        }
        if (pMatrix.size() == 0) {
            pMatrix = null;
            return pMatrix;
        }
        return pMatrix;
    }

    public Vector getColumnHeaders() {
        return this.platformHeaders;
    }
}

