/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.util.Hashtable;
import org.tigr.microarray.mev.file.AffyGCOSFileLoader;
import org.tigr.microarray.mev.file.AffymetrixFileLoader;
import org.tigr.microarray.mev.file.AgilentFileLoader;
import org.tigr.microarray.mev.file.CGHStanfordFileLoader;
import org.tigr.microarray.mev.file.DFCI_CoreFileLoader;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GEOSeriesMatrixLoader;
import org.tigr.microarray.mev.file.GEO_GDSFileLoader;
import org.tigr.microarray.mev.file.GenePixFileLoader;
import org.tigr.microarray.mev.file.MAGETABFileLoader;
import org.tigr.microarray.mev.file.Mas5FileLoader;
import org.tigr.microarray.mev.file.MevFileLoader;
import org.tigr.microarray.mev.file.RMAFileLoader;
import org.tigr.microarray.mev.file.RNASeqFileLoader;
import org.tigr.microarray.mev.file.SOFT_AffymetrixFileLoader;
import org.tigr.microarray.mev.file.SOFT_TwoChannelFileLoader;
import org.tigr.microarray.mev.file.StanfordFileLoader;
import org.tigr.microarray.mev.file.TCGADownloader;
import org.tigr.microarray.mev.file.TavFileLoader;

public enum FileType {
    STANFORD("tdms", 0, false, StanfordFileLoader.class, "Tab Delimited, Multiple Sample Files (TDMS) (*.*)"),
    MEV_TARBALL("mev", 1, true, MevFileLoader.class, "MeV Files (*.mev and *.ann)"),
    TAV("tav", 2, false, TavFileLoader.class, "TIGR ArrayViewer Files (*.tav)"),
    AFFY_GCOS("affy-gcos", 3, false, AffyGCOSFileLoader.class, "Affymetrix GCOS(using MAS5) Files"),
    DCHIP("dchip", 4, true, DFCI_CoreFileLoader.class, "dChip/DFCI_Core Format Files"),
    GW_AFFY("gw-affy", 5, true, AffymetrixFileLoader.class, "GW Affymetrix Files"),
    BIOCONDUCTOR_MAS5("bioconductor-mas5", 6, false, Mas5FileLoader.class, "Bioconductor(using MAS5) Files"),
    RMA("rma", 7, false, RMAFileLoader.class, "RMA Files"),
    CGH("cgh", 8, false, CGHStanfordFileLoader.class, "CGH Tab Delimited, Multiple Sample"),
    AFFY_GPL("affy-gp", 9, false, SOFT_AffymetrixFileLoader.class, "GEO SOFT Affymetrix Format Files"),
    TWO_CHANNEL_GPL("two-channel-gpl", 10, false, SOFT_TwoChannelFileLoader.class, "GEO SOFT Two Channel Format Files"),
    GENEPIX("genepix", 11, true, GenePixFileLoader.class, "GenePix Format Files"),
    AGILENT("agilent", 12, true, AgilentFileLoader.class, "Agilent Files"),
    GEO_SERIES_MATRIX("geo-series-matrix", 13, false, GEOSeriesMatrixLoader.class, "GEO Series Matrix Files"),
    GEO_GDS("geo-gds", 14, false, GEO_GDSFileLoader.class, "GEO GDS Format Files"),
    MAGETAB("mage-tab", 15, false, MAGETABFileLoader.class, "MAGE-TAB Format Files"),
    RNASEQ("rnaseq", 16, false, RNASeqFileLoader.class, "Tab Delimited, Multiple Files for DGE/RPKM data"),
    TCGA_DOWNLOAD("tcga-download", 17, false, TCGADownloader.class, "Tab Delimited, Multiple Files for TCGA data");

    private String commandArg;
    private int loaderIndex;
    private boolean multifile;
    private String description;
    private Class<ExpressionFileLoader> loader;
    private static Hashtable<String, FileType> commandArgOptions;

    private FileType(String commandArg, int loaderIndex, boolean multifile, Class loader, String description) {
        this.commandArg = commandArg;
        this.loaderIndex = loaderIndex;
        this.multifile = multifile;
        this.loader = loader;
        this.description = description;
    }

    public static FileType getTypeFromLoaderIndex(int loaderIndex) {
        for (FileType f : FileType.values()) {
            if (f.loaderIndex != loaderIndex) continue;
            return f;
        }
        return null;
    }

    public Class<ExpressionFileLoader> getFileLoader() {
        return this.loader;
    }

    public static FileType getFileType(String commandArg) {
        return commandArgOptions.get(commandArg);
    }

    public static String getAvailableOptions() {
        return commandArgOptions.keys().toString();
    }

    public int getLoaderIndex() {
        return this.loaderIndex;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMultifile() {
        return this.multifile;
    }

    public String getCommandArg() {
        return this.commandArg;
    }

    static {
        commandArgOptions = new Hashtable();
        for (FileType f : FileType.values()) {
            commandArgOptions.put(f.commandArg, f);
        }
    }
}

