/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;

public class FileTreePane
extends JPanel {
    public static final ImageIcon ICON_COMPUTER = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/PCIcon.gif")));
    public static final ImageIcon ICON_DISK = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/disk.gif")));
    public static final ImageIcon ICON_FOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/Directory.gif")));
    public static final ImageIcon ICON_EXPANDEDFOLDER = new ImageIcon(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("org/tigr/images/expandedfolder.gif")));
    public static final String WINDOWS = "windows";
    public static final String LINUX = "linux";
    public static final String MAC = "mac";
    private String os = System.getProperty("os.name");
    public char DIRECTORY_DIV;
    public String DIRECTORY_DIV_S;
    protected JTree m_tree;
    protected DefaultTreeModel m_model;
    protected JList fileList;
    private Vector rightListContent;
    private Vector leftListContent;
    protected String fPath;
    protected String selectedSingleFile;
    protected Vector selectedFilesVec;
    protected int selectedCount;
    protected Vector listeners = new Vector();
    protected String dataPath;
    protected DefaultMutableTreeNode top;
    public static final int NODE_COLLAPSED = 0;
    public static final int NODE_EXPANDED = 1;
    public static final int NODE_SELECTED = 2;

    public FileTreePane() {
        String sep = System.getProperty("file.separator");
        this.DIRECTORY_DIV = sep.toCharArray()[0];
        this.DIRECTORY_DIV_S = sep;
        JPanel fillerPane = new JPanel();
        this.top = new DefaultMutableTreeNode(new IconData(ICON_COMPUTER, null, "Computer"));
        File[] roots = File.listRoots();
        for (int k = 0; k < roots.length; ++k) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(ICON_DISK, null, new FileNode(roots[k])));
            this.top.add(node);
            node.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        this.m_model = new DefaultTreeModel(this.top);
        this.m_tree = new JTree(this.m_model);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        IconCellRenderer renderer = new IconCellRenderer();
        this.m_tree.setCellRenderer(renderer);
        this.m_tree.addTreeExpansionListener(new EventHandler());
        this.m_tree.addTreeSelectionListener(new EventHandler());
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        JScrollPane s = new JScrollPane();
        s.getViewport().add(this.m_tree);
        this.setLayout(new BorderLayout());
        this.add((Component)s, "Center");
    }

    public FileTreePane(String dataPath) {
        this.dataPath = dataPath;
        String sep = System.getProperty("file.separator");
        this.DIRECTORY_DIV = sep.toCharArray()[0];
        this.DIRECTORY_DIV_S = sep;
        JPanel fillerPane = new JPanel();
        this.top = new DefaultMutableTreeNode(new IconData(ICON_COMPUTER, null, "Computer"));
        File[] roots = File.listRoots();
        for (int k = 0; k < roots.length; ++k) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(ICON_DISK, null, new FileNode(roots[k])));
            this.top.add(node);
            node.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
        this.m_model = new DefaultTreeModel(this.top);
        this.m_tree = new JTree(this.m_model);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        IconCellRenderer renderer = new IconCellRenderer();
        this.m_tree.setCellRenderer(renderer);
        this.m_tree.addTreeExpansionListener(new EventHandler());
        this.m_tree.addTreeSelectionListener(new EventHandler());
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        JScrollPane s = new JScrollPane();
        s.getViewport().add(this.m_tree);
        this.setLayout(new BorderLayout());
        this.add((Component)s, "Center");
    }

    public String getSelection() {
        return this.fPath;
    }

    public void openDataPath() {
        if (this.dataPath == null) {
            return;
        }
        File file = new File(this.dataPath);
        if (file.exists() && file.isDirectory()) {
            this.openPath(this.top, this.dataPath, System.getProperty("file.separator"));
        }
    }

    private boolean openPath(DefaultMutableTreeNode root, String dataPath, String sep) {
        this.fPath = dataPath;
        TreePath path = new TreePath(root);
        StringTokenizer stok = new StringTokenizer(dataPath, sep);
        String[] nodes = new String[stok.countTokens()];
        String drive = stok.nextToken() + sep;
        DefaultMutableTreeNode subRoot = null;
        int childCount = root.getChildCount();
        DefaultMutableTreeNode tempNode = null;
        FileNode tempFileNode = null;
        int cumul = 0;
        if (!sep.equals("/")) {
            int driveNum = 0;
            for (int i = 0; i < childCount; ++i) {
                tempNode = (DefaultMutableTreeNode)root.getChildAt(i);
                tempFileNode = this.getFileNode(tempNode);
                if (!drive.equalsIgnoreCase(tempFileNode.toString())) continue;
                subRoot = (DefaultMutableTreeNode)root.getChildAt(i);
                driveNum = i;
                cumul = i;
                break;
            }
        } else {
            subRoot = (DefaultMutableTreeNode)root.getChildAt(0);
            stok = new StringTokenizer(dataPath, sep);
        }
        if (subRoot == null) {
            return false;
        }
        path = path.pathByAddingChild(subRoot);
        this.m_tree.expandPath(path);
        this.m_tree.validate();
        boolean stop = false;
        block1: while (!stop && stok.hasMoreTokens()) {
            childCount = subRoot.getChildCount();
            String nodeName = stok.nextToken();
            for (int i = 0; i < childCount; ++i) {
                tempNode = (DefaultMutableTreeNode)subRoot.getChildAt(i);
                tempFileNode = this.getFileNode(tempNode);
                if (tempFileNode == null) {
                    stop = true;
                    continue block1;
                }
                if (!nodeName.equalsIgnoreCase(tempFileNode.toString())) continue;
                this.buildOffNode(tempFileNode, subRoot);
                path = path.pathByAddingChild(tempNode);
                this.fPath = this.fPath + tempNode.toString() + sep;
                this.m_tree.expandPath(path);
                subRoot = (DefaultMutableTreeNode)subRoot.getChildAt(i);
                this.repaint();
                continue block1;
            }
        }
        this.m_tree.makeVisible(path);
        this.m_tree.scrollPathToVisible(path);
        this.m_tree.setSelectionPath(path);
        this.m_tree.validate();
        return true;
    }

    private void buildOffNode(FileNode tempFileNode, DefaultMutableTreeNode subRoot) {
        File[] files = new File(tempFileNode.toString()).listFiles();
        if (files == null) {
            return;
        }
        Vector<FileNode> v = new Vector<FileNode>();
        for (int k = 0; k < files.length; ++k) {
            File f = files[k];
            if (!f.isDirectory()) continue;
            FileNode newNode = new FileNode(f);
            boolean isAdded = false;
            for (int i = 0; i < v.size(); ++i) {
                FileNode nd = (FileNode)v.elementAt(i);
                if (newNode.compareTo(nd) >= 0) continue;
                v.insertElementAt(newNode, i);
                isAdded = true;
                break;
            }
            if (isAdded) continue;
            v.addElement(newNode);
        }
        for (int i = 0; i < v.size(); ++i) {
            FileNode nd = (FileNode)v.elementAt(i);
            IconData idata = new IconData(ICON_FOLDER, ICON_EXPANDEDFOLDER, nd);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
            subRoot.add(node);
            if (!nd.hasSubDirs()) continue;
            subRoot.add(new DefaultMutableTreeNode(new Boolean(true)));
        }
    }

    private DefaultMutableTreeNode getTreeNode(TreePath path) {
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    private FileNode getFileNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        if (obj instanceof IconData) {
            obj = ((IconData)obj).getObject();
        }
        if (obj instanceof FileNode) {
            return (FileNode)obj;
        }
        return null;
    }

    public Vector getFileNameList(String directoryPath) {
        if (directoryPath == null) {
            return null;
        }
        FileBrowser fBrowser = new FileBrowser(this.fPath);
        Vector retrievedFileNames = fBrowser.getFileNamesVec();
        return retrievedFileNames;
    }

    public void addFileTreePaneListener(FileTreePaneListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeFileTreePaneListener(FileTreePaneListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireEvent(FileTreePaneEvent event, int eventType) {
        Vector targets = (Vector)this.listeners.clone();
        block5: for (int i = 0; i < targets.size(); ++i) {
            FileTreePaneListener listener = (FileTreePaneListener)targets.elementAt(i);
            switch (eventType) {
                case 0: {
                    listener.nodeCollapsed(event);
                    continue block5;
                }
                case 1: {
                    listener.nodeExpanded(event);
                    continue block5;
                }
                case 2: {
                    listener.nodeSelected(event);
                }
            }
        }
    }

    public static void main(String[] args) {
        FileTreePane ftp = new FileTreePane("C:\\MyProjects\\MeV_2_3_Devel\\Data");
        JFrame frame = new JFrame("FileTreePane");
        frame.getContentPane().add(ftp);
        frame.setSize(600, 600);
        frame.setLocation(150, 150);
        frame.setVisible(true);
    }

    private class FileBrowser {
        private String workingFullDir;
        private String workingDir;
        private Vector filesVec;
        private File dir;
        private File subDir;

        public FileBrowser(String directory) {
            this.setDirectory(directory);
        }

        public void setDirectory(String directory) {
            this.workingFullDir = directory;
            this.dir = new File(directory);
            this.workingDir = this.dir.getAbsolutePath();
            if (!this.dir.isDirectory()) {
                this.workingDir = this.workingDir.substring(0, this.workingDir.lastIndexOf(FileTreePane.this.DIRECTORY_DIV));
            } else {
                this.filterFiles();
            }
        }

        public void filterFiles() {
            this.filesVec = new Vector();
            if (this.dir == null) {
                return;
            }
            String[] available = this.dir.list();
            if (this.workingDir == null) {
                this.workingDir = this.dir.getAbsolutePath();
            }
            for (int i = 0; i < available.length; ++i) {
                File checkFile = new File(this.dir, available[i]);
                if (!checkFile.isFile()) continue;
                this.filesVec.addElement(this.workingDir + (this.workingDir.endsWith(FileTreePane.this.DIRECTORY_DIV_S) ? "" : FileTreePane.this.DIRECTORY_DIV_S) + available[i]);
            }
        }

        public Vector getFileNamesVec() {
            return this.filesVec;
        }

        public int getFileCounts() {
            return this.filesVec.size();
        }

        public String getAbsolutePath() {
            return this.workingDir;
        }

        public String creatSubDir(String sub) {
            this.subDir = new File(this.workingFullDir + FileTreePane.this.DIRECTORY_DIV + sub + FileTreePane.this.DIRECTORY_DIV);
            return this.workingFullDir + FileTreePane.this.DIRECTORY_DIV + sub + FileTreePane.this.DIRECTORY_DIV;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    private class IconCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        protected boolean m_selected;

        public IconCellRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            this.setText(obj.toString());
            if (obj instanceof Boolean) {
                this.setText("Retrieving data...");
            }
            if (obj instanceof IconData) {
                IconData idata = (IconData)obj;
                if (expanded) {
                    this.setIcon(idata.getExpandedIcon());
                } else {
                    this.setIcon(idata.getIcon());
                }
            } else {
                this.setIcon(null);
            }
            this.setFont(tree.getFont());
            this.setForeground(sel ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(sel ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_selected = sel;
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            Color bColor = this.getBackground();
            Icon icon = this.getIcon();
            g.setColor(bColor);
            int offset = 0;
            if (icon != null && this.getText() != null) {
                offset = icon.getIconWidth() + this.getIconTextGap();
            }
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            if (this.m_selected) {
                g.setColor(this.m_borderSelectionColor);
                g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
            super.paintComponent(g);
        }
    }

    private class IconData {
        protected Icon m_icon;
        protected Icon m_expandedIcon;
        protected Object m_data;

        public IconData(Icon icon, Object data) {
            this.m_icon = icon;
            this.m_expandedIcon = null;
            this.m_data = data;
        }

        public IconData(Icon icon, Icon expandedIcon, Object data) {
            this.m_icon = icon;
            this.m_expandedIcon = expandedIcon;
            this.m_data = data;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public Icon getExpandedIcon() {
            return this.m_expandedIcon != null ? this.m_expandedIcon : this.m_icon;
        }

        public Object getObject() {
            return this.m_data;
        }

        public String toString() {
            return this.m_data.toString();
        }
    }

    private class EventHandler
    implements ListSelectionListener,
    TreeExpansionListener,
    TreeSelectionListener {
        private EventHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FileTreePane.this.selectedFilesVec = new Vector();
            FileTreePane.this.selectedCount = FileTreePane.this.fileList.getSelectedValues().length;
            for (int i = 0; i <= FileTreePane.this.selectedCount - 1; ++i) {
                FileTreePane.this.selectedFilesVec.add(i, (String)FileTreePane.this.fileList.getSelectedValues()[i]);
            }
            FileTreePane.this.selectedSingleFile = (String)FileTreePane.this.fileList.getSelectedValue();
            FileTreePane.this.fPath = (String)FileTreePane.this.fileList.getSelectedValue();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            DefaultMutableTreeNode node = FileTreePane.this.getTreeNode(event.getPath());
            FileNode fnode = FileTreePane.this.getFileNode(node);
            if (fnode != null && fnode.expand(node)) {
                FileTreePane.this.m_model.reload(node);
            }
            FileTreePane.this.fireEvent(new FileTreePaneEvent(event, null), 1);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            FileTreePane.this.fireEvent(new FileTreePaneEvent(event, null), 0);
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode node = FileTreePane.this.getTreeNode(event.getPath());
            FileNode fnode = FileTreePane.this.getFileNode(node);
            if (fnode != null) {
                FileTreePane.this.fPath = fnode.getFile().getAbsolutePath();
                if (FileTreePane.this.fPath.charAt(FileTreePane.this.fPath.length() - 1) != FileTreePane.this.DIRECTORY_DIV) {
                    FileTreePane.this.fPath = FileTreePane.this.fPath + FileTreePane.this.DIRECTORY_DIV;
                }
                Vector fileNameVector = FileTreePane.this.getFileNameList(FileTreePane.this.fPath);
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("Path", FileTreePane.this.fPath);
                if (fileNameVector != null) {
                    hash.put("Filenames", fileNameVector);
                }
                FileTreePane.this.fireEvent(new FileTreePaneEvent(event, hash), 2);
            } else {
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("Path", "");
                FileTreePane.this.fireEvent(new FileTreePaneEvent(event, null), 2);
            }
        }
    }

    private class FileNode {
        protected File m_file;

        public FileNode(File file) {
            this.m_file = file;
        }

        public File getFile() {
            return this.m_file;
        }

        public String toString() {
            return this.m_file.getName().length() > 0 ? this.m_file.getName() : this.m_file.getPath();
        }

        public boolean expand(DefaultMutableTreeNode parent) {
            DefaultMutableTreeNode flag = (DefaultMutableTreeNode)parent.getFirstChild();
            if (flag == null) {
                return false;
            }
            Object obj = flag.getUserObject();
            if (!(obj instanceof Boolean)) {
                return false;
            }
            parent.removeAllChildren();
            File[] files = this.listFiles();
            if (files == null) {
                return true;
            }
            Vector<FileNode> v = new Vector<FileNode>();
            for (int k = 0; k < files.length; ++k) {
                File f = files[k];
                if (!f.isDirectory()) continue;
                FileNode newNode = new FileNode(f);
                boolean isAdded = false;
                for (int i = 0; i < v.size(); ++i) {
                    FileNode nd = (FileNode)v.elementAt(i);
                    if (newNode.compareTo(nd) >= 0) continue;
                    v.insertElementAt(newNode, i);
                    isAdded = true;
                    break;
                }
                if (isAdded) continue;
                v.addElement(newNode);
            }
            for (int i = 0; i < v.size(); ++i) {
                FileNode nd = (FileNode)v.elementAt(i);
                IconData idata = new IconData(ICON_FOLDER, ICON_EXPANDEDFOLDER, nd);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
                parent.add(node);
                if (!nd.hasSubDirs()) continue;
                node.add(new DefaultMutableTreeNode(new Boolean(true)));
            }
            return true;
        }

        public boolean hasSubDirs() {
            File[] files = this.listFiles();
            if (files == null) {
                return false;
            }
            for (int k = 0; k < files.length; ++k) {
                if (!files[k].isDirectory()) continue;
                return true;
            }
            return false;
        }

        public int compareTo(FileNode toCompare) {
            return this.m_file.getName().compareToIgnoreCase(toCompare.m_file.getName());
        }

        protected File[] listFiles() {
            if (!this.m_file.isDirectory()) {
                return null;
            }
            try {
                return this.m_file.listFiles();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error reading directory " + this.m_file.getAbsolutePath(), "Warning", 2);
                return null;
            }
        }
    }
}

