/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import org.tigr.microarray.mev.SessionOptions;
import org.tigr.microarray.mev.file.FileType;
import org.tigr.microarray.mev.file.InvalidFileArgumentsException;

public class FileLoadInfo {
    protected FileType fileType;
    protected String dataFileURL;
    protected String arrayType;
    protected String speciesName;
    protected int firstRow = -1;
    protected int firstColumn = -1;
    protected boolean isMultiFile = false;
    protected boolean isDownloadDatafile = false;
    protected String localFile;

    public boolean isDownloadDatafile() {
        return this.isDownloadDatafile;
    }

    public void setDownloadDatafile(boolean isDownloadDatafile) {
        this.isDownloadDatafile = isDownloadDatafile;
    }

    public String getLocalFile() {
        return this.localFile;
    }

    public FileLoadInfo(SessionOptions so) throws InvalidFileArgumentsException {
        this.fileType = so.getFileType();
        this.setDataFileURL(so.getDataFile());
        this.setArrayType(so.getArrayType());
        this.setFirstRow(so.getFirstRow());
        this.setFirstColumn(so.getFirstColumn());
        this.setMultiFile(this.fileType.isMultifile());
        if (this.dataFileURL != null && !this.dataFileURL.equals("")) {
            this.isDownloadDatafile = true;
        }
    }

    public String getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayType) {
        this.arrayType = arrayType;
    }

    public String getDataFileURL() {
        return this.dataFileURL;
    }

    public void setDataFileURL(String dataFilePath) {
        this.dataFileURL = dataFilePath;
    }

    public FileLoadInfo(FileType type) {
        this.fileType = type;
    }

    public String getDataFile() {
        return this.dataFileURL;
    }

    public void setDataFile(String dataFile) {
        this.dataFileURL = dataFile;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public void setFirstColumn(int firstColumn) {
        this.firstColumn = firstColumn;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public String getSpeciesName() {
        return this.speciesName;
    }

    public void setSpeciesName(String speciesName) {
        this.speciesName = speciesName;
    }

    public boolean isMultiFile() {
        return this.isMultiFile;
    }

    public void setMultiFile(boolean isMultiFile) {
        this.isMultiFile = isMultiFile;
    }
}

