/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.RNASeqChipAnnotation;
import org.tigr.microarray.mev.annotation.IChipAnnotation;
import org.tigr.microarray.mev.file.SlideLoaderProgressBar;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public abstract class ExpressionFileLoader
extends SlideLoaderProgressBar {
    protected SuperExpressionFileLoader superLoader;
    protected SlideLoaderProgressBar progress;
    protected boolean stop = false;
    protected IChipAnnotation chipAnno = new RNASeqChipAnnotation();
    protected int firstRow = -1;
    protected int firstCol = -1;

    public ExpressionFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader.getFrame());
        this.superLoader = superLoader;
    }

    public IChipAnnotation getChipAnnotation() {
        return this.chipAnno;
    }

    public void setCoordinates(int firstRow, int firstCol) {
        this.firstRow = firstRow;
        this.firstCol = firstCol;
    }

    public abstract ISlideData loadExpressionFile(File var1) throws IOException;

    public abstract Vector<ISlideData> loadExpressionFiles() throws IOException;

    public FileFilter getFileFilter() {
        FileFilter defaultFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "Generic Expression Files (*.*)";
            }
        };
        return defaultFileFilter;
    }

    public void setLoadEnabled(boolean state) {
        this.superLoader.setLoadEnabled(state);
    }

    public abstract boolean checkLoadEnable();

    public abstract JPanel getFileLoaderPanel();

    public abstract String getFilePath();

    public abstract void openDataPath();

    public abstract String getAnnotationFilePath();

    public abstract void setAnnotationFilePath(String var1);

    public abstract int getDataType();

    public boolean canAutoLoad(File file) {
        return false;
    }

    protected int getCountOfLines(File file) throws IOException {
        String currentLine;
        int count = 0;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((currentLine = reader.readLine()) != null) {
            ++count;
        }
        reader.close();
        return count;
    }

    public abstract void setFilePath(String var1);

    public Point getFirstExpressionCell(Vector<Vector<String>> dataVector) {
        if (this.firstRow == -1 || this.firstCol == -1) {
            int guessCol = 0;
            int guessRow = 0;
            Vector<String> lastRow = dataVector.get(dataVector.size() - 1);
            for (int j = lastRow.size() - 1; j >= 0; --j) {
                String thisEntry = lastRow.get(j);
                try {
                    Float temp = new Float(thisEntry);
                    continue;
                }
                catch (Exception e) {
                    guessCol = j + 1;
                    break;
                }
            }
            for (int i = dataVector.size() - 1; i >= 0; --i) {
                Vector<String> thisRow = dataVector.get(i);
                try {
                    String thisEntry = thisRow.get(guessCol);
                    Float temp = new Float(thisEntry);
                    continue;
                }
                catch (Exception e) {
                    guessRow = i + 1;
                    break;
                }
            }
            if (guessCol == 0) {
                guessCol = 1;
            }
            return new Point(guessRow, guessCol);
        }
        return new Point(this.firstRow - 1, this.firstCol);
    }
}

