/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.FileLoaderUtility;

public class DFCI_CoreFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private DFCI_CoreFileLoaderPanel aflp;
    private boolean loadEnabled = false;
    private File[] files;
    private int affyDataType = 2;
    private Hashtable _tempAnno = new Hashtable();
    private MultipleArrayViewer mav;
    protected MevAnnotation mevAnno = new MevAnnotation();
    private String annotationFileName;

    public DFCI_CoreFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.aflp = new DFCI_CoreFileLoaderPanel();
    }

    @Override
    public void setFilePath(String path) {
        this.aflp.pathTextField.setText(path);
        File fileDir = new File(path);
        File[] allFiles = fileDir.listFiles();
        Vector<File> v = new Vector<File>(allFiles.length);
        for (int i = 0; i < allFiles.length; ++i) {
            v.add(allFiles[i]);
        }
        this.processFileList(path, v);
    }

    @Override
    public Vector<ISlideData> loadExpressionFiles() throws IOException {
        Object[] affymetrixFiles = this.aflp.getAffymetrixSelectedListModel().toArray();
        String[] fieldNames = new String[]{"Affy_ID", "Detection", "P-value"};
        ISlideData[] data = null;
        this.files = new File[affymetrixFiles.length];
        for (int j = 0; j < affymetrixFiles.length; ++j) {
            File file;
            this.files[j] = file = new File(this.aflp.pathTextField.getText(), ((File)affymetrixFiles[j]).getName());
        }
        if (this.isAnnotationSelected()) {
            this.mav.getData().setAnnotationLoaded(true);
            AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader(new File(this.getAnnotationFilePath()));
            this._tempAnno = afr.getAffyAnnotation();
            this.chipAnno = afr.getAffyChipAnnotation();
        }
        if (this.aflp.absoluteRadioButton.isSelected()) {
            data = this.loadAffyAbsolute(this.files);
            this.affyDataType = 2;
        } else if (this.aflp.absMeanRadioButton.isSelected()) {
            data = this.loadAffyAbsMean(this.files);
            this.affyDataType = 4;
        } else if (this.aflp.referenceRadioButton.isSelected()) {
            Object[] list = this.aflp.getRefSelectedListModel().toArray();
            Object[] dataList = this.aflp.getAffymetrixSelectedListModel().toArray();
            if (list.length < 1) {
                return null;
            }
            if (list.length >= 1) {
                if (dataList.length < 1) {
                    return null;
                }
                File refFile = new File(this.aflp.refFileListTextField.getText(), ((File)list[0]).getName());
                File[] dataFiles = this.toFileArray(dataList);
                data = this.loadAffyReference(refFile, dataFiles);
                this.affyDataType = 3;
            }
        }
        data[0].getSlideMetaData().setFieldNames(fieldNames);
        Vector<ISlideData> carrier = new Vector<ISlideData>();
        if (data != null) {
            TMEV.setDataType(2);
            for (int i = 0; i < data.length; ++i) {
                carrier.add(data[i]);
            }
        }
        return carrier;
    }

    private File[] toFileArray(Object[] files) {
        File[] dataFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            dataFiles[i] = new File(this.aflp.pathTextField.getText(), ((File)files[i]).getName());
        }
        return dataFiles;
    }

    @Override
    public ISlideData loadExpressionFile(File currentFile) throws IOException {
        return null;
    }

    public Vector loadReferenceFile(File currentFile) throws IOException {
        return new Vector();
    }

    @Override
    public int getDataType() {
        return this.affyDataType;
    }

    private ISlideData[] loadAffyReference(File refFile, File[] files) throws IOException {
        int i;
        if (files.length < 1) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(refFile));
        int numTokens = 0;
        String[] headfields = new String[]{"Probe Set Name", "Signal", "Detection", "Detection p-value"};
        int[] tag = new int[4];
        StringSplitter ss = new StringSplitter('\t');
        int countOfLines = this.getCountOfLines(refFile) - 3;
        float[] refSignals = new float[countOfLines];
        int index = 0;
        String currentLine = reader.readLine();
        currentLine = reader.readLine();
        currentLine = reader.readLine();
        ss.init(currentLine);
        numTokens = ss.countTokens();
        int m = 0;
        int k = 0;
        for (k = 0; k < numTokens; ++k) {
            if (m >= 4 || !ss.nextToken().equals(headfields[m])) continue;
            tag[m] = k;
            ++m;
        }
        while ((currentLine = reader.readLine()) != null) {
            this.setFileProgress(index);
            ss.init(currentLine);
            m = 0;
            String tmp = "";
            for (int j = 0; j < tag[3] + 1; ++j) {
                tmp = ss.nextToken();
                if (j != tag[m]) continue;
                if (m == 1) {
                    refSignals[index] = new Float(tmp).floatValue();
                    ++index;
                }
                ++m;
            }
        }
        reader.close();
        ISlideData[] slideData = new ISlideData[files.length];
        countOfLines = 0;
        int numOfProbesets = 0;
        this.setFilesCount(files.length);
        for (i = 0; i < files.length; ++i) {
            if (this.stop) {
                return null;
            }
            this.setFilesProgress(i);
            this.setRemain(files.length - i);
            this.setFileName(files[i].getPath());
            if (i == 0) {
                countOfLines = this.getCountOfLines(files[i]);
                this.setLinesCount(countOfLines);
                numOfProbesets = countOfLines - 3;
            }
            if (this.meta == null) {
                slideData[i] = this.loadAffySlideData(files[i]);
                this.meta = slideData[i].getSlideMetaData();
                continue;
            }
            slideData[i] = this.loadAffyFloatSlideData(files[i], numOfProbesets, this.meta);
        }
        for (i = 0; i < files.length; ++i) {
            for (int j = 0; j < numOfProbesets; ++j) {
                slideData[i].setIntensities(j, refSignals[j], slideData[i].getCY5(j));
            }
        }
        return slideData;
    }

    private ISlideData[] loadAffyAbsMean(File[] files) throws IOException {
        int j;
        int i;
        if (files.length < 1) {
            return null;
        }
        ISlideData[] slideData = new ISlideData[files.length];
        int countOfLines = 0;
        int numOfProbesets = 0;
        countOfLines = this.getCountOfLines(files[0]);
        this.setLinesCount(countOfLines);
        numOfProbesets = countOfLines - 3;
        float[] totalOfSignals = new float[numOfProbesets];
        this.setFilesCount(files.length);
        for (i = 0; i < files.length; ++i) {
            if (this.stop) {
                return null;
            }
            this.setFilesProgress(i);
            this.setRemain(files.length - i);
            this.setFileName(files[i].getPath());
            if (this.meta == null) {
                slideData[i] = this.loadAffySlideData(files[i]);
                this.meta = slideData[i].getSlideMetaData();
                for (j = 0; j < numOfProbesets; ++j) {
                    int n = j;
                    totalOfSignals[n] = totalOfSignals[n] + slideData[i].getCY5(j);
                }
                continue;
            }
            slideData[i] = this.loadAffyFloatSlideData(files[i], numOfProbesets, this.meta);
            for (j = 0; j < numOfProbesets; ++j) {
                int n = j;
                totalOfSignals[n] = totalOfSignals[n] + slideData[i].getCY5(j);
            }
        }
        for (i = 0; i < numOfProbesets; ++i) {
            totalOfSignals[i] = totalOfSignals[i] / (float)files.length;
        }
        for (i = 0; i < files.length; ++i) {
            for (j = 0; j < numOfProbesets; ++j) {
                slideData[i].setIntensities(j, totalOfSignals[j], slideData[i].getCY5(j));
            }
        }
        return slideData;
    }

    private ISlideData[] loadAffyAbsolute(File[] files) throws IOException {
        if (files.length < 1) {
            return null;
        }
        ISlideData[] slideData = new ISlideData[files.length];
        int countOfLines = 0;
        int numOfProbesets = 0;
        this.setFilesCount(files.length);
        for (int i = 0; i < files.length; ++i) {
            if (this.stop) {
                return null;
            }
            this.setFilesProgress(i);
            this.setRemain(files.length - i);
            this.setFileName(files[i].getPath());
            if (i == 0) {
                countOfLines = this.getCountOfLines(files[i]);
                this.setLinesCount(countOfLines);
                numOfProbesets = countOfLines - 3;
            }
            if (this.meta == null) {
                slideData[i] = this.loadAffySlideData(files[i]);
                this.meta = slideData[i].getSlideMetaData();
                continue;
            }
            slideData[i] = this.loadAffyFloatSlideData(files[i], numOfProbesets, this.meta);
        }
        return slideData;
    }

    private ISlideData loadAffySlideData(File file) throws IOException {
        AffySlideDataElement slideDataElement = null;
        String[] headfields = new String[]{"Probe Set Name", "Signal", "Detection", "Detection p-value"};
        int[] tag = new int[4];
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(0);
            TMEV.setNameIndex(3);
            TMEV.setIndicesAdjusted(true);
        }
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        String[] moreFields = new String[3];
        String detection = "";
        float[] intensities = new float[2];
        int maxRows = this.getCountOfLines(this.files[0]);
        int maxColumns = 1;
        SampleAnnotation sampAnn = new SampleAnnotation();
        SlideData slideData = new SlideData(maxRows, maxColumns, sampAnn);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int curpos = 0;
        int row = 1;
        int column = 1;
        int numTokens = 0;
        StringSplitter ss = new StringSplitter('\t');
        String currentLine = reader.readLine();
        currentLine = reader.readLine();
        currentLine = reader.readLine();
        ss.init(currentLine);
        numTokens = ss.countTokens();
        int m = 0;
        int k = 0;
        for (k = 0; k < numTokens; ++k) {
            if (m >= 4 || !ss.nextToken().equals(headfields[m])) continue;
            tag[m] = k;
            ++m;
        }
        while ((currentLine = reader.readLine()) != null) {
            this.setFileProgress(curpos++);
            ss = new StringSplitter('\t');
            ss.init(currentLine);
            rows[2] = row++;
            rows[0] = rows[2];
            columns[0] = columns[2] = column;
            m = 0;
            String tmp = "";
            for (int i = 0; i < tag[3] + 1; ++i) {
                tmp = ss.nextToken();
                if (i != tag[m]) continue;
                if (m == 0) {
                    moreFields[0] = tmp;
                } else if (m == 1) {
                    intensities[0] = 1.0f;
                    intensities[1] = new Float(tmp).floatValue();
                } else if (m == 2) {
                    detection = tmp;
                    moreFields[1] = tmp;
                } else if (m == 3) {
                    moreFields[2] = tmp;
                }
                ++m;
            }
            String cloneName = moreFields[0];
            if (this._tempAnno.size() != 0) {
                MevAnnotation mevAnno;
                if ((MevAnnotation)this._tempAnno.get(cloneName) != null) {
                    mevAnno = (MevAnnotation)this._tempAnno.get(cloneName);
                    slideDataElement = new AffySlideDataElement(String.valueOf(curpos), rows, columns, intensities, moreFields, mevAnno);
                } else {
                    mevAnno = new MevAnnotation();
                    mevAnno.setCloneID(cloneName);
                    slideDataElement = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields, mevAnno);
                }
            } else {
                slideDataElement = new AffySlideDataElement(String.valueOf(curpos), rows, columns, intensities, moreFields);
            }
            slideDataElement.setDetection(detection);
            slideDataElement.setPvalue(new Float(moreFields[2]).floatValue());
            slideData.addSlideDataElement(slideDataElement);
        }
        reader.close();
        slideData.setSampleAnnotationLoaded(true);
        slideData.getSampleAnnotation().setAnnotation("Default Slide Name", file.getName());
        this.mav.getData().setSampleAnnotationLoaded(true);
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    private ISlideData loadAffyFloatSlideData(File file, int countOfLines, ISlideMetaData slideMetaData) throws IOException {
        int numTokens = 0;
        String[] headfields = new String[]{"Probe Set Name", "Signal", "Detection", "Detection p-value"};
        float pvalue = 0.0f;
        int[] tag = new int[4];
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(0);
            TMEV.setNameIndex(3);
            TMEV.setIndicesAdjusted(true);
        }
        SampleAnnotation sampAnn = new SampleAnnotation();
        FloatSlideData slideData = new FloatSlideData(slideMetaData, sampAnn);
        BufferedReader reader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter ss = new StringSplitter('\t');
        float[] intensities = new float[2];
        String detection = "";
        int index = 0;
        String currentLine = reader.readLine();
        currentLine = reader.readLine();
        currentLine = reader.readLine();
        ss.init(currentLine);
        numTokens = ss.countTokens();
        int m = 0;
        int k = 0;
        for (k = 0; k < numTokens; ++k) {
            if (m >= 4 || !ss.nextToken().equals(headfields[m])) continue;
            tag[m] = k;
            ++m;
        }
        while ((currentLine = reader.readLine()) != null) {
            this.setFileProgress(index);
            ss.init(currentLine);
            m = 0;
            String tmp = "";
            for (int j = 0; j < tag[3] + 1; ++j) {
                tmp = ss.nextToken();
                if (j != tag[m]) continue;
                if (m == 1) {
                    intensities[0] = 1.0f;
                    intensities[1] = new Float(tmp).floatValue();
                } else if (m == 2) {
                    detection = tmp;
                } else if (m == 3) {
                    pvalue = new Float(tmp).floatValue();
                }
                ++m;
            }
            slideData.setIntensities(index, intensities[0], intensities[1]);
            slideData.setDetection(index, detection);
            slideData.setPvalue(index, pvalue);
            ++index;
        }
        reader.close();
        slideData.setSampleAnnotationLoaded(true);
        slideData.getSampleAnnotation().setAnnotation("Default Slide Name", file.getName());
        this.mav.getData().setSampleAnnotationLoaded(true);
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    public float get_Median(ArrayList<Float> float_array) {
        Float median;
        Collections.sort(float_array);
        if (float_array.size() == 1) {
            return float_array.get(0).floatValue();
        }
        int center = float_array.size() / 2;
        if (float_array.size() % 2 == 0) {
            Float a = float_array.get(center);
            Float b = float_array.get(center - 1);
            median = new Float((a.floatValue() + b.floatValue()) / 2.0f);
        } else {
            median = float_array.get(center);
        }
        return median.floatValue();
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter affymetrixFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt") || f.getName().endsWith(".TXT");
            }

            @Override
            public String getDescription() {
                return "Affymetrix Data Files (*.txt)";
            }
        };
        return affymetrixFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean state) {
        this.loadEnabled = state;
        this.setLoadEnabled(this.loadEnabled);
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.aflp;
    }

    public void processFileList(String filePath, Vector fileNames) {
        this.aflp.setPath(filePath);
        if (fileNames == null) {
            return;
        }
        FileFilter affymetrixFileFilter = this.getFileFilter();
        this.aflp.getAffymetrixAvailableListModel().clear();
        this.aflp.getRefAvailableListModel().clear();
        for (int i = 0; i < fileNames.size(); ++i) {
            File targetFile = new File((String)fileNames.elementAt(i));
            if (!affymetrixFileFilter.accept(targetFile)) continue;
            this.aflp.getAffymetrixAvailableListModel().addElement(new File((String)fileNames.elementAt(i)));
            this.aflp.getRefAvailableListModel().addElement(new File((String)fileNames.elementAt(i)));
        }
    }

    @Override
    public String getFilePath() {
        if (this.aflp.pathTextField == null) {
            return null;
        }
        return this.aflp.pathTextField.getText();
    }

    @Override
    public void openDataPath() {
    }

    public String getAnnotationFileName() {
        return this.annotationFileName;
    }

    public void setAnnotationFileName(String name) {
        this.annotationFileName = name;
    }

    @Override
    public String getAnnotationFilePath() {
        return this.aflp.adh.getAnnFilePath();
    }

    public boolean isAnnotationSelected() {
        return this.aflp.adh.isAnnotationSelected();
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
        this.aflp.adh.setAnnFilePath(filePath);
    }

    private class DFCI_CoreFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JPanel selectionPanel;
        JPanel fileLoaderPanel;
        JPanel affymetrixSelectionPanel;
        JPanel selectFilePanel;
        JLabel selectFile;
        JButton browseButton1;
        JTextField pathTextField;
        JPanel affymetrixListPanel;
        JLabel affymetrixAvailableLabel;
        JLabel affymetrixSelectedLabel;
        JList affymetrixAvailableList;
        JList affymetrixSelectedList;
        JScrollPane affymetrixAvailableScrollPane;
        JScrollPane affymetrixSelectedScrollPane;
        JPanel affymetrixButtonPanel;
        JButton affymetrixAddButton;
        JButton affymetrixAddAllButton;
        JButton affymetrixRemoveButton;
        JButton affymetrixRemoveAllButton;
        JPanel additionalReqPanel;
        JPanel refPanel;
        JTextField refFileListTextField;
        JLabel selectReference;
        JButton browseButton2;
        JPanel buttonPanel;
        ButtonGroup optionsButtonGroup;
        JRadioButton absMeanRadioButton;
        JRadioButton referenceRadioButton;
        JRadioButton absoluteRadioButton;
        JPanel refListPanel;
        JLabel refAvailableLabel;
        JLabel refSelectedLabel;
        JList refAvailableList;
        JList refSelectedList;
        JScrollPane refAvailableScrollPane;
        JScrollPane refSelectedScrollPane;
        JPanel refButtonPanel;
        JButton refAddButton;
        JButton refAddAllButton;
        JButton refRemoveButton;
        JButton refRemoveAllButton;
        JPanel annotationPanel;
        AnnotationDownloadHandler adh;

        public DFCI_CoreFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.adh = new AnnotationDownloadHandler(DFCI_CoreFileLoader.this.superLoader.viewer.getResourceManager(), DFCI_CoreFileLoader.this.superLoader.annotationLists, DFCI_CoreFileLoader.this.superLoader.defaultSpeciesName, DFCI_CoreFileLoader.this.superLoader.defaultArrayName);
            this.selectFilePanel = new JPanel();
            this.selectFilePanel.setLayout(new GridBagLayout());
            this.selectFile = new JLabel("Select expression data directory");
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.setSize(new Dimension(100, 30));
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.browseButton1.addActionListener(new EventHandler());
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            DFCI_CoreFileLoader.this.gba.add(this.selectFilePanel, this.selectFile, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.selectFilePanel, this.pathTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.selectFilePanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.affymetrixSelectionPanel = new JPanel();
            this.affymetrixSelectionPanel.setLayout(new GridBagLayout());
            this.affymetrixSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (DFCI_Core Format Files)"));
            this.affymetrixAvailableLabel = new JLabel("Available");
            this.affymetrixSelectedLabel = new JLabel("Selected");
            this.affymetrixAvailableList = new JList(new DefaultListModel());
            this.affymetrixSelectedList = new JList(new DefaultListModel());
            this.affymetrixAvailableScrollPane = new JScrollPane(this.affymetrixAvailableList);
            this.affymetrixSelectedScrollPane = new JScrollPane(this.affymetrixSelectedList);
            this.affymetrixAddButton = new JButton("Add");
            this.affymetrixAddButton.setPreferredSize(new Dimension(100, 20));
            this.affymetrixAddButton.addActionListener(new EventHandler());
            this.affymetrixAddAllButton = new JButton("Add All");
            this.affymetrixAddAllButton.setPreferredSize(new Dimension(100, 20));
            this.affymetrixAddAllButton.addActionListener(new EventHandler());
            this.affymetrixRemoveButton = new JButton("Remove");
            this.affymetrixRemoveButton.setPreferredSize(new Dimension(100, 20));
            this.affymetrixRemoveButton.addActionListener(new EventHandler());
            this.affymetrixRemoveAllButton = new JButton("Remove All");
            this.affymetrixRemoveAllButton.setPreferredSize(new Dimension(100, 20));
            this.affymetrixRemoveAllButton.addActionListener(new EventHandler());
            this.affymetrixButtonPanel = new JPanel();
            this.affymetrixButtonPanel.setLayout(new GridBagLayout());
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.absoluteRadioButton = new JRadioButton("Absolute", true);
            this.absoluteRadioButton.setFocusPainted(false);
            this.absMeanRadioButton = new JRadioButton("Absolute/Mean Intensity");
            this.absMeanRadioButton.setFocusPainted(false);
            this.referenceRadioButton = new JRadioButton("Reference (Select reference files below)");
            this.referenceRadioButton.setFocusPainted(false);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.absoluteRadioButton);
            bg.add(this.absMeanRadioButton);
            bg.add(this.referenceRadioButton);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            DFCI_CoreFileLoader.this.gba.add(buttonPanel, this.absoluteRadioButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 50, 0, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(buttonPanel, this.referenceRadioButton, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 50, 0, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(buttonPanel, this.absMeanRadioButton, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            this.affymetrixListPanel = new JPanel();
            this.affymetrixListPanel.setLayout(new GridBagLayout());
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixSelectionPanel, this.selectFilePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixSelectionPanel, buttonPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.affymetrixSelectionPanel, this.affymetrixListPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.annotationPanel = this.adh.getAnnotationLoaderPanel(DFCI_CoreFileLoader.this.gba);
            this.refPanel = new JPanel();
            this.refPanel.setLayout(new GridBagLayout());
            this.refFileListTextField = new JTextField();
            this.refFileListTextField.setEditable(false);
            this.refFileListTextField.setForeground(Color.black);
            this.refFileListTextField.setFont(new Font("monospaced", 1, 12));
            this.browseButton2 = new JButton("Browse");
            this.browseButton2.addActionListener(new EventHandler());
            this.browseButton2.setSize(new Dimension(100, 30));
            this.browseButton2.setPreferredSize(new Dimension(100, 30));
            this.selectReference = new JLabel("Select folder containing the Reference file");
            DFCI_CoreFileLoader.this.gba.add(this.refPanel, this.selectReference, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refPanel, this.refFileListTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refPanel, this.browseButton2, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.additionalReqPanel = new JPanel();
            this.additionalReqPanel.setLayout(new GridBagLayout());
            this.additionalReqPanel.setBorder(new TitledBorder(new EtchedBorder(), "Additional Requirements"));
            this.refAvailableLabel = new JLabel("Available Reference Files");
            this.refSelectedLabel = new JLabel("Selected Reference Files");
            this.refAvailableList = new JList(new DefaultListModel());
            this.refSelectedList = new JList(new DefaultListModel());
            this.refAvailableScrollPane = new JScrollPane(this.refAvailableList);
            this.refSelectedScrollPane = new JScrollPane(this.refSelectedList);
            this.refAddButton = new JButton("Add");
            this.refAddButton.addActionListener(new EventHandler());
            this.refAddAllButton = new JButton("Add All");
            this.refAddAllButton.addActionListener(new EventHandler());
            this.refRemoveButton = new JButton("Remove");
            this.refRemoveButton.addActionListener(new EventHandler());
            this.refRemoveAllButton = new JButton("Remove All");
            this.refRemoveAllButton.addActionListener(new EventHandler());
            Dimension buttonSize = new Dimension(100, 20);
            this.refAddButton.setPreferredSize(buttonSize);
            this.refAddAllButton.setPreferredSize(buttonSize);
            this.refRemoveButton.setPreferredSize(buttonSize);
            this.refRemoveAllButton.setPreferredSize(buttonSize);
            this.affymetrixAddAllButton.setFocusPainted(false);
            this.affymetrixAddButton.setFocusPainted(false);
            this.affymetrixRemoveAllButton.setFocusPainted(false);
            this.affymetrixRemoveButton.setFocusPainted(false);
            this.refAddAllButton.setFocusPainted(false);
            this.refAddButton.setFocusPainted(false);
            this.refRemoveAllButton.setFocusPainted(false);
            this.refRemoveButton.setFocusPainted(false);
            this.refButtonPanel = new JPanel();
            this.refButtonPanel.setLayout(new GridBagLayout());
            DFCI_CoreFileLoader.this.gba.add(this.refButtonPanel, this.refAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refButtonPanel, this.refAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refButtonPanel, this.refRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refButtonPanel, this.refRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.refListPanel = new JPanel();
            this.refListPanel.setLayout(new GridBagLayout());
            DFCI_CoreFileLoader.this.gba.add(this.refListPanel, this.refAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refListPanel, this.refSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refListPanel, this.refAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refListPanel, this.refButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.refListPanel, this.refSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.additionalReqPanel, buttonPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.additionalReqPanel, this.refPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 0, 2, 0), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.additionalReqPanel, this.refListPanel, 0, 3, 1, 2, 1, 1, 1, 10, new Insets(2, 2, 0, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.selectionPanel, this.additionalReqPanel, 0, 7, 2, 2, 1, 1, 1, 10, new Insets(0, 2, 0, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.selectionPanel, this.affymetrixSelectionPanel, 0, 1, 2, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.selectionPanel, this.annotationPanel, 0, 3, 2, 3, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this.selectionPanel, this.additionalReqPanel, 0, 6, 2, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            DFCI_CoreFileLoader.this.gba.add(this.fileLoaderPanel, this.selectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            DFCI_CoreFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        }

        public void onDataFileBrowse() {
            FileLoaderUtility fileLoad = new FileLoaderUtility();
            Vector retrievedFileNames = new Vector();
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(1);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                ((DefaultListModel)this.affymetrixAvailableList.getModel()).clear();
                ((DefaultListModel)this.affymetrixSelectedList.getModel()).clear();
                File selectedFile = fileChooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                this.pathTextField.setText(path);
                retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
                for (int i = 0; i < retrievedFileNames.size(); ++i) {
                    Object fileName = retrievedFileNames.get(i);
                    boolean acceptFile = DFCI_CoreFileLoader.this.getFileFilter().accept((File)fileName);
                    if (!acceptFile) continue;
                    String Name = fileChooser.getName((File)fileName);
                    ((DefaultListModel)this.affymetrixAvailableList.getModel()).addElement(new File(Name));
                }
            }
        }

        public void onRefFileBrowse() {
            FileLoaderUtility fileLoad = new FileLoaderUtility();
            Vector retrievedFileNames = new Vector();
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(1);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                ((DefaultListModel)this.refAvailableList.getModel()).clear();
                ((DefaultListModel)this.refSelectedList.getModel()).clear();
                File selectedFile = fileChooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                this.refFileListTextField.setText(path);
                retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
                for (int i = 0; i < retrievedFileNames.size(); ++i) {
                    Object fileName = retrievedFileNames.get(i);
                    boolean acceptFile = DFCI_CoreFileLoader.this.getFileFilter().accept((File)fileName);
                    if (!acceptFile) continue;
                    String Name = fileChooser.getName((File)fileName);
                    ((DefaultListModel)this.refAvailableList.getModel()).addElement(new File(Name));
                }
            }
        }

        public void setPath(String path) {
            this.pathTextField.setText(path);
        }

        public void openDataPath() {
        }

        public void validateLists() {
            if (((DefaultListModel)this.affymetrixSelectedList.getModel()).size() > 0) {
                if (this.referenceRadioButton.isSelected()) {
                    if (((DefaultListModel)this.refSelectedList.getModel()).size() > 0) {
                        DFCI_CoreFileLoader.this.markLoadEnabled(true);
                    } else {
                        DFCI_CoreFileLoader.this.markLoadEnabled(false);
                    }
                } else {
                    DFCI_CoreFileLoader.this.markLoadEnabled(true);
                }
            } else {
                DFCI_CoreFileLoader.this.markLoadEnabled(false);
            }
        }

        public void onAffymetrixAdd() {
            int i;
            int[] chosenIndices = this.affymetrixAvailableList.getSelectedIndices();
            Object[] chosenObjects = new Object[chosenIndices.length];
            for (i = chosenIndices.length - 1; i >= 0; --i) {
                Object addItem = ((DefaultListModel)this.affymetrixAvailableList.getModel()).getElementAt(chosenIndices[i]);
                chosenObjects[i] = addItem;
            }
            for (i = 0; i < chosenIndices.length; ++i) {
                ((DefaultListModel)this.affymetrixSelectedList.getModel()).addElement(chosenObjects[i]);
            }
            this.validateLists();
        }

        public void onAffymetrixAddAll() {
            int elementCount = ((DefaultListModel)this.affymetrixAvailableList.getModel()).size();
            for (int i = 0; i < elementCount; ++i) {
                Object addItem = ((DefaultListModel)this.affymetrixAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.affymetrixSelectedList.getModel()).addElement(addItem);
            }
            this.validateLists();
        }

        public void onAffymetrixRemove() {
            int[] chosenIndices = this.affymetrixSelectedList.getSelectedIndices();
            for (int i = chosenIndices.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.affymetrixSelectedList.getModel()).remove(chosenIndices[i]);
            }
            this.validateLists();
        }

        public void onAffymetrixRemoveAll() {
            ((DefaultListModel)this.affymetrixSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public void onRefAdd() {
            int i;
            int[] chosenIndices = this.refAvailableList.getSelectedIndices();
            Object[] chosenObjects = new Object[chosenIndices.length];
            for (i = chosenIndices.length - 1; i >= 0; --i) {
                Object addItem = ((DefaultListModel)this.refAvailableList.getModel()).getElementAt(chosenIndices[i]);
                chosenObjects[i] = addItem;
            }
            for (i = 0; i < chosenIndices.length; ++i) {
                ((DefaultListModel)this.refSelectedList.getModel()).addElement(chosenObjects[i]);
            }
            this.validateLists();
        }

        public void onRefAddAll() {
            int elementCount = ((DefaultListModel)this.refAvailableList.getModel()).size();
            for (int i = 0; i < elementCount; ++i) {
                Object addItem = ((DefaultListModel)this.refAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.refSelectedList.getModel()).addElement(addItem);
            }
            this.validateLists();
        }

        public void onRefRemove() {
            int[] chosenIndices = this.refSelectedList.getSelectedIndices();
            for (int i = chosenIndices.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.refSelectedList.getModel()).remove(chosenIndices[i]);
            }
            this.validateLists();
        }

        public void onRefRemoveAll() {
            ((DefaultListModel)this.refSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public DefaultListModel getAffymetrixAvailableListModel() {
            return (DefaultListModel)this.affymetrixAvailableList.getModel();
        }

        public DefaultListModel getRefAvailableListModel() {
            return (DefaultListModel)this.refAvailableList.getModel();
        }

        public DefaultListModel getAffymetrixSelectedListModel() {
            return (DefaultListModel)this.affymetrixSelectedList.getModel();
        }

        public DefaultListModel getRefSelectedListModel() {
            return (DefaultListModel)this.refSelectedList.getModel();
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            @Override
            public void nodeSelected(FileTreePaneEvent event) {
                String filePath = (String)event.getValue("Path");
                Vector fileNames = (Vector)event.getValue("Filenames");
                DFCI_CoreFileLoader.this.processFileList(filePath, fileNames);
            }

            @Override
            public void nodeCollapsed(FileTreePaneEvent event) {
            }

            @Override
            public void nodeExpanded(FileTreePaneEvent event) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == DFCI_CoreFileLoaderPanel.this.affymetrixAddButton) {
                    DFCI_CoreFileLoaderPanel.this.onAffymetrixAdd();
                } else if (source == DFCI_CoreFileLoaderPanel.this.affymetrixAddAllButton) {
                    DFCI_CoreFileLoaderPanel.this.onAffymetrixAddAll();
                } else if (source == DFCI_CoreFileLoaderPanel.this.affymetrixRemoveButton) {
                    DFCI_CoreFileLoaderPanel.this.onAffymetrixRemove();
                } else if (source == DFCI_CoreFileLoaderPanel.this.affymetrixRemoveAllButton) {
                    DFCI_CoreFileLoaderPanel.this.onAffymetrixRemoveAll();
                } else if (source == DFCI_CoreFileLoaderPanel.this.refAddButton) {
                    DFCI_CoreFileLoaderPanel.this.onRefAdd();
                } else if (source == DFCI_CoreFileLoaderPanel.this.refAddAllButton) {
                    DFCI_CoreFileLoaderPanel.this.onRefAddAll();
                } else if (source == DFCI_CoreFileLoaderPanel.this.refRemoveButton) {
                    DFCI_CoreFileLoaderPanel.this.onRefRemove();
                } else if (source == DFCI_CoreFileLoaderPanel.this.refRemoveAllButton) {
                    DFCI_CoreFileLoaderPanel.this.onRefRemoveAll();
                } else if (source == DFCI_CoreFileLoaderPanel.this.browseButton1) {
                    DFCI_CoreFileLoaderPanel.this.onDataFileBrowse();
                } else if (source == DFCI_CoreFileLoaderPanel.this.browseButton2) {
                    DFCI_CoreFileLoaderPanel.this.onRefFileBrowse();
                } else if (source instanceof JRadioButton) {
                    DFCI_CoreFileLoader.this.aflp.validateLists();
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

