/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.CGHSlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.cgh.CGHDataGenerator.CGHCloneComparator;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;

public class CGHStanfordFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private boolean stop = false;
    private CGHStanfordFileLoaderPanel CGHsflp;
    private ExpressionFileTableCellRenderer myCellRenderer;
    private MultipleArrayViewer mav = this.superLoader.getArrayViewer();

    public CGHStanfordFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.gba = new GBA();
        this.CGHsflp = new CGHStanfordFileLoaderPanel();
    }

    public Vector loadExpressionFiles() throws IOException {
        return this.loadStanfordExpressionFile(new File(this.CGHsflp.fileNameTextField.getText()));
    }

    @Override
    public void setFilePath(String path) {
        this.CGHsflp.fileNameTextField.setText(path);
        this.processStanfordFile(new File(path));
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    public Vector loadStanfordExpressionFile(File f) throws IOException {
        String currentLine;
        int preSpotRows = this.CGHsflp.getXRow() + 1;
        int preExperimentColumns = this.CGHsflp.getXColumn();
        int species = this.CGHsflp.getXSpecies();
        boolean isLog2 = this.CGHsflp.getXLog2Status();
        ArrayList clones = new ArrayList();
        if (preExperimentColumns < 5) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "Insufficient annotation.", "TDMS Load Error", 1);
        }
        int cloneFileIndex = 0;
        int numLines = this.getCountOfLines(f);
        int spotCount = numLines - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        CGHClone[] cloneArray = new CGHClone[numLines - 1];
        Hashtable<String, Integer> unSortedCloneNames = new Hashtable<String, Integer>();
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        String[] moreFields = new String[preExperimentColumns];
        boolean rColumns = true;
        int rRows = spotCount;
        ISlideData[] slideDataArray = null;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        int counter = 0;
        int column = 1;
        int row = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(numLines);
        this.setFileProgress(0);
        while ((currentLine = reader.readLine()) != null) {
            int i;
            if (this.stop) {
                return null;
            }
            ss.init(currentLine);
            if (counter == 0) {
                int i2;
                int experimentCount = ss.countTokens() + 1 - preExperimentColumns;
                slideDataArray = new ISlideData[experimentCount];
                SampleAnnotation sampAnn = new SampleAnnotation();
                slideDataArray = new ISlideData[experimentCount];
                slideDataArray[0] = new SlideData(rRows, 1, sampAnn);
                slideDataArray[0].setSlideFileName(f.getPath());
                for (int i3 = 1; i3 < slideDataArray.length; ++i3) {
                    sampAnn = new SampleAnnotation();
                    slideDataArray[i3] = new FloatSlideData(slideDataArray[0].getSlideMetaData(), spotCount, sampAnn);
                    slideDataArray[i3].setSlideFileName(f.getPath());
                }
                String[] fieldNames = new String[preExperimentColumns];
                for (i2 = 0; i2 < preExperimentColumns; ++i2) {
                    fieldNames[i2] = ss.nextToken();
                }
                slideDataArray[0].getSlideMetaData().setFieldNames(fieldNames);
                for (i2 = 0; i2 < experimentCount; ++i2) {
                    String val = ss.nextToken();
                    slideDataArray[i2].setSampleAnnotationLoaded(true);
                    slideDataArray[i2].getSampleAnnotation().setAnnotation("Default Slide Name", val);
                    slideDataArray[i2].setSlideDataName(val);
                    this.mav.getData().setSampleAnnotationLoaded(true);
                }
            } else if (counter >= preSpotRows) {
                CGHClone clone_T2;
                rows[0] = rows[2] = row++;
                columns[0] = columns[2] = column;
                column = column == 1 ? 1 : ++column;
                for (i = 0; i < preExperimentColumns; ++i) {
                    moreFields[i] = ss.nextToken();
                }
                cloneArray[cloneFileIndex] = clone_T2 = new CGHClone(moreFields[0].trim(), moreFields[1].trim(), moreFields[2].trim(), moreFields[3].trim(), species);
                unSortedCloneNames.put(moreFields[0].trim(), new Integer(cloneFileIndex));
                CGHSlideDataElement sde = new CGHSlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], moreFields);
                slideDataArray[0].addSlideDataElement(sde);
                for (int i4 = 0; i4 < slideDataArray.length; ++i4) {
                    float cy5;
                    float cy3 = 1.0f;
                    try {
                        String value = ss.nextToken();
                        cy5 = Float.parseFloat(value);
                    }
                    catch (Exception e) {
                        cy3 = 0.0f;
                        cy5 = Float.NaN;
                    }
                    slideDataArray[i4].setIntensities(counter - preSpotRows, cy3, cy5);
                }
                ++cloneFileIndex;
            } else {
                for (i = 0; i < preExperimentColumns - 1; ++i) {
                    ss.nextToken();
                }
                String key = ss.nextToken();
                for (int j = 0; j < slideDataArray.length; ++j) {
                    if (slideDataArray[j].getSampleAnnotation() != null) {
                        String val = ss.nextToken();
                        slideDataArray[j].getSampleAnnotation().setAnnotation(key, val);
                        continue;
                    }
                    SampleAnnotation sampAnn = new SampleAnnotation();
                    sampAnn.setAnnotation(key, ss.nextToken());
                    slideDataArray[j].setSampleAnnotation(sampAnn);
                    slideDataArray[j].setSampleAnnotationLoaded(true);
                }
            }
            this.setFileProgress(counter);
            ++counter;
        }
        reader.close();
        ((MultipleArrayData)this.mav.getData()).setHasDyeSwap(false);
        ((MultipleArrayData)this.mav.getData()).setLog2Data(isLog2);
        ((MultipleArrayData)this.mav.getData()).setHasCloneDistribution(false);
        ((MultipleArrayData)this.mav.getData()).setCGHData();
        ((MultipleArrayData)this.mav.getData()).setCGHSpecies(species);
        List<CGHClone> sortedList = Arrays.asList(cloneArray);
        Collections.sort(sortedList, new CGHCloneComparator());
        this.sortSlideDataArrays(slideDataArray, sortedList, unSortedCloneNames, clones, species);
        int[][] chrIndices = CGHStanfordFileLoader.calculateChromosomeIndices(sortedList);
        unSortedCloneNames.clear();
        unSortedCloneNames = null;
        cloneArray = null;
        sortedList = null;
        ((MultipleArrayData)this.mav.getData()).setChromosomeIndices(chrIndices);
        int[] samplesOrder = this.generateDefaultSamplesOrder(slideDataArray);
        ((MultipleArrayData)this.mav.getData()).setSamplesOrder(samplesOrder);
        ((MultipleArrayData)this.mav.getData()).setClones(clones);
        Vector<ISlideData> data = new Vector<ISlideData>(slideDataArray.length);
        for (int i = 0; i < slideDataArray.length; ++i) {
            data.add(slideDataArray[i]);
        }
        this.setFilesProgress(1);
        return data;
    }

    public static int[][] calculateChromosomeIndices(List sortedList) {
        int ii;
        int numClones = sortedList.size();
        int numChromosomes = ((CGHClone)sortedList.get(sortedList.size() - 1)).getChromosomeIndex() + 1;
        int[][] chromosomeIndices = new int[numChromosomes][3];
        chromosomeIndices[0][0] = 0;
        int curChromosomeIndex = 0;
        Iterator clonesIt = sortedList.iterator();
        int i = 0;
        while (clonesIt.hasNext()) {
            CGHClone curClone = (CGHClone)clonesIt.next();
            curClone.setSortedIndex(i);
            while (curClone.getChromosomeIndex() > curChromosomeIndex) {
                chromosomeIndices[curChromosomeIndex][1] = i - 1;
                chromosomeIndices[++curChromosomeIndex][0] = i;
            }
            ++i;
        }
        chromosomeIndices[numChromosomes - 1][1] = numClones - 1;
        for (ii = 0; ii < numChromosomes; ++ii) {
            chromosomeIndices[ii][2] = chromosomeIndices[ii][1] - chromosomeIndices[ii][0] + 1;
        }
        for (ii = 0; ii < numChromosomes; ++ii) {
            int st = chromosomeIndices[ii][0];
            int end = chromosomeIndices[ii][1];
            int len = chromosomeIndices[ii][2];
        }
        return chromosomeIndices;
    }

    private int[] generateDefaultSamplesOrder(ISlideData[] slideDataArray) {
        int[] samplesOrder = new int[slideDataArray.length];
        for (int i = 0; i < samplesOrder.length; ++i) {
            samplesOrder[i] = i;
        }
        return samplesOrder;
    }

    private void sortSlideDataArray(ISlideData[] slideDataArray, List sorted, ArrayList unSorted, ArrayList clones, int species) {
        Iterator clonesIt = sorted.iterator();
        int sortInd_T = 0;
        while (clonesIt.hasNext()) {
            CGHSlideDataElement sde_T1;
            CGHClone clone_T1;
            CGHClone curClone = (CGHClone)clonesIt.next();
            int ind_T = unSorted.indexOf(curClone.getName());
            clones.add(curClone);
            if (curClone.getName() != unSorted.get(ind_T)) {
                System.out.println("Swap Sort Ind, File Ind: " + sortInd_T + ", " + ind_T);
                System.out.println("Sorted clone entry: " + curClone.getName());
                System.out.println("UnSorted clone entry: " + unSorted.get(ind_T));
                System.exit(1);
            }
            if ((clone_T1 = (sde_T1 = (CGHSlideDataElement)slideDataArray[0].getSlideDataElement(sortInd_T)).getClone(species)) == null) {
                System.out.println("Null CGHClone");
                System.exit(1);
            }
            for (int j = 0; j < slideDataArray.length; ++j) {
                if (j == 0) {
                    CGHSlideDataElement rem_T = (CGHSlideDataElement)((SlideData)slideDataArray[j]).set(ind_T, sde_T1);
                    ((SlideData)slideDataArray[j]).setElementAt(rem_T, sortInd_T);
                    continue;
                }
                FloatSlideData fse_T = (FloatSlideData)slideDataArray[j];
                float cy3_1 = fse_T.getCY3(sortInd_T);
                float cy5_1 = fse_T.getCY5(sortInd_T);
                float cy3_2 = fse_T.getCY3(ind_T);
                float cy5_2 = fse_T.getCY5(ind_T);
                fse_T.setIntensities(ind_T, cy3_1, cy5_1);
                fse_T.setIntensities(sortInd_T, cy3_2, cy5_2);
            }
            String name_T = unSorted.set(ind_T, clone_T1.getName());
            unSorted.set(sortInd_T, name_T);
            ++sortInd_T;
        }
        System.out.println("Loop times: " + sortInd_T);
        System.out.println("# of SlideDataElements: " + slideDataArray[0].getSize() + ", " + sorted.size());
    }

    private void sortSlideDataArrays(ISlideData[] slideDataArray, List sorted, Hashtable unSorted, ArrayList clones, int species) {
        System.out.println("List size: " + sorted.size());
        System.out.println("unSorted size: " + unSorted.size());
        Iterator clonesIt = sorted.iterator();
        int sortInd_T = 0;
        while (clonesIt.hasNext()) {
            CGHClone curClone = (CGHClone)clonesIt.next();
            Integer int_T = (Integer)unSorted.get(curClone.getName());
            if (int_T == null) {
                System.out.println("Sorted clone entry not found in Hashtable: " + curClone.getName());
                System.exit(1);
            }
            int ind_T = int_T;
            clones.add(curClone);
            CGHSlideDataElement sde_T1 = (CGHSlideDataElement)slideDataArray[0].getSlideDataElement(sortInd_T);
            CGHClone clone_T1 = sde_T1.getClone(species);
            if (clone_T1 == null) {
                System.out.println("Null CGHClone");
                System.exit(1);
            }
            for (int j = 0; j < slideDataArray.length; ++j) {
                if (j == 0) {
                    CGHSlideDataElement rem_T = (CGHSlideDataElement)((SlideData)slideDataArray[j]).set(ind_T, sde_T1);
                    ((SlideData)slideDataArray[j]).setElementAt(rem_T, sortInd_T);
                    continue;
                }
                FloatSlideData fse_T = (FloatSlideData)slideDataArray[j];
                float cy3_1 = fse_T.getCY3(sortInd_T);
                float cy5_1 = fse_T.getCY5(sortInd_T);
                float cy3_2 = fse_T.getCY3(ind_T);
                float cy5_2 = fse_T.getCY5(ind_T);
                fse_T.setIntensities(ind_T, cy3_1, cy5_1);
                fse_T.setIntensities(sortInd_T, cy3_2, cy5_2);
            }
            Integer loc_T = unSorted.put(clone_T1.getName(), new Integer(ind_T));
            unSorted.put(curClone.getName(), loc_T);
            ++sortInd_T;
        }
        System.out.println("# of SlideDataElements: " + slideDataArray[0].getSize() + ", " + sorted.size());
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "CGH Tab Delimited, Multiple Sample Files (*.txt)";
            }
        };
        return mevFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.CGHsflp.getXRow() + 1;
        int tableColumn = this.CGHsflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.CGHsflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.CGHsflp;
    }

    public void processStanfordFile(File targetFile) {
        Vector<String> columnHeaders = new Vector<String>();
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        String currentLine = null;
        if (!this.validateFile(targetFile)) {
            return;
        }
        this.CGHsflp.setFileName(targetFile.getAbsolutePath());
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        try {
            reader = new BufferedReader(new FileReader(targetFile), 131072);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            currentLine = reader.readLine();
            ss.init(currentLine);
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                columnHeaders.add(ss.nextToken());
            }
            model.setColumnIdentifiers(columnHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && cnt < 100) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i = 0; i < ss.countTokens() + 1; ++i) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.CGHsflp.setTableModel(model);
        Point p = this.getFirstExpressionCell(dataVector);
        this.CGHsflp.setSelectedCell(p.x, p.y);
    }

    @Override
    public String getFilePath() {
        return this.CGHsflp.fileNameTextField.getText();
    }

    @Override
    public void openDataPath() {
        this.CGHsflp.openDataPath();
    }

    @Override
    public String getAnnotationFilePath() {
        return null;
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
    }

    private class CGHStanfordFileLoaderPanel
    extends JPanel {
        JTextField fileNameTextField;
        JTextField annFileNameTextField;
        JTextField selectedFiles;
        JPanel fileSelectionPanel;
        JRadioButton speciesHsButton;
        JRadioButton speciesMmButton;
        ButtonGroup speciesGroup;
        JRadioButton log2RatioButton;
        JRadioButton justRatioButton;
        ButtonGroup ratioGroup;
        JPanel additionalRequirements;
        JTable expressionTable;
        JLabel instructionsLabel;
        JLabel customAnnotation;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel fileLoaderPanel;
        JPanel annotationPanel;
        JButton browseButton1;
        JButton browseButton2;
        protected EventListener eventListener;
        JLabel fileSelectionLabel;
        JLabel dataSelection;
        private int xRow = -1;
        private int xColumn = -1;
        private int xSpecies = -1;
        private boolean isLog2 = false;

        public CGHStanfordFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.eventListener = new EventListener();
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.fileSelectionLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select data file</html>";
            this.dataSelection.setText(chooseFile);
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(this.eventListener);
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (CGH Stanford Format Files)"));
            CGHStanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.fileSelectionLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedFiles, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.speciesHsButton = new JRadioButton("Human", true);
            this.speciesHsButton.setFocusPainted(false);
            this.speciesMmButton = new JRadioButton("Mouse");
            this.speciesMmButton.setFocusPainted(false);
            this.speciesGroup = new ButtonGroup();
            this.speciesGroup.add(this.speciesHsButton);
            this.speciesGroup.add(this.speciesMmButton);
            this.additionalRequirements = new JPanel();
            this.additionalRequirements.setLayout(new GridBagLayout());
            this.additionalRequirements.setBorder(new TitledBorder(new EtchedBorder(), "Additional Requirements"));
            this.log2RatioButton = new JRadioButton("Log2 Ratio", true);
            this.log2RatioButton.setFocusPainted(false);
            this.justRatioButton = new JRadioButton("Ratio");
            this.justRatioButton.setFocusPainted(false);
            this.ratioGroup = new ButtonGroup();
            this.ratioGroup.add(this.log2RatioButton);
            this.ratioGroup.add(this.justRatioButton);
            CGHStanfordFileLoader.this.gba.add(this.additionalRequirements, this.speciesHsButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.additionalRequirements, this.speciesMmButton, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.additionalRequirements, this.log2RatioButton, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.additionalRequirements, this.justRatioButton, 1, 1, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            this.expressionTable = new JTable();
            CGHStanfordFileLoader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable.setDefaultRenderer(Object.class, CGHStanfordFileLoader.this.myCellRenderer);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    CGHStanfordFileLoaderPanel.this.setSelectedCell(CGHStanfordFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), CGHStanfordFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>First 5 columns MUST be ProbeID, Chromosome, Start, End and Description <BR>Columns MUST be in the order mentioned above<BR>Description field can contain anything e.g., Gene Symbol, RefSeq etc.<BR>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            CGHStanfordFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            CGHStanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.additionalRequirements, 0, 4, 1, 2, 3, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 7, 1, 6, 3, 6, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            CGHStanfordFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            CGHStanfordFileLoader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            CGHStanfordFileLoader.this.checkLoadEnable();
        }

        public void openDataPath() {
        }

        public void onBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                CGHStanfordFileLoader.this.processStanfordFile(selectedFile);
            }
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public int getXSpecies() {
            this.xSpecies = this.speciesHsButton.isSelected() ? 0 : (this.speciesMmButton.isSelected() ? 1 : -100);
            return this.xSpecies;
        }

        public boolean getXLog2Status() {
            if (this.log2RatioButton.isSelected()) {
                this.isLog2 = true;
            }
            if (this.justRatioButton.isSelected()) {
                this.isLog2 = false;
            }
            return this.isLog2;
        }

        public void selectStanfordFile() {
            JFileChooser jfc = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            jfc.setFileFilter(CGHStanfordFileLoader.this.getFileFilter());
            int activityCode = jfc.showDialog(this, "Select");
            if (activityCode == 0) {
                File target = jfc.getSelectedFile();
                CGHStanfordFileLoader.this.processStanfordFile(target);
            }
        }

        public void setFileName(String fileName) {
            this.fileNameTextField.setText(fileName);
            this.selectedFiles.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        private class EventListener
        implements ActionListener {
            private EventListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == CGHStanfordFileLoaderPanel.this.browseButton1) {
                    CGHStanfordFileLoaderPanel.this.onBrowse();
                }
            }
        }
    }
}

