/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ease.EASEEntrezSupportDataFile;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.ResourcererAnnotationFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class AnnotationDownloadHandler {
    public static final String GOT_ANNOTATION_FILE = "got-annotation-file";
    public static final String CHOOSE_ORGANISM = "Choose an organism";
    public static final String CHOOSE_ARRAY = "Choose an array";
    boolean annotationSelected = false;
    boolean isEnabled = true;
    JPanel annotationPanel;
    String defaultSpeciesName;
    String defaultArrayName;
    boolean inProgress = false;
    JComboBox organismListBox;
    JComboBox arrayListBox;
    JCheckBox proceedLoadingAnnotation;
    JRadioButton autoDownload;
    JRadioButton loadFromFile;
    JRadioButton bioconductor;
    JTextField annFileLocation = new JTextField("No file selected");
    JButton browseAnnFileButton;
    JLabel statusLabel;
    ButtonGroup bg = new ButtonGroup();
    JLabel optionalMessage;
    String datapath;
    Hashtable<String, Vector<String>> annotationLists;
    IResourceManager irm;
    private ActionListener additionalListener;

    public AnnotationDownloadHandler(IResourceManager irm, Hashtable<String, Vector<String>> annotationLists, String defaultSpeciesName, String defaultArrayName) {
        this.irm = irm;
        this.annotationLists = annotationLists;
        this.defaultSpeciesName = defaultSpeciesName;
        this.defaultArrayName = defaultArrayName;
    }

    public AnnotationDownloadHandler(IFramework framework) {
        this.irm = framework.getResourceManager();
        PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
        this.defaultSpeciesName = TMEV.getSettingForOption("last-loaded-species", CHOOSE_ORGANISM);
        this.defaultArrayName = TMEV.getSettingForOption("last-loaded-array", CHOOSE_ARRAY);
        try {
            File f = this.irm.getSupportFile(aafd, false);
            this.annotationLists = aafd.parseAnnotationListFile(f);
        }
        catch (SupportFileAccessError sfae) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JPanel getAnnotationLoaderPanel(GBA gba) {
        this.annotationPanel = new JPanel(){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(bg);
                if (this != null) {
                    if (AnnotationDownloadHandler.this.autoDownload != null) {
                        AnnotationDownloadHandler.this.autoDownload.setBackground(bg);
                    }
                    if (AnnotationDownloadHandler.this.loadFromFile != null) {
                        AnnotationDownloadHandler.this.loadFromFile.setBackground(bg);
                    }
                    if (AnnotationDownloadHandler.this.bioconductor != null) {
                        AnnotationDownloadHandler.this.bioconductor.setBackground(bg);
                    }
                    if (AnnotationDownloadHandler.this.proceedLoadingAnnotation != null) {
                        AnnotationDownloadHandler.this.proceedLoadingAnnotation.setBackground(bg);
                    }
                    if (AnnotationDownloadHandler.this.annFileLocation != null) {
                        AnnotationDownloadHandler.this.annFileLocation.setBackground(bg);
                    }
                    if (AnnotationDownloadHandler.this.arrayListBox != null) {
                        AnnotationDownloadHandler.this.arrayListBox.setBackground(bg);
                    }
                    if (AnnotationDownloadHandler.this.organismListBox != null) {
                        AnnotationDownloadHandler.this.organismListBox.setBackground(bg);
                    }
                }
            }
        };
        this.annotationPanel.setLayout(new GridBagLayout());
        this.annotationPanel.setBorder(new TitledBorder(new EtchedBorder(), "Load Annotation Data"));
        this.proceedLoadingAnnotation = new JCheckBox("Load Annotation");
        this.proceedLoadingAnnotation.setEnabled(true);
        this.proceedLoadingAnnotation.setSelected(false);
        this.autoDownload = new JRadioButton("Automatically download");
        this.loadFromFile = new JRadioButton("Load from local file");
        this.bioconductor = new JRadioButton("Download from Bioconductor");
        this.annFileLocation.setEditable(false);
        this.browseAnnFileButton = new JButton("Choose File");
        this.statusLabel = new JLabel("Please select a species name and array name.");
        this.bg.add(this.autoDownload);
        this.bg.add(this.loadFromFile);
        this.bg.add(this.bioconductor);
        this.autoDownload.addActionListener(new EventListener());
        this.loadFromFile.addActionListener(new EventListener());
        this.bioconductor.addActionListener(new EventListener());
        this.browseAnnFileButton.addActionListener(new EventListener());
        this.proceedLoadingAnnotation.addActionListener(new EventListener());
        if (this.annotationLists != null && this.annotationLists.size() > 0) {
            this.arrayListBox = new JComboBox();
            this.arrayListBox.setEnabled(true);
            this.arrayListBox.addActionListener(new EventListener());
            Vector<String> organisms = new Vector<String>(this.annotationLists.keySet());
            organisms.add(0, CHOOSE_ORGANISM);
            this.organismListBox = new JComboBox<String>(organisms);
            this.organismListBox.setSelectedIndex(0);
            this.organismListBox.addActionListener(new EventListener());
            if (this.defaultSpeciesName != null) {
                this.organismListBox.setSelectedItem(this.defaultSpeciesName);
            }
            this.updateArrayList(this.organismListBox.getSelectedItem().toString());
            this.arrayListBox.setSelectedItem(this.defaultArrayName);
            this.proceedLoadingAnnotation.setSelected(true);
        } else {
            Vector<String> temp = new Vector<String>();
            temp.add("No species available");
            this.organismListBox = new JComboBox(temp);
            this.organismListBox.setEnabled(false);
            Vector<String> temp2 = new Vector<String>();
            temp2.add("No arrays available");
            this.arrayListBox = new JComboBox(new Vector(temp2));
            this.arrayListBox.setEnabled(false);
            this.annotationLists = new Hashtable();
            this.proceedLoadingAnnotation.setEnabled(false);
            this.proceedLoadingAnnotation.setSelected(false);
        }
        int i = 0;
        if (this.optionalMessage != null) {
            i = 1;
            gba.add(this.annotationPanel, this.optionalMessage, 0, 0, 3, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 10), 0, 0);
        }
        gba.add(this.annotationPanel, this.autoDownload, 0, i, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 10), 0, 0);
        gba.add(this.annotationPanel, this.organismListBox, 0, i + 1, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 10), 0, 0);
        gba.add(this.annotationPanel, this.arrayListBox, 0, i + 2, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 10), 0, 0);
        gba.add(this.annotationPanel, this.loadFromFile, 1, i, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 10), 0, 0);
        gba.add(this.annotationPanel, this.annFileLocation, 1, i + 1, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 10), 0, 0);
        gba.add(this.annotationPanel, this.browseAnnFileButton, 1, i + 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 10), 0, 0);
        gba.add(this.annotationPanel, this.proceedLoadingAnnotation, 2, i, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.annotationPanel, this.statusLabel, 2, i + 1, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.checkForAnnotationFile();
        this.autoDownload.setSelected(true);
        this.onSelectAutoDownload();
        this.checkForAnnotationFile();
        return this.annotationPanel;
    }

    public void setOptionalMessage(String message) {
        this.optionalMessage = new JLabel(message);
    }

    public String getAnnFilePath() {
        return this.datapath;
    }

    public void setAnnFilePath(String filePath) {
        this.datapath = filePath;
        this.annFileLocation.setText(filePath);
    }

    protected void updateArrayList(String organismName) {
        this.arrayListBox.removeAllItems();
        Vector<String> annFileKeyBoxItems = this.annotationLists.get(organismName);
        if (annFileKeyBoxItems == null) {
            annFileKeyBoxItems = new Vector();
            annFileKeyBoxItems.add(0, CHOOSE_ARRAY);
        }
        if (annFileKeyBoxItems.get(0) == null || !annFileKeyBoxItems.get(0).equals(CHOOSE_ARRAY)) {
            annFileKeyBoxItems.add(0, CHOOSE_ARRAY);
        }
        for (int i = 0; i < annFileKeyBoxItems.size(); ++i) {
            this.arrayListBox.addItem(annFileKeyBoxItems.elementAt(i));
        }
    }

    protected void checkForAnnotationFile() {
        try {
            final String organismName = this.organismListBox.getSelectedItem().toString();
            final String arrayName = this.arrayListBox.getSelectedItem().toString();
            if (this.autoDownload.isSelected() && !organismName.equals(CHOOSE_ORGANISM) && !arrayName.equals(CHOOSE_ARRAY)) {
                final ResourcererAnnotationFileDefinition def = new ResourcererAnnotationFileDefinition(organismName, arrayName);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AnnotationDownloadHandler.this.inProgress = true;
                            AnnotationDownloadHandler.this.updateLabel();
                            try {
                                AnnotationDownloadHandler.this.datapath = AnnotationDownloadHandler.this.irm.getSupportFile(def, true).getAbsolutePath();
                                AnnotationDownloadHandler.this.setAnnFilePath(AnnotationDownloadHandler.this.datapath);
                            }
                            catch (SupportFileAccessError sfae) {
                                AnnotationDownloadHandler.this.annotationSelected = false;
                                AnnotationDownloadHandler.this.inProgress = false;
                                AnnotationDownloadHandler.this.updateLabel();
                                if (sfae.isFileNotFound() || !sfae.isInternetAccessWasAllowed()) {
                                    ShowThrowableDialog.show(new JFrame(), "Annotation not available", true, 64, sfae, def.getURL() + "was not found. Please check that your internet connection is enabled. ");
                                } else {
                                    ShowThrowableDialog.show(new JFrame(), "Annotation not available", true, 64, sfae, sfae.getMessage());
                                }
                                return;
                            }
                            AnnotationDownloadHandler.this.getAdditionalSupportFiles(organismName, arrayName);
                            AnnotationDownloadHandler.this.annotationSelected = true;
                            AnnotationDownloadHandler.this.inProgress = false;
                            TMEV.storeProperty("last-loaded-species", organismName);
                            TMEV.storeProperty("last-loaded-array", arrayName);
                            AnnotationDownloadHandler.this.updateLabel();
                        }
                        catch (Exception e) {
                            AnnotationDownloadHandler.this.annotationSelected = false;
                            AnnotationDownloadHandler.this.updateLabel();
                            e.printStackTrace();
                        }
                    }
                });
                thread.setPriority(1);
                thread.start();
            }
        }
        catch (NullPointerException npe) {
            this.annotationSelected = false;
        }
        this.updateLabel();
    }

    public boolean isAnnotationSelected() {
        return this.annotationSelected;
    }

    public int onAnnotationFileBrowse() {
        JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.ANNOTATION_PATH);
        fileChooser.setFileSelectionMode(0);
        int retVal = fileChooser.showOpenDialog(null);
        if (retVal == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.setAnnFilePath(selectedFile.getAbsolutePath());
            this.annotationSelected = true;
            this.updateLabel();
        }
        return retVal;
    }

    public void addListener(ActionListener listener) {
        this.additionalListener = listener;
    }

    public void getAdditionalSupportFiles(String organismName, String arrayName) throws SupportFileAccessError {
        Vector<ISupportFileDefinition> defs = new Vector<ISupportFileDefinition>();
        defs.add((ISupportFileDefinition)new EASEEntrezSupportDataFile(organismName, arrayName));
        this.irm.getSupportFiles(defs, true);
    }

    private void onSelectAutoDownload() {
        this.annFileLocation.setEnabled(false);
        this.browseAnnFileButton.setEnabled(false);
        this.organismListBox.setEnabled(true);
        this.arrayListBox.setEnabled(true);
        this.checkForAnnotationFile();
        if (this.annotationSelected) {
            this.proceedLoadingAnnotation.setSelected(true);
        }
    }

    private void onSelectBrowseFile() {
        this.annFileLocation.setEnabled(true);
        this.browseAnnFileButton.setEnabled(true);
        this.organismListBox.setEnabled(false);
        this.arrayListBox.setEnabled(false);
        if (this.annotationSelected) {
            this.proceedLoadingAnnotation.setSelected(true);
        }
        this.updateLabel();
    }

    private void onSelectBioconductor() {
        this.annFileLocation.setEnabled(false);
        this.browseAnnFileButton.setEnabled(false);
        this.organismListBox.setEnabled(true);
        this.arrayListBox.setEnabled(true);
        this.checkForAnnotationFile();
        if (this.annotationSelected) {
            this.proceedLoadingAnnotation.setSelected(true);
        }
        this.updateLabel();
    }

    private void onToggleProceed() {
        this.updateLabel();
    }

    private void updateLabel() {
        if (this.inProgress) {
            this.statusLabel.setText("Downloading...");
            this.statusLabel.setForeground(Color.black);
        } else if (!this.proceedLoadingAnnotation.isSelected()) {
            this.statusLabel.setText("No annotation will be loaded.");
            this.statusLabel.setForeground(Color.red);
            this.annotationSelected = false;
        } else {
            this.annotationSelected = true;
            if (this.autoDownload.isSelected()) {
                if (this.organismListBox.getSelectedItem() == null || this.organismListBox.getSelectedItem().equals(CHOOSE_ORGANISM) || this.arrayListBox.getSelectedItem() == null || this.arrayListBox.getSelectedItem().equals(CHOOSE_ARRAY)) {
                    this.statusLabel.setText("Please choose an array and species name.");
                    this.statusLabel.setForeground(Color.red);
                    this.annotationSelected = false;
                } else if (this.annotationSelected) {
                    this.statusLabel.setText("Annotation will be loaded.");
                    this.statusLabel.setForeground(Color.black);
                } else {
                    this.statusLabel.setText("Annotation could not be downloaded.");
                    this.statusLabel.setForeground(Color.red);
                }
            } else if (!new File(this.annFileLocation.getText()).exists()) {
                this.statusLabel.setText("Please choose a valid annotation file.");
                this.statusLabel.setForeground(Color.red);
                this.annotationSelected = false;
            } else {
                this.statusLabel.setText("Annotation will be loaded.");
                this.statusLabel.setForeground(Color.black);
                this.annotationSelected = true;
            }
        }
        if (!this.isEnabled) {
            this.statusLabel.setForeground(Color.gray);
        }
        SwingUtilities.updateComponentTreeUI(this.statusLabel);
        this.annotationPanel.repaint();
        this.statusLabel.repaint();
    }

    public void setDownloadEnabled(boolean isEnabled) {
        this.autoDownload.setEnabled(isEnabled);
        this.loadFromFile.setSelected(false);
        this.loadFromFile.setEnabled(isEnabled);
        this.bioconductor.setSelected(false);
        this.bioconductor.setEnabled(isEnabled);
        this.organismListBox.setEnabled(isEnabled);
        this.arrayListBox.setEnabled(isEnabled);
        this.proceedLoadingAnnotation.setSelected(isEnabled);
        this.proceedLoadingAnnotation.setEnabled(isEnabled);
        this.annotationSelected = false;
        this.statusLabel.setForeground(Color.gray);
        this.isEnabled = isEnabled;
    }

    public static void main(String[] args) {
        FileResourceManager irm;
        JFrame frame = new JFrame("Testing Annotation Download Handler");
        GBA gba = new GBA();
        frame.setLayout(new GridBagLayout());
        frame.setSize(800, 200);
        try {
            irm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
            irm.setAskToGetOnline(false);
        }
        catch (RepositoryInitializationError rie) {
            rie.printStackTrace();
            return;
        }
        try {
            File taxonfile = irm.getSupportFile(new PipelinedAnnotationsFileDefinition(), true);
            PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
            Hashtable<String, Vector<String>> speciestoarrays = aafd.parseAnnotationListFile(taxonfile);
            AnnotationDownloadHandler adh = new AnnotationDownloadHandler(irm, speciestoarrays, "Human", "affy_HG-U133A");
            JPanel annotationPanel = adh.getAnnotationLoaderPanel(gba);
            frame.add(annotationPanel);
        }
        catch (SupportFileAccessError sfae) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        frame.setVisible(true);
    }

    private class EventListener
    implements ActionListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == AnnotationDownloadHandler.this.browseAnnFileButton) {
                int retVal = AnnotationDownloadHandler.this.onAnnotationFileBrowse();
                if (AnnotationDownloadHandler.this.additionalListener != null && retVal == 0) {
                    AnnotationDownloadHandler.this.additionalListener.actionPerformed(new ActionEvent(AnnotationDownloadHandler.this.browseAnnFileButton, 0, AnnotationDownloadHandler.GOT_ANNOTATION_FILE));
                }
            } else if (source.equals(AnnotationDownloadHandler.this.autoDownload)) {
                System.out.println("autoDownmload");
                if (AnnotationDownloadHandler.this.autoDownload.isSelected()) {
                    AnnotationDownloadHandler.this.onSelectAutoDownload();
                }
            } else if (source.equals(AnnotationDownloadHandler.this.loadFromFile)) {
                if (AnnotationDownloadHandler.this.loadFromFile.isSelected()) {
                    AnnotationDownloadHandler.this.onSelectBrowseFile();
                }
            } else if (source.equals(AnnotationDownloadHandler.this.bioconductor)) {
                if (AnnotationDownloadHandler.this.bioconductor.isSelected()) {
                    AnnotationDownloadHandler.this.onSelectBioconductor();
                }
            } else if (source.equals(AnnotationDownloadHandler.this.proceedLoadingAnnotation)) {
                AnnotationDownloadHandler.this.onToggleProceed();
            } else if (source.equals(AnnotationDownloadHandler.this.organismListBox)) {
                AnnotationDownloadHandler.this.updateArrayList((String)AnnotationDownloadHandler.this.organismListBox.getSelectedItem());
                AnnotationDownloadHandler.this.checkForAnnotationFile();
            } else if (source.equals(AnnotationDownloadHandler.this.arrayListBox)) {
                AnnotationDownloadHandler.this.checkForAnnotationFile();
            }
        }
    }
}

