/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.util.LineCount;

public class AgilentFileParser {
    public static final int VALID_AGILENT_FILE = 1;
    public static final int INVALID_AGILENT_FILE = 0;
    public static final String PROBENAME = "ProbeName";
    public static final String RPROCESSEDSIGNAL = "rProcessedSignal";
    public static final String GPROCESSEDSIGNAL = "gProcessedSignal";
    public static final String ROW = "Row";
    public static final String COLUMN = "Col";
    public static final String FEATURENUMBER = "FeatureNum";
    public static final String RMEDIANSIGNAL = "rMedianSignal";
    public static final String GMEDIANSIGNAL = "gMedianSignal";
    public static final String SYSTEMATICNAME = "SystematicName";
    public static final String GENENAME = "GeneName";
    private boolean isAgilentFileValid = false;
    private boolean isOneColor;
    private ArrayList<String> requiredHeaders = new ArrayList();
    private String[][] dataMatrix = new String[1][1];

    public AgilentFileParser(boolean isOneColor) {
        this.isOneColor = isOneColor;
        this.initializeHeaders();
    }

    public static int validate(String headerLine, boolean isOneColor) {
        ArrayList columnHeaders = new ArrayList();
        StringSplitter split = new StringSplitter('\t');
        split.init(headerLine);
        boolean valid1 = false;
        boolean valid2 = false;
        boolean valid3 = false;
        boolean valid4 = false;
        boolean valid5 = false;
        while (split.hasMoreTokens()) {
            String token = split.nextToken();
            if (token.equalsIgnoreCase(FEATURENUMBER)) {
                valid1 = true;
            }
            if (token.equalsIgnoreCase(GPROCESSEDSIGNAL)) {
                valid2 = true;
            }
            if (token.equalsIgnoreCase(RPROCESSEDSIGNAL)) {
                valid3 = true;
            }
            if (token.equalsIgnoreCase(ROW)) {
                valid4 = true;
            }
            if (!token.equalsIgnoreCase(COLUMN)) continue;
            valid5 = true;
        }
        if (valid1 && valid2 && valid3 && valid4 && valid5) {
            return 1;
        }
        if (isOneColor && valid1 && valid2 && valid4 && valid5) {
            return 1;
        }
        return 0;
    }

    public ArrayList<String> getRequiredHeaders() {
        return this.requiredHeaders;
    }

    public void initializeHeaders() {
        this.requiredHeaders.add(FEATURENUMBER);
        this.requiredHeaders.add(ROW);
        this.requiredHeaders.add(COLUMN);
        this.requiredHeaders.add(PROBENAME);
        if (!this.isOneColor) {
            this.requiredHeaders.add(GENENAME);
        }
        this.requiredHeaders.add(SYSTEMATICNAME);
        this.requiredHeaders.add(GPROCESSEDSIGNAL);
        if (!this.isOneColor) {
            this.requiredHeaders.add(RPROCESSEDSIGNAL);
        }
        this.requiredHeaders.add(GMEDIANSIGNAL);
        if (!this.isOneColor) {
            this.requiredHeaders.add(RMEDIANSIGNAL);
        }
    }

    public void setHeaderPositions(ArrayList<String> columnHeaders, String headerLine) {
        Pattern pattern = null;
        Matcher m = null;
        boolean colIndex = false;
        for (int index = 0; index < columnHeaders.size(); ++index) {
            String key = columnHeaders.get(index);
            pattern = Pattern.compile(key, 2);
            m = pattern.matcher(headerLine);
            if (m.find()) continue;
            this.requiredHeaders.remove(key);
        }
    }

    public void loadFile(File targetFile) {
        StringSplitter splitter = new StringSplitter('\t');
        String currentLine = new String();
        BufferedReader reader = null;
        Pattern pattern = Pattern.compile("FEATURES", 2);
        int lines_in_file = LineCount.getNumberOfLines(targetFile);
        int headerLinesCount = 0;
        ArrayList<String> columnHeaders = new ArrayList();
        try {
            reader = new BufferedReader(new FileReader(targetFile));
            boolean patternFound = false;
            while (!patternFound) {
                currentLine = reader.readLine();
                ++headerLinesCount;
                Matcher m = pattern.matcher(currentLine);
                if (!m.find() || !(m = (pattern = Pattern.compile(FEATURENUMBER, 2)).matcher(currentLine)).find()) continue;
                if (AgilentFileParser.validate(currentLine, this.isOneColor) != 1) {
                    this.isAgilentFileValid = false;
                    return;
                }
                this.isAgilentFileValid = true;
                columnHeaders = new ArrayList<String>(Arrays.asList(currentLine.split("\t")));
                this.setHeaderPositions(columnHeaders, currentLine);
                patternFound = true;
                break;
            }
            this.dataMatrix = new String[lines_in_file - headerLinesCount][this.getRequiredHeaders().size()];
            int rowIndex = 0;
            while ((currentLine = reader.readLine()) != null) {
                int columnIndex = 0;
                String[] tokens = currentLine.split("\t");
                if (this.getRequiredHeaders().contains(FEATURENUMBER)) {
                    this.dataMatrix[rowIndex][0] = tokens[columnHeaders.indexOf(FEATURENUMBER)];
                    ++columnIndex;
                }
                if (this.getRequiredHeaders().contains(ROW)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(ROW)];
                }
                if (this.getRequiredHeaders().contains(COLUMN)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(COLUMN)];
                }
                if (this.getRequiredHeaders().contains(PROBENAME)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(PROBENAME)];
                }
                if (this.getRequiredHeaders().contains(GENENAME)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(GENENAME)];
                }
                if (this.getRequiredHeaders().contains(SYSTEMATICNAME)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(SYSTEMATICNAME)];
                }
                if (this.getRequiredHeaders().contains(RPROCESSEDSIGNAL)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(RPROCESSEDSIGNAL)];
                }
                if (this.getRequiredHeaders().contains(GPROCESSEDSIGNAL)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(GPROCESSEDSIGNAL)];
                }
                if (this.getRequiredHeaders().contains(RMEDIANSIGNAL)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(RMEDIANSIGNAL)];
                }
                if (this.getRequiredHeaders().contains(GMEDIANSIGNAL)) {
                    this.dataMatrix[rowIndex][columnIndex++] = tokens[columnHeaders.indexOf(GMEDIANSIGNAL)];
                }
                ++rowIndex;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isAgilentFileValid = false;
        }
    }

    public String[][] getDataMatrix() {
        return this.dataMatrix;
    }

    public boolean isAgilentFileValid() {
        return this.isAgilentFileValid;
    }
}

