/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.file.AgilentAnnotationFileParser;
import org.tigr.microarray.mev.file.AgilentFileParser;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.SupportFileAccessError;
import org.tigr.microarray.util.FileLoaderUtility;

public class AgilentFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private AgilentFileLoaderPanel aflp = new AgilentFileLoaderPanel();
    private MultipleArrayViewer mav;
    private boolean loadEnabled = true;
    private String annotationFilePath = "NA";
    private boolean loadMedianIntensities = false;
    private String[] uidArray;
    private boolean oneColorData;

    public AgilentFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
    }

    @Override
    public ISlideData loadExpressionFile(File f) throws IOException {
        return null;
    }

    @Override
    public Vector<ISlideData> loadExpressionFiles() throws IOException {
        this.loadMedianIntensities = this.aflp.loadMedButton.isSelected();
        this.oneColorData = this.aflp.oneColorButton.isSelected();
        Object[] dataFiles = this.aflp.getSelectedListModel().toArray();
        Vector<ISlideData> data = new Vector<ISlideData>();
        ISlideMetaData metaData = null;
        ISlideData slideData = null;
        this.setFilesCount(dataFiles.length);
        this.setRemain(dataFiles.length);
        for (int index = 0; index < dataFiles.length; ++index) {
            File file;
            if (index == 0) {
                file = new File(this.getFilePath(), ((File)dataFiles[index]).getName());
                slideData = this.loadSlideData(file);
                if (slideData == null) {
                    return null;
                }
                data.add(slideData);
                metaData = slideData.getSlideMetaData();
            } else {
                file = new File(this.getFilePath(), ((File)dataFiles[index]).getName());
                data.add(this.loadFloatSlideData(file, metaData));
            }
            this.setRemain(dataFiles.length - index - 1);
            this.setFilesProgress(index);
        }
        if (this.aflp.isAnnotationLoaded()) {
            data.set(0, this.loadResourcererAnnotationFile((SlideData)data.elementAt(0), new File(this.getAnnotationFilePath())));
        } else if (!this.getAnnotationFilePath().equalsIgnoreCase("NA")) {
            data.set(0, this.loadAnnotationFile((SlideData)data.elementAt(0), new File(this.getAnnotationFilePath())));
        }
        return data;
    }

    private SlideData loadResourcererAnnotationFile(SlideData targetData, File sourceFile) throws IOException {
        this.mav.getData().setAnnotationLoaded(true);
        File annoFile = new File(this.getAnnotationFilePath());
        AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader(new File(this.getAnnotationFilePath()));
        Hashtable<String, MevAnnotation> _tempAnno = afr.getAffyAnnotation();
        this.chipAnno = afr.getAffyChipAnnotation();
        int dataLength = targetData.getSize();
        int probeColumn = Arrays.asList(targetData.getSlideMetaData().getFieldNames()).indexOf("ProbeName");
        for (int index = 0; index < dataLength; ++index) {
            MevAnnotation mevAnno = null;
            if (_tempAnno.size() != 0 && probeColumn != -1) {
                String cloneName = targetData.getSlideDataElement(index).getExtraFields()[probeColumn];
                if (_tempAnno.get(cloneName) != null) {
                    mevAnno = _tempAnno.get(cloneName);
                } else {
                    mevAnno = new MevAnnotation();
                    mevAnno.setCloneID(cloneName);
                }
            }
            targetData.getSlideDataElement(index).setElementAnnotation(mevAnno);
        }
        targetData.getSlideMetaData().updateFilledAnnFields();
        return targetData;
    }

    private SlideData loadAnnotationFile(SlideData targetData, File sourceFile) throws IOException {
        AgilentAnnotationFileParser parser = new AgilentAnnotationFileParser();
        parser.loadAnnotationFile(sourceFile);
        if (parser.isAnnotationLoaded()) {
            ArrayList<String> headers = parser.getColumnHeaders();
            String[][] annMatrix = parser.getAnnotationMatrix();
            targetData.getSlideMetaData().setFieldNames(headers.toArray(new String[headers.size()]));
            Hashtable<String, String[]> hash = new Hashtable<String, String[]>();
            int dataLength = targetData.getSize();
            for (int i = 0; i < annMatrix.length; ++i) {
                String[] value = new String[headers.size()];
                System.arraycopy(annMatrix[i], 1, value, 0, headers.size());
                hash.put(annMatrix[i][0], value);
            }
            for (int i = 0; i < dataLength; ++i) {
                String[] extraFields = new String[headers.size()];
                extraFields = (String[])hash.get(this.uidArray[i]);
                ((SlideDataElement)targetData.getSlideDataElement(i)).setExtraFields(extraFields);
            }
        }
        return targetData;
    }

    private ISlideData loadSlideData(File targetFile) throws IOException {
        SlideData slideData = null;
        AgilentFileParser afp = new AgilentFileParser(this.oneColorData);
        afp.loadFile(targetFile);
        int numAnnotationColumns = -1;
        String[][] data = new String[1][1];
        String[] annotationHeaders = null;
        if (afp.isAgilentFileValid()) {
            int i;
            data = new String[afp.getDataMatrix().length][afp.getDataMatrix()[0].length];
            data = afp.getDataMatrix();
            this.uidArray = new String[data.length];
            int probeName = afp.getRequiredHeaders().indexOf("ProbeName");
            int genename = afp.getRequiredHeaders().indexOf("GeneName");
            int rProcessedSignal = afp.getRequiredHeaders().indexOf("rProcessedSignal");
            int gProcessedSignal = afp.getRequiredHeaders().indexOf("gProcessedSignal");
            int rMedianSignal = afp.getRequiredHeaders().indexOf("rMedianSignal");
            int gMedianSignal = afp.getRequiredHeaders().indexOf("gMedianSignal");
            if (probeName != -1 && (genename != -1 || this.oneColorData)) {
                numAnnotationColumns = 5;
            }
            if (this.loadMedianIntensities && rProcessedSignal == -1 && !this.oneColorData || gProcessedSignal == -1) {
                JOptionPane.showMessageDialog(this.aflp, "Error loading " + targetFile.getName() + "\n" + "The file was missing median intensity columns indicated by\n" + "the header names rMedianSignal and gMedianSignal", "Load Error", 0);
                return null;
            }
            if (rProcessedSignal == -1 && !this.oneColorData || gProcessedSignal == -1) {
                JOptionPane.showMessageDialog(this.aflp, "Error loading " + targetFile.getName() + "\n" + "The file was missing intensity columns indicated by\n" + "the header names rProcessedSignal and gProcessedSignal", "Load Error", 0);
                return null;
            }
            int maxRow = 0;
            int maxCol = 0;
            for (i = 0; i < data.length; ++i) {
                maxRow = Math.max(maxRow, Integer.parseInt(data[i][1]));
                maxCol = Math.max(maxCol, Integer.parseInt(data[i][2]));
            }
            slideData = new SlideData(maxRow, maxCol);
            this.setLinesCount(data.length);
            annotationHeaders = new String[numAnnotationColumns];
            for (int fieldCnt = 0; fieldCnt < numAnnotationColumns; ++fieldCnt) {
                annotationHeaders[fieldCnt] = afp.getRequiredHeaders().get(fieldCnt);
            }
            slideData.getSlideMetaData().setFieldNames(annotationHeaders);
            for (i = 0; i < data.length; ++i) {
                int[] rows = new int[3];
                int[] cols = new int[3];
                float[] intensities = new float[2];
                this.uidArray[i] = data[i][0];
                String[] fieldNames = new String[numAnnotationColumns];
                for (int fieldCnt = 0; fieldCnt < numAnnotationColumns; ++fieldCnt) {
                    fieldNames[fieldCnt] = data[i][fieldCnt];
                }
                try {
                    if (this.loadMedianIntensities) {
                        if (!this.oneColorData) {
                            intensities[0] = Float.parseFloat(data[i][rMedianSignal]);
                        }
                        intensities[1] = Float.parseFloat(data[i][gMedianSignal]);
                    } else {
                        if (!this.oneColorData) {
                            intensities[0] = Float.parseFloat(data[i][rProcessedSignal]);
                        }
                        intensities[1] = Float.parseFloat(data[i][gProcessedSignal]);
                    }
                    rows[0] = Integer.parseInt(data[i][1]);
                    cols[0] = Integer.parseInt(data[i][2]);
                    rows[1] = 0;
                    cols[1] = 0;
                    rows[2] = 0;
                    cols[2] = 0;
                }
                catch (NumberFormatException e) {
                    final String fileName = targetFile.getName();
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showConfirmDialog(AgilentFileLoader.this.aflp, "The input file \"" + fileName + "\" seems to be missing critical columns like " + "\n" + "FeatureNum, rMedianSignal, gMedianSignal," + "rProcessedSignal and gProcessedSignal.", "Loading Aborted/Loading Error", 0);
                        }
                    });
                    thread.start();
                    return null;
                }
                SlideDataElement sde = new SlideDataElement(data[i][0], rows, cols, intensities, fieldNames, null);
                slideData.addSlideDataElement(sde);
                this.setFileProgress(i);
            }
            slideData.setSlideDataName(targetFile.getName());
            slideData.setSlideFileName(targetFile.getPath());
            return slideData;
        }
        return null;
    }

    private ISlideData loadFloatSlideData(File currentFile, ISlideMetaData metaData) throws IOException {
        AgilentFileParser afp = new AgilentFileParser(this.oneColorData);
        afp.loadFile(currentFile);
        FloatSlideData floatSlideData = new FloatSlideData(metaData);
        int intensity1 = 0;
        int intensity2 = 0;
        if (afp.isAgilentFileValid()) {
            if (this.loadMedianIntensities) {
                intensity1 = afp.getRequiredHeaders().indexOf("rMedianSignal");
                intensity2 = afp.getRequiredHeaders().indexOf("gMedianSignal");
            } else {
                intensity1 = afp.getRequiredHeaders().indexOf("rProcessedSignal");
                intensity2 = afp.getRequiredHeaders().indexOf("gProcessedSignal");
            }
            if (intensity1 == -1 && !this.oneColorData || intensity2 == -1) {
                if (this.loadMedianIntensities) {
                    JOptionPane.showMessageDialog(this.aflp, "Error loading " + currentFile.getName() + "\n" + "The file was missing median intensity columns indicated by\n" + "the header names rMedianSignal and gMedianSignal", "Load Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.aflp, "Error loading " + currentFile.getName() + "\n" + "The file was missing intensity columns indicated by\n" + "the header names rProcessedSignal and gProcessedSignal", "Load Error", 0);
                }
                return null;
            }
            String[][] data = afp.getDataMatrix();
            this.setLinesCount(data.length);
            for (int i = 0; i < data.length; ++i) {
                floatSlideData.setIntensities(i, (this.oneColorData ? null : Float.valueOf(Float.parseFloat(data[i][intensity1]))).floatValue(), Float.parseFloat(data[i][intensity2]));
                this.setFileProgress(i);
            }
        }
        floatSlideData.setSlideDataName(currentFile.getName());
        floatSlideData.setSlideFileName(currentFile.getPath());
        return floatSlideData;
    }

    @Override
    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    @Override
    public String getAnnotationFilePath() {
        if (this.aflp.isAnnotationLoaded()) {
            this.annotationFilePath = this.aflp.adh.getAnnFilePath();
            return this.annotationFilePath;
        }
        if (this.annotationFilePath.length() == 0) {
            return "NA";
        }
        return this.annotationFilePath;
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.aflp;
    }

    @Override
    public String getFilePath() {
        if (this.aflp.pathTextField == null) {
            return null;
        }
        return this.aflp.pathTextField.getText();
    }

    @Override
    public void openDataPath() {
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
        this.annotationFilePath = filePath;
    }

    @Override
    public void setFilePath(String path) {
        this.aflp.pathTextField.setText(path);
        this.processFileList(path, new Vector());
    }

    public void processFileList(String filePath, Vector fileNames) {
        if (fileNames == null) {
            return;
        }
        FileFilter mevFileFilter = this.getFileFilter();
        this.aflp.getAvailableListModel().clear();
        for (int i = 0; i < fileNames.size(); ++i) {
            File targetFile = new File((String)fileNames.elementAt(i));
            if (!mevFileFilter.accept(targetFile)) continue;
            this.aflp.getAvailableListModel().addElement(new File((String)fileNames.elementAt(i)));
        }
    }

    private MultipleArrayViewer getMav() {
        return this.mav;
    }

    private class AgilentFileLoaderPanel
    extends JPanel {
        private JPanel choicePanel;
        private JPanel annotationPanel;
        private JPanel dataPanel;
        private JRadioButton loadIButton;
        private JRadioButton loadMedButton;
        private JPanel selectFilePanel;
        private JPanel annotationSelectionMethodPanel;
        private JLabel annotationSelectionLabel;
        private JComboBox annotationSelectionBox;
        private JLabel availableLabel;
        private JLabel selectedLabel;
        private JLabel selectFile;
        private JLabel selectAnnotationFile;
        private JList availableList;
        private JList selectedList;
        private JScrollPane availableScrollPane;
        private JScrollPane selectedScrollPane;
        private JButton addButton;
        private JButton addAllButton;
        private JButton removeButton;
        private JButton removeAllButton;
        private JButton browseButton1;
        private JButton annBrowseButton;
        private JTextField pathTextField;
        private JTextField annPathTextField;
        private AnnotationDownloadHandler adh = null;
        private JPanel colorPanel;
        private JRadioButton oneColorButton;
        private JRadioButton twoColorButton;
        private static final String LOAD_AGILENT_ANNOTATION = "load_agilent_annotation_file";
        private static final String LOAD_RESOURCERER_ANNOTATION = "load_resourcerer_annotation";

        private AgilentFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.choicePanel = new JPanel();
            this.choicePanel.setBorder(new TitledBorder(new EtchedBorder(), "Choice Panel"));
            this.choicePanel.setLayout(new GridBagLayout());
            this.loadIButton = new JRadioButton("Load Integrated Spot Intensities", true);
            this.loadIButton.setFocusPainted(false);
            this.loadMedButton = new JRadioButton("Load Median Spot Intensities");
            this.loadMedButton.setFocusPainted(false);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.loadIButton);
            bg.add(this.loadMedButton);
            AgilentFileLoader.this.gba.add(this.choicePanel, this.loadIButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 2, 0, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this.choicePanel, this.loadMedButton, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 2, 0, 2), 0, 0);
            this.colorPanel = new JPanel();
            this.colorPanel.setBorder(new TitledBorder(new EtchedBorder(), "Experimental Design Panel"));
            this.colorPanel.setLayout(new GridBagLayout());
            this.oneColorButton = new JRadioButton("One-Color");
            this.oneColorButton.setFocusPainted(false);
            this.twoColorButton = new JRadioButton("Two-Color", true);
            this.twoColorButton.setFocusPainted(false);
            ButtonGroup bg1 = new ButtonGroup();
            bg1.add(this.oneColorButton);
            bg1.add(this.twoColorButton);
            AgilentFileLoader.this.gba.add(this.colorPanel, this.oneColorButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 2, 0, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this.colorPanel, this.twoColorButton, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 2, 0, 2), 0, 0);
            this.annotationPanel = new JPanel();
            this.annotationPanel.setLayout(new GridBagLayout());
            this.annotationPanel.setBorder(new TitledBorder(new EtchedBorder(), "Annotation Panel"));
            this.annotationSelectionMethodPanel = new JPanel();
            this.annotationSelectionLabel = new JLabel("Annotation selection method");
            String[] selectionMethods = new String[]{"Load Agilent provided annotation file", "Load gene annotations from Resourcerer"};
            this.annotationSelectionBox = new JComboBox<String>(selectionMethods);
            this.annotationSelectionBox.addActionListener(new Listener());
            this.createAnnotationPanel(LOAD_AGILENT_ANNOTATION);
            AgilentFileLoader.this.gba.add(this.annotationSelectionMethodPanel, this.annotationSelectionLabel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this.annotationSelectionMethodPanel, new JLabel(), 0, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this.annotationSelectionMethodPanel, this.annotationSelectionBox, 2, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this.annotationPanel, this.annotationSelectionMethodPanel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.dataPanel = new JPanel();
            this.dataPanel.setLayout(new GridBagLayout());
            this.dataPanel.setBorder(new TitledBorder(new EtchedBorder(), "Agilent Feature Extraction Files (*.txt)"));
            JPanel selectFilePanel = new JPanel();
            selectFilePanel.setLayout(new GridBagLayout());
            this.selectFile = new JLabel("Select directory containing Agilent Feature Extraction Files");
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.setSize(new Dimension(100, 30));
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.browseButton1.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgilentFileLoaderPanel.this.onFeatureFileBrowse();
                }
            });
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            AgilentFileLoader.this.gba.add(selectFilePanel, this.selectFile, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(selectFilePanel, this.pathTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(selectFilePanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            JPanel listPanel = new JPanel();
            listPanel.setLayout(new GridBagLayout());
            this.availableLabel = new JLabel("Available Files");
            this.selectedLabel = new JLabel("Selected Files");
            this.availableList = new JList(new DefaultListModel());
            this.selectedList = new JList(new DefaultListModel());
            this.availableScrollPane = new JScrollPane(this.availableList);
            this.selectedScrollPane = new JScrollPane(this.selectedList);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            this.addButton = new JButton("Add");
            this.addButton.setPreferredSize(new Dimension(100, 20));
            this.addButton.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgilentFileLoaderPanel.this.onAdd();
                }
            });
            this.addAllButton = new JButton("Add All");
            this.addAllButton.setPreferredSize(new Dimension(100, 20));
            this.addAllButton.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgilentFileLoaderPanel.this.onAddAll();
                }
            });
            this.removeButton = new JButton("Remove");
            this.removeButton.setPreferredSize(new Dimension(100, 20));
            this.removeButton.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgilentFileLoaderPanel.this.onRemove();
                }
            });
            this.removeAllButton = new JButton("Remove All");
            this.removeAllButton.setPreferredSize(new Dimension(100, 20));
            this.removeAllButton.addActionListener(new Listener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AgilentFileLoaderPanel.this.onRemoveAll();
                }
            });
            AgilentFileLoader.this.gba.add(buttonPanel, this.addButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(buttonPanel, this.addAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(buttonPanel, this.removeButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(buttonPanel, this.removeAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(listPanel, this.availableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentFileLoader.this.gba.add(listPanel, this.availableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentFileLoader.this.gba.add(listPanel, buttonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentFileLoader.this.gba.add(listPanel, this.selectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentFileLoader.this.gba.add(listPanel, this.selectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentFileLoader.this.gba.add(this.dataPanel, selectFilePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this.dataPanel, listPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this, this.choicePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this, this.colorPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this, this.annotationPanel, 0, 2, 1, 1, 100, 100, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AgilentFileLoader.this.gba.add(this, this.dataPanel, 0, 4, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.revalidate();
        }

        public void createAnnotationPanel(String actionCommand) {
            if (actionCommand.equalsIgnoreCase(LOAD_AGILENT_ANNOTATION)) {
                this.selectFilePanel = new JPanel();
                this.selectFilePanel.setLayout(new GridBagLayout());
                this.selectAnnotationFile = new JLabel("Select Agilent annotation file");
                this.annPathTextField = new JTextField();
                this.annPathTextField.setEditable(false);
                this.annPathTextField.setFont(new Font("monospaced", 1, 12));
                this.annBrowseButton = new JButton("Browse");
                this.annBrowseButton.setName("Browse");
                this.annBrowseButton.setActionCommand("browse");
                this.annBrowseButton.setSize(new Dimension(100, 30));
                this.annBrowseButton.setPreferredSize(new Dimension(100, 30));
                this.annBrowseButton.addActionListener(new Listener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int result = AgilentFileLoaderPanel.this.onSelectAgilentAnnotationFile();
                        if (result == 0) {
                            AgilentFileLoaderPanel.this.annPathTextField.setText(AgilentFileLoader.this.getAnnotationFilePath());
                        }
                    }
                });
                AgilentFileLoader.this.gba.add(this.selectFilePanel, this.selectAnnotationFile, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                AgilentFileLoader.this.gba.add(this.selectFilePanel, this.annPathTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
                AgilentFileLoader.this.gba.add(this.selectFilePanel, this.annBrowseButton, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
                AgilentFileLoader.this.gba.add(this.annotationPanel, this.selectFilePanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                this.revalidate();
            } else if (actionCommand.equalsIgnoreCase(LOAD_RESOURCERER_ANNOTATION)) {
                FileResourceManager irm;
                Hashtable<String, Vector<String>> speciestoarrays = new Hashtable<String, Vector<String>>();
                try {
                    irm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
                    irm.setAskToGetOnline(false);
                }
                catch (RepositoryInitializationError rie) {
                    rie.printStackTrace();
                    return;
                }
                try {
                    File taxonfile = irm.getSupportFile(new PipelinedAnnotationsFileDefinition(), true);
                    PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
                    speciestoarrays = aafd.parseAnnotationListFile(taxonfile);
                }
                catch (SupportFileAccessError sfae) {
                    sfae.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                this.adh = new AnnotationDownloadHandler(irm, speciestoarrays, "Human", "affy_HG-U133A");
                this.selectFilePanel = new JPanel();
                this.selectFilePanel.setLayout(new GridBagLayout());
                if (AgilentFileLoader.this.getMav().getData().isAnnotationLoaded()) {
                    this.annotationPanel.setVisible(false);
                    this.adh.setOptionalMessage("Annotation is already loaded for array " + AgilentFileLoader.this.getMav().getData().getChipAnnotation().getChipType());
                    this.adh.setAnnFilePath(AgilentFileLoader.this.getMav().getData().getChipAnnotation().getAnnFileName());
                }
                this.adh.addListener(new Listener());
                AgilentFileLoader.this.gba.add(this.selectFilePanel, this.adh.getAnnotationLoaderPanel(AgilentFileLoader.this.gba), 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                AgilentFileLoader.this.gba.add(this.annotationPanel, this.selectFilePanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                this.revalidate();
                this.adh.setDownloadEnabled(!AgilentFileLoader.this.getMav().getData().isAnnotationLoaded());
            }
        }

        public void onFeatureFileBrowse() {
            FileLoaderUtility fileLoad = new FileLoaderUtility();
            Vector retrievedFileNames = new Vector();
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(1);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                this.getAvailableListModel().clear();
                this.getSelectedListModel().clear();
                File selectedFile = fileChooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
                for (int i = 0; i < retrievedFileNames.size(); ++i) {
                    Object fileName = retrievedFileNames.get(i);
                    boolean acceptFile = AgilentFileLoader.this.getFileFilter().accept((File)fileName);
                    if (!acceptFile) continue;
                    this.pathTextField.setText(path);
                    String Name = fileChooser.getName((File)fileName);
                    this.getAvailableListModel().addElement(new File(Name));
                }
            }
        }

        public int onSelectAgilentAnnotationFile() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            fileChooser.setFileSelectionMode(2);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String path = selectedFile.getAbsolutePath();
                AgilentFileLoader.this.setAnnotationFilePath(path);
            }
            return retVal;
        }

        public void onAdd() {
            int i;
            int[] chosenIndices = this.availableList.getSelectedIndices();
            Object[] chosenObjects = new Object[chosenIndices.length];
            for (i = chosenIndices.length - 1; i >= 0; --i) {
                Object addItem = ((DefaultListModel)this.availableList.getModel()).getElementAt(chosenIndices[i]);
                chosenObjects[i] = addItem;
            }
            for (i = 0; i < chosenIndices.length; ++i) {
                ((DefaultListModel)this.selectedList.getModel()).addElement(chosenObjects[i]);
            }
        }

        public void onAddAll() {
            int elementCount = ((DefaultListModel)this.availableList.getModel()).size();
            for (int i = 0; i < elementCount; ++i) {
                Object addItem = ((DefaultListModel)this.availableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.selectedList.getModel()).addElement(addItem);
            }
        }

        public void onRemove() {
            int[] chosenIndices = this.selectedList.getSelectedIndices();
            for (int i = chosenIndices.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.selectedList.getModel()).remove(chosenIndices[i]);
            }
        }

        public void onRemoveAll() {
            ((DefaultListModel)this.selectedList.getModel()).removeAllElements();
        }

        public DefaultListModel getAvailableListModel() {
            return (DefaultListModel)this.availableList.getModel();
        }

        public DefaultListModel getSelectedListModel() {
            return (DefaultListModel)this.selectedList.getModel();
        }

        private void updateLabel(String name) {
            this.annotationSelectionBox.setSelectedItem(name);
        }

        private boolean isAnnotationLoaded() {
            if (this.adh != null) {
                return this.adh.isAnnotationSelected();
            }
            return false;
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == AgilentFileLoaderPanel.this.addButton) {
                    AgilentFileLoaderPanel.this.onAdd();
                } else if (source == AgilentFileLoaderPanel.this.addAllButton) {
                    AgilentFileLoaderPanel.this.onAddAll();
                } else if (source == AgilentFileLoaderPanel.this.removeButton) {
                    AgilentFileLoaderPanel.this.onRemove();
                } else if (source == AgilentFileLoaderPanel.this.removeAllButton) {
                    AgilentFileLoaderPanel.this.onRemoveAll();
                } else if (source.equals(AgilentFileLoaderPanel.this.annotationSelectionBox)) {
                    AgilentFileLoaderPanel.this.updateLabel((String)AgilentFileLoaderPanel.this.annotationSelectionBox.getSelectedItem());
                    if (((String)AgilentFileLoaderPanel.this.annotationSelectionBox.getSelectedItem()).equalsIgnoreCase("Load gene annotations from Resourcerer")) {
                        AgilentFileLoaderPanel.this.annotationPanel.removeAll();
                        AgilentFileLoaderPanel.this.revalidate();
                        AgilentFileLoaderPanel.this.createAnnotationPanel(AgilentFileLoaderPanel.LOAD_RESOURCERER_ANNOTATION);
                        AgilentFileLoader.this.gba.add(AgilentFileLoaderPanel.this.annotationSelectionMethodPanel, AgilentFileLoaderPanel.this.annotationSelectionLabel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
                        AgilentFileLoader.this.gba.add(AgilentFileLoaderPanel.this.annotationSelectionMethodPanel, AgilentFileLoaderPanel.this.annotationSelectionBox, 2, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
                        AgilentFileLoader.this.gba.add(AgilentFileLoaderPanel.this.annotationPanel, AgilentFileLoaderPanel.this.annotationSelectionMethodPanel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
                        AgilentFileLoaderPanel.this.revalidate();
                    } else if (((String)AgilentFileLoaderPanel.this.annotationSelectionBox.getSelectedItem()).equalsIgnoreCase("Load Agilent provided annotation file")) {
                        AgilentFileLoaderPanel.this.annotationPanel.removeAll();
                        AgilentFileLoaderPanel.this.revalidate();
                        AgilentFileLoaderPanel.this.createAnnotationPanel(AgilentFileLoaderPanel.LOAD_AGILENT_ANNOTATION);
                        AgilentFileLoader.this.gba.add(AgilentFileLoaderPanel.this.annotationSelectionMethodPanel, AgilentFileLoaderPanel.this.annotationSelectionLabel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
                        AgilentFileLoader.this.gba.add(AgilentFileLoaderPanel.this.annotationSelectionMethodPanel, AgilentFileLoaderPanel.this.annotationSelectionBox, 2, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
                        AgilentFileLoader.this.gba.add(AgilentFileLoaderPanel.this.annotationPanel, AgilentFileLoaderPanel.this.annotationSelectionMethodPanel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
                        AgilentFileLoaderPanel.this.revalidate();
                    }
                }
            }
        }
    }
}

