/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.util.LineCount;

public class AgilentAnnotationFileParser {
    public static final int INVALID_ANNOTATION_FILE = 0;
    public static final int VALID_ANNOTATION_FILE = 1;
    public static final String REF_NUM = "RefNumber";
    public static final String ROW = "Row";
    public static final String COLUMN = "Column";
    private String[][] annotationMatrix = new String[1][1];
    private int uniqueIdentifierColumn;
    private ArrayList<String> columnNames;
    private boolean isAnnotationLoaded = false;

    public static int validate(String headerLine) {
        StringSplitter split = new StringSplitter('\t');
        split.init(headerLine);
        Pattern pattern = Pattern.compile(REF_NUM, 2);
        Matcher m = pattern.matcher(headerLine);
        if (m.find()) {
            System.out.println("valid annotation file");
            return 1;
        }
        System.out.println("invalid annotation file");
        return 0;
    }

    public void loadAnnotationFile(File targetFile) {
        StringSplitter splitter = new StringSplitter('\t');
        String currentLine = new String();
        int rowCount = LineCount.getNumberOfLines(targetFile);
        BufferedReader reader = null;
        Pattern pattern = Pattern.compile(REF_NUM, 2);
        try {
            reader = new BufferedReader(new FileReader(targetFile));
            currentLine = reader.readLine();
            int result = AgilentAnnotationFileParser.validate(currentLine);
            if (result == 0) {
                return;
            }
            ArrayList<String> columnHeaders = new ArrayList<String>(Arrays.asList(currentLine.split("\t")));
            this.columnNames = new ArrayList();
            this.columnNames.add(0, REF_NUM);
            for (int index = 0; index < columnHeaders.size(); ++index) {
                String key = columnHeaders.get(index);
                if (key.equalsIgnoreCase(REF_NUM) || key.equalsIgnoreCase(ROW) || key.equalsIgnoreCase(COLUMN)) continue;
                this.columnNames.add(key);
            }
            this.annotationMatrix = new String[rowCount - 1][this.columnNames.size()];
            int rowIndex = 0;
            while ((currentLine = reader.readLine()) != null) {
                String[] tokens = currentLine.split("\t");
                for (int index = 0; index < this.columnNames.size(); ++index) {
                    String key = this.columnNames.get(index);
                    int colIndex = columnHeaders.indexOf(key);
                    this.annotationMatrix[rowIndex][index] = colIndex < tokens.length ? tokens[colIndex] : "NA";
                }
                ++rowIndex;
            }
            reader.close();
            this.columnNames.remove(REF_NUM);
            this.isAnnotationLoaded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAnnotationLoaded() {
        return this.isAnnotationLoaded;
    }

    public String[][] getAnnotationMatrix() {
        return this.annotationMatrix;
    }

    public ArrayList<String> getColumnHeaders() {
        return this.columnNames;
    }

    public int getUniqueIdentifierColumn() {
        return this.uniqueIdentifierColumn;
    }
}

