/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.AffymetrixAnnotationParser;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.microarray.util.ExpressionFileTableCellRenderer;

public class AffyGCOSFileLoader
extends ExpressionFileLoader {
    private GBA gba;
    private boolean stop = false;
    private AffyGCOSFileLoaderPanel sflp;
    ExpressionFileTableCellRenderer myCellRenderer;
    private int affyDataType = 2;
    private Hashtable _tempAnno = new Hashtable();
    private MultipleArrayViewer mav;
    protected MevAnnotation mevAnno = new MevAnnotation();

    @Override
    public void setFilePath(String path) {
        this.sflp.setDataFileName(path);
        this.processAffyGCOSFile(new File(path));
    }

    public AffyGCOSFileLoader(SuperExpressionFileLoader superLoader) {
        super(superLoader);
        this.mav = superLoader.getArrayViewer();
        this.gba = new GBA();
        this.sflp = new AffyGCOSFileLoaderPanel();
    }

    public Vector loadExpressionFiles() throws IOException {
        if (this.isAnnotationSelected()) {
            this.mav.getData().setAnnotationLoaded(true);
            File annoFile = new File(this.getAnnotationFilePath());
            String extension = annoFile.getName().substring(annoFile.getName().lastIndexOf(46) + 1, annoFile.getName().length());
            if (annoFile.getName().endsWith("annot.csv")) {
                AffymetrixAnnotationParser aafp = AffymetrixAnnotationParser.createAnnotationFileParser(new File(this.getAnnotationFilePath()));
                this._tempAnno = aafp.getAffyAnnotation();
            }
            if (extension.equalsIgnoreCase("txt")) {
                AnnotationFileReader afr = AnnotationFileReader.createAnnotationFileReader(new File(this.getAnnotationFilePath()));
                this._tempAnno = afr.getAffyAnnotation();
                this.chipAnno = afr.getAffyChipAnnotation();
            }
        }
        return this.loadAffyGCOSExpressionFile(new File(this.sflp.selectedFiles.getText()));
    }

    @Override
    public ISlideData loadExpressionFile(File f) {
        return null;
    }

    public void setTMEVDataType() {
        TMEV.setDataType(2);
    }

    public Vector loadAffyGCOSExpressionFile(File f) throws IOException {
        int j;
        String currentLine;
        this.setTMEVDataType();
        int preSpotRows = this.sflp.getXRow() + 1;
        int preExperimentColumns = this.sflp.getXColumn();
        int numLines = this.getCountOfLines(f);
        int spotCount = numLines - preSpotRows;
        if (spotCount <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        int[] rows = new int[]{0, 1, 0};
        int[] columns = new int[]{0, 1, 0};
        String[] moreFields = new String[1];
        String[] extraFields = null;
        boolean rColumns = true;
        int rRows = spotCount;
        ISlideData[] slideDataArray = null;
        AffySlideDataElement sde = null;
        Object slideData = null;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringSplitter ss = new StringSplitter('\t');
        int experimentCount = 0;
        int counter = 0;
        int column = 1;
        int row = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(numLines);
        this.setFileProgress(0);
        float[] intensities = new float[2];
        while ((currentLine = reader.readLine()) != null) {
            String val;
            int i;
            if (this.stop) {
                return null;
            }
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            if (counter == 0) {
                String[] fieldNames;
                if (this.sflp.onlyIntensityRadioButton.isSelected()) {
                    experimentCount = ss.countTokens() - preExperimentColumns;
                }
                if (this.sflp.intensityWithDetectionRadioButton.isSelected()) {
                    experimentCount = (ss.countTokens() + 1 - preExperimentColumns) / 2;
                }
                if (this.sflp.intensityWithDetectionPvalRadioButton.isSelected()) {
                    experimentCount = (ss.countTokens() + 1 - preExperimentColumns) / 3;
                }
                slideDataArray = new ISlideData[experimentCount];
                SampleAnnotation sampAnn = new SampleAnnotation();
                slideDataArray[0] = new SlideData(rRows, 1, sampAnn);
                slideDataArray[0].setSlideFileName(f.getPath());
                for (i = 1; i < experimentCount; ++i) {
                    sampAnn = new SampleAnnotation();
                    slideDataArray[i] = new FloatSlideData(slideDataArray[0].getSlideMetaData(), spotCount, sampAnn);
                    slideDataArray[i].setSlideFileName(f.getPath());
                }
                if (this.sflp.onlyIntensityRadioButton.isSelected()) {
                    fieldNames = new String[]{"AffyID"};
                    slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                } else if (this.sflp.intensityWithDetectionRadioButton.isSelected()) {
                    fieldNames = new String[2];
                    extraFields = new String[1];
                    fieldNames[0] = "AffyID";
                    fieldNames[1] = "Detection";
                    slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                } else {
                    fieldNames = new String[3];
                    extraFields = new String[2];
                    fieldNames[0] = "AffyID";
                    fieldNames[1] = "Detection";
                    fieldNames[2] = "P-value";
                    slideDataArray[0].getSlideMetaData().appendFieldNames(fieldNames);
                }
                ss.nextToken();
                for (i = 0; i < experimentCount; ++i) {
                    val = ss.nextToken();
                    slideDataArray[i].setSampleAnnotationLoaded(true);
                    slideDataArray[i].getSampleAnnotation().setAnnotation("Default Slide Name", val);
                    slideDataArray[i].setSlideDataName(val);
                    this.mav.getData().setSampleAnnotationLoaded(true);
                    if (this.sflp.intensityWithDetectionPvalRadioButton.isSelected()) {
                        ss.nextToken();
                        ss.nextToken();
                        continue;
                    }
                    if (!this.sflp.intensityWithDetectionRadioButton.isSelected()) continue;
                    ss.nextToken();
                }
            } else if (counter >= preSpotRows) {
                rows[0] = rows[2] = row++;
                columns[0] = columns[2] = column;
                column = column == 1 ? 1 : ++column;
                moreFields[0] = ss.nextToken();
                String cloneName = moreFields[0];
                if (this._tempAnno.size() != 0) {
                    if ((MevAnnotation)this._tempAnno.get(cloneName) != null) {
                        MevAnnotation mevAnno = (MevAnnotation)this._tempAnno.get(cloneName);
                        sde = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields, mevAnno);
                    } else {
                        MevAnnotation mevAnno = new MevAnnotation();
                        mevAnno.setCloneID(cloneName);
                        sde = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, new float[2], moreFields, mevAnno);
                    }
                } else {
                    sde = new AffySlideDataElement(String.valueOf(row + 1), rows, columns, intensities, moreFields);
                }
                slideDataArray[0].addSlideDataElement(sde);
                i = 0;
                for (i = 0; i < slideDataArray.length; ++i) {
                    try {
                        intensities[0] = 1.0f;
                        intensities[1] = ss.nextFloatToken(0.0f);
                        if (this.sflp.intensityWithDetectionPvalRadioButton.isSelected()) {
                            extraFields[0] = ss.nextToken();
                            extraFields[1] = ss.nextToken();
                        } else if (this.sflp.intensityWithDetectionRadioButton.isSelected()) {
                            extraFields[0] = ss.nextToken();
                        }
                    }
                    catch (Exception e) {
                        intensities[1] = Float.NaN;
                    }
                    if (i == 0) {
                        slideDataArray[i].setIntensities(counter - preSpotRows, intensities[0], intensities[1]);
                        if (this.sflp.intensityWithDetectionPvalRadioButton.isSelected()) {
                            sde.setDetection(extraFields[0]);
                            sde.setPvalue(new Float(extraFields[1]).floatValue());
                            continue;
                        }
                        if (!this.sflp.intensityWithDetectionRadioButton.isSelected()) continue;
                        sde.setDetection(extraFields[0]);
                        continue;
                    }
                    if (i == 1) {
                        this.meta = slideDataArray[0].getSlideMetaData();
                    }
                    slideDataArray[i].setIntensities(counter - preSpotRows, intensities[0], intensities[1]);
                    if (this.sflp.intensityWithDetectionPvalRadioButton.isSelected()) {
                        ((FloatSlideData)slideDataArray[i]).setDetection(counter - preSpotRows, extraFields[0]);
                        ((FloatSlideData)slideDataArray[i]).setPvalue(counter - preSpotRows, new Float(extraFields[1]).floatValue());
                    }
                    if (!this.sflp.intensityWithDetectionRadioButton.isSelected()) continue;
                    ((FloatSlideData)slideDataArray[i]).setDetection(counter - preSpotRows, extraFields[0]);
                }
            } else {
                for (int i2 = 0; i2 < preExperimentColumns - 1; ++i2) {
                    ss.nextToken();
                }
                String key = ss.nextToken();
                for (j = 0; j < slideDataArray.length; ++j) {
                    if (slideDataArray[j].getSampleAnnotation() != null) {
                        val = ss.nextToken();
                        slideDataArray[j].getSampleAnnotation().setAnnotation(key, val);
                        continue;
                    }
                    SampleAnnotation sampAnn = new SampleAnnotation();
                    sampAnn.setAnnotation(key, ss.nextToken());
                    slideDataArray[j].setSampleAnnotation(sampAnn);
                    slideDataArray[j].setSampleAnnotationLoaded(true);
                }
            }
            this.setFileProgress(counter);
            ++counter;
        }
        reader.close();
        Vector<void> data = new Vector<void>(slideDataArray.length);
        for (j = 0; j < slideDataArray.length; ++j) {
            data.add(slideDataArray[j]);
        }
        this.setFilesProgress(1);
        return data;
    }

    @Override
    public FileFilter getFileFilter() {
        FileFilter mevFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "AffyGCOS Files(*.txt)";
            }
        };
        return mevFileFilter;
    }

    @Override
    public boolean checkLoadEnable() {
        int tableRow = this.sflp.getXRow() + 1;
        int tableColumn = this.sflp.getXColumn();
        if (tableColumn < 0) {
            return false;
        }
        TableModel model = this.sflp.getTable().getModel();
        String fieldSummary = "";
        for (int i = 0; i < tableColumn; ++i) {
            fieldSummary = fieldSummary + model.getColumnName(i) + (i + 1 == tableColumn ? "" : ", ");
        }
        this.sflp.setFieldsText(fieldSummary);
        if (tableRow >= 1 && tableColumn >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File targetFile) {
        return true;
    }

    @Override
    public JPanel getFileLoaderPanel() {
        return this.sflp;
    }

    @Override
    public int getDataType() {
        return this.affyDataType;
    }

    @Override
    public String getAnnotationFilePath() {
        return this.sflp.getAnnFilePath();
    }

    public boolean isAnnotationSelected() {
        return this.sflp.isAnnotationSelected();
    }

    public void processAffyGCOSFile(File targetFile) {
        Vector<String> columnHeaders = new Vector<String>();
        Vector<Vector<String>> dataVector = new Vector<Vector<String>>();
        Vector<String> rowVector = null;
        BufferedReader reader = null;
        String currentLine = null;
        if (!this.validateFile(targetFile)) {
            return;
        }
        this.sflp.setDataFileName(targetFile.getAbsolutePath());
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        try {
            reader = new BufferedReader(new FileReader(targetFile), 131072);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            StringSplitter ss = new StringSplitter('\t');
            currentLine = reader.readLine();
            while (currentLine.endsWith("\t")) {
                currentLine = currentLine.substring(0, currentLine.length() - 1);
            }
            ss.init(currentLine);
            for (int i = 0; i < ss.countTokens() + 1; ++i) {
                columnHeaders.add(ss.nextToken());
            }
            model.setColumnIdentifiers(columnHeaders);
            int cnt = 0;
            while ((currentLine = reader.readLine()) != null && cnt < 100) {
                ++cnt;
                ss.init(currentLine);
                rowVector = new Vector<String>();
                for (int i = 0; i < ss.countTokens() + 1; ++i) {
                    try {
                        rowVector.add(ss.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException nsee) {
                        rowVector.add(" ");
                    }
                }
                dataVector.add(rowVector);
                model.addRow(rowVector);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.sflp.setTableModel(model);
        Point p = this.getFirstExpressionCell(dataVector);
        this.sflp.setSelectedCell(p.x, p.y);
    }

    @Override
    public String getFilePath() {
        return this.sflp.selectedFiles.getText();
    }

    @Override
    public void openDataPath() {
        this.sflp.openDataPath();
    }

    @Override
    public Point getFirstExpressionCell(Vector<Vector<String>> dataVector) {
        int guessCol = 0;
        int guessRow = 0;
        Vector<String> lastRow = dataVector.get(dataVector.size() - 1);
        for (int j = lastRow.size() - 2; j >= 0; --j) {
            String thisEntry = lastRow.get(j);
            try {
                Float temp = new Float(thisEntry);
                continue;
            }
            catch (Exception e) {
                guessCol = j + 1;
                break;
            }
        }
        for (int i = dataVector.size() - 1; i >= 0; --i) {
            Vector<String> thisRow = dataVector.get(i);
            try {
                String thisEntry = thisRow.get(guessCol);
                Float temp = new Float(thisEntry);
                continue;
            }
            catch (Exception e) {
                guessRow = i + 1;
                break;
            }
        }
        return new Point(guessRow, guessCol);
    }

    @Override
    public void setAnnotationFilePath(String filePath) {
        this.sflp.adh.setAnnFilePath(filePath);
    }

    private class AffyGCOSFileLoaderPanel
    extends JPanel {
        JPanel fileSelectionPanel;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel additionalRequirementPanel;
        JTextField fileNameTextField;
        JTextField selectedFiles;
        ButtonGroup optionsButtonGroup;
        JRadioButton onlyIntensityRadioButton;
        JRadioButton intensityWithDetectionRadioButton;
        JRadioButton intensityWithDetectionPvalRadioButton;
        JPanel annotationPanel;
        JPanel mainPanel;
        JLabel fileSelectionLabel;
        JLabel dataSelection;
        JButton browseButton1;
        protected EventListener eventListener;
        JPanel fileLoaderPanel;
        private int xRow = -1;
        private int xColumn = -1;
        AnnotationDownloadHandler adh;

        public AffyGCOSFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.adh = new AnnotationDownloadHandler(AffyGCOSFileLoader.this.superLoader.viewer.getResourceManager(), AffyGCOSFileLoader.this.superLoader.annotationLists, AffyGCOSFileLoader.this.superLoader.defaultSpeciesName, AffyGCOSFileLoader.this.superLoader.defaultArrayName);
            this.eventListener = new EventListener();
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.selectedFiles = new JTextField();
            this.selectedFiles.setEditable(false);
            this.selectedFiles.setForeground(Color.black);
            this.selectedFiles.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionLabel = new JLabel();
            this.fileSelectionLabel.setForeground(Color.BLACK);
            String fileTypeChoices = "<html> Selected files </html>";
            this.fileSelectionLabel.setText(fileTypeChoices);
            this.dataSelection = new JLabel();
            this.dataSelection.setForeground(Color.BLACK);
            String chooseFile = "<html>Select expression data file</html>";
            this.dataSelection.setText(chooseFile);
            this.browseButton1 = new JButton("Browse");
            this.browseButton1.addActionListener(this.eventListener);
            this.browseButton1.setSize(100, 30);
            this.browseButton1.setPreferredSize(new Dimension(100, 30));
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "File    (Affy GCOS Format Files)"));
            AffyGCOSFileLoader.this.gba.add(this.fileSelectionPanel, this.dataSelection, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.fileSelectionPanel, this.browseButton1, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.fileSelectionPanel, this.fileSelectionLabel, 0, 2, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.fileSelectionPanel, this.selectedFiles, 1, 2, 1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.annotationPanel = this.adh.getAnnotationLoaderPanel(AffyGCOSFileLoader.this.gba);
            this.adh.setDownloadEnabled(true);
            this.additionalRequirementPanel = new JPanel();
            this.additionalRequirementPanel.setLayout(new GridBagLayout());
            this.additionalRequirementPanel.setBorder(new TitledBorder(new EtchedBorder(), "Additional Requirements"));
            this.optionsButtonGroup = new ButtonGroup();
            this.onlyIntensityRadioButton = new JRadioButton("Only Intensity", true);
            this.optionsButtonGroup.add(this.onlyIntensityRadioButton);
            this.intensityWithDetectionRadioButton = new JRadioButton("Intensity With Detection");
            this.optionsButtonGroup.add(this.intensityWithDetectionRadioButton);
            this.intensityWithDetectionPvalRadioButton = new JRadioButton("Intensity with Detection and P-value");
            this.optionsButtonGroup.add(this.intensityWithDetectionPvalRadioButton);
            AffyGCOSFileLoader.this.gba.add(this.additionalRequirementPanel, this.onlyIntensityRadioButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.additionalRequirementPanel, this.intensityWithDetectionPvalRadioButton, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 0, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.additionalRequirementPanel, this.intensityWithDetectionRadioButton, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.expressionTable = new JTable();
            AffyGCOSFileLoader.this.myCellRenderer = new ExpressionFileTableCellRenderer();
            this.expressionTable.setDefaultRenderer(Object.class, AffyGCOSFileLoader.this.myCellRenderer);
            this.expressionTable.setGridColor(Color.LIGHT_GRAY);
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    AffyGCOSFileLoaderPanel.this.setSelectedCell(AffyGCOSFileLoaderPanel.this.expressionTable.rowAtPoint(event.getPoint()), AffyGCOSFileLoaderPanel.this.expressionTable.columnAtPoint(event.getPoint()));
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String instructions = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(instructions);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            AffyGCOSFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            AffyGCOSFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.fileLoaderPanel, this.annotationPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.fileLoaderPanel, this.additionalRequirementPanel, 0, 4, 1, 2, 3, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 0, 7, 1, 6, 3, 6, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
            AffyGCOSFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        }

        public boolean isAnnotationSelected() {
            return this.adh.isAnnotationSelected();
        }

        public String getAnnFilePath() {
            return this.adh.getAnnFilePath();
        }

        private void setSelectedCell(int xR, int xC) {
            this.xRow = xR;
            this.xColumn = xC;
            AffyGCOSFileLoader.this.myCellRenderer.setSelected(this.xRow, this.xColumn);
            this.expressionTable.repaint();
            AffyGCOSFileLoader.this.checkLoadEnable();
        }

        public void openDataPath() {
        }

        public void onBrowse() {
            JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            int retVal = fileChooser.showOpenDialog(this);
            if (retVal == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                this.fileNameTextField.setText(selectedFile.getAbsolutePath());
                AffyGCOSFileLoader.this.processAffyGCOSFile(selectedFile);
            }
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void setDataFileName(String fileName) {
            this.selectedFiles.setText(fileName);
        }

        public void setTableModel(TableModel model) {
            this.expressionTable.setModel(model);
            int numCols = this.expressionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String fieldsText) {
        }

        private class EventListener
        implements ActionListener {
            private EventListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == AffyGCOSFileLoaderPanel.this.browseButton1) {
                    AffyGCOSFileLoaderPanel.this.onBrowse();
                }
            }
        }
    }
}

