/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit.lola;

import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.IClusterSubmitter;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.RepositoryConfigParser;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.lola.LOLADialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.lola.LOLAPasswordDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.lola.connLOLA;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;

public class LOLASubmitter
implements IClusterSubmitter {
    private Cluster cluster;
    private IFramework framework;
    private RepositoryConfigParser parser;
    private Submitter submitter;
    private Thread thread;
    private boolean stop = false;

    @Override
    public boolean submit(Cluster cluster, IFramework framework, RepositoryConfigParser parser) {
        this.cluster = cluster;
        this.framework = framework;
        this.parser = parser;
        try {
            this.submitter = new Submitter();
            this.thread = new Thread(this.submitter);
            this.thread.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Error starting the submission thread, submission aborted", "Submission Thread Error", 0);
            return false;
        }
        return true;
    }

    private float[] getFolds(IData data, Cluster cluster, String[] sampleNames, int[] groupings) {
        int sns = sampleNames.length;
        int[] genes = cluster.getIndices();
        float[] signals = new float[sns];
        float[] folds = new float[genes.length];
        for (int i = 0; i < genes.length; ++i) {
            for (int j = 0; j < sns; ++j) {
                signals[j] = data.getRatio(j, genes[i], 0);
            }
            folds[i] = this.get_fold(signals, groupings);
        }
        return folds;
    }

    private float get_fold(float[] signals, int[] groupings) {
        float[] mean = new float[3];
        mean[2] = 0.0f;
        mean[1] = 0.0f;
        mean[0] = 0.0f;
        int num_b = 0;
        int num_a = 0;
        for (int i = 0; i < signals.length; ++i) {
            if (groupings[i] == 0) {
                ++num_a;
            } else if (groupings[i] == 1) {
                ++num_b;
            }
            int n = groupings[i];
            mean[n] = mean[n] + signals[i];
        }
        mean[0] = mean[0] / (float)num_a;
        mean[1] = mean[1] / (float)num_b;
        return mean[0] / mean[1];
    }

    private String constructGeneList(IData data, int[] rows, float[] folds) {
        String gene_list = new String();
        for (int i = 0; i < rows.length; ++i) {
            gene_list = gene_list + data.getElementAttribute(rows[i], 0) + "\t" + folds[i] + "\n";
        }
        return gene_list;
    }

    private class SubmissionListener
    extends DialogListener {
        private SubmissionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (LOLASubmitter.this.thread != null) {
                LOLASubmitter.this.stop = true;
            }
        }
    }

    private class Submitter
    implements Runnable {
        private Submitter() {
        }

        @Override
        public void run() {
            Logger logger = new Logger(LOLASubmitter.this.framework.getFrame(), "LOLA Submission Log", (DialogListener)new SubmissionListener());
            logger.show();
            logger.append("Begin LOLA Submission Process\n");
            IData data = LOLASubmitter.this.framework.getData();
            logger.append("Data Type Verification\n");
            if (data.getDataType() != 2 && data.getDataType() != 3 && data.getDataType() != 4 && data.getDataType() != 5) {
                JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "The Data Type must be Human Affymetrix data to comply with the LOLA repository.", "Data Type Mismatch Error", 0);
                return;
            }
            if (LOLASubmitter.this.stop) {
                return;
            }
            logger.append("Extract Sample Names\n");
            Experiment experiment = LOLASubmitter.this.cluster.getExperiment();
            int count = experiment.getNumberOfSamples();
            int[] sampleOrder = experiment.getColumnIndicesCopy();
            String[] expNames = new String[count];
            for (int i = 0; i < count; ++i) {
                expNames[i] = data.getSampleName(sampleOrder[i]);
            }
            logger.append("Get User Login Info\n");
            Hashtable userInfo = LOLASubmitter.this.parser.getUserInfo("LOLA");
            String email = (String)userInfo.get("email");
            String pw = (String)userInfo.get("password");
            LOLAPasswordDialog passDialog = new LOLAPasswordDialog(email, pw);
            if (LOLASubmitter.this.stop) {
                return;
            }
            if (passDialog.showModal() != 0) {
                JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Submission aborted prior to login.", "Abort LOLA Submission", 1);
                return;
            }
            email = passDialog.getUserName();
            pw = passDialog.getPassword();
            logger.append("Collect Grouping Information and Fold Changes\n");
            LOLADialog dialog = new LOLADialog("Export Gene List to LOLA", expNames, LOLASubmitter.this.cluster);
            if (dialog.showModal() == 0) {
                int[] sampleGroupings = dialog.getGroupAssignments();
                float[] folds = LOLASubmitter.this.getFolds(data, LOLASubmitter.this.cluster, expNames, sampleGroupings);
                logger.append("Construct Gene List\n");
                String geneList = LOLASubmitter.this.constructGeneList(data, LOLASubmitter.this.cluster.getIndices(), folds);
                if (LOLASubmitter.this.stop) {
                    return;
                }
                if (email != null && pw != null) {
                    connLOLA connection = new connLOLA(email, pw);
                    logger.append("Login to LOLA\n");
                    String sessionID = connection.login();
                    if (LOLASubmitter.this.stop) {
                        return;
                    }
                    if (sessionID.equals("")) {
                        JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Error during login to LOLA.  Please go to http://lola.gwu.edu to establish an account.\nIf you have an account please try again. You may Edit the user information for LOLA in the archive_submission_config.xml\n (in " + TMEV.getConfigurationFile("archive_submission_config.xml").getAbsoluteFile() + ") to reflect\nyour email and LOLA password so that MeV will retain this information for you.", "LOLA Login Error", 0);
                        return;
                    }
                    logger.append("Login Complete\n");
                    logger.append("Submit List\n");
                    if (!connection.submit_list(LOLASubmitter.this.cluster.getClusterLabel(), LOLASubmitter.this.cluster.getClusterDescription(), geneList)) {
                        JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "After login, an error occurred during list submission to LOLA.\nPlease check that the primary identifiers are Affy ID's or LocusLink.\nThe submission page for LOLA describes the submission requirements.", "LOLA Submission Error", 0);
                        return;
                    }
                    logger.append("Commit List\n");
                    connection.create_list();
                    logger.append("Logout from LOLA\n");
                    connection.logout();
                    JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Submission to LOLA completed successfully.  Thank you.", "LOLA Submission Confirmation", 1);
                    logger.append("Record Submission to History Node\n");
                    LOLASubmitter.this.framework.addHistory("Gene submission to LOLA, Cluster #" + LOLASubmitter.this.cluster.getSerialNumber() + ", containing " + LOLASubmitter.this.cluster.getSize() + " genes.");
                    logger.dispose();
                } else {
                    JOptionPane.showMessageDialog(LOLASubmitter.this.framework.getFrame(), "Error during login to LOLA.  No login information available.  Please go to http://lola.gwu.edu to establish an account.\nIf you have an account edit the user information for LOLA in the archive_submission_config.xml\n (in " + TMEV.getConfigurationFile("archive_submission_config.xml").getAbsoluteFile() + ") to reflect\nyour email and LOLA password.", "LOLA Login Error", 0);
                    return;
                }
            }
        }
    }
}

