/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit.lola;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class LOLADialog
extends AlgorithmDialog {
    private GroupExperimentsPanel gPanel;
    private JButton lola_it;
    private JButton cancel;
    int result = 2;
    String[] sample_names;
    int[] sample_groupings;

    public LOLADialog(String frameTitle, String[] sample_names, Cluster cluster) {
        super(new JFrame(), frameTitle, true);
        int count;
        this.sample_names = sample_names;
        this.sample_groupings = new int[sample_names.length];
        this.setBounds(0, 0, 800, 500);
        this.setDefaultCloseOperation(2);
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(BorderFactory.createLineBorder(Color.black));
        pane.setLayout(new BorderLayout(1, 2));
        Listener listener = new Listener();
        this.gPanel = new GroupExperimentsPanel(sample_names);
        for (count = 0; count < this.gPanel.groupARadioButtons.length; ++count) {
            this.gPanel.groupARadioButtons[count].addActionListener(new GroupListener(0, count));
        }
        for (count = 0; count < this.gPanel.groupBRadioButtons.length; ++count) {
            this.gPanel.groupBRadioButtons[count].addActionListener(new GroupListener(1, count));
        }
        pane.add((Component)this.gPanel, "Center");
        this.addContent(pane);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    public int[] getGroupAssignments() {
        return this.sample_groupings;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    class GroupExperimentsPanel
    extends JPanel {
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(String[] exptNames) {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            JPanel panel1 = new JPanel();
            JLabel[] expLabels = new JLabel[exptNames.length];
            this.groupARadioButtons = new JRadioButton[exptNames.length];
            this.groupBRadioButtons = new JRadioButton[exptNames.length];
            this.neitherGroupRadioButtons = new JRadioButton[exptNames.length];
            ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.length];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag2);
            panel1.setLayout(gridbag);
            for (int i = 0; i < exptNames.length; ++i) {
                String s1 = exptNames[i];
                expLabels[i] = new JLabel(s1);
                chooseGroup[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                chooseGroup[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                chooseGroup[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither", false);
                chooseGroup[i].add(this.neitherGroupRadioButtons[i]);
                this.buildConstraints(constraints, 0, i, 1, 1, 25, 100);
                gridbag.setConstraints(expLabels[i], constraints);
                panel1.add(expLabels[i]);
                this.buildConstraints(constraints, 1, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupARadioButtons[i], constraints);
                panel1.add(this.groupARadioButtons[i]);
                this.buildConstraints(constraints, 2, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupBRadioButtons[i], constraints);
                panel1.add(this.groupBRadioButtons[i]);
                this.buildConstraints(constraints, 3, i, 1, 1, 25, 100);
                gridbag.setConstraints(this.neitherGroupRadioButtons[i], constraints);
                panel1.add(this.neitherGroupRadioButtons[i]);
            }
            JScrollPane scroll = new JScrollPane(panel1);
            scroll.setPreferredSize(new Dimension(400, 450));
            this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            gridbag2.setConstraints(scroll, constraints);
            this.add(scroll);
        }

        void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
            gbc.gridx = gx;
            gbc.gridy = gy;
            gbc.gridwidth = gw;
            gbc.gridheight = gh;
            gbc.weightx = wx;
            gbc.weighty = wy;
        }
    }

    class GroupListener
    implements ActionListener {
        int file_index;
        int group;

        GroupListener(int group, int file_index) {
            this.group = group;
            this.file_index = file_index;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LOLADialog.this.sample_groupings[this.file_index] = this.group;
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                this.onOk();
            } else if (command.equals("cancel-command")) {
                LOLADialog.this.result = 2;
                LOLADialog.this.dispose();
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                this.onOk();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LOLADialog.this.result = -1;
            LOLADialog.this.dispose();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        private void onOk() {
            try {
                LOLADialog.this.result = 0;
            }
            catch (Exception exception) {
                LOLADialog.this.result = 2;
            }
            LOLADialog.this.dispose();
        }
    }
}

