/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit;

import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.ClusterArchiveSelectionDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.IClusterSubmitter;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.RepositoryConfigParser;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class SubmissionManager {
    private RepositoryConfigParser parser;
    private ClusterRepository repository;
    private IFramework framework;

    public SubmissionManager(IFramework framework, ClusterRepository repository) {
        this.framework = framework;
        this.repository = repository;
        this.parser = new RepositoryConfigParser();
    }

    public boolean submit(Cluster cluster) {
        boolean submit = false;
        if (!this.parser.parseSubmissionConfigFile()) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error parsing gene cluster submission configuration file, \n\"archive_submission_config.xml\"", "Submission Configuration File", 0);
            return false;
        }
        ClusterArchiveSelectionDialog dialog = new ClusterArchiveSelectionDialog(this.parser);
        if (dialog.showModal() == 0) {
            String repName = dialog.getSelectedRepositoryName();
            String implClassName = this.parser.getRepositorySubmissionClass(repName);
            try {
                this.getClass();
                IClusterSubmitter submitter = (IClusterSubmitter)Class.forName(implClassName).newInstance();
                submit = submitter.submit(cluster, this.framework, this.parser);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return submit;
    }
}

