/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.xerces.parsers.DOMParser;
import org.tigr.microarray.mev.TMEV;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryConfigParser
extends DefaultHandler {
    Document document;
    private Element root;
    private Hashtable repositoryHash;

    public boolean parseSubmissionConfigFile() {
        try {
            File file = TMEV.getConfigurationFile("archive_submission_config.xml");
            if (file == null || !file.exists()) {
                JOptionPane.showMessageDialog(new JFrame(), "Error during submission configuration.  The file archive_submission_config.xml which contains\ncluter repository information was missing or not in MeV's config folder.\n", "Cluster Submission Error", 0);
                return false;
            }
            URL url = file.toURI().toURL();
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler((ErrorHandler)this);
            parser.parse(url.toString());
            this.document = parser.getDocument();
            this.root = this.document.getDocumentElement();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Error parsing archive_submission_config.xml which contains repository information.", "Cluster Submission Error", 0);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Error parsing archive_submission_config.xml which contains repository information.", "Cluster Submission Error", 0);
            return false;
        }
        this.initializeRepositoryHash();
        return true;
    }

    public Element getRoot() {
        return this.root;
    }

    public String[] getRepositoryNames() {
        if (this.repositoryHash == null) {
            return null;
        }
        Set keys = this.repositoryHash.keySet();
        String[] names = new String[keys.size()];
        Iterator iter = keys.iterator();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)iter.next();
        }
        return names;
    }

    public String getRepositoryDescription(String repName) {
        if (this.repositoryHash == null) {
            return null;
        }
        Element elem = this.getRepositoryXMLElement(repName);
        NodeList list = elem.getElementsByTagName("description");
        return list.item(0).getChildNodes().item(0).getNodeValue();
    }

    public Element getRepositoryXMLElement(String repName) {
        if (this.repositoryHash == null) {
            return null;
        }
        return (Element)this.repositoryHash.get(repName);
    }

    private void initializeRepositoryHash() {
        this.repositoryHash = new Hashtable();
        NodeList nameList = this.root.getElementsByTagName("submit_entry");
        String[] names = new String[nameList.getLength()];
        for (int i = 0; i < names.length; ++i) {
            this.repositoryHash.put(((Element)nameList.item(i)).getAttribute("name"), (Element)nameList.item(i));
        }
    }

    public String getRepositorySpecifications(String repName) {
        String table = new String();
        table = table + "<table cellpadding=5><tr><th colspan=2 align=left>Additional Submission Details</th></tr>";
        Element elem = this.getRepositoryXMLElement(repName);
        elem = (Element)elem.getElementsByTagName("submission").item(0);
        elem = (Element)elem.getElementsByTagName("specification_table").item(0);
        NodeList list = elem.getElementsByTagName("spec");
        for (int i = 0; i < list.getLength(); ++i) {
            String key = ((Element)list.item(i)).getAttribute("key");
            String value = ((Element)list.item(i)).getAttribute("value");
            table = table + "<tr><td><b>" + key + ":</b></td><td>" + value + "</td></tr>";
        }
        table = table + "</table>";
        return table;
    }

    public String getRepositoryPage(String repName) {
        String text = new String();
        text = text + "<html><body><h2>" + repName + "</h2><hr size=3>" + "<b>Repository Name:&nbsp&nbsp</b>" + repName + "<br><br>" + "<b>Repository Web Site:&nbsp&nbsp</b>" + this.getRepositoryURL(repName) + "<br><br>" + "<b>Description:&nbsp&nbsp</b>" + this.getRepositoryDescription(repName) + "<br><br>";
        text = text + this.getRepositorySpecifications(repName);
        text = text + "</body></html>";
        return text;
    }

    public Hashtable getUserInfo(String repName) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Element elem = this.getRepositoryXMLElement(repName);
        NodeList list = elem.getElementsByTagName("user");
        elem = (Element)list.item(0);
        String value = elem.getAttribute("user_name");
        table.put("user_name", value);
        value = elem.getAttribute("password");
        table.put("password", value);
        value = elem.getAttribute("email");
        table.put("email", value);
        return table;
    }

    public String getRepositorySubmissionClass(String repName) {
        Element elem = this.getRepositoryXMLElement(repName);
        NodeList list = elem.getElementsByTagName("impl");
        return ((Element)list.item(0)).getAttribute("impl_class");
    }

    public String getRepositoryURL(String repName) {
        Element elem = this.getRepositoryXMLElement(repName);
        if (elem != null) {
            return elem.getAttribute("url");
        }
        return null;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        System.err.println("Warning:  " + e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        System.err.println("Error:  " + e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("Fatal Error:  " + e);
    }
}

