/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.RepositoryConfigParser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ClusterArchiveSelectionDialog
extends AlgorithmDialog {
    private RepositoryConfigParser parser;
    private RepositoryPane repPane;
    int result = 2;

    public ClusterArchiveSelectionDialog(RepositoryConfigParser parser) {
        super(new JFrame(), "Cluster Archive Selection Dialog", true);
        this.parser = parser;
        this.okButton.setText("Submit");
        this.okButton.setEnabled(false);
        this.validate();
        this.repPane = new RepositoryPane();
        this.addContent(this.repPane);
        this.setActionListeners((ActionListener)((Object)new Listener()));
    }

    public ClusterArchiveSelectionDialog() {
        super(new JFrame(), "Cluster Archive Selection Dialog", true);
        JPanel panel = new JPanel();
        this.repPane = new RepositoryPane();
        panel.add(this.repPane);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width / 2, (int)((double)screenSize.height / 1.6));
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.repPane.setSelectedIndex(0);
    }

    public String getSelectedRepositoryName() {
        return this.repPane.getSelectedRepositoryName();
    }

    private JPanel constructIntroPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        JTextPane pane = new JTextPane();
        pane.setEditable(false);
        pane.setMargin(new Insets(10, 15, 10, 15));
        pane.setContentType("text/html");
        String text = new String();
        text = text + "<html><h2>External Cluster Repository Submission</h2><hr size=3>";
        text = text + "Welcome to MeV's cluster submission process.  Select a repository using the ";
        text = text + "tabbed panes in this dialog. ";
        text = text + "Information on each page will indicate the suitability of a repository for your gene list. ";
        text = text + "After selection of a repository, hit submit to be lead through the submission process. ";
        text = text + "<br><br>";
        text = text + "For first time submissions it might be required to register at the repostitory web site and ";
        text = text + "to use the user name and password during the cluster submission (See manual for details)</html>";
        pane.setText(text);
        panel.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private class Listener
    extends DialogListener
    implements ChangeListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                ClusterArchiveSelectionDialog.this.result = 0;
                ClusterArchiveSelectionDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                ClusterArchiveSelectionDialog.this.result = 2;
                ClusterArchiveSelectionDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    ClusterArchiveSelectionDialog.this.resetControls();
                    ClusterArchiveSelectionDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser((Window)((Object)ClusterArchiveSelectionDialog.this), (String)"Cluster Archive Submission");
                }
            }
            ClusterArchiveSelectionDialog.this.dispose();
        }

        public void windowClosing(WindowEvent e) {
            ClusterArchiveSelectionDialog.this.result = -1;
            ClusterArchiveSelectionDialog.this.dispose();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ClusterArchiveSelectionDialog.this.okButton.setEnabled(ClusterArchiveSelectionDialog.this.repPane.getSelectedIndex() != 0);
        }
    }

    private class RepositoryPanel
    extends JPanel {
        private String repositoryName;

        public RepositoryPanel(String repName) {
            super(new GridBagLayout());
            this.repositoryName = repName;
            this.constructContent(repName);
        }

        private void constructContent(String repName) {
            String page = ClusterArchiveSelectionDialog.this.parser.getRepositoryPage(repName);
            JTextPane pane = new JTextPane();
            pane.setEditable(false);
            pane.setMargin(new Insets(10, 15, 10, 15));
            pane.setContentType("text/html");
            pane.setText(page);
            JScrollPane scroll = new JScrollPane(pane);
            this.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pane.setCaretPosition(0);
        }
    }

    private class RepositoryPane
    extends JTabbedPane {
        String[] repNames;

        public RepositoryPane() {
            this.addTab("Introduction", ClusterArchiveSelectionDialog.this.constructIntroPanel());
            this.addChangeListener(new Listener());
            this.repNames = ClusterArchiveSelectionDialog.this.parser.getRepositoryNames();
            for (int i = 0; i < this.repNames.length; ++i) {
                this.addTab(this.repNames[i], new RepositoryPanel(this.repNames[i]));
            }
        }

        public String getSelectedRepositoryName() {
            return this.getTitleAt(this.getSelectedIndex());
        }
    }
}

