/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ListImportDialog
extends AlgorithmDialog {
    private Vector annFields;
    private JComboBox listBox;
    private JTextPane pane;
    private JCheckBox[] checkBoxes;
    private List theList;
    private List otherList;
    private int result = 2;
    private boolean bin = false;
    private ArrayList<JTextField> lowerFieldArray = new ArrayList();
    private ArrayList<JTextField> upperFieldArray = new ArrayList();
    private int importType = 0;
    private int binnedClusterCount = 0;
    ParameterPanel binParamPanel;
    JButton addOne;
    ArrayList<Integer> removedClusters = new ArrayList();

    public ListImportDialog(Frame parent, String[] fieldNames, boolean geneList, String[] genes) {
        super(parent, geneList ? "Gene List Import Dialog" : "Sample List Import Dialog", true);
        this.annFields = new Vector();
        for (int i = 0; i < fieldNames.length; ++i) {
            this.annFields.addElement(fieldNames[i]);
        }
        ParameterPanel paramPanel = geneList ? new ParameterPanel("Gene List Import Parameters") : new ParameterPanel("Sample List Import Parameters");
        paramPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel listLabel = geneList ? new JLabel("Gene ID Type:") : new JLabel("Sample ID Type:");
        this.listBox = new JComboBox(this.annFields);
        if (this.annFields.size() > 0) {
            this.listBox.setSelectedIndex(0);
        }
        JLabel textLabel = new JLabel("Paste List (ctrl-v):");
        this.pane = new JTextPane();
        this.pane.setPreferredSize(new Dimension(125, 200));
        if (genes != null) {
            String genelist = "";
            for (int i = 0; i < genes.length; ++i) {
                genelist = genelist + genes[i] + "\n";
            }
            this.pane.setText(genelist);
        }
        JScrollPane scroll = new JScrollPane(this.pane);
        scroll.getViewport().setViewSize(new Dimension(125, 200));
        scroll.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListImportDialog.this.loadGeneListFile();
            }
        });
        paramPanel.add((Component)listLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)this.listBox, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        paramPanel.add((Component)textLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(20, 0, 0, 20), 0, 0));
        paramPanel.add((Component)scroll, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 10, 0), 0, 0));
        paramPanel.add((Component)browseButton, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 10, 0), 0, 0));
        this.addContent((Component)paramPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
    }

    private void loadGeneListFile() {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                Vector<String> data = new Vector<String>();
                String geneList = "";
                while ((line = br.readLine()) != null) {
                    data.add(line.trim());
                    geneList = geneList + line.trim() + "\n";
                }
                this.pane.setText(geneList.trim());
                br.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ListImportDialog(Frame parent, String[] fieldNames, boolean geneList, boolean auto, boolean bin) {
        super(parent, geneList ? "Gene Binning Dialog" : "Sample Binning Dialog", true);
        int i;
        this.importType = 2;
        this.bin = bin;
        this.annFields = new Vector();
        for (int i2 = 0; i2 < fieldNames.length; ++i2) {
            this.annFields.addElement(fieldNames[i2]);
        }
        this.checkBoxes = new JCheckBox[this.annFields.size()];
        JComboBox comboBox = new JComboBox();
        this.binParamPanel = geneList ? new ParameterPanel("Gene Binning Parameters") : new ParameterPanel("Sample Binning Parameters");
        this.binParamPanel.setLayout((LayoutManager)new GridBagLayout());
        this.listBox = new JComboBox(this.annFields);
        JLabel listLabel = geneList ? new JLabel("Gene ID Type:") : new JLabel("Sample Factor:");
        this.binParamPanel.add((Component)listLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 20), 0, 0));
        if (this.annFields.size() > 0) {
            this.listBox.setSelectedIndex(0);
        }
        for (i = 0; i < this.annFields.size(); ++i) {
            this.checkBoxes[i] = new JCheckBox(fieldNames[i], false);
            comboBox.add(this.checkBoxes[i]);
        }
        this.theList = new List(16, false);
        this.otherList = new List(8, false);
        for (i = 0; i < this.annFields.size(); ++i) {
            this.theList.add(fieldNames[i]);
        }
        this.binParamPanel.add((Component)this.listBox, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.addAnotherCluster();
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
    }

    private void addAnotherCluster() {
        ++this.binnedClusterCount;
        JPanel fieldsPanel = new JPanel();
        JLabel lowerLimit = new JLabel("Lower Limit: ");
        JLabel upperLimit = new JLabel("Upper Limit: ");
        JTextField lowerField = new JTextField("");
        JTextField upperField = new JTextField("");
        lowerField.setSize(50, 20);
        lowerField.setMinimumSize(new Dimension(20, 10));
        lowerField.setPreferredSize(new Dimension(50, 20));
        fieldsPanel.setOpaque(false);
        fieldsPanel.setLayout(new GridBagLayout());
        fieldsPanel.add((Component)lowerLimit, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        fieldsPanel.add((Component)upperLimit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        fieldsPanel.add((Component)lowerField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        fieldsPanel.add((Component)upperField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        fieldsPanel.setBorder(BorderFactory.createTitledBorder("Cluster " + this.binnedClusterCount));
        this.lowerFieldArray.add(lowerField);
        this.upperFieldArray.add(upperField);
        this.binParamPanel.add((Component)fieldsPanel, (Object)new GridBagConstraints(0, this.binnedClusterCount, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        JButton remBut = new JButton("X");
        remBut.setActionCommand(String.valueOf(this.binnedClusterCount));
        remBut.addActionListener((ActionListener)((Object)new RemoveClusterListener()));
        if (this.binnedClusterCount > 1) {
            this.binParamPanel.add((Component)remBut, (Object)new GridBagConstraints(2, this.binnedClusterCount, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        }
        if (this.addOne != null) {
            this.binParamPanel.remove((Component)this.addOne);
        }
        this.addOne = new JButton("Add another cluster");
        this.addOne.addActionListener((ActionListener)((Object)new AddClusterListener()));
        this.binParamPanel.add((Component)this.addOne, (Object)new GridBagConstraints(0, this.binnedClusterCount + 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.addContent((Component)this.binParamPanel);
        this.pack();
    }

    private void removeCluster(int cluster) {
        int count = 0;
        for (int i = 0; i < this.removedClusters.size(); ++i) {
            if (this.removedClusters.get(i) >= cluster) continue;
            ++count;
        }
        this.binParamPanel.remove(2 * (cluster - count));
        this.binParamPanel.remove(2 * (cluster - count) - 1);
        this.removedClusters.add(cluster);
        this.pack();
    }

    public ListImportDialog(Frame parent, String[] fieldNames, boolean geneList, boolean auto) {
        super(parent, geneList ? "Automatic Gene Clustering Dialog" : "Automatic Sample Clustering Dialog", true);
        this.importType = 1;
        this.annFields = new Vector();
        for (int i = 0; i < fieldNames.length; ++i) {
            this.annFields.addElement(fieldNames[i]);
        }
        this.checkBoxes = new JCheckBox[this.annFields.size()];
        JComboBox comboBox = new JComboBox();
        ParameterPanel paramPanel = geneList ? new ParameterPanel("Gene Auto-Clustering Parameters") : new ParameterPanel("Sample Auto-Clustering Parameters");
        paramPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel listLabel = geneList ? new JLabel("Available Gene ID Types:") : new JLabel("Available Sample Factors:");
        JLabel otherListLabel = geneList ? new JLabel("Selected Gene ID Types:") : new JLabel("Selected Sample Factors:");
        this.listBox = new JComboBox(this.annFields);
        this.pane = new JTextPane();
        this.pane.setPreferredSize(new Dimension(125, 200));
        JScrollPane scroll = new JScrollPane(this.pane);
        scroll.getViewport().setViewSize(new Dimension(125, 200));
        scroll.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        if (this.annFields.size() > 0) {
            this.listBox.setSelectedIndex(0);
        }
        for (int i = 0; i < this.annFields.size(); ++i) {
            this.checkBoxes[i] = new JCheckBox(fieldNames[i], false);
            comboBox.add(this.checkBoxes[i]);
        }
        this.theList = new List(16, false);
        this.otherList = new List(8, false);
        JLabel selectorLabel = new JLabel("Add:");
        Button selector = new Button(">>>>");
        JLabel unSelectorLabel = new JLabel("Delete:");
        Button unSelector = new Button("<<<<");
        selector.setActionCommand("select-command");
        unSelector.setActionCommand("unselect-command");
        selector.addActionListener((ActionListener)((Object)new Listener()));
        unSelector.addActionListener((ActionListener)((Object)new Listener()));
        selector.setSize(50, 30);
        for (int i = 0; i < this.annFields.size(); ++i) {
            this.theList.add(fieldNames[i]);
        }
        this.theList.setMultipleMode(true);
        this.otherList.setMultipleMode(true);
        paramPanel.add((Component)listLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)otherListLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)this.theList, (Object)new GridBagConstraints(0, 1, 1, 5, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)selector, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)selectorLabel, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)unSelector, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)unSelectorLabel, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        paramPanel.add((Component)this.otherList, (Object)new GridBagConstraints(2, 1, 1, 5, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        this.addContent((Component)paramPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.listBox.setSelectedIndex(0);
        this.pane.setText("");
    }

    public String getFieldName() {
        return (String)this.listBox.getSelectedItem();
    }

    public List getSelectedFields() {
        return this.otherList;
    }

    public String[] getList() {
        String text = this.pane.getText();
        StringTokenizer stok = new StringTokenizer(text, "\n");
        String[] outputList = new String[stok.countTokens()];
        int cnt = 0;
        while (stok.hasMoreTokens()) {
            outputList[cnt] = stok.nextToken().trim();
            ++cnt;
        }
        return outputList;
    }

    public float[] getLowerLimit() {
        float[] lf = new float[this.lowerFieldArray.size() - this.removedClusters.size()];
        int j = 0;
        for (int i = 0; i < this.lowerFieldArray.size(); ++i) {
            if (this.removedClusters.contains(i + 1)) continue;
            lf[j] = Float.parseFloat(this.lowerFieldArray.get(i).getText());
            ++j;
        }
        return lf;
    }

    public float[] getUpperLimit() {
        float[] uf = new float[this.upperFieldArray.size() - this.removedClusters.size()];
        int j = 0;
        for (int i = 0; i < this.upperFieldArray.size(); ++i) {
            if (this.removedClusters.contains(i + 1)) continue;
            uf[j] = Float.parseFloat(this.upperFieldArray.get(i).getText());
            ++j;
        }
        return uf;
    }

    public static void main(String[] args) {
        String[] qwe = new String[]{"qwe", "werhjkhjkhjk", "sdfsdf", "qqqq", "eevsf"};
        ListImportDialog lid = new ListImportDialog(new Frame(), qwe, true, null);
        if (lid.showModal() == 0) {
            for (int i = 0; i < lid.getUpperLimit().length; ++i) {
                System.out.println(lid.getUpperLimit()[i]);
            }
        }
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (ListImportDialog.this.bin) {
                    try {
                        for (int i = 0; i < ListImportDialog.this.lowerFieldArray.size(); ++i) {
                            if (ListImportDialog.this.removedClusters.contains(i + 1) || !(Float.parseFloat(((JTextField)ListImportDialog.this.upperFieldArray.get(i)).getText()) < Float.parseFloat(((JTextField)ListImportDialog.this.lowerFieldArray.get(i)).getText()))) continue;
                            JOptionPane.showMessageDialog(null, "Upper limit for Cluster " + (i + 1) + " must be greater than lower limit.", "Error", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Please enter numerical values for the upper and lower limits.", "Error", 0);
                        return;
                    }
                }
                ListImportDialog.this.result = 0;
                ListImportDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                ListImportDialog.this.result = 2;
                ListImportDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    ListImportDialog.this.resetControls();
                    ListImportDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser((Window)((Object)ListImportDialog.this), (String)"List Import Dialog");
                    if (ListImportDialog.this.importType == 1) {
                        HelpWindow.launchBrowser((Window)((Object)ListImportDialog.this), (String)"Auto Import Dialog");
                    }
                    if (ListImportDialog.this.importType == 2) {
                        HelpWindow.launchBrowser((Window)((Object)ListImportDialog.this), (String)"Binned Import Dialog");
                    }
                } else {
                    if (command.equals("select-command")) {
                        if (ListImportDialog.this.theList.getSelectedIndexes() == null) {
                            return;
                        }
                        String[] selected = ListImportDialog.this.theList.getSelectedItems();
                        for (int i = 0; i < selected.length; ++i) {
                            ListImportDialog.this.otherList.add(selected[i]);
                            ListImportDialog.this.theList.remove(selected[i]);
                        }
                        return;
                    }
                    if (command.equals("unselect-command")) {
                        if (ListImportDialog.this.otherList.getSelectedIndexes() == null) {
                            return;
                        }
                        String[] selected = ListImportDialog.this.otherList.getSelectedItems();
                        for (int i = 0; i < selected.length; ++i) {
                            ListImportDialog.this.theList.add(selected[i]);
                            ListImportDialog.this.otherList.remove(selected[i]);
                        }
                        return;
                    }
                }
            }
            ListImportDialog.this.dispose();
        }

        public void windowClosing(WindowEvent e) {
            ListImportDialog.this.result = 2;
            ListImportDialog.this.dispose();
        }
    }

    private class RemoveClusterListener
    extends DialogListener {
        private RemoveClusterListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ListImportDialog.this.removeCluster(Integer.parseInt(e.getActionCommand()));
        }
    }

    private class AddClusterListener
    extends DialogListener {
        private AddClusterListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ListImportDialog.this.addAnotherCluster();
        }
    }
}

