/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;

public class ClusterWorker {
    ClusterRepository repository;

    public ClusterWorker(ClusterRepository repository) {
        this.repository = repository;
    }

    public Cluster intersection(Cluster[] clusters) {
        HashSet[] sets = new HashSet[clusters.length];
        int minSize = 0;
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = clusters[i].getHashSet();
            minSize = Math.min(minSize, clusters[i].getSize());
        }
        HashSet resultSet = new HashSet();
        resultSet.addAll(this.intersect(sets));
        Iterator iterator = resultSet.iterator();
        int size = resultSet.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Integer)iterator.next();
        }
        return this.buildResultCluster("Intersection", clusters, result);
    }

    private Cluster buildResultCluster(String operation, Cluster[] clusters, int[] indices) {
        String clusterNumbers = "";
        for (int i = 0; i < clusters.length - 1; ++i) {
            clusterNumbers = clusterNumbers + clusters[i].getSerialNumber() + ":";
        }
        if (clusters.length - 1 > -1) {
            clusterNumbers = clusterNumbers + clusters[clusters.length - 1].getSerialNumber();
        }
        Experiment experiment = this.getMinExperiment(clusters);
        ClusterAttributesDialog dialog = new ClusterAttributesDialog("Cluster Operation: " + operation + "( " + clusterNumbers + " )", "Cluster Op", operation + "( " + clusterNumbers + " )", null, null, this.repository.getNextDefaultColor());
        if (dialog.showModal() == 0) {
            if (this.repository.clusterColors.contains(dialog.getColor())) {
                Object[] optionst = new Object[]{"OK", "CANCEL"};
                int option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
                if (option == 2) {
                    return null;
                }
                if (option == 0) {
                    return this.buildResultCluster(operation, clusters, indices);
                }
                return null;
            }
            this.repository.clusterColors.add(dialog.getColor());
            return new Cluster(indices, "Cluster Op.", dialog.getLabel(), operation + "( " + clusterNumbers + " )", "", dialog.getDescription(), -1, this.repository.takeNextClusterSerialNumber(), dialog.getColor(), experiment);
        }
        return null;
    }

    private Cluster buildBasicCluster(String operation, Cluster[] clusters, int[] indices) {
        String clusterNumbers = "";
        for (int i = 0; i < clusters.length - 1; ++i) {
            clusterNumbers = clusterNumbers + clusters[i].getSerialNumber() + ":";
        }
        if (clusters.length - 1 > -1) {
            clusterNumbers = clusterNumbers + clusters[clusters.length - 1].getSerialNumber();
        }
        Experiment experiment = this.getMinExperiment(clusters);
        return new Cluster(indices, "Cluster Op.", "", operation + "( " + clusterNumbers + " )", "", "", -1, -1, Color.lightGray, experiment);
    }

    public Experiment getMinExperiment(Cluster[] clusters) {
        Experiment smallestExp;
        Experiment currentExp = smallestExp = clusters[0].getExperiment();
        for (int i = 0; i < clusters.length; ++i) {
            currentExp = clusters[i].getExperiment();
            if (currentExp.getNumberOfGenes() >= smallestExp.getNumberOfGenes()) continue;
            smallestExp = currentExp;
        }
        return smallestExp;
    }

    private HashSet intersect(HashSet[] sets) {
        HashSet result = this.intersect(sets[0], sets[1]);
        if (sets.length == 2) {
            return result;
        }
        for (int i = 2; i < sets.length; ++i) {
            result = this.intersect(result, sets[i]);
        }
        return result;
    }

    private HashSet intersect(HashSet setOne, HashSet setTwo) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (Integer currVal : setOne) {
            if (!setTwo.contains(currVal)) continue;
            result.add(currVal);
        }
        return result;
    }

    public Cluster union(Cluster[] clusters) {
        int[] result = this.getUniqueIndices(clusters);
        return this.buildResultCluster("Union", clusters, result);
    }

    public int[] getUniqueIndices(Cluster[] clusters) {
        int[][] indices = new int[clusters.length][];
        int count = 0;
        for (int i = 0; i < clusters.length; ++i) {
            Cluster cluster = clusters[i];
            indices[i] = cluster.getIndices();
            count += indices[i].length;
        }
        int[] resultIndices = new int[count];
        int cnt = 0;
        for (int i = 0; i < indices.length; ++i) {
            for (int j = 0; j < indices[i].length; ++j) {
                resultIndices[cnt] = indices[i][j];
                ++cnt;
            }
        }
        resultIndices = this.makeIndicesUnique(resultIndices);
        return resultIndices;
    }

    private int[] makeIndicesUnique(int[] indices) {
        int numberOfElements = this.repository.getDataElementCount();
        boolean[] indexCheck = new boolean[numberOfElements];
        int uniqueCount = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (indexCheck[indices[i]]) continue;
            indexCheck[indices[i]] = true;
            ++uniqueCount;
        }
        int[] newIndices = new int[uniqueCount];
        int cnt = 0;
        for (int i = 0; i < indexCheck.length; ++i) {
            if (!indexCheck[i]) continue;
            newIndices[cnt] = i;
            ++cnt;
        }
        return newIndices;
    }

    public String[] getClusterLabels(Cluster[] clusters) {
        String[] labels = new String[clusters.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = clusters[i].getClusterLabel();
        }
        return labels;
    }

    public Cluster xor(Cluster[] clusters) {
        Cluster union = this.utilityUnion(clusters);
        Cluster inter = this.utilityIntersection(clusters);
        HashSet unionSet = union.getHashSet();
        HashSet interSet = inter.getHashSet();
        Iterator iterator = interSet.iterator();
        while (iterator.hasNext()) {
            unionSet.remove(iterator.next());
        }
        return this.buildResultCluster("XOR", clusters, this.getIndices(unionSet));
    }

    public Cluster utilityUnion(Cluster[] clusters) {
        int[] result = this.getUniqueIndices(clusters);
        return this.buildBasicCluster("Union", clusters, result);
    }

    public Cluster utilityIntersection(Cluster[] clusters) {
        HashSet[] sets = new HashSet[clusters.length];
        int minSize = 0;
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = clusters[i].getHashSet();
            minSize = Math.min(minSize, clusters[i].getSize());
        }
        HashSet resultSet = new HashSet();
        resultSet.addAll(this.intersect(sets));
        Iterator iterator = resultSet.iterator();
        int size = resultSet.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Integer)iterator.next();
        }
        return this.buildBasicCluster("Intersection", clusters, result);
    }

    private int[] getIndices(HashSet set) {
        Object[] a = set.toArray();
        int[] indices = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            indices[i] = (Integer)a[i];
        }
        return indices;
    }
}

