/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterWorker;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.BoxChartViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.VennDiagramViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ClusterTable
extends JPanel
implements IViewer {
    private JTable tableOfClusters;
    private JTable tableOfElements;
    private IViewer iViewer;
    private IViewer ctv;
    private IViewer ev;
    private IViewer egv;
    private IViewer cv;
    private JPopupMenu menu;
    private JPanel pane;
    JRadioButton rb1;
    JRadioButton rb2;
    JRadioButton rb3;
    JRadioButton rb4;
    JRadioButton rb5;
    JButton storeRows;
    JButton storeAll;
    JComboBox viewerCB;
    private JScrollPane bottomTablePane;
    private JScrollPane topTablePane;
    private ClusterRepository repository;
    private ClusterTableModel model;
    private IFramework framework;
    private boolean geneClusterTable;

    public ClusterTable(ClusterRepository rep, IFramework framework) {
        super(new GridBagLayout());
        this.framework = framework;
        this.repository = rep;
        this.geneClusterTable = rep.isGeneClusterRepository();
        this.setBackground(Color.white);
        MenuListener menuListener = new MenuListener();
        this.initializeTable();
        this.initializeMenu(menuListener);
    }

    private void initializeTable() {
        Vector<String> headerVector = new Vector<String>();
        headerVector.add("Serial #");
        headerVector.add("Source");
        headerVector.add("Factor");
        headerVector.add("Cluster Node");
        headerVector.add("Cluster Label");
        headerVector.add("Remarks");
        headerVector.add("Size");
        headerVector.add("Color");
        headerVector.add("Show Color");
        Vector<Object> dataVector = new Vector<Object>();
        int row = 0;
        for (int i = 0; i < this.repository.size(); ++i) {
            ClusterList list = this.repository.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                Cluster cluster = list.getClusterAt(j);
                dataVector.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
                dataVector.add(new JLabel(String.valueOf(cluster.getSource())));
                dataVector.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
                dataVector.add(new JLabel(String.valueOf(cluster.getClusterID())));
                dataVector.add(cluster.getClusterLabel());
                dataVector.add(cluster.getClusterDescription());
                dataVector.add(new JLabel(String.valueOf(cluster.getSize())));
                dataVector.add(cluster.getClusterColor());
                dataVector.add(new Boolean(cluster.showColor()));
                ++row;
            }
        }
        this.model = new ClusterTableModel(headerVector, dataVector);
        this.tableOfClusters = new JTable(this.model);
        ClusterCellRenderer renderer = new ClusterCellRenderer();
        this.tableOfClusters.setDefaultRenderer(Color.class, renderer);
        this.tableOfClusters.setDefaultRenderer(JLabel.class, renderer);
        this.tableOfClusters.setPreferredScrollableViewportSize(new Dimension(450, 175));
        this.tableOfClusters.addMouseListener(new TableListener());
        this.tableOfClusters.addKeyListener(new TableListener());
        this.tableOfClusters.setBackground(Color.white);
        this.tableOfClusters.setRowHeight(this.tableOfClusters.getRowHeight() + 10);
        this.tableOfClusters.setRowSelectionAllowed(true);
        this.tableOfClusters.getSelectionModel().setSelectionMode(2);
        this.setInitialColumnWidths();
        this.ctv = new ClusterTableViewer(this.framework);
        this.ev = new ExperimentViewer(this.framework);
        this.egv = new CentroidViewer(this.framework, 1);
        this.cv = new CentroidViewer(this.framework, 0);
        String[] viewerStrings = this.geneClusterTable ? new String[]{"Table", "Expression Image", "Expression Graph", "Centroid Graph", "Venn Diagram"} : new String[]{"Table", "Expression Image", "Expression Graph", "Centroid Graph", "Venn Diagram", "Expression Chart"};
        this.viewerCB = new JComboBox<String>(viewerStrings);
        this.viewerCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ClusterTable.this.geneClusterTable) {
                    switch (ClusterTable.this.viewerCB.getSelectedIndex()) {
                        case 0: {
                            ClusterTable.this.iViewer = ClusterTable.this.ctv;
                            ClusterTable.this.tableOfElements = ((ClusterTableViewer)ClusterTable.this.iViewer).getTable();
                            ClusterTable.this.tableOfElements.setAutoResizeMode(0);
                            ClusterTable.this.bottomTablePane.setViewportView(ClusterTable.this.tableOfElements);
                            break;
                        }
                        case 1: {
                            ClusterTable.this.iViewer = ClusterTable.this.ev;
                            ClusterTable.this.bottomTablePane.setViewportView(((ExperimentViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((ExperimentViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            break;
                        }
                        case 2: {
                            ClusterTable.this.iViewer = ClusterTable.this.egv;
                            ClusterTable.this.bottomTablePane.setViewportView(((CentroidViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((CentroidViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            break;
                        }
                        case 3: {
                            ClusterTable.this.iViewer = ClusterTable.this.cv;
                            ClusterTable.this.bottomTablePane.setViewportView(((CentroidViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((CentroidViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            break;
                        }
                        case 4: {
                            ClusterTable.this.iViewer = (IViewer)new VennDiagramViewer(ClusterTable.this.framework, false, ClusterTable.this.getSelectedClusters());
                            ClusterTable.this.bottomTablePane.setViewportView(((VennDiagramViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((VennDiagramViewer)ClusterTable.this.iViewer).getHeaderComponent());
                        }
                    }
                } else {
                    switch (ClusterTable.this.viewerCB.getSelectedIndex()) {
                        case 0: {
                            ClusterTable.this.iViewer = (IViewer)new ExperimentClusterTableViewer(ClusterTable.this.framework);
                            ClusterTable.this.tableOfElements = ((ExperimentClusterTableViewer)ClusterTable.this.iViewer).getTable();
                            ClusterTable.this.tableOfElements.setAutoResizeMode(0);
                            ClusterTable.this.bottomTablePane.setViewportView(ClusterTable.this.tableOfElements);
                            break;
                        }
                        case 1: {
                            ClusterTable.this.iViewer = (IViewer)new ExperimentClusterViewer(ClusterTable.this.framework);
                            ClusterTable.this.bottomTablePane.setViewportView(((ExperimentClusterViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((ExperimentClusterViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            break;
                        }
                        case 2: {
                            ClusterTable.this.iViewer = (IViewer)new ExperimentClusterCentroidViewer(ClusterTable.this.framework, 1);
                            ClusterTable.this.bottomTablePane.setViewportView(((ExperimentClusterCentroidViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((ExperimentClusterCentroidViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            break;
                        }
                        case 3: {
                            ClusterTable.this.iViewer = (IViewer)new ExperimentClusterCentroidViewer(ClusterTable.this.framework, 0);
                            ClusterTable.this.bottomTablePane.setViewportView(((ExperimentClusterCentroidViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((ExperimentClusterCentroidViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            break;
                        }
                        case 4: {
                            ClusterTable.this.iViewer = (IViewer)new VennDiagramViewer(ClusterTable.this.framework, true, ClusterTable.this.getSelectedClusters());
                            ClusterTable.this.bottomTablePane.setViewportView(((VennDiagramViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((VennDiagramViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            break;
                        }
                        case 5: {
                            ClusterTable.this.iViewer = (IViewer)new BoxChartViewer(ClusterTable.this.framework, ClusterTable.this.getSelectedClusters());
                            ClusterTable.this.bottomTablePane.setViewportView(((BoxChartViewer)ClusterTable.this.iViewer).getContentComponent());
                            ClusterTable.this.bottomTablePane.setColumnHeaderView(((BoxChartViewer)ClusterTable.this.iViewer).getHeaderComponent());
                            ((BoxChartViewer)ClusterTable.this.iViewer).setScrollBar(ClusterTable.this.bottomTablePane.getVerticalScrollBar());
                        }
                    }
                }
                if (ClusterTable.this.viewerCB.getSelectedIndex() == 0) {
                    if (ClusterTable.this.tableOfElements.getColumnCount() < 11) {
                        for (int i = 0; i < ClusterTable.this.tableOfElements.getColumnCount(); ++i) {
                            ClusterTable.this.tableOfElements.getColumnModel().getColumn(i).setPreferredWidth(800 / ClusterTable.this.tableOfElements.getColumnCount());
                            ClusterTable.this.tableOfElements.getColumnModel().getColumn(i).setWidth(800 / ClusterTable.this.tableOfElements.getColumnCount());
                        }
                    }
                    ClusterTable.this.tableOfElements.addMouseListener(new BottomListener());
                }
                ClusterTable.this.bottomTablePane.updateUI();
                ClusterTable.this.bottomTablePane.repaint();
                ClusterTable.this.bottomTablePane.validate();
                ClusterTable.this.updateBottomViewer();
            }
        });
        this.model.addTableModelListener(new TableListener());
        this.tableOfClusters.setRowHeight(30);
        if (this.pane == null) {
            this.pane = new JPanel();
        }
        this.pane.setLayout(new GridBagLayout());
        this.topTablePane = new JScrollPane(this.tableOfClusters);
        if (this.geneClusterTable) {
            switch (this.viewerCB.getSelectedIndex()) {
                case 0: {
                    this.iViewer = new ClusterTableViewer(this.framework);
                    this.tableOfElements = ((ClusterTableViewer)this.iViewer).getTable();
                    this.tableOfElements.setAutoResizeMode(0);
                    this.bottomTablePane = new JScrollPane(this.tableOfElements);
                    break;
                }
                case 1: {
                    this.iViewer = new ExperimentViewer(this.framework);
                    this.bottomTablePane = new JScrollPane(((ExperimentViewer)this.iViewer).getContentComponent());
                    this.bottomTablePane.setColumnHeaderView(((ExperimentViewer)this.iViewer).getHeaderComponent());
                    break;
                }
                case 2: {
                    this.iViewer = new CentroidViewer(this.framework, 1);
                    this.bottomTablePane = new JScrollPane(((CentroidViewer)this.iViewer).getContentComponent());
                    this.bottomTablePane.setColumnHeaderView(((CentroidViewer)this.iViewer).getHeaderComponent());
                    break;
                }
                case 3: {
                    this.iViewer = new CentroidViewer(this.framework, 0);
                    this.bottomTablePane = new JScrollPane(((CentroidViewer)this.iViewer).getContentComponent());
                    this.bottomTablePane.setColumnHeaderView(((CentroidViewer)this.iViewer).getHeaderComponent());
                }
            }
            this.bottomTablePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Genes", 0, 0, new Font("Dialog", 1, 12), Color.black));
        } else {
            switch (this.viewerCB.getSelectedIndex()) {
                case 0: {
                    this.iViewer = new ExperimentClusterTableViewer(this.framework);
                    this.tableOfElements = ((ExperimentClusterTableViewer)this.iViewer).getTable();
                    this.tableOfElements.setAutoResizeMode(0);
                    this.bottomTablePane = new JScrollPane(this.tableOfElements);
                    break;
                }
                case 1: {
                    this.iViewer = new ExperimentClusterViewer(this.framework);
                    this.bottomTablePane = new JScrollPane(((ExperimentClusterViewer)this.iViewer).getContentComponent());
                    this.bottomTablePane.setColumnHeaderView(((ExperimentClusterViewer)this.iViewer).getHeaderComponent());
                    break;
                }
                case 2: {
                    this.iViewer = new ExperimentClusterCentroidViewer(this.framework, 1);
                    this.bottomTablePane = new JScrollPane(((ExperimentClusterCentroidViewer)this.iViewer).getContentComponent());
                    this.bottomTablePane.setColumnHeaderView(((ExperimentClusterCentroidViewer)this.iViewer).getHeaderComponent());
                    break;
                }
                case 3: {
                    this.iViewer = new ExperimentClusterCentroidViewer(this.framework, 0);
                    this.bottomTablePane = new JScrollPane(((ExperimentClusterCentroidViewer)this.iViewer).getContentComponent());
                    this.bottomTablePane.setColumnHeaderView(((ExperimentClusterCentroidViewer)this.iViewer).getHeaderComponent());
                }
            }
            this.bottomTablePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Samples", 0, 0, new Font("Dialog", 1, 12), Color.black));
        }
        if (this.viewerCB.getSelectedIndex() == 0) {
            if (this.tableOfElements.getColumnCount() < 11) {
                for (int i = 0; i < this.tableOfElements.getColumnCount(); ++i) {
                    this.tableOfElements.getColumnModel().getColumn(i).setPreferredWidth(800 / this.tableOfElements.getColumnCount());
                    this.tableOfElements.getColumnModel().getColumn(i).setWidth(800 / this.tableOfElements.getColumnCount());
                }
            }
            this.tableOfElements.addMouseListener(new BottomListener());
        }
        this.topTablePane.setMaximumSize(new Dimension(800, 150));
        this.topTablePane.setPreferredSize(new Dimension(800, 150));
        this.topTablePane.setMinimumSize(new Dimension(800, 150));
        this.topTablePane.validate();
        this.bottomTablePane.setBackground(Color.white);
        this.bottomTablePane.setMaximumSize(new Dimension(800, 150));
        this.bottomTablePane.setPreferredSize(new Dimension(800, 150));
        this.bottomTablePane.setMinimumSize(new Dimension(800, 150));
        this.bottomTablePane.validate();
        this.rb1 = new JRadioButton("Show all");
        this.rb2 = new JRadioButton("Show selected");
        this.rb3 = new JRadioButton("Show intersect");
        this.rb4 = new JRadioButton("Show except");
        this.rb5 = new JRadioButton("Show excluded");
        this.storeAll = new JButton("Store Table as Cluster");
        this.storeRows = new JButton("Store Rows as Cluster");
        JButton autoCluster = new JButton("Auto-Cluster by Factor");
        JButton listCluster = new JButton("Cluster by List Import");
        JButton binCluster = new JButton("Cluster by Binning");
        this.storeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ClusterTable.this.geneClusterTable) {
                    switch (ClusterTable.this.viewerCB.getSelectedIndex()) {
                        case 0: {
                            ((ClusterTableViewer)ClusterTable.this.iViewer).storeCluster();
                            break;
                        }
                        case 1: {
                            ((ExperimentViewer)ClusterTable.this.iViewer).storeCluster();
                            break;
                        }
                        case 2: {
                            ((CentroidViewer)ClusterTable.this.iViewer).storeCluster();
                        }
                    }
                } else {
                    switch (ClusterTable.this.viewerCB.getSelectedIndex()) {
                        case 0: {
                            ((ExperimentClusterTableViewer)ClusterTable.this.iViewer).storeCluster();
                            break;
                        }
                        case 1: {
                            ((ExperimentClusterViewer)ClusterTable.this.iViewer).storeCluster();
                        }
                    }
                }
                ClusterTable.this.updateClusterTable();
            }
        });
        this.storeRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ClusterTable.this.geneClusterTable) {
                    switch (ClusterTable.this.viewerCB.getSelectedIndex()) {
                        case 0: {
                            ((ClusterTableViewer)ClusterTable.this.iViewer).storeSelectedRowsAsCluster();
                            break;
                        }
                        case 1: {
                            ((ExperimentViewer)ClusterTable.this.iViewer).storeCluster();
                            break;
                        }
                        case 2: {
                            ((CentroidViewer)ClusterTable.this.iViewer).storeCluster();
                            break;
                        }
                        case 3: {
                            ((CentroidViewer)ClusterTable.this.iViewer).storeCluster();
                        }
                    }
                } else {
                    switch (ClusterTable.this.viewerCB.getSelectedIndex()) {
                        case 0: {
                            ((ExperimentClusterTableViewer)ClusterTable.this.iViewer).storeSelectedRowsAsCluster();
                            break;
                        }
                        case 1: {
                            ((ExperimentClusterViewer)ClusterTable.this.iViewer).storeCluster();
                            break;
                        }
                        case 2: {
                            ((ExperimentClusterCentroidViewer)ClusterTable.this.iViewer).storeCluster();
                            break;
                        }
                        case 3: {
                            ((ExperimentClusterCentroidViewer)ClusterTable.this.iViewer).storeCluster();
                        }
                    }
                }
                ClusterTable.this.updateClusterTable();
            }
        });
        autoCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ClusterTable.this.repository.autoCreateClusters();
                ClusterTable.this.updateClusterTable();
            }
        });
        listCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ClusterTable.this.repository.createClusterFromList();
                ClusterTable.this.updateClusterTable();
            }
        });
        binCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ClusterTable.this.repository.binCreateClusters();
                ClusterTable.this.updateClusterTable();
            }
        });
        this.rb1.setSelected(true);
        this.rb2.setSelected(false);
        this.rb3.setSelected(false);
        this.rb4.setSelected(false);
        this.rb5.setSelected(false);
        this.rb1.setBackground(Color.white);
        this.rb2.setBackground(Color.white);
        this.rb3.setBackground(Color.white);
        this.rb4.setBackground(Color.white);
        this.rb5.setBackground(Color.white);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rb1);
        bg.add(this.rb2);
        bg.add(this.rb3);
        bg.add(this.rb4);
        bg.add(this.rb5);
        RBListener rblistener = new RBListener();
        this.rb1.addActionListener(rblistener);
        this.rb2.addActionListener(rblistener);
        this.rb3.addActionListener(rblistener);
        this.rb4.addActionListener(rblistener);
        this.rb5.addActionListener(rblistener);
        JPanel rbPanel = new JPanel();
        rbPanel.setLayout(new GridBagLayout());
        rbPanel.setBackground(Color.white);
        rbPanel.add((Component)this.viewerCB, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rbPanel.add((Component)this.rb1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rbPanel.add((Component)this.rb2, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rbPanel.add((Component)this.rb5, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rbPanel.add((Component)this.rb3, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        rbPanel.add((Component)this.rb4, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.setBackground(Color.white);
        buttonPanel.add((Component)this.storeRows, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.storeAll, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)new JSeparator(1), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        buttonPanel.add((Component)autoCluster, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)listCluster, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)binCluster, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.add((Component)rbPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanel.add((Component)this.bottomTablePane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanel.add((Component)buttonPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JSplitPane splitPane = new JSplitPane(0, this.topTablePane, bottomPanel);
        this.pane.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.validate();
        this.pane.setBackground(Color.white);
        this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateBottomViewer();
        this.validate();
    }

    private void updateClusterTable() {
        Vector<String> headerVector = new Vector<String>();
        headerVector.add("Serial #");
        headerVector.add("Source");
        headerVector.add("Factor");
        headerVector.add("Cluster Node");
        headerVector.add("Cluster Label");
        headerVector.add("Remarks");
        headerVector.add("Size");
        headerVector.add("Color");
        headerVector.add("Show Color");
        Vector<Object> dataVector = new Vector<Object>();
        int row = 0;
        for (int i = 0; i < this.repository.size(); ++i) {
            ClusterList list = this.repository.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                Cluster cluster = list.getClusterAt(j);
                dataVector.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
                dataVector.add(new JLabel(String.valueOf(cluster.getSource())));
                dataVector.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
                dataVector.add(new JLabel(String.valueOf(cluster.getClusterID())));
                dataVector.add(cluster.getClusterLabel());
                dataVector.add(cluster.getClusterDescription());
                dataVector.add(new JLabel(String.valueOf(cluster.getSize())));
                dataVector.add(cluster.getClusterColor());
                dataVector.add(new Boolean(cluster.showColor()));
                ++row;
            }
        }
        this.model = new ClusterTableModel(headerVector, dataVector);
        this.tableOfClusters.setModel(this.model);
        ClusterCellRenderer renderer = new ClusterCellRenderer();
        this.tableOfClusters.setDefaultRenderer(Color.class, renderer);
        this.tableOfClusters.setDefaultRenderer(JLabel.class, renderer);
        this.tableOfClusters.setPreferredScrollableViewportSize(new Dimension(450, 175));
        this.tableOfClusters.setBackground(Color.white);
        this.tableOfClusters.setRowHeight(this.tableOfClusters.getRowHeight() + 10);
        this.tableOfClusters.setRowSelectionAllowed(true);
        this.tableOfClusters.getSelectionModel().setSelectionMode(2);
        this.setInitialColumnWidths();
        this.model.sortBy("Serial #");
        this.tableOfClusters.setRowHeight(30);
        this.tableOfClusters.updateUI();
        this.tableOfClusters.revalidate();
    }

    private void updateBottomViewer() {
        if (this.repository.getTotalClusters() != 0) {
            if (this.geneClusterTable) {
                this.upDateGeneViewer();
            } else {
                this.upDateSampleViewer();
            }
        }
        this.setRadioButtons();
        this.setButtons();
    }

    private void upDateGeneViewer() {
        if (this.viewerCB.getSelectedIndex() == 4) {
            ((VennDiagramViewer)this.iViewer).setClusters(this.getSelectedClusters());
            this.bottomTablePane.setViewportView(((VennDiagramViewer)this.iViewer).getContentComponent());
            ((VennDiagramViewer)this.iViewer).repaint();
            return;
        }
        Object mat = new int[1][];
        if (this.rb1.isSelected()) {
            mat = new int[1][this.iViewer.getExperiment().getNumberOfGenes()];
            for (int i = 0; i < mat[0].length; ++i) {
                mat[0][i] = this.iViewer.getExperiment().getGeneIndexMappedToData(i);
            }
        } else if (this.tableOfClusters.getSelectedRowCount() == 0) {
            mat = new int[1][0];
        } else if (this.rb2.isSelected()) {
            int i;
            ArrayList<Integer> arl = new ArrayList<Integer>();
            for (i = 0; i < this.getSelectedClusters().length; ++i) {
                for (int j = 0; j < this.getSelectedClusters()[i].getIndices().length; ++j) {
                    if (arl.contains(this.getSelectedClusters()[i].getIndices()[j])) continue;
                    arl.add(this.getSelectedClusters()[i].getIndices()[j]);
                }
            }
            mat = new int[1][arl.size()];
            for (i = 0; i < arl.size(); ++i) {
                mat[0][i] = (Integer)arl.get(i);
            }
        } else if (this.rb3.isSelected()) {
            if (this.tableOfClusters.getSelectedRowCount() == 1) {
                mat = new int[1][0];
            } else {
                int i;
                ArrayList<Integer> arl = new ArrayList<Integer>();
                for (i = 0; i < this.getSelectedClusters()[0].getIndices().length; ++i) {
                    boolean inAll = true;
                    for (int j = 1; j < this.getSelectedClusters().length; ++j) {
                        for (int k = 0; k < this.getSelectedClusters()[j].getIndices().length; ++k) {
                            inAll = false;
                            if (this.getSelectedClusters()[0].getIndices()[i] != this.getSelectedClusters()[j].getIndices()[k]) continue;
                            inAll = true;
                            break;
                        }
                        if (!inAll) break;
                    }
                    if (!inAll) continue;
                    arl.add(this.getSelectedClusters()[0].getIndices()[i]);
                }
                mat = new int[1][arl.size()];
                for (i = 0; i < arl.size(); ++i) {
                    mat[0][i] = (Integer)arl.get(i);
                }
            }
        } else if (this.rb4.isSelected()) {
            ArrayList<Integer> arl = new ArrayList<Integer>();
            for (int h = 0; h < this.getSelectedClusters().length; ++h) {
                for (int i = 0; i < this.getSelectedClusters()[h].getIndices().length; ++i) {
                    boolean inNone = false;
                    for (int j = 0; j < this.getSelectedClusters().length; ++j) {
                        if (j == h) continue;
                        for (int k = 0; k < this.getSelectedClusters()[j].getIndices().length; ++k) {
                            inNone = true;
                            if (this.getSelectedClusters()[h].getIndices()[i] != this.getSelectedClusters()[j].getIndices()[k]) continue;
                            inNone = false;
                            break;
                        }
                        if (!inNone) break;
                    }
                    if (!inNone) continue;
                    arl.add(this.getSelectedClusters()[h].getIndices()[i]);
                }
            }
            mat = new int[1][arl.size()];
            for (int i = 0; i < arl.size(); ++i) {
                mat[0][i] = (Integer)arl.get(i);
            }
        } else if (this.rb5.isSelected()) {
            ArrayList<Integer> arl = new ArrayList<Integer>();
            for (int i = 0; i < this.getSelectedClusters().length; ++i) {
                for (int j = 0; j < this.getSelectedClusters()[i].getIndices().length; ++j) {
                    if (arl.contains(this.getSelectedClusters()[i].getIndices()[j])) continue;
                    arl.add(this.getSelectedClusters()[i].getIndices()[j]);
                }
            }
            mat = new int[1][this.iViewer.getExperiment().getNumberOfGenes() - arl.size()];
            int count = 0;
            for (int i = 0; i < this.iViewer.getExperiment().getNumberOfGenes(); ++i) {
                if (arl.contains(this.iViewer.getExperiment().getGeneIndexMappedToData(i))) continue;
                mat[0][count] = this.iViewer.getExperiment().getGeneIndexMappedToData(i);
                ++count;
            }
        }
        switch (this.viewerCB.getSelectedIndex()) {
            case 0: {
                ((ClusterTableViewer)this.iViewer).setTableClusters((int[][])mat);
                this.tableOfElements = ((ClusterTableViewer)this.iViewer).getTable();
                this.tableOfElements.repaint();
                this.tableOfElements.revalidate();
                break;
            }
            case 1: {
                ((ExperimentViewer)this.iViewer).setClusters((int[][])mat);
                ((ExperimentHeader)((ExperimentViewer)this.iViewer).getHeaderComponent()).setClusters((int[][])mat);
                this.bottomTablePane.setViewportView(((ExperimentViewer)this.iViewer).getContentComponent());
                this.bottomTablePane.setColumnHeaderView(((ExperimentViewer)this.iViewer).getHeaderComponent());
                break;
            }
            case 2: {
                ((CentroidViewer)this.iViewer).setClusters((int[][])mat);
                this.bottomTablePane.setViewportView(((CentroidViewer)this.iViewer).getContentComponent());
                this.bottomTablePane.setColumnHeaderView(((CentroidViewer)this.iViewer).getHeaderComponent());
                break;
            }
            case 3: {
                ((CentroidViewer)this.iViewer).setClusters((int[][])mat);
                this.bottomTablePane.setViewportView(((CentroidViewer)this.iViewer).getContentComponent());
                this.bottomTablePane.setColumnHeaderView(((CentroidViewer)this.iViewer).getHeaderComponent());
                break;
            }
            case 4: {
                ((VennDiagramViewer)this.iViewer).setClusters(this.getSelectedClusters());
                this.bottomTablePane.setViewportView(((VennDiagramViewer)this.iViewer).getContentComponent());
                ((VennDiagramViewer)this.iViewer).repaint();
                break;
            }
            case 5: {
                ((BoxChartViewer)this.iViewer).setClusters(this.getSelectedClusters());
                this.bottomTablePane.setViewportView(((BoxChartViewer)this.iViewer).getContentComponent());
                ((BoxChartViewer)this.iViewer).repaint();
            }
        }
    }

    private void upDateSampleViewer() {
        if (this.viewerCB.getSelectedIndex() == 4) {
            ((VennDiagramViewer)this.iViewer).setClusters(this.getSelectedClusters());
            this.bottomTablePane.setViewportView(((VennDiagramViewer)this.iViewer).getContentComponent());
            ((VennDiagramViewer)this.iViewer).repaint();
            return;
        }
        Object mat = new int[1][];
        if (this.rb1.isSelected()) {
            mat = new int[1][this.iViewer.getExperiment().getNumberOfSamples()];
            for (int i = 0; i < mat[0].length; ++i) {
                mat[0][i] = i;
            }
        } else if (this.tableOfClusters.getSelectedRowCount() == 0) {
            mat = new int[1][0];
        } else if (this.rb2.isSelected()) {
            int i;
            ArrayList<Integer> arl = new ArrayList<Integer>();
            for (i = 0; i < this.getSelectedClusters().length; ++i) {
                for (int j = 0; j < this.getSelectedClusters()[i].getIndices().length; ++j) {
                    if (arl.contains(this.getSelectedClusters()[i].getIndices()[j])) continue;
                    arl.add(this.getSelectedClusters()[i].getIndices()[j]);
                }
            }
            mat = new int[1][arl.size()];
            for (i = 0; i < arl.size(); ++i) {
                mat[0][i] = (Integer)arl.get(i);
            }
        } else if (this.rb3.isSelected()) {
            if (this.tableOfClusters.getSelectedRowCount() == 1) {
                mat = new int[1][0];
            } else {
                int i;
                ArrayList<Integer> arl = new ArrayList<Integer>();
                for (i = 0; i < this.getSelectedClusters()[0].getIndices().length; ++i) {
                    boolean inAll = true;
                    for (int j = 1; j < this.getSelectedClusters().length; ++j) {
                        for (int k = 0; k < this.getSelectedClusters()[j].getIndices().length; ++k) {
                            inAll = false;
                            if (this.getSelectedClusters()[0].getIndices()[i] != this.getSelectedClusters()[j].getIndices()[k]) continue;
                            inAll = true;
                            break;
                        }
                        if (!inAll) break;
                    }
                    if (!inAll) continue;
                    arl.add(this.getSelectedClusters()[0].getIndices()[i]);
                }
                mat = new int[1][arl.size()];
                for (i = 0; i < arl.size(); ++i) {
                    mat[0][i] = (Integer)arl.get(i);
                }
            }
        } else if (this.rb4.isSelected()) {
            ArrayList<Integer> arl = new ArrayList<Integer>();
            for (int h = 0; h < this.getSelectedClusters().length; ++h) {
                for (int i = 0; i < this.getSelectedClusters()[h].getIndices().length; ++i) {
                    boolean inNone = false;
                    for (int j = 0; j < this.getSelectedClusters().length; ++j) {
                        if (j == h) continue;
                        for (int k = 0; k < this.getSelectedClusters()[j].getIndices().length; ++k) {
                            inNone = true;
                            if (this.getSelectedClusters()[h].getIndices()[i] != this.getSelectedClusters()[j].getIndices()[k]) continue;
                            inNone = false;
                            break;
                        }
                        if (!inNone) break;
                    }
                    if (!inNone) continue;
                    arl.add(this.getSelectedClusters()[h].getIndices()[i]);
                }
            }
            mat = new int[1][arl.size()];
            for (int i = 0; i < arl.size(); ++i) {
                mat[0][i] = (Integer)arl.get(i);
            }
        } else if (this.rb5.isSelected()) {
            ArrayList<Integer> arl = new ArrayList<Integer>();
            for (int i = 0; i < this.getSelectedClusters().length; ++i) {
                for (int j = 0; j < this.getSelectedClusters()[i].getIndices().length; ++j) {
                    if (arl.contains(this.getSelectedClusters()[i].getIndices()[j])) continue;
                    arl.add(this.getSelectedClusters()[i].getIndices()[j]);
                }
            }
            mat = new int[1][this.iViewer.getExperiment().getNumberOfSamples() - arl.size()];
            int count = 0;
            for (int i = 0; i < this.iViewer.getExperiment().getNumberOfSamples(); ++i) {
                if (arl.contains(i)) continue;
                mat[0][count] = i;
                ++count;
            }
        }
        switch (this.viewerCB.getSelectedIndex()) {
            case 0: {
                ((ExperimentClusterTableViewer)this.iViewer).setTableClusters((int[][])mat);
                this.tableOfElements = ((ExperimentClusterTableViewer)this.iViewer).getTable();
                this.tableOfElements.updateUI();
                break;
            }
            case 1: {
                ((ExperimentClusterViewer)this.iViewer).setClusters((int[][])mat);
                ((ExperimentClusterHeader)((ExperimentClusterViewer)this.iViewer).getHeaderComponent()).setClusters((int[][])mat);
                this.bottomTablePane.setViewportView(((ExperimentClusterViewer)this.iViewer).getContentComponent());
                this.bottomTablePane.setColumnHeaderView(((ExperimentClusterViewer)this.iViewer).getHeaderComponent());
                break;
            }
            case 2: {
                ((ExperimentClusterCentroidViewer)this.iViewer).setClusters((int[][])mat);
                this.bottomTablePane.setViewportView(((ExperimentClusterCentroidViewer)this.iViewer).getContentComponent());
                this.bottomTablePane.setColumnHeaderView(((ExperimentClusterCentroidViewer)this.iViewer).getHeaderComponent());
                break;
            }
            case 3: {
                ((ExperimentClusterCentroidViewer)this.iViewer).setClusters((int[][])mat);
                this.bottomTablePane.setViewportView(((ExperimentClusterCentroidViewer)this.iViewer).getContentComponent());
                this.bottomTablePane.setColumnHeaderView(((ExperimentClusterCentroidViewer)this.iViewer).getHeaderComponent());
                break;
            }
            case 4: {
                ((VennDiagramViewer)this.iViewer).setClusters(this.getSelectedClusters());
                this.bottomTablePane.setViewportView(((VennDiagramViewer)this.iViewer).getContentComponent());
                ((VennDiagramViewer)this.iViewer).repaint();
                break;
            }
            case 5: {
                ((BoxChartViewer)this.iViewer).setClusters(this.getSelectedClusters());
                this.bottomTablePane.setViewportView(((BoxChartViewer)this.iViewer).getContentComponent());
                ((BoxChartViewer)this.iViewer).repaint();
            }
        }
    }

    private void setButtons() {
        this.storeRows.setEnabled(this.tableOfElements.getSelectedRowCount() > 0 && this.viewerCB.getSelectedIndex() == 0);
        this.storeAll.setEnabled((this.tableOfElements.getRowCount() != 0 || this.viewerCB.getSelectedIndex() != 0) && this.viewerCB.getSelectedIndex() != 4);
    }

    private void setRadioButtons() {
        if (this.viewerCB.getSelectedIndex() == 4 || this.viewerCB.getSelectedIndex() == 5) {
            this.rb1.setEnabled(false);
            this.rb2.setEnabled(false);
            this.rb3.setEnabled(false);
            this.rb4.setEnabled(false);
            this.rb5.setEnabled(false);
            this.rb2.setSelected(true);
        } else {
            this.rb1.setEnabled(true);
            if (this.repository.getTotalClusters() == 0) {
                this.rb2.setEnabled(false);
                this.rb3.setEnabled(false);
                this.rb4.setEnabled(false);
                this.rb5.setEnabled(false);
            } else {
                this.rb2.setEnabled(true);
                this.rb5.setEnabled(true);
                if (this.tableOfClusters.getSelectedRowCount() < 2) {
                    this.rb3.setEnabled(false);
                    this.rb4.setEnabled(false);
                } else {
                    this.rb3.setEnabled(true);
                    this.rb4.setEnabled(true);
                }
            }
        }
    }

    public void removeRow(int row) {
        this.model.removeRow(row);
    }

    public void addCluster(Cluster cluster) {
        Vector<Object> dataVector = new Vector<Object>();
        dataVector.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
        dataVector.add(new JLabel(String.valueOf(cluster.getSource())));
        dataVector.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
        dataVector.add(new JLabel(String.valueOf(cluster.getClusterID())));
        dataVector.add(cluster.getClusterLabel());
        dataVector.add(cluster.getClusterDescription());
        dataVector.add(new JLabel(String.valueOf(cluster.getSize())));
        dataVector.add(cluster.getClusterColor());
        dataVector.add(new Boolean(cluster.showColor()));
        this.model.addRow(dataVector);
    }

    private void initializeMenu(MenuListener listener) {
        this.menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Modify Attributes", GUIFactory.getIcon((String)"empty16.gif"));
        item.setActionCommand("modify-command");
        item.addActionListener(listener);
        this.menu.add(item);
        this.menu.addSeparator();
        this.menu.add(this.initializeOpenMenu(listener));
        this.menu.addSeparator();
        this.menu.add(this.initializeClusterOperationsMenu(listener));
        this.menu.addSeparator();
        this.menu.add(this.initializeSortMenu(listener));
        this.menu.addSeparator();
        this.menu.add(this.initializeHideMenu(listener));
        this.menu.addSeparator();
        item = new JMenuItem("Delete Selected", GUIFactory.getIcon((String)"delete16.gif"));
        item.setActionCommand("delete-command");
        item.addActionListener(listener);
        this.menu.add(item);
        item = new JMenuItem("Delete All", GUIFactory.getIcon((String)"delete16.gif"));
        item.setActionCommand("delete-all-command");
        item.addActionListener(listener);
        this.menu.add(item);
        this.menu.addSeparator();
        item = new JMenuItem("Save Cluster", GUIFactory.getIcon((String)"save16.gif"));
        item.setActionCommand("save-cluster-command");
        item.addActionListener(listener);
        this.menu.add(item);
        this.menu.addSeparator();
        item = this.repository.isGeneClusterRepository() ? new JMenuItem("Import Gene List", GUIFactory.getIcon((String)"empty.gif")) : new JMenuItem("Import Experiment List", GUIFactory.getIcon((String)"empty.gif"));
        item.setActionCommand("import-list-command");
        item.addActionListener(listener);
        this.menu.add(item);
        if (this.repository.isGeneClusterRepository()) {
            this.menu.addSeparator();
            item = new JMenuItem("Submit Gene List (External Repository)", GUIFactory.getIcon((String)"empty.gif"));
            item.setActionCommand("submit-list-command");
            item.addActionListener(listener);
            this.menu.add(item);
            item = new JMenuItem("Broadcast Clusters to Gaggle", GUIFactory.getIcon((String)"empty.gif"));
            item.setActionCommand("submit-broadcastcluster-command");
            item.addActionListener(listener);
            this.menu.add(item);
        }
    }

    private JMenu initializeOpenMenu(MenuListener listener) {
        JMenu menu = new JMenu("Open/Launch");
        menu.setIcon(GUIFactory.getIcon((String)"open_launch.gif"));
        JMenuItem item = new JMenuItem("Open Cluster Viewer", GUIFactory.getIcon((String)"Open16.gif"));
        item.setActionCommand("go-to-origin-command");
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Launch MeV Session", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        item.setActionCommand("launch-new-command");
        item.addActionListener(listener);
        menu.add(item);
        return menu;
    }

    private JMenu initializeHideMenu(MenuListener listener) {
        JMenu menu = new JMenu("Hide Columns");
        menu.setIcon(GUIFactory.getIcon((String)"empty16.gif"));
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.model.getColumnName(i));
            item.setActionCommand("hide-command");
            item.setSelected(false);
            item.addActionListener(listener);
            menu.add(item);
        }
        menu.addSeparator();
        JMenuItem showAll = new JMenuItem("Show All");
        showAll.setActionCommand("show-all-command");
        showAll.addActionListener(listener);
        menu.add(showAll);
        return menu;
    }

    private JMenu initializeSortMenu(MenuListener listener) {
        JMenu menu = new JMenu("Sort");
        menu.setIcon(GUIFactory.getIcon((String)"empty16.gif"));
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < this.model.getColumnCount() - 1; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.model.getColumnName(i));
            item.setActionCommand("sort-command");
            if (this.model.getColumnName(i).equals("Serial #")) {
                item.setSelected(true);
            } else {
                item.setSelected(false);
            }
            bg.add(item);
            item.addActionListener(listener);
            menu.add(item);
        }
        return menu;
    }

    private JMenu initializeClusterOperationsMenu(MenuListener listener) {
        JMenu menu = new JMenu("Cluster Operations");
        menu.setIcon(GUIFactory.getIcon((String)"cluster_operations.gif"));
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < 3; ++i) {
            JMenuItem item = new JMenuItem();
            if (i == 0) {
                item.setText("Intersection");
                item.setIcon(GUIFactory.getIcon((String)"intersection.gif"));
            } else if (i == 1) {
                item.setText("Union");
                item.setIcon(GUIFactory.getIcon((String)"union.gif"));
            } else if (i == 2) {
                item.setText("XOR");
                item.setIcon(GUIFactory.getIcon((String)"xor.gif"));
            }
            item.setActionCommand("cluster-operations-command");
            bg.add(item);
            item.addActionListener(listener);
            menu.add(item);
        }
        return menu;
    }

    private void setInitialColumnWidths() {
        String[] columnNames = this.model.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            this.setColumnWidth(columnNames[i]);
        }
    }

    private void setColumnWidth(String headerName) {
        int width = 10;
        if (headerName.equals("Serial #")) {
            TableColumn column = this.tableOfClusters.getColumn(headerName);
            width = 50;
            column.setWidth(width);
            column.setMaxWidth(width);
            column.setMinWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Source")) {
            TableColumn column = this.tableOfClusters.getColumn(headerName);
            width = 100;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Color")) {
            TableColumn column = this.tableOfClusters.getColumn(headerName);
            width = 60;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Size")) {
            TableColumn column = this.tableOfClusters.getColumn(headerName);
            width = 50;
            column.setWidth(width);
            column.setMaxWidth(width);
            column.setMinWidth(width);
            column.setPreferredWidth(width);
        }
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData data) {
        this.repaint();
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this.pane;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.iViewer.onSelected(framework);
        if (this.iViewer instanceof BoxChartViewer) {
            ((BoxChartViewer)this.iViewer).setClusters(this.getSelectedClusters());
        }
        this.repaint();
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.iViewer.onMenuChanged(menu);
    }

    public JComponent getHeaderComponent() {
        return this.tableOfClusters.getTableHeader();
    }

    public void onRepositoryChanged(ClusterRepository cr) {
        this.repository = cr;
        this.imposeHideMenu();
        this.validate();
        this.model.sortBy("Serial #");
        this.model.fireTableDataChanged();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.tableOfClusters.getSelectionModel().setSelectionInterval(0, 0);
        this.tableOfClusters.updateUI();
        this.tableOfClusters.repaint();
        this.repaint();
        this.tableOfClusters.revalidate();
        this.updateUI();
        this.pane.updateUI();
        this.updateClusterTable();
    }

    private void imposeHideMenu() {
        JMenu hideMenu = (JMenu)this.menu.getComponent(8);
        for (int i = 0; i < hideMenu.getMenuComponentCount(); ++i) {
            JMenuItem item;
            Component component = hideMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).isSelected()) continue;
            this.model.hide(item.getText());
        }
    }

    private void enableAllMenuItems() {
        int n = this.menu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.menu.getComponent(i) instanceof JMenuItem)) continue;
            this.menu.getComponent(i).setEnabled(true);
            int m = 0;
            m = ((JMenuItem)this.menu.getComponent(i)).getComponentCount();
            if (((JMenuItem)this.menu.getComponent(i)).getText().equals("Open/Launch")) {
                ((JMenu)this.menu.getComponent(i)).getMenuComponent(0).setEnabled(true);
            }
            for (int j = 0; j < m; ++j) {
                ((JMenuItem)((JMenuItem)this.menu.getComponent(i)).getComponent(m)).setEnabled(true);
            }
        }
    }

    private Cluster[] getSelectedClusters() {
        int[] rows = this.tableOfClusters.getSelectedRows();
        Cluster[] clusters = new Cluster[rows.length];
        for (int i = 0; i < clusters.length; ++i) {
            clusters[i] = this.repository.getCluster(this.model.getClusterSerialNumber(rows[i]));
        }
        return clusters;
    }

    private void modifyColor(int row, int col) {
        Color color = (Color)this.tableOfClusters.getValueAt(row, col);
        Color origColor = (Color)this.tableOfClusters.getValueAt(row, col);
        while (this.repository.clusterColors.contains(color = JColorChooser.showDialog(this, "Reassign Color", color))) {
            Object[] optionst = new Object[]{"OK", "CANCEL"};
            int option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
            if (option == 2) {
                return;
            }
            if (option == 0) continue;
            return;
        }
        if (color != null) {
            this.tableOfClusters.setValueAt(color, row, col);
            this.repository.updateClusterColor(this.model.getClusterSerialNumber(row), color);
            this.repository.clusterColors.add(color);
            this.repository.clusterColors.remove(origColor);
        }
    }

    private void modifyShowColor(int row, int col) {
        Cluster[] clusters = this.getSelectedClusters();
        if (clusters.length == 0) {
            return;
        }
        Boolean bool = (Boolean)this.model.getValueAt(row, col);
        clusters[0].enableShowColor(bool == false);
        this.model.setValueAt(clusters[0].getClusterColor(), row, col - 1);
        this.model.fireTableDataChanged();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.tableOfClusters.repaint();
        this.repaint();
    }

    private void launchNewMevSession() {
        Cluster[] clusters = this.getSelectedClusters();
        ClusterWorker worker = new ClusterWorker(this.repository);
        int[] indices = worker.getUniqueIndices(clusters);
        String[] clusterLabels = worker.getClusterLabels(clusters);
        if (clusterLabels.length == 1) {
            if (this.geneClusterTable) {
                this.framework.launchNewMAV(indices, worker.getMinExperiment(clusters), "Cluster: " + clusterLabels[0], 0);
            } else {
                this.framework.launchNewMAV(indices, worker.getMinExperiment(clusters), "Cluster: " + clusterLabels[0], 1);
            }
        } else if (clusterLabels.length > 1) {
            String labelString = "";
            labelString = "Clusters: ";
            for (int i = 0; i < clusterLabels.length - 1; ++i) {
                labelString = labelString + clusterLabels[i] + " : ";
            }
            labelString = labelString + clusterLabels[clusterLabels.length - 1];
            if (this.geneClusterTable) {
                this.framework.launchNewMAV(indices, worker.getMinExperiment(clusters), "Cluster: " + clusterLabels[0], 0);
            } else {
                this.framework.launchNewMAV(indices, worker.getMinExperiment(clusters), "Cluster: " + clusterLabels[0], 1);
            }
        }
    }

    private void openClusterNode() {
        int row = this.tableOfClusters.getSelectedRow();
        Cluster cluster = this.repository.getCluster(this.model.getClusterSerialNumber(row));
        if (!cluster.getSource().equals("Algorithm")) {
            return;
        }
        DefaultMutableTreeNode node = cluster.getNode();
        if (node == null) {
            Object userObject = cluster.getUserObject();
            if (userObject != null && (node = this.framework.getNode(userObject)) != null) {
                cluster.setNode(node);
                this.framework.setTreeNode(node);
            }
        } else {
            this.framework.setTreeNode(node);
        }
    }

    private void modifyClusterAttributes() {
        int row = this.tableOfClusters.getSelectedRow();
        if (this.model.isLegalRow(row)) {
            ClusterAttributesDialog dialog;
            Color origColor;
            Cluster cluster;
            block4: {
                int option;
                cluster = this.repository.getCluster(this.model.getClusterSerialNumber(row));
                origColor = cluster.getClusterColor();
                do {
                    if ((dialog = new ClusterAttributesDialog("Modify Cluster Attributes", cluster.getAlgorithmName(), cluster.getClusterID(), cluster.getClusterLabel(), cluster.getClusterDescription(), cluster.getClusterColor())).showModal() != 0) {
                        return;
                    }
                    if (!this.repository.clusterColors.contains(dialog.getColor()) || origColor == dialog.getColor()) break block4;
                    Object[] optionst = new Object[]{"OK", "CANCEL"};
                    option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
                    if (option != 2) continue;
                    return;
                } while (option == 0);
                return;
            }
            Color clusterColor = dialog.getColor();
            String clusterLabel = dialog.getLabel();
            String clusterDescription = dialog.getDescription();
            cluster.setClusterColor(clusterColor);
            cluster.setClusterLabel(clusterLabel);
            cluster.setClusterDescription(clusterDescription);
            if (clusterColor != origColor) {
                this.repository.clusterColors.add(clusterColor);
                this.repository.clusterColors.remove(origColor);
            }
            this.model.setClusterColor(row, clusterColor);
            this.model.setClusterLabel(row, clusterLabel);
            this.model.setClusterDescription(row, clusterDescription);
            this.model.fireTableDataChanged();
        }
    }

    private void showAllColumns() {
        JMenu hideMenu = (JMenu)this.menu.getComponent(8);
        for (int i = 0; i < hideMenu.getMenuComponentCount(); ++i) {
            JMenuItem item;
            Component component = hideMenu.getMenuComponent(i);
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).isSelected()) continue;
            this.model.addColumn(item.getText());
            item.setSelected(false);
        }
    }

    private void performClusterOperation(String clusterOp) {
        Cluster[] clusters = this.getSelectedClusters();
        if (clusters.length < 2) {
            return;
        }
        ClusterWorker worker = new ClusterWorker(this.repository);
        Cluster result = null;
        if (clusterOp.equals("Intersection")) {
            result = worker.intersection(clusters);
        } else if (clusterOp.equals("Union")) {
            result = worker.union(clusters);
        } else if (clusterOp.equals("XOR")) {
            result = worker.xor(clusters);
        }
        if (result != null) {
            this.repository.addCluster(this.repository.getClusterOperationsList(), result);
            this.addCluster(result);
        }
        if (result != null) {
            this.framework.addHistory("Cluster Operation: " + result.getAlgorithmName());
        }
    }

    private void deleteSelectedRows() {
        int[] rows = this.tableOfClusters.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            if (!this.model.isLegalRow(rows[i] - i)) continue;
            this.repository.removeCluster(this.model.getSerialNumber(rows[i] - i));
            this.model.removeRow(rows[i] - i);
        }
        if (rows.length > 0) {
            this.model.fireTableDataChanged();
        }
        this.onRepositoryChanged(this.repository);
    }

    private void deleteAllRows() {
        int result = JOptionPane.showConfirmDialog(this, "Are you sure that you want to delete all clusters in the repository?", "Delete All Clusters", 0, 2);
        if (result == 0) {
            this.model.removeAllRows();
            this.repository.clearClusterLists();
        }
    }

    public void deleteAllClusters() {
        this.model.removeAllRows();
        this.repository.clearClusterLists();
    }

    private void saveCluster() {
        Cluster[] clusters = this.getSelectedClusters();
        if (clusters.length != 1) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "One row must be selected to indicate the cluster to save.", "Save Error", 2);
            return;
        }
        this.repository.saveCluster(clusters[0].getSerialNumber());
    }

    private void submitCluster() {
        Cluster[] clusters = this.getSelectedClusters();
        if (clusters != null && clusters.length > 0) {
            this.repository.submitCluster(clusters[0]);
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    private void broadcastCluster() {
        Cluster[] clusters = this.getSelectedClusters();
        if (clusters != null && clusters.length > 0) {
            this.repository.broadcastGeneClusters(clusters);
        }
    }

    public int getViewerType() {
        return -1;
    }

    public void setExperimentID(int i) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public Expression getExpression() {
        return null;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.setLayout(new GridBagLayout());
        JButton asd = new JButton("asdjjjjjjjjjjjjjjjjjjjjjjj");
        asd.setIcon(new ImageIcon("C:/sampleglass.gif"));
        jf.add((Component)asd, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JSeparator js = new JSeparator(1);
        jf.add((Component)js, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jf.add((Component)new JButton("werr"), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        jf.pack();
        jf.setVisible(true);
        try {
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.exit(0);
    }

    public class MenuListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String command = actionEvent.getActionCommand();
            if (command.equals("hide-command")) {
                if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                    ClusterTable.this.model.hide(((JCheckBoxMenuItem)actionEvent.getSource()).getText());
                } else {
                    ClusterTable.this.model.addColumn(((JCheckBoxMenuItem)actionEvent.getSource()).getText());
                }
            } else if (command.equals("show-all-command")) {
                ClusterTable.this.showAllColumns();
            } else if (command.equals("sort-command")) {
                ClusterTable.this.model.sortBy(((JRadioButtonMenuItem)actionEvent.getSource()).getText());
            } else if (command.equals("modify-command")) {
                ClusterTable.this.modifyClusterAttributes();
            } else if (!command.equals("modify-membership-command")) {
                if (command.equals("go-to-origin-command")) {
                    ClusterTable.this.openClusterNode();
                } else if (command.equals("launch-new-command")) {
                    ClusterTable.this.launchNewMevSession();
                } else if (command.equals("cluster-operations-command")) {
                    ClusterTable.this.performClusterOperation(((JMenuItem)actionEvent.getSource()).getText());
                } else if (command.equals("delete-command")) {
                    ClusterTable.this.deleteSelectedRows();
                } else if (command.equals("delete-all-command")) {
                    ClusterTable.this.deleteAllRows();
                } else if (command.equals("save-cluster-command")) {
                    ClusterTable.this.saveCluster();
                } else if (command.equals("import-list-command")) {
                    Cluster newCluster = ClusterTable.this.repository.createClusterFromList();
                    if (newCluster != null) {
                        ClusterTable.this.addCluster(newCluster);
                    }
                } else if (command.equals("submit-list-command")) {
                    ClusterTable.this.submitCluster();
                } else if (command.equals("submit-broadcastcluster-command")) {
                    ClusterTable.this.broadcastCluster();
                }
            }
        }
    }

    public class RBListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ClusterTable.this.bottomTablePane.updateUI();
            ClusterTable.this.bottomTablePane.repaint();
            ClusterTable.this.bottomTablePane.validate();
            ClusterTable.this.updateBottomViewer();
            ClusterTable.this.iViewer.onSelected(ClusterTable.this.framework);
        }
    }

    public class ClusterCellEditor
    implements TableCellEditor {
        JTextArea textArea;
        EventListenerList list = new EventListenerList();

        public ClusterCellEditor(JTextArea ta) {
            this.textArea = ta;
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.list.add(CellEditorListener.class, cellEditorListener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean param, int param3, int param4) {
            if (obj instanceof JTextArea) {
                this.textArea.setText(((JTextArea)obj).getText());
                this.textArea.selectAll();
                this.textArea.setCaretPosition(0);
                return this.textArea;
            }
            return (Component)obj;
        }

        @Override
        public void cancelCellEditing() {
            this.textArea = null;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        @Override
        public Object getCellEditorValue() {
            return this.textArea;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.textArea != null) {
                ClusterTable.this.repository.getCluster(ClusterTable.this.model.getClusterSerialNumber(ClusterTable.this.tableOfClusters.getSelectedRow())).setClusterDescription(this.textArea.getText());
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }
    }

    public class TableListener
    implements TableModelListener,
    MouseListener,
    KeyListener {
        @Override
        public void keyReleased(KeyEvent ke) {
            ClusterTable.this.bottomTablePane.updateUI();
            ClusterTable.this.bottomTablePane.repaint();
            ClusterTable.this.bottomTablePane.validate();
            ClusterTable.this.updateBottomViewer();
        }

        @Override
        public void keyPressed(KeyEvent ke) {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                int col = ClusterTable.this.tableOfClusters.getSelectedColumn();
                int row = ClusterTable.this.tableOfClusters.getSelectedRow();
                if (!ClusterTable.this.model.isLegalRow(row) || !ClusterTable.this.model.isLegalColumn(col)) {
                    return;
                }
                if (ClusterTable.this.tableOfClusters.getColumnClass(col) == Color.class) {
                    ClusterTable.this.modifyColor(row, col);
                } else if (ClusterTable.this.tableOfClusters.getColumnClass(col) == Boolean.class) {
                    ClusterTable.this.modifyShowColor(row, col);
                }
                ClusterTable.this.topTablePane.updateUI();
                ClusterTable.this.bottomTablePane.updateUI();
                ClusterTable.this.bottomTablePane.repaint();
                ClusterTable.this.bottomTablePane.validate();
                ClusterTable.this.updateBottomViewer();
            } else if (mouseEvent.isPopupTrigger()) {
                int menuSize = ClusterTable.this.menu.getComponentCount();
                int selectionSize = ClusterTable.this.tableOfClusters.getSelectedRowCount();
                int[] selectedRows = ClusterTable.this.tableOfClusters.getSelectedRows();
                if (selectionSize < 1) {
                    return;
                }
                ClusterTable.this.enableAllMenuItems();
                for (int i = 0; i < menuSize; ++i) {
                    String menuString;
                    Component component = ClusterTable.this.menu.getComponent(i);
                    if (component instanceof JMenuItem) {
                        JMenuItem item = (JMenuItem)component;
                        menuString = item.getText();
                        if (selectionSize != 1 && menuString.equals("Modify Attributes")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize != 1 && menuString.equals("Save Cluster")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize < 2 && menuString.equals("Cluster Operations")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize != 1 && menuString.equals("Modify Cluster")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize != 1 && menuString.equals("Open/Launch")) {
                            ((JMenu)item).getMenuComponent(0).setEnabled(false);
                            continue;
                        }
                        if (!menuString.equals("Open/Launch") || ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(selectedRows[0])).getSource().equals("Algorithm")) continue;
                        ((JMenu)item).getMenuComponent(0).setEnabled(false);
                        continue;
                    }
                    if (!(component instanceof JMenu)) continue;
                    JMenu aMenu = (JMenu)component;
                    menuString = aMenu.getText();
                    if (selectionSize != 1 && (menuString.equals("Modify Cluster") || menuString.equals("Open/Launch"))) {
                        aMenu.setEnabled(false);
                        continue;
                    }
                    if (menuString.equals("Open/Lanuch") && !ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(selectedRows[0])).getSource().equals("Algorithm")) {
                        aMenu.getMenuComponent(1).setEnabled(false);
                        continue;
                    }
                    aMenu.setEnabled(true);
                }
                ClusterTable.this.menu.show(ClusterTable.this.tableOfClusters, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ClusterTable.this.topTablePane.updateUI();
            ClusterTable.this.bottomTablePane.updateUI();
            ClusterTable.this.bottomTablePane.repaint();
            ClusterTable.this.bottomTablePane.validate();
            ClusterTable.this.updateBottomViewer();
            if (mouseEvent.isPopupTrigger()) {
                int menuSize = ClusterTable.this.menu.getComponentCount();
                int selectionSize = ClusterTable.this.tableOfClusters.getSelectedRowCount();
                int[] selectedRows = ClusterTable.this.tableOfClusters.getSelectedRows();
                if (selectionSize < 1) {
                    return;
                }
                ClusterTable.this.enableAllMenuItems();
                for (int i = 0; i < menuSize; ++i) {
                    String menuString;
                    Component component = ClusterTable.this.menu.getComponent(i);
                    if (component instanceof JMenuItem) {
                        JMenuItem item = (JMenuItem)component;
                        menuString = item.getText();
                        if (selectionSize != 1 && menuString.equals("Modify Attributes")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize != 1 && menuString.equals("Save Cluster")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize < 2 && menuString.equals("Cluster Operations")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize != 1 && menuString.equals("Modify Cluster")) {
                            component.setEnabled(false);
                        }
                        if (selectionSize != 1 && menuString.equals("Open/Launch")) {
                            ((JMenu)item).getMenuComponent(0).setEnabled(false);
                            continue;
                        }
                        if (!menuString.equals("Open/Launch") || ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(selectedRows[0])).getSource().equals("Algorithm")) continue;
                        ((JMenu)item).getMenuComponent(0).setEnabled(false);
                        continue;
                    }
                    if (!(component instanceof JMenu)) continue;
                    JMenu aMenu = (JMenu)component;
                    menuString = aMenu.getText();
                    if (selectionSize != 1 && (menuString.equals("Modify Cluster") || menuString.equals("Open/Launch"))) {
                        aMenu.setEnabled(false);
                        continue;
                    }
                    if (menuString.equals("Open/Lanuch") && !ClusterTable.this.repository.getCluster(ClusterTable.this.model.getSerialNumber(selectedRows[0])).getSource().equals("Algorithm")) {
                        aMenu.getMenuComponent(1).setEnabled(false);
                        continue;
                    }
                    aMenu.setEnabled(true);
                }
                ClusterTable.this.menu.show(ClusterTable.this.tableOfClusters, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ClusterTable.this.modifyClusterAttributes();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }

    public class BottomListener
    implements MouseListener {
        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ClusterTable.this.setButtons();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ClusterTable.this.setButtons();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ClusterTable.this.setButtons();
        }
    }

    public class ClusterCellRenderer
    implements TableCellRenderer {
        private JPanel colorPanel = new JPanel();
        private JLabel label;
        private JTextArea textArea;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int row, int col) {
            if (obj instanceof Color) {
                this.colorPanel.setBackground((Color)obj);
                return this.colorPanel;
            }
            if (obj instanceof JLabel) {
                this.label = (JLabel)obj;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                this.label.setBackground(new Color(225, 225, 225));
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (ClusterTable.this.tableOfClusters.isRowSelected(row)) {
                    this.label.setBackground(ClusterTable.this.tableOfClusters.getSelectionBackground());
                }
                return this.label;
            }
            if (obj instanceof JTextArea) {
                this.textArea = (JTextArea)obj;
                if (ClusterTable.this.tableOfClusters.isRowSelected(row)) {
                    this.textArea.setBackground(ClusterTable.this.tableOfClusters.getSelectionBackground());
                }
                return this.textArea;
            }
            if (obj instanceof Boolean) {
                System.out.println("Handle Boolean");
                JCheckBox box = new JCheckBox();
                box.setBackground(Color.white);
                box.setHorizontalAlignment(0);
                box.setSelected((Boolean)obj);
                return box;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class ClusterTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] rowData;
        private Row[] rows;
        private int colToSort = 0;

        public ClusterTableModel(Vector columnNames, Vector rowData) {
            this.initializeHeader(columnNames);
            this.initializeData(rowData);
            this.rows = new Row[this.rowData.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        private void initializeHeader(Vector headerNames) {
            this.columnNames = new String[headerNames.size()];
            for (int i = 0; i < headerNames.size(); ++i) {
                this.columnNames[i] = (String)headerNames.elementAt(i);
            }
        }

        private void initializeData(Vector data) {
            int cnt = 0;
            this.rowData = new Object[data.size() / this.columnNames.length][this.columnNames.length];
            while (cnt < data.size()) {
                for (int j = 0; j < this.columnNames.length; ++j) {
                    this.rowData[cnt / this.columnNames.length][j] = data.elementAt(cnt);
                    ++cnt;
                }
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rowData[this.rows[row].index][col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 7 || col == 8;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.rowData[this.rows[row].index][col] = value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        public Class getColumnClass(int col) {
            if (col == 7) {
                return Color.class;
            }
            if (col == 4 || col == 5) {
                return String.class;
            }
            if (col == 8) {
                return Boolean.class;
            }
            return JLabel.class;
        }

        public int getClusterSerialNumber(int row) {
            if (this.isLegalRow(row)) {
                return Integer.parseInt(((JLabel)this.getValueAt(row, 0)).getText());
            }
            return -1;
        }

        public boolean isLegalRow(int row) {
            return row > -1 && row < this.getRowCount();
        }

        public boolean isLegalColumn(int col) {
            return col > -1 && col < this.getColumnCount();
        }

        public void sort(int c) {
            this.colToSort = c;
            Arrays.sort(this.rows);
            ClusterTable.this.tableOfClusters.repaint();
        }

        public void sortBy(String key) {
            int col = this.getColumnIndex(key);
            if (col >= 0) {
                this.sort(col);
                this.colToSort = col;
            }
        }

        private int getColumnIndex(String key) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (this.columnNames[i] != key) continue;
                return i;
            }
            return 0;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void hide(String columnName) {
            ClusterTable.this.tableOfClusters.removeColumn(ClusterTable.this.tableOfClusters.getColumn(columnName));
        }

        public void addColumn(String columnName) {
            ClusterTable.this.tableOfClusters.addColumn(new TableColumn(this.getColumnIndex(columnName)));
            this.moveColumnFromEnd(this.getColumnIndex(columnName));
        }

        public void addRow(Vector data) {
            int i;
            Object[][] newData = new Object[this.rowData.length + 1][this.columnNames.length];
            for (i = 0; i < this.rowData.length; ++i) {
                for (int j = 0; j < this.rowData[i].length; ++j) {
                    newData[i][j] = this.rowData[i][j];
                }
            }
            for (i = 0; i < this.columnNames.length; ++i) {
                newData[newData.length - 1][i] = data.elementAt(i);
            }
            this.rowData = newData;
            Row[] newRows = new Row[this.rowData.length];
            for (int i2 = 0; i2 < this.rows.length; ++i2) {
                newRows[i2] = this.rows[i2];
            }
            newRows[newRows.length - 1] = new Row();
            newRows[newRows.length - 1].index = newRows.length - 1;
            this.rows = newRows;
            this.fireTableRowsInserted(this.rows.length - 1, this.rows.length - 1);
        }

        public void removeRow(int tableRow) {
            int row = this.rows[tableRow].index;
            Object[][] newData = new Object[this.rowData.length - 1][this.rowData[0].length];
            int currRow = -1;
            for (int i = 0; i < this.rowData.length; ++i) {
                if (i == row) continue;
                ++currRow;
                for (int j = 0; j < this.rowData[i].length; ++j) {
                    newData[currRow][j] = this.rowData[i][j];
                }
            }
            this.rowData = newData;
            Row[] newRows = new Row[this.rowData.length];
            currRow = -1;
            for (int i = 0; i < this.rows.length; ++i) {
                if (i == row) continue;
                newRows[++currRow] = this.rows[i];
                newRows[currRow].index = currRow;
            }
            this.rows = newRows;
            this.fireTableRowsDeleted(row, row);
        }

        public void removeAllRows() {
            int numRows = this.rows.length;
            this.rowData = new Object[0][0];
            this.rows = new Row[0];
            this.fireTableRowsDeleted(0, numRows);
        }

        private void moveColumnFromEnd(int finalLocation) {
            for (int i = ClusterTable.this.tableOfClusters.getColumnCount() - 1; i > finalLocation; --i) {
                ClusterTable.this.tableOfClusters.moveColumn(i - 1, i);
            }
        }

        public int getSerialNumber(int row) {
            JLabel serialLabel = (JLabel)this.rowData[this.rows[row].index][0];
            return Integer.parseInt(serialLabel.getText());
        }

        public void setClusterColor(int tableRow, Color clusterColor) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Color");
            this.setValueAt(clusterColor, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        public void setClusterLabel(int tableRow, String clusterLabel) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Cluster Label");
            this.setValueAt(clusterLabel, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        public void setClusterDescription(int tableRow, String clusterDescription) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Remarks");
            this.setValueAt(clusterDescription, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        private class Row
        implements Comparable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object other) {
                Row otherRow = (Row)other;
                Object myObject = ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort];
                Object otherObject = ClusterTableModel.this.rowData[otherRow.index][ClusterTableModel.this.colToSort];
                if (ClusterTable.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Serial #") || ClusterTable.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Size")) {
                    Integer i = new Integer(((JLabel)ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort]).getText());
                    return i.compareTo(new Integer(((JLabel)otherObject).getText()));
                }
                if (myObject instanceof Comparable) {
                    return ((Comparable)myObject).compareTo(otherObject);
                }
                if (myObject instanceof JLabel) {
                    this.myString = ((JLabel)myObject).getText();
                    this.otherString = ((JLabel)otherObject).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - otherRow.index;
            }
        }
    }
}

