/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Frame;
import java.awt.List;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.SearchResultDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ListImportDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.SubmissionManager;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class ClusterRepository
extends Vector {
    public static final int GENE_CLUSTER = 0;
    public static final int EXPERIMENT_CLUSTER = 1;
    private int numberOfElements;
    private ClusterList[] elementClusters;
    private int clusterSerialCounter = 0;
    private int totalClusters = 0;
    private int removedClusters = 0;
    private boolean geneClusterRepository = false;
    private IFramework framework;
    public ArrayList<Color> clusterColors = new ArrayList();

    public ClusterRepository(Boolean isGeneClusterRepository, Integer numberOfElements, Integer clusterSerialCounter, ClusterList[] elementClusters) {
        this.geneClusterRepository = isGeneClusterRepository;
        this.numberOfElements = numberOfElements;
        this.elementClusters = elementClusters;
        this.clusterSerialCounter = clusterSerialCounter;
    }

    public ClusterRepository(Boolean isGeneClusterRepository, Integer numberOfElements, Integer clusterSerialCounter, ClusterList[] elementClusters, ArrayList clusterColors) {
        this.geneClusterRepository = isGeneClusterRepository;
        this.numberOfElements = numberOfElements;
        this.elementClusters = elementClusters;
        this.clusterSerialCounter = clusterSerialCounter;
        this.clusterColors = clusterColors;
    }

    public ClusterRepository(int numberOfElements, IFramework framework) {
        this.numberOfElements = numberOfElements;
        this.framework = framework;
        this.elementClusters = new ClusterList[numberOfElements];
        this.addClusterList(new ClusterList("Cluster Ops."));
    }

    public ClusterRepository(int numberOfElements, IFramework framework, boolean isGeneClusterRepository) {
        this.numberOfElements = numberOfElements;
        this.framework = framework;
        this.elementClusters = new ClusterList[numberOfElements];
        this.geneClusterRepository = isGeneClusterRepository;
        this.addClusterList(new ClusterList("Cluster Ops."));
    }

    public ClusterRepository(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.elementClusters = new ClusterList[numberOfElements];
        this.geneClusterRepository = false;
        this.addClusterList(new ClusterList("Cluster Ops."));
    }

    public ArrayList getClusterColors() {
        return this.clusterColors;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public ClusterList[] getElementClusters() {
        return this.elementClusters;
    }

    public int getClusterSerialCounter() {
        return this.clusterSerialCounter;
    }

    public Hashtable getAllExperiments() {
        Hashtable<Integer, Experiment> allExpts = new Hashtable<Integer, Experiment>();
        for (int i = 0; i < this.elementClusters.length; ++i) {
            try {
                for (int j = 0; j < this.elementClusters[i].size(); ++j) {
                    Cluster c = (Cluster)this.elementClusters[i].get(j);
                    allExpts.put(new Integer(c.getExptID()), c.getExperiment());
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return allExpts;
    }

    public int getTotalClusters() {
        return this.clusterSerialCounter - this.removedClusters;
    }

    public void populateExperiments(Hashtable allExpts) {
        for (int i = 0; i < this.elementClusters.length; ++i) {
            try {
                for (int j = 0; j < this.elementClusters[i].size(); ++j) {
                    Cluster c = (Cluster)this.elementClusters[i].get(j);
                    c.setExperiment((Experiment)allExpts.get(new Integer(c.getExptID())));
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void setFramework(IFramework framework) {
        this.framework = framework;
    }

    public IFramework getFramework() {
        return this.framework;
    }

    public boolean isColorOverlap(int index, Color color, Color c) {
        int cluster = -1;
        for (int findColor = 0; findColor < this.elementClusters[index].size(); ++findColor) {
            if (this.elementClusters[index].getClusterAt(findColor).getClusterColor() != color) continue;
            cluster = findColor;
        }
        for (int j = 0; j < this.elementClusters[index].getClusterAt(cluster).getIndices().length; ++j) {
            for (int i = 0; i < this.elementClusters[this.elementClusters[index].getClusterAt(cluster).getIndices()[j]].size(); ++i) {
                if (this.elementClusters[this.elementClusters[index].getClusterAt(cluster).getIndices()[j]].getClusterAt(i).getClusterColor() == color || this.elementClusters[this.elementClusters[index].getClusterAt(cluster).getIndices()[j]].getClusterAt(i).getClusterColor() != c) continue;
                return true;
            }
        }
        return false;
    }

    public int getVisibleClusters() {
        return this.clusterColors.size();
    }

    public Color getColor(int index) {
        if (this.elementClusters[index] == null || this.elementClusters[index].size() == 0) {
            return null;
        }
        Color color = this.elementClusters[index].lastCluster().getClusterColor();
        if (color != null) {
            return color;
        }
        Color[] colors = this.getColors(index);
        if (colors.length <= 1) {
            return null;
        }
        for (int i = colors.length - 2; i >= 0; --i) {
            if (colors[i] == null) continue;
            return colors[i];
        }
        return null;
    }

    public Color[] getColors(int index) {
        if (this.elementClusters[index] == null) {
            return null;
        }
        ClusterList list = this.elementClusters[index];
        Color[] colors = new Color[list.size()];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = list.getClusterAt(i).getClusterColor();
        }
        return colors;
    }

    public int getDataElementCount() {
        return this.numberOfElements;
    }

    public boolean isGeneClusterRepository() {
        return this.geneClusterRepository;
    }

    public ClusterList getClusterList(int index) {
        if (this.isInRange(index)) {
            return (ClusterList)this.elementAt(index);
        }
        return null;
    }

    public void addClusterList(ClusterList list) {
        this.add(list);
    }

    public void addCluster(ClusterList list, Cluster cluster) {
        if (cluster == null) {
            return;
        }
        if (!cluster.getSource().equals("Cluster Op.") && list.isClusterSaved(cluster.getClusterID(), cluster.getIndices())) {
            Cluster savedCluster = list.getCluster(cluster.getClusterID());
            if (savedCluster == null) {
                list.addCluster(cluster);
                this.updateClusterMembership(cluster);
                return;
            }
            savedCluster.setClusterColor(cluster.getClusterColor());
            savedCluster.setClusterLabel(cluster.getClusterLabel());
            savedCluster.setClusterDescription(cluster.getClusterDescription());
            this.setClusterSerialCounter(this.getMaxClusterSerialNumber() - 1);
            this.moveClusterToEndInMembershipLists(savedCluster);
        } else {
            if (list == null) {
                list = new ClusterList("Cluster Ops.");
                this.addClusterList(list);
            }
            list.addCluster(cluster);
            this.updateClusterMembership(cluster);
        }
    }

    public void addSubCluster(ClusterList list, Cluster cluster) {
        if (cluster == null) {
            return;
        }
        list.addCluster(cluster);
        this.updateClusterMembership(cluster);
    }

    private void updateClusterMembership(Cluster cluster) {
        int[] indices = cluster.getIndices();
        for (int i = 0; i < indices.length; ++i) {
            if (this.elementClusters[indices[i]] == null) {
                this.elementClusters[indices[i]] = new ClusterList("element " + indices[i]);
            }
            this.elementClusters[indices[i]].add(cluster);
        }
    }

    private void moveClusterToEndInMembershipLists(Cluster cluster) {
        int[] indices = cluster.getIndices();
        for (int i = 0; i < indices.length; ++i) {
            if (this.elementClusters[indices[i]] == null) {
                this.elementClusters[indices[i]] = new ClusterList("element " + indices[i]);
            }
            if (!this.elementClusters[indices[i]].contains(cluster)) continue;
            this.elementClusters[indices[i]].removeElement(cluster);
            this.elementClusters[indices[i]].addElement(cluster);
        }
    }

    private void removeClusterMembership(Cluster cluster) {
        int[] indices = cluster.getIndices();
        for (int i = 0; i < indices.length; ++i) {
            if (this.elementClusters[indices[i]] == null) continue;
            this.elementClusters[indices[i]].removeElement(cluster);
        }
    }

    public void clearClusterLists() {
        for (int i = 0; i < this.size(); ++i) {
            this.getClusterList(i).clear();
        }
        this.clearElementClusters();
        if (this.isGeneClusterRepository()) {
            this.framework.getData().deleteColors();
        } else {
            this.framework.getData().deleteExperimentColors();
        }
    }

    private void clearElementClusters() {
        for (int i = 0; i < this.numberOfElements; ++i) {
            this.elementClusters[i] = null;
        }
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getClusterList(i).size() <= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isInRange(int index) {
        return index > -1 && index < this.size();
    }

    public Cluster storeCluster(int algorithmIndex, String algorithmName, String clusterID, int[] indices, Experiment experiment) {
        ClusterList list = this.findClusterList(algorithmName);
        if (list == null) {
            list = new ClusterList(algorithmName);
            this.addClusterList(list);
        } else if (list.isClusterSaved(clusterID, indices)) {
            JOptionPane pane = new JOptionPane("Cluster has already been saved.  Would you like to replace the existing attributes?", 3, 1);
            pane.setVisible(true);
            int option = pane.getOptionType();
            if (option == 2 || option == 1) {
                return null;
            }
        }
        ClusterAttributesDialog dialog = new ClusterAttributesDialog("Store Cluster Attributes", algorithmName, clusterID, null, null, this.getNextDefaultColor());
        if (dialog.showModal() != 0) {
            return null;
        }
        Color clusterColor = dialog.getColor();
        String clusterLabel = dialog.getLabel();
        String clusterDescription = dialog.getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(indices, "Algorithm", clusterLabel, algorithmName, clusterID, clusterDescription, algorithmIndex, this.clusterSerialCounter, clusterColor, experiment);
        this.addCluster(list, cluster);
        return cluster;
    }

    public Cluster storeCluster(int algorithmIndex, String algorithmName, String clusterID, int[] indices, DefaultMutableTreeNode clusterNode, Experiment experiment) {
        int option;
        ClusterList list = this.findClusterList(algorithmName);
        if (list == null) {
            list = new ClusterList(algorithmName);
            this.addClusterList(list);
        } else if (list.isClusterSaved(clusterID, indices) && (option = JOptionPane.showConfirmDialog(new Frame(), "Cluster has already been saved.  Would you like to modify the existing attributes?", "Cluster Saved Alert", 0, 3)) == 1) {
            return null;
        }
        ClusterAttributesDialog dialog = new ClusterAttributesDialog("Store Cluster Attributes", algorithmName, clusterID, null, null, this.getNextDefaultColor());
        if (dialog.showModal() != 0) {
            return null;
        }
        if (this.clusterColors.contains(dialog.getColor())) {
            Object[] optionst = new Object[]{"OK", "CANCEL"};
            int option2 = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
            if (option2 == 2) {
                return null;
            }
            if (option2 == 0) {
                return this.storeCluster(algorithmIndex, algorithmName, clusterID, indices, clusterNode, experiment);
            }
            return null;
        }
        this.clusterColors.add(dialog.getColor());
        Color clusterColor = dialog.getColor();
        String clusterLabel = dialog.getLabel();
        String clusterDescription = dialog.getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(indices, "Algorithm", clusterLabel, algorithmName, clusterID, clusterDescription, algorithmIndex, this.clusterSerialCounter, clusterColor, clusterNode, experiment);
        this.addCluster(list, cluster);
        return cluster;
    }

    public Cluster storeSubCluster(int algorithmIndex, String algorithmName, String clusterID, int[] indices, DefaultMutableTreeNode clusterNode, Experiment experiment) {
        ClusterList list = this.findClusterList(algorithmName);
        boolean modification = false;
        if (list == null) {
            list = new ClusterList(algorithmName);
            this.addClusterList(list);
        } else if (list.isClusterSaved(clusterID, indices) && list.getCluster(clusterID).doIndicesMatch(indices)) {
            int option = JOptionPane.showConfirmDialog(new Frame(), "Cluster has already been saved.  Would you like to modify the existing attributes?", "Cluster Saved Alert", 0, 3);
            modification = true;
            if (option == 1) {
                return null;
            }
        }
        ClusterAttributesDialog dialog = new ClusterAttributesDialog("Store Cluster Attributes", algorithmName, clusterID, null, null, this.getNextDefaultColor());
        if (dialog.showModal() != 0) {
            return null;
        }
        if (this.clusterColors.contains(dialog.getColor())) {
            Object[] optionst = new Object[]{"OK", "CANCEL"};
            int option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
            if (option == 2) {
                return null;
            }
            if (option == 0) {
                return this.storeSubCluster(algorithmIndex, algorithmName, clusterID, indices, clusterNode, experiment);
            }
            return null;
        }
        this.clusterColors.add(dialog.getColor());
        Color clusterColor = dialog.getColor();
        String clusterLabel = dialog.getLabel();
        String clusterDescription = dialog.getDescription();
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(indices, "Algorithm", clusterLabel, algorithmName, clusterID, clusterDescription, algorithmIndex, this.clusterSerialCounter, clusterColor, clusterNode, experiment);
        if (modification) {
            this.addCluster(list, cluster);
        } else {
            this.addSubCluster(list, cluster);
        }
        return cluster;
    }

    private ClusterList findClusterList(String algName) {
        for (int i = 0; i < this.size(); ++i) {
            ClusterList curr = this.getClusterList(i);
            if (!curr.getAlgorithmName().equals(algName)) continue;
            return curr;
        }
        return null;
    }

    public ClusterList getClusterOperationsList() {
        return this.findClusterList("Cluster Ops.");
    }

    public boolean removeCluster(int[] indices, String algorithmName, String clusterID) {
        ClusterList list = this.findClusterList(algorithmName);
        if (list == null || list.size() == 0) {
            return false;
        }
        Cluster cluster = list.getCluster(clusterID);
        if (cluster != null) {
            cluster = null;
            ++this.removedClusters;
            int serialNumber = cluster.getSerialNumber();
            if (this.isGeneClusterRepository()) {
                this.framework.getData().setProbesColor(indices, null);
                this.framework.addHistory("Remove Gene Cluster From Repository: Serial # " + String.valueOf(serialNumber));
            } else {
                this.framework.getData().setExperimentColor(indices, null);
                this.framework.addHistory("Remove Experiment Cluster From Repository: Serial # " + String.valueOf(serialNumber));
            }
        } else {
            return false;
        }
        list.removeCluster(clusterID);
        this.removeElementClusters(indices, cluster);
        return true;
    }

    public boolean removeSubCluster(int[] indices, String algorithmName, String clusterID) {
        ClusterList list = this.findClusterList(algorithmName);
        if (list == null || list.size() == 0) {
            return false;
        }
        Cluster cluster = null;
        Cluster temp = null;
        for (int i = 0; i < list.size(); ++i) {
            temp = list.getClusterAt(i);
            if (!temp.doIndicesMatch(indices)) continue;
            cluster = temp;
        }
        if (cluster == null) {
            return false;
        }
        cluster = null;
        ++this.removedClusters;
        int serialNumber = cluster.getSerialNumber();
        if (this.isGeneClusterRepository()) {
            this.framework.getData().setProbesColor(indices, null);
            this.framework.addHistory("Remove Gene Cluster From Repository: Serial # " + String.valueOf(serialNumber));
        } else {
            this.framework.getData().setExperimentColor(indices, null);
            this.framework.addHistory("Remove Experiment Cluster From Repository: Serial # " + String.valueOf(serialNumber));
        }
        list.removeCluster(cluster);
        this.removeElementClusters(indices, cluster);
        return true;
    }

    private void removeElementClusters(int[] indices, Cluster cluster) {
        for (int i = 0; i < indices.length; ++i) {
            this.elementClusters[indices[i]].remove(cluster);
        }
    }

    public void updateClusterColor(int serialNumber, Color color) {
        Cluster cluster = this.getCluster(serialNumber);
        if (cluster != null) {
            cluster.setClusterColor(color);
        }
    }

    public Cluster getCluster2(int serialNumber) {
        Cluster cluster = null;
        ClusterList list = null;
        for (int i = 0; i < this.size(); ++i) {
            list = this.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                cluster = list.getClusterAt(j);
                if (serialNumber != cluster.getSerialNumber()) continue;
                return cluster;
            }
        }
        return cluster;
    }

    public Cluster getCluster(int serialNumber) {
        Cluster cluster = null;
        ClusterList list = null;
        for (int i = 0; i < this.size(); ++i) {
            list = this.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                if (serialNumber != list.getClusterAt(j).getSerialNumber()) continue;
                return list.getClusterAt(j);
            }
        }
        return cluster;
    }

    public boolean removeCluster(int serialNumber) {
        Cluster cluster = this.getCluster(serialNumber);
        if (cluster == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ClusterList list = this.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                if (list.getClusterAt(j) != cluster) continue;
                list.removeCluster(serialNumber);
            }
        }
        int[] indices = cluster.getIndices();
        this.removeClusterMembership(cluster);
        this.clusterColors.remove(cluster.getClusterColor());
        cluster = null;
        ++this.removedClusters;
        if (this.isGeneClusterRepository()) {
            this.framework.getData().setProbesColor(indices, null);
            this.framework.addHistory("Remove Gene Cluster From Repository: Serial # " + String.valueOf(serialNumber));
        } else {
            this.framework.getData().setExperimentColor(indices, null);
            this.framework.addHistory("Remove Experiment Cluster From Repository: Serial # " + String.valueOf(serialNumber));
        }
        return true;
    }

    public int takeNextClusterSerialNumber() {
        ++this.clusterSerialCounter;
        return this.clusterSerialCounter;
    }

    public int getMaxClusterSerialNumber() {
        return this.clusterSerialCounter;
    }

    public void setClusterSerialCounter(int value) {
        this.clusterSerialCounter = value;
    }

    public void printRepository() {
    }

    public void saveCluster(int serialNumber) {
        Cluster cluster = this.getCluster(serialNumber);
        try {
            if (this.geneClusterRepository) {
                ExperimentUtil.saveGeneCluster((Frame)this.framework.getFrame(), (IData)this.framework.getData(), (int[])cluster.getIndices());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.framework.getFrame(), (Experiment)cluster.getExperiment(), (IData)this.framework.getData(), (int[])cluster.getIndices());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving cluster.  Cluster not saved.", "Save Error", 2);
            e.printStackTrace();
        }
    }

    public Cluster createClusterFromList() {
        return this.createClusterFromList(null);
    }

    public Cluster storeClusterWithoutDialog(int[] clusterIndices, String source, String factor, String node, String label, String clusterDescription) {
        Experiment experiment = this.framework.getData().getExperiment();
        Color nextColor = this.getNextDefaultColor();
        this.clusterColors.add(nextColor);
        ClusterList list = this.getClusterOperationsList();
        Color clusterColor = nextColor;
        ++this.clusterSerialCounter;
        Cluster cluster = new Cluster(clusterIndices, source, factor, node, label, clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
        list.addCluster(cluster);
        this.updateClusterMembership(cluster);
        return cluster;
    }

    public Cluster storeClusterQuietlyFromList(String[] genelist, String identifier, String label, String description) {
        String key = identifier;
        String[] ids = genelist;
        String clusterLabel = label;
        String clusterDescription = description;
        boolean[] matches = new boolean[ids.length];
        Experiment experiment = this.framework.getData().getExperiment();
        int[] newIndices = this.getMatchingIndices(experiment, key, ids, matches, true);
        if (newIndices != null && newIndices.length > 0) {
            int[] selectedIndices = newIndices;
            if (selectedIndices == null || selectedIndices.length < 1) {
                return null;
            }
            return this.storeClusterWithoutDialog(newIndices, "Gaggle", key, "Gene List Import", clusterLabel, clusterDescription);
        }
        return null;
    }

    public Cluster createClusterFromList(String[] genelist) {
        Experiment experiment = this.framework.getData().getExperiment();
        if (this.isGeneClusterRepository()) {
            ListImportDialog dialog = new ListImportDialog(this.framework.getFrame(), this.framework.getData().getAllFilledAnnotationFields(), true, genelist);
            if (dialog.showModal() == 0) {
                boolean[] matches;
                String[] ids;
                String key = dialog.getFieldName();
                int[] newIndices = this.getMatchingIndices(experiment, key, ids = dialog.getList(), matches = new boolean[ids.length], true);
                if (newIndices != null && newIndices.length > 0) {
                    SearchResultDialog resultDialog = new SearchResultDialog(this.framework, newIndices, ids, matches, true);
                    if (resultDialog.showModal() == 0) {
                        ClusterAttributesDialog clusterDialog;
                        int[] selectedIndices;
                        block17: {
                            int option;
                            selectedIndices = resultDialog.getSelectedIndices();
                            if (selectedIndices == null || selectedIndices.length < 1) {
                                return null;
                            }
                            do {
                                if ((clusterDialog = new ClusterAttributesDialog("Store Cluster Attributes", "List Import", "Gene List", null, null, this.getNextDefaultColor())).showModal() != 0) {
                                    return null;
                                }
                                if (!this.clusterColors.contains(clusterDialog.getColor())) break block17;
                                Object[] optionst = new Object[]{"OK", "CANCEL"};
                                option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
                                if (option != 2) continue;
                                return null;
                            } while (option == 0);
                            return null;
                        }
                        this.clusterColors.add(clusterDialog.getColor());
                        ClusterList list = this.getClusterOperationsList();
                        Color clusterColor = clusterDialog.getColor();
                        String clusterLabel = clusterDialog.getLabel();
                        String clusterDescription = clusterDialog.getDescription();
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(selectedIndices, "Cluster Op.", clusterLabel, "List Import", "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                        this.addCluster(list, cluster);
                        return cluster;
                    }
                    return null;
                }
                JOptionPane.showMessageDialog(this.framework.getFrame(), "No genes matching the list entries were found.", "No Matches Found", 1);
            }
        } else {
            ISlideData slide = this.framework.getData().getFeature(0);
            if (slide == null) {
                return null;
            }
            Vector<String> slideNameKeys = slide.getSlideDataKeys();
            String[] slideNames = new String[slideNameKeys.size()];
            for (int i = 0; i < slideNames.length; ++i) {
                slideNames[i] = slideNameKeys.elementAt(i);
            }
            ListImportDialog dialog = new ListImportDialog(this.framework.getFrame(), slideNames, false, genelist);
            if (dialog.showModal() == 0) {
                boolean[] matches;
                String[] ids;
                String key = dialog.getFieldName();
                int[] newIndices = this.getMatchingIndices(experiment, key, ids = dialog.getList(), matches = new boolean[ids.length], false);
                if (newIndices != null && newIndices.length > 0) {
                    SearchResultDialog resultDialog = new SearchResultDialog(this.framework, newIndices, ids, matches, false);
                    if (resultDialog.showModal() == 0) {
                        ClusterAttributesDialog clusterDialog;
                        int[] selectedIndices;
                        block18: {
                            int option;
                            selectedIndices = resultDialog.getSelectedIndices();
                            if (selectedIndices == null || selectedIndices.length < 1) {
                                return null;
                            }
                            do {
                                if ((clusterDialog = new ClusterAttributesDialog("Store Cluster Attributes", "List Import", "Sample List", null, null, this.getNextDefaultColor())).showModal() != 0) {
                                    return null;
                                }
                                if (!this.clusterColors.contains(clusterDialog.getColor())) break block18;
                                Object[] optionst = new Object[]{"OK", "CANCEL"};
                                option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
                                if (option != 2) continue;
                                return null;
                            } while (option == 0);
                            return null;
                        }
                        this.clusterColors.add(clusterDialog.getColor());
                        ClusterList list = this.getClusterOperationsList();
                        Color clusterColor = clusterDialog.getColor();
                        String clusterLabel = clusterDialog.getLabel();
                        String clusterDescription = clusterDialog.getDescription();
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(selectedIndices, "List Import", clusterLabel, "List Import", "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                        this.addCluster(list, cluster);
                        return cluster;
                    }
                } else {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "No samples matching the list entries were found.", "No Matches Found", 1);
                }
            }
        }
        return null;
    }

    public ArrayList<Cluster> binCreateClusters() {
        int clusterCount;
        String oldLabel = this.framework.getData().getCurrentSampleLabelKey();
        ArrayList<Cluster> clusterArray = new ArrayList<Cluster>();
        Experiment experiment = this.framework.getData().getExperiment();
        ISlideData slide = this.framework.getData().getFeature(0);
        if (slide == null) {
            return null;
        }
        Vector<String> slideNameKeys = slide.getSlideDataKeys();
        String[] slideNames = new String[slideNameKeys.size()];
        for (int i = 0; i < slideNames.length; ++i) {
            slideNames[i] = slideNameKeys.elementAt(i);
        }
        if (!this.isGeneClusterRepository()) {
            ListImportDialog dialog = new ListImportDialog(this.framework.getFrame(), slideNames, false, true, true);
            if (dialog.showModal() == 0) {
                block1: for (clusterCount = 0; clusterCount < dialog.getLowerLimit().length; ++clusterCount) {
                    ClusterAttributesDialog clusterDialog;
                    String key = dialog.getFieldName();
                    int[] allIndices = experiment.getColumnIndicesCopy();
                    String[] annList = new String[experiment.getNumberOfSamples()];
                    this.framework.getData().setSampleLabelKey(key);
                    ArrayList<String> noRepeatsLabelList = new ArrayList<String>();
                    boolean[] matches = new boolean[annList.length];
                    for (int i = 0; i < allIndices.length; ++i) {
                        annList[i] = this.framework.getData().getFullSampleName(i);
                        if (noRepeatsLabelList.contains(annList[i])) continue;
                        noRepeatsLabelList.add(annList[i]);
                    }
                    int[] newIndices = this.getBinnedIndices(experiment, key, dialog.getLowerLimit()[clusterCount], dialog.getUpperLimit()[clusterCount], matches, false);
                    int[] selectedIndices = newIndices;
                    if (selectedIndices == null || selectedIndices.length < 1) {
                        JOptionPane.showMessageDialog(this.framework.getFrame(), "No samples within the given limits for 'Cluster " + (clusterCount + 1) + "' were found.", "No Samples Found", 1);
                        continue;
                    }
                    String clusterLabel = Float.toString(dialog.getLowerLimit()[clusterCount]) + "-" + Float.toString(dialog.getUpperLimit()[clusterCount]);
                    while ((clusterDialog = new ClusterAttributesDialog("Store Cluster Attributes", "List Import", "Gene List", key + " - " + clusterLabel, null, this.getNextDefaultColor())).showModal() == 0) {
                        if (this.clusterColors.contains(clusterDialog.getColor())) {
                            Object[] optionst = new Object[]{"OK", "CANCEL"};
                            int option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
                            if (option == 2) continue block1;
                            if (option == 0) continue;
                            return null;
                        }
                        this.clusterColors.add(clusterDialog.getColor());
                        ClusterList list = this.getClusterOperationsList();
                        Color clusterColor = clusterDialog.getColor();
                        clusterLabel = clusterDialog.getLabel();
                        String clusterDescription = clusterDialog.getDescription();
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(selectedIndices, "Cluster Op.", clusterLabel, "Binned Cluster", "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                        this.addCluster(list, cluster);
                        clusterArray.add(cluster);
                        continue block1;
                    }
                }
                this.framework.getData().setSampleLabelKey(oldLabel);
                return clusterArray;
            }
        } else {
            ListImportDialog dialog = new ListImportDialog(this.framework.getFrame(), this.framework.getData().getFieldNames(), true, true, true);
            if (dialog.showModal() == 0) {
                block4: for (clusterCount = 0; clusterCount < dialog.getLowerLimit().length; ++clusterCount) {
                    ClusterAttributesDialog clusterDialog;
                    String key = dialog.getFieldName();
                    int[] allIndices = experiment.getRowMappingArrayCopy();
                    String[] annList = new String[experiment.getNumberOfGenes()];
                    annList = this.framework.getData().getAnnotationList(key, allIndices);
                    boolean[] matches = new boolean[annList.length];
                    int[] newIndices = this.getBinnedIndices(experiment, key, dialog.getLowerLimit()[clusterCount], dialog.getUpperLimit()[clusterCount], matches, true);
                    int[] selectedIndices = newIndices;
                    if (selectedIndices == null || selectedIndices.length < 1) {
                        JOptionPane.showMessageDialog(this.framework.getFrame(), "No genes within the given limits for 'Cluster " + (clusterCount + 1) + "' were found.", "No Samples Found", 1);
                        continue;
                    }
                    String clusterLabel = Float.toString(dialog.getLowerLimit()[clusterCount]) + "-" + Float.toString(dialog.getUpperLimit()[clusterCount]);
                    while ((clusterDialog = new ClusterAttributesDialog("Store Cluster Attributes", "List Import", "Gene List", key + " - " + clusterLabel, null, this.getNextDefaultColor())).showModal() == 0) {
                        if (this.clusterColors.contains(clusterDialog.getColor())) {
                            Object[] optionst = new Object[]{"OK", "CANCEL"};
                            int option = JOptionPane.showOptionDialog(null, "Cluster Color is already being used. Please select another Color.", "Duplicate Color Error", -1, 2, null, optionst, optionst[0]);
                            if (option == 2) continue block4;
                            if (option == 0) continue;
                            return null;
                        }
                        this.clusterColors.add(clusterDialog.getColor());
                        ClusterList list = this.getClusterOperationsList();
                        Color clusterColor = clusterDialog.getColor();
                        clusterLabel = clusterDialog.getLabel();
                        String clusterDescription = clusterDialog.getDescription();
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(selectedIndices, "Cluster Op.", clusterLabel, "Binned Cluster", "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                        this.addCluster(list, cluster);
                        clusterArray.add(cluster);
                        continue block4;
                    }
                }
                return clusterArray;
            }
        }
        return clusterArray;
    }

    public ArrayList<Cluster> autoCreateClusters() {
        String oldLabel = this.framework.getData().getCurrentSampleLabelKey();
        ArrayList<Cluster> clusterArray = new ArrayList<Cluster>();
        Experiment experiment = this.framework.getData().getExperiment();
        ISlideData slide = this.framework.getData().getFeature(0);
        if (slide == null) {
            return null;
        }
        Vector<String> slideNameKeys = slide.getSlideDataKeys();
        String[] slideNames = new String[slideNameKeys.size()];
        for (int i = 0; i < slideNames.length; ++i) {
            slideNames[i] = slideNameKeys.elementAt(i);
        }
        if (!this.isGeneClusterRepository()) {
            ListImportDialog dialog = new ListImportDialog(this.framework.getFrame(), slideNames, false, true);
            if (dialog.showModal() == 0) {
                List selectedFields = dialog.getSelectedFields();
                for (int slidei = 0; slidei < selectedFields.getItemCount(); ++slidei) {
                    String key = selectedFields.getItem(slidei);
                    int[] allIndices = experiment.getColumnIndicesCopy();
                    String[] annList = new String[experiment.getNumberOfSamples()];
                    this.framework.getData().setSampleLabelKey(key);
                    ArrayList<String> noRepeatsLabelList = new ArrayList<String>();
                    boolean[] matches = new boolean[annList.length];
                    for (int i = 0; i < allIndices.length; ++i) {
                        annList[i] = this.framework.getData().getFullSampleName(i);
                        if (noRepeatsLabelList.contains(annList[i])) continue;
                        noRepeatsLabelList.add(annList[i]);
                    }
                    if (noRepeatsLabelList.size() > 10) {
                        Object[] optionst = new Object[]{"OK", "CANCEL"};
                        int option = JOptionPane.showOptionDialog(null, "Clustering by annotation type " + key + " will create " + noRepeatsLabelList.size() + " clusters.  Are you sure you want to continue?", "High cluster count for annotation type", -1, 2, null, optionst, optionst[0]);
                        if (option != 0) continue;
                    }
                    String[][] labelArray = new String[noRepeatsLabelList.size()][1];
                    for (int i = 0; i < labelArray.length; ++i) {
                        labelArray[i][0] = (String)noRepeatsLabelList.get(i);
                    }
                    for (int label = 0; label < noRepeatsLabelList.size(); ++label) {
                        int[] newIndices = this.getMatchingIndices(experiment, key, labelArray[label], matches, false);
                        int[] selectedIndices = newIndices;
                        if (selectedIndices == null || selectedIndices.length < 1) {
                            return null;
                        }
                        Color nextColor = this.getNextDefaultColor();
                        this.clusterColors.add(nextColor);
                        ClusterList list = this.getClusterOperationsList();
                        Color clusterColor = nextColor;
                        String clusterLabel = labelArray[label][0];
                        String clusterDescription = null;
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(selectedIndices, "Auto Cluster", key + " - " + clusterLabel, key, "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                        list.addCluster(cluster);
                        this.updateClusterMembership(cluster);
                        clusterArray.add(cluster);
                    }
                }
                this.framework.getData().setSampleLabelKey(oldLabel);
            }
        } else {
            ListImportDialog dialog = new ListImportDialog(this.framework.getFrame(), this.framework.getData().getFieldNames(), true, true);
            if (dialog.showModal() == 0) {
                List selectedFields = dialog.getSelectedFields();
                for (int slidei = 0; slidei < selectedFields.getItemCount(); ++slidei) {
                    String key = selectedFields.getItem(slidei);
                    int[] allIndices = experiment.getRowMappingArrayCopy();
                    String[] annList = new String[experiment.getNumberOfGenes()];
                    annList = this.framework.getData().getAnnotationList(key, allIndices);
                    ArrayList<String> noRepeatsLabelList = new ArrayList<String>();
                    boolean[] matches = new boolean[annList.length];
                    for (int i = 0; i < allIndices.length; ++i) {
                        if (noRepeatsLabelList.contains(annList[i])) continue;
                        noRepeatsLabelList.add(annList[i]);
                    }
                    if (noRepeatsLabelList.size() > 10) {
                        Object[] optionst = new Object[]{"OK", "CANCEL"};
                        int option = JOptionPane.showOptionDialog(null, "Clustering by annotation type " + key + " will create " + noRepeatsLabelList.size() + " clusters.  Are you sure you want to continue?", "High cluster count for annotation type", -1, 2, null, optionst, optionst[0]);
                        if (option != 0) continue;
                    }
                    String[][] labelArray = new String[noRepeatsLabelList.size()][1];
                    for (int i = 0; i < labelArray.length; ++i) {
                        labelArray[i][0] = (String)noRepeatsLabelList.get(i);
                    }
                    for (int label = 0; label < noRepeatsLabelList.size(); ++label) {
                        int[] newIndices = this.getMatchingIndices(experiment, key, labelArray[label], matches, true);
                        int[] selectedIndices = newIndices;
                        if (selectedIndices == null || selectedIndices.length < 1) {
                            return null;
                        }
                        Color nextColor = this.getNextDefaultColor();
                        this.clusterColors.add(nextColor);
                        ClusterList list = this.getClusterOperationsList();
                        Color clusterColor = nextColor;
                        String clusterLabel = labelArray[label][0];
                        String clusterDescription = null;
                        ++this.clusterSerialCounter;
                        Cluster cluster = new Cluster(selectedIndices, "Auto Cluster", key + " - " + clusterLabel, key, "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                        list.addCluster(cluster);
                        this.updateClusterMembership(cluster);
                        clusterArray.add(cluster);
                    }
                }
            }
        }
        return clusterArray;
    }

    public ArrayList<Cluster> autoCreateClusters(int index) {
        ArrayList<Cluster> clusterArray = new ArrayList<Cluster>();
        Experiment experiment = this.framework.getData().getExperiment();
        ISlideData slide = this.framework.getData().getFeature(0);
        if (slide == null) {
            return null;
        }
        Vector<String> slideNameKeys = slide.getSlideDataKeys();
        String[] slideNames = new String[slideNameKeys.size()];
        for (int i = 0; i < slideNames.length; ++i) {
            slideNames[i] = slideNameKeys.elementAt(i);
        }
        if (!this.isGeneClusterRepository()) {
            String key = this.framework.getData().getCurrentSampleLabelKey();
            int[] allIndices = experiment.getColumnIndicesCopy();
            String[] annList = new String[experiment.getNumberOfSamples()];
            ArrayList<String> noRepeatsLabelList = new ArrayList<String>();
            boolean[] matches = new boolean[annList.length];
            for (int i = 0; i < allIndices.length; ++i) {
                annList[i] = this.framework.getData().getFullSampleName(i);
                if (noRepeatsLabelList.contains(annList[i])) continue;
                noRepeatsLabelList.add(annList[i]);
            }
            if (noRepeatsLabelList.size() > 10) {
                Object[] optionst = new Object[]{"OK", "CANCEL"};
                int option = JOptionPane.showOptionDialog(null, "Clustering by annotation type " + key + " will create " + noRepeatsLabelList.size() + " clusters.  Are you sure you want to continue?", "High cluster count for annotation type", -1, 2, null, optionst, optionst[0]);
                if (option != 0) {
                    return null;
                }
            }
            String[][] labelArray = new String[noRepeatsLabelList.size()][1];
            for (int i = 0; i < labelArray.length; ++i) {
                labelArray[i][0] = (String)noRepeatsLabelList.get(i);
            }
            for (int label = 0; label < noRepeatsLabelList.size(); ++label) {
                int[] newIndices = this.getMatchingIndices(experiment, key, labelArray[label], matches, false);
                int[] selectedIndices = newIndices;
                if (selectedIndices == null || selectedIndices.length < 1) {
                    return null;
                }
                Color nextColor = this.getNextDefaultColor();
                this.clusterColors.add(nextColor);
                ClusterList list = this.getClusterOperationsList();
                Color clusterColor = nextColor;
                String clusterLabel = labelArray[label][0];
                String clusterDescription = null;
                ++this.clusterSerialCounter;
                Cluster cluster = new Cluster(selectedIndices, "Auto Cluster", key + " - " + clusterLabel, key, "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                list.addCluster(cluster);
                this.updateClusterMembership(cluster);
                clusterArray.add(cluster);
            }
        } else {
            String key = this.framework.getData().getFieldNames()[index];
            int[] allIndices = experiment.getRowMappingArrayCopy();
            String[] annList = new String[experiment.getNumberOfGenes()];
            annList = this.framework.getData().getAnnotationList(key, allIndices);
            ArrayList<String> noRepeatsLabelList = new ArrayList<String>();
            boolean[] matches = new boolean[annList.length];
            for (int i = 0; i < allIndices.length; ++i) {
                if (noRepeatsLabelList.contains(annList[i])) continue;
                noRepeatsLabelList.add(annList[i]);
            }
            if (noRepeatsLabelList.size() > 10) {
                Object[] optionst = new Object[]{"OK", "CANCEL"};
                int option = JOptionPane.showOptionDialog(null, "Clustering by annotation type " + key + " will create " + noRepeatsLabelList.size() + " clusters.  Are you sure you want to continue?", "High cluster count for annotation type", -1, 2, null, optionst, optionst[0]);
                if (option != 0) {
                    return null;
                }
            }
            String[][] labelArray = new String[noRepeatsLabelList.size()][1];
            for (int i = 0; i < labelArray.length; ++i) {
                labelArray[i][0] = (String)noRepeatsLabelList.get(i);
            }
            for (int label = 0; label < noRepeatsLabelList.size(); ++label) {
                int[] newIndices = this.getMatchingIndices(experiment, key, labelArray[label], matches, true);
                int[] selectedIndices = newIndices;
                if (selectedIndices == null || selectedIndices.length < 1) {
                    return null;
                }
                Color nextColor = this.getNextDefaultColor();
                this.clusterColors.add(nextColor);
                ClusterList list = this.getClusterOperationsList();
                Color clusterColor = nextColor;
                String clusterLabel = labelArray[label][0];
                String clusterDescription = null;
                ++this.clusterSerialCounter;
                Cluster cluster = new Cluster(selectedIndices, "Auto Cluster", key + " - " + clusterLabel, key, "N/A", clusterDescription, list.getAlgorithmIndex(), this.clusterSerialCounter, clusterColor, experiment);
                list.addCluster(cluster);
                this.updateClusterMembership(cluster);
                clusterArray.add(cluster);
            }
        }
        return clusterArray;
    }

    public Color getNextDefaultColor() {
        int blue;
        int green;
        int red;
        Color color;
        if (!this.clusterColors.contains(Color.green)) {
            return Color.green;
        }
        if (!this.clusterColors.contains(Color.blue)) {
            return Color.blue;
        }
        if (!this.clusterColors.contains(Color.red)) {
            return Color.red;
        }
        if (!this.clusterColors.contains(Color.yellow)) {
            return Color.yellow;
        }
        if (!this.clusterColors.contains(Color.orange)) {
            return Color.orange;
        }
        if (!this.clusterColors.contains(Color.black)) {
            return Color.black;
        }
        if (!this.clusterColors.contains(Color.pink)) {
            return Color.pink;
        }
        while (this.clusterColors.contains(color = new Color(red = (int)(Math.random() * 256.0), green = (int)(Math.random() * 256.0), blue = (int)(Math.random() * 256.0)))) {
        }
        return color;
    }

    private int[] getMatchingIndices(Experiment experiment, String key, String[] ids, boolean geneIndices) {
        int[] indices = null;
        Vector<Integer> indicesVector = new Vector<Integer>();
        IData data = this.framework.getData();
        if (geneIndices) {
            int i;
            int[] allIndices = experiment.getRowMappingArrayCopy();
            String[] annList = this.framework.getData().getAnnotationList(key, allIndices);
            Vector<String> idVector = new Vector<String>(annList.length);
            for (i = 0; i < ids.length; ++i) {
                idVector.addElement(ids[i]);
            }
            for (i = 0; i < annList.length; ++i) {
                if (!idVector.contains(annList[i])) continue;
                indicesVector.addElement(new Integer(allIndices[i]));
            }
            indices = new int[indicesVector.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indicesVector.elementAt(i);
            }
        } else {
            int i;
            int[] allIndices = experiment.getColumnIndicesCopy();
            String[] annList = new String[experiment.getNumberOfSamples()];
            data.setSampleLabelKey(key);
            Vector<String> idVector = new Vector<String>(annList.length);
            for (i = 0; i < ids.length; ++i) {
                idVector.addElement(ids[i]);
            }
            for (i = 0; i < allIndices.length; ++i) {
                annList[i] = data.getFullSampleName(i);
            }
            for (i = 0; i < annList.length; ++i) {
                if (!idVector.contains(annList[i])) continue;
                indicesVector.addElement(new Integer(allIndices[i]));
            }
            indices = new int[indicesVector.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indicesVector.elementAt(i);
            }
        }
        return indices;
    }

    private int[] getBinnedIndices(Experiment experiment, String key, float lowerLimit, float upperLimit, boolean[] matches, boolean geneIndices) {
        int[] indices = null;
        Vector<Integer> indicesVector = new Vector<Integer>();
        IData data = this.framework.getData();
        if (geneIndices) {
            int i;
            int[] allIndices = experiment.getRowMappingArrayCopy();
            String[] annList = this.framework.getData().getAnnotationList(key, allIndices);
            for (i = 0; i < annList.length; ++i) {
                try {
                    if (!(Float.parseFloat(annList[i]) >= lowerLimit) || !(Float.parseFloat(annList[i]) <= upperLimit)) continue;
                    indicesVector.addElement(new Integer(allIndices[i]));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            indices = new int[indicesVector.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indicesVector.elementAt(i);
            }
        } else {
            int i;
            int[] allIndices = experiment.getColumnIndicesCopy();
            String[] annList = new String[experiment.getNumberOfSamples()];
            data.setSampleLabelKey(key);
            for (i = 0; i < allIndices.length; ++i) {
                annList[i] = data.getFullSampleName(i);
            }
            for (i = 0; i < annList.length; ++i) {
                try {
                    if (!(Float.parseFloat(annList[i]) >= lowerLimit) || !(Float.parseFloat(annList[i]) <= upperLimit)) continue;
                    indicesVector.addElement(new Integer(allIndices[i]));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            indices = new int[indicesVector.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indicesVector.elementAt(i);
            }
        }
        return indices;
    }

    private int[] getMatchingIndices(Experiment experiment, String key, String[] ids, boolean[] matches, boolean geneIndices) {
        int[] indices = null;
        Vector<Integer> indicesVector = new Vector<Integer>();
        IData data = this.framework.getData();
        if (geneIndices) {
            int i;
            int[] allIndices = experiment.getRowMappingArrayCopy();
            String[] annList = this.framework.getData().getAnnotationList(key, allIndices);
            Vector<String> idVector = new Vector<String>(annList.length);
            for (i = 0; i < ids.length; ++i) {
                idVector.addElement(ids[i]);
            }
            for (i = 0; i < annList.length; ++i) {
                if (!idVector.contains(annList[i])) continue;
                indicesVector.addElement(new Integer(allIndices[i]));
                for (int j = 0; j < idVector.size(); ++j) {
                    if (!annList[i].equals((String)idVector.elementAt(j))) continue;
                    matches[j] = true;
                }
            }
            indices = new int[indicesVector.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indicesVector.elementAt(i);
            }
        } else {
            int i;
            int[] allIndices = experiment.getColumnIndicesCopy();
            String[] annList = new String[experiment.getNumberOfSamples()];
            String oldLabel = data.getCurrentSampleLabelKey();
            data.setSampleLabelKey(key);
            Vector<String> idVector = new Vector<String>(annList.length);
            for (i = 0; i < ids.length; ++i) {
                idVector.addElement(ids[i]);
            }
            for (i = 0; i < allIndices.length; ++i) {
                annList[i] = data.getFullSampleName(i);
            }
            for (i = 0; i < annList.length; ++i) {
                if (!idVector.contains(annList[i])) continue;
                indicesVector.addElement(new Integer(allIndices[i]));
                for (int j = 0; j < idVector.size(); ++j) {
                    if (!annList[i].equals((String)idVector.elementAt(j))) continue;
                    matches[j] = true;
                }
            }
            indices = new int[indicesVector.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)indicesVector.elementAt(i);
            }
            data.setSampleLabelKey(oldLabel);
        }
        return indices;
    }

    public void submitCluster(Cluster cluster) {
        SubmissionManager subManager = new SubmissionManager(this.framework, this);
        subManager.submit(cluster);
    }

    public void broadcastGeneClusters(Cluster[] clusters) {
        this.framework.broadcastGeneClusters(clusters);
    }
}

