/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;

public class ClusterList
extends Vector {
    String algorithmName;
    int algorithmIndex;

    public ClusterList() {
    }

    public ClusterList(int numberOfClusters) {
        super(numberOfClusters);
    }

    public ClusterList(String AlgorithmName) {
        this.algorithmName = AlgorithmName;
    }

    public static String[] getPersistenceDelegateArgs() {
        return new String[]{"vector", "algorithmName", "algorithmIndex"};
    }

    public Vector getVector() {
        return new Vector();
    }

    public ClusterList(Vector v, String name, int index) {
        super(v);
        this.algorithmIndex = index;
        this.algorithmName = name;
    }

    public void addCluster(Cluster cluster) {
        this.add(cluster);
    }

    public void removeCluster(Cluster cluster) {
        this.remove(cluster);
    }

    public void removeClusterAt(int clusterIndex) {
        if (this.isInRange(clusterIndex)) {
            this.removeElementAt(clusterIndex);
        }
    }

    public Cluster getClusterAt(int clusterIndex) {
        if (this.isInRange(clusterIndex)) {
            return (Cluster)this.elementAt(clusterIndex);
        }
        return null;
    }

    public Cluster lastCluster() {
        if (!this.isEmpty()) {
            return (Cluster)this.lastElement();
        }
        return null;
    }

    public Color getClusterColor(int clusterIndex) {
        if (this.isInRange(clusterIndex)) {
            return ((Cluster)this.elementAt(clusterIndex)).getClusterColor();
        }
        return null;
    }

    public String getClusterName(int clusterIndex) {
        if (this.isInRange(clusterIndex)) {
            return ((Cluster)this.elementAt(clusterIndex)).getClusterLabel();
        }
        return null;
    }

    public String getClusterID(int clusterIndex) {
        if (this.isInRange(clusterIndex)) {
            return ((Cluster)this.elementAt(clusterIndex)).getClusterID();
        }
        return null;
    }

    public int getClusterSerialNumber(int clusterIndex) {
        if (this.isInRange(clusterIndex)) {
            return ((Cluster)this.elementAt(clusterIndex)).getSerialNumber();
        }
        return -1;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String name) {
        this.algorithmName = name;
    }

    public int getAlgorithmIndex() {
        return this.algorithmIndex;
    }

    public void setAlgorithmIndex(int index) {
        this.algorithmIndex = index;
    }

    protected boolean isInRange(int index) {
        return index > -1 && index < this.size();
    }

    public boolean isClusterSaved(String clusterID, int[] indices) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getClusterID(i).equals(clusterID) || !this.getCluster(clusterID).doIndicesMatch(indices)) continue;
            return true;
        }
        return false;
    }

    public boolean isClusterSaved(int serialNumber) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getClusterSerialNumber(i) != serialNumber) continue;
            return true;
        }
        return false;
    }

    public Cluster getCluster(String clusterID) {
        for (int i = 0; i < this.size(); ++i) {
            Cluster curr = this.getClusterAt(i);
            if (!curr.getClusterID().equals(clusterID)) continue;
            return curr;
        }
        return null;
    }

    public Cluster getCluster(int serialNumber) {
        for (int i = 0; i < this.size(); ++i) {
            Cluster curr = this.getClusterAt(i);
            if (curr.getSerialNumber() != serialNumber) continue;
            return curr;
        }
        return null;
    }

    public void removeCluster(String clusterID) {
        Cluster cluster = this.getCluster(clusterID);
        if (cluster != null) {
            this.removeCluster(cluster);
        }
    }

    public void removeCluster(int serialNumber) {
        Cluster cluster = this.getCluster(serialNumber);
        if (cluster != null) {
            this.removeCluster(cluster);
        }
    }
}

