/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.util.awt.AccessibleColorPalette;

public class ClusterAttributesDialog
extends AlgorithmDialog {
    JTextArea textArea;
    JLabel colorLabel;
    JTextField clusterLabelField;
    int result = 2;
    String clusterLabelStr;
    String clusterDescriptionStr;
    Color clusterColor;
    JColorChooser colorChooser;
    AccessibleColorPalette colorBlind;

    public ClusterAttributesDialog(String frameTitle, String analysis, String clusterID) {
        this(frameTitle, analysis, clusterID, null, null, Color.GREEN);
    }

    public ClusterAttributesDialog(String frameTitle, String analysis, String clusterID, String clusterLabelStr, String clusterDescription, Color clusterColor) {
        super(new JFrame(), frameTitle, true);
        this.clusterLabelStr = clusterLabelStr;
        this.clusterDescriptionStr = clusterDescription;
        this.clusterColor = Color.GREEN;
        JPanel parameters = new JPanel();
        parameters.setLayout(new GridBagLayout());
        parameters.setBackground(Color.white);
        parameters.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        EventListener listener = new EventListener();
        JLabel analysisName = new JLabel("Analysis Node");
        JTextField analysisField = new JTextField(analysis);
        analysisField.setEditable(false);
        analysisField.setHorizontalAlignment(0);
        JLabel clusterNode = new JLabel("Cluster Node");
        JTextField clusterIDField = new JTextField(clusterID);
        clusterIDField.setEditable(false);
        clusterIDField.setHorizontalAlignment(0);
        JLabel clusterLabel = new JLabel("Cluster Label*");
        this.clusterLabelField = new JTextField(15);
        if (this.clusterLabelStr != null) {
            this.clusterLabelField.setText(this.clusterLabelStr);
        }
        JLabel notes = new JLabel("Remarks: *");
        this.textArea = new JTextArea(2, 30);
        this.textArea.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.gray));
        this.textArea.setMargin(new Insets(0, 3, 0, 3));
        this.textArea.setSize(350, 50);
        this.textArea.setPreferredSize(new Dimension(370, 50));
        this.textArea.setMargin(new Insets(2, 3, 2, 3));
        if (this.clusterDescriptionStr != null) {
            this.textArea.setText(this.clusterDescriptionStr);
        }
        JButton setColorButton = new JButton("Select Color");
        setColorButton.setFocusPainted(false);
        setColorButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.darkGray));
        setColorButton.setSize(80, 25);
        setColorButton.setPreferredSize(new Dimension(100, 25));
        setColorButton.setActionCommand("set-color-command");
        setColorButton.addActionListener(listener);
        this.colorLabel = new JLabel("Preview: No Color");
        this.colorLabel.setHorizontalAlignment(0);
        this.colorLabel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.colorLabel.setBackground(Color.lightGray);
        this.colorLabel.setOpaque(true);
        this.colorLabel.setEnabled(false);
        if (this.clusterColor != null) {
            this.colorLabel.setBackground(clusterColor);
            this.colorLabel.setText(" ");
        }
        JLabel optionalLabel = new JLabel("(* = optional fields)");
        parameters.add((Component)analysisName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 20, 0), 0, 0));
        parameters.add((Component)analysisField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 20, 20, 0), 0, 0));
        parameters.add((Component)clusterNode, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        parameters.add((Component)clusterIDField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 20, 0), 0, 0));
        parameters.add((Component)clusterLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        parameters.add((Component)this.clusterLabelField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 20, 0), 0, 0));
        parameters.add((Component)notes, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        parameters.add((Component)this.textArea, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        parameters.add((Component)setColorButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        parameters.add((Component)this.colorLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 50, 10, 50), 0, 0));
        parameters.add((Component)optionalLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.clusterLabelField.requestFocusInWindow();
        this.setActionListeners(listener);
        if (this.clusterColor == null) {
            this.okButton.setEnabled(false);
        }
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Color getColor() {
        return this.colorLabel.getBackground();
    }

    public String getLabel() {
        return this.clusterLabelField.getText();
    }

    public String getDescription() {
        return this.textArea.getText();
    }

    public static void main(String[] args) {
        ClusterAttributesDialog d = new ClusterAttributesDialog("Store Cluster Attributes", "KMC-genes (2)", "Cluster 8");
        d.show();
    }

    public class EventListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command == "set-color-command") {
                Color color = JColorChooser.showDialog((Component)((Object)ClusterAttributesDialog.this), "Color", null);
                if (color != null) {
                    ClusterAttributesDialog.this.okButton.setEnabled(true);
                    ClusterAttributesDialog.this.colorLabel.setEnabled(true);
                    ClusterAttributesDialog.this.colorLabel.setText(" ");
                    ClusterAttributesDialog.this.colorLabel.setBackground(color);
                } else if (!ClusterAttributesDialog.this.colorLabel.isEnabled()) {
                    ClusterAttributesDialog.this.okButton.setEnabled(false);
                }
            } else if (command == "ok-command") {
                ClusterAttributesDialog.this.result = 0;
                ClusterAttributesDialog.this.dispose();
            } else if (command == "cancel-command") {
                ClusterAttributesDialog.this.result = 2;
                ClusterAttributesDialog.this.dispose();
            } else if (command == "reset-command") {
                if (ClusterAttributesDialog.this.clusterDescriptionStr != null) {
                    ClusterAttributesDialog.this.textArea.setText(ClusterAttributesDialog.this.clusterDescriptionStr);
                    ClusterAttributesDialog.this.textArea.selectAll();
                } else {
                    ClusterAttributesDialog.this.textArea.setText("");
                }
                ClusterAttributesDialog.this.textArea.setCaretPosition(0);
                if (ClusterAttributesDialog.this.clusterColor != null) {
                    ClusterAttributesDialog.this.colorLabel.setBackground(ClusterAttributesDialog.this.clusterColor);
                } else {
                    ClusterAttributesDialog.this.colorLabel.setBackground(Color.lightGray);
                    ClusterAttributesDialog.this.colorLabel.setText("Preview: No Color");
                    ClusterAttributesDialog.this.colorLabel.setEnabled(false);
                }
                if (ClusterAttributesDialog.this.clusterLabelStr != null) {
                    ClusterAttributesDialog.this.clusterLabelField.setText(ClusterAttributesDialog.this.clusterLabelStr);
                    ClusterAttributesDialog.this.clusterLabelField.selectAll();
                } else {
                    ClusterAttributesDialog.this.clusterLabelField.setText("");
                }
                ClusterAttributesDialog.this.clusterLabelField.requestFocus();
                ClusterAttributesDialog.this.clusterLabelField.setCaretPosition(0);
            } else if (command == "info-command") {
                HelpWindow.launchBrowser((Window)((Object)ClusterAttributesDialog.this), (String)"Cluster Save Dialog");
            }
        }
    }
}

